"use strict";var _a,_b,_c,_d,_e,_f,_g,_h;Object.defineProperty(exports,"__esModule",{value:!0}),exports.AssetImageCode=exports.EcrImageCode=exports.CfnParametersCode=exports.AssetCode=exports.InlineCode=exports.S3CodeV2=exports.S3Code=exports.Code=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var child_process_1=()=>{var tmp=require("child_process");return child_process_1=()=>tmp,tmp},ecr_assets=()=>{var tmp=require("../../aws-ecr-assets");return ecr_assets=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},s3_assets=()=>{var tmp=require("../../aws-s3-assets");return s3_assets=()=>tmp,tmp},cdk=()=>{var tmp=require("../../core");return cdk=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../core/lib/errors");return errors_1=()=>tmp,tmp};class Code{static fromBucket(bucket,key,objectVersion){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromBucket),error}return new S3Code(bucket,key,objectVersion)}static fromBucketV2(bucket,key,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_BucketOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromBucketV2),error}return new S3CodeV2(bucket,key,options)}static bucket(bucket,key,objectVersion){return this.fromBucket(bucket,key,objectVersion)}static fromInline(code){return new InlineCode(code)}static inline(code){return this.fromInline(code)}static fromAsset(path,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_assets_AssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}return new AssetCode(path,options)}static fromCustomCommand(output,command,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_CustomCommandOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCustomCommand),error}if(command.length===0)throw new(errors_1()).UnscopedValidationError('command must contain at least one argument. For example, ["node", "buildFile.js"].');const cmd=command[0],commandArguments=command.splice(1),proc=options?.commandOptions===void 0?(0,child_process_1().spawnSync)(cmd,commandArguments):(0,child_process_1().spawnSync)(cmd,commandArguments,options.commandOptions);if(proc.error)throw new(errors_1()).UnscopedValidationError(`Failed to execute custom command: ${proc.error}`);if(proc.status!==0)throw new(errors_1()).UnscopedValidationError(`${command.join(" ")} exited with status: ${proc.status}

stdout: ${proc.stdout?.toString().trim()}

stderr: ${proc.stderr?.toString().trim()}`);return new AssetCode(output,options)}static fromDockerBuild(path,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_DockerBuildAssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDockerBuild),error}let imagePath=options.imagePath??"/asset/.";imagePath.endsWith("/")?imagePath=`${imagePath}.`:imagePath.endsWith("/.")||(imagePath=`${imagePath}/.`);const assetPath=cdk().DockerImage.fromBuild(path,options).cp(imagePath,options.outputPath);return new AssetCode(assetPath)}static asset(path){return this.fromAsset(path)}static fromCfnParameters(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_CfnParametersCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCfnParameters),error}return new CfnParametersCode(props)}static cfnParameters(props){return this.fromCfnParameters(props)}static fromEcrImage(repository,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_IRepository(repository),jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_EcrImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEcrImage),error}return new EcrImageCode(repository,props)}static fromAssetImage(directory,props={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_AssetImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAssetImage),error}return new AssetImageCode(directory,props)}bindToResource(_resource,_options){try{jsiiDeprecationWarnings().aws_cdk_lib_CfnResource(_resource),jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_ResourceBindOptions(_options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindToResource),error}}}exports.Code=Code,_a=JSII_RTTI_SYMBOL_1,Code[_a]={fqn:"aws-cdk-lib.aws_lambda.Code",version:"2.188.0"};class S3Code extends Code{constructor(bucket,key,objectVersion){super(),this.key=key,this.objectVersion=objectVersion,this.isInline=!1;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,S3Code),error}if(!bucket.bucketName)throw new(errors_1()).ValidationError("bucketName is undefined for the provided bucket",bucket);this.bucketName=bucket.bucketName}bind(_scope){return{s3Location:{bucketName:this.bucketName,objectKey:this.key,objectVersion:this.objectVersion}}}}exports.S3Code=S3Code,_b=JSII_RTTI_SYMBOL_1,S3Code[_b]={fqn:"aws-cdk-lib.aws_lambda.S3Code",version:"2.188.0"};class S3CodeV2 extends Code{constructor(bucket,key,options){super(),this.key=key,this.options=options,this.isInline=!1;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_BucketOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,S3CodeV2),error}if(!bucket.bucketName)throw new(errors_1()).ValidationError("bucketName is undefined for the provided bucket",bucket);this.bucketName=bucket.bucketName}bind(_scope){return{s3Location:{bucketName:this.bucketName,objectKey:this.key,objectVersion:this.options?.objectVersion},sourceKMSKeyArn:this.options?.sourceKMSKey?.keyArn}}}exports.S3CodeV2=S3CodeV2,_c=JSII_RTTI_SYMBOL_1,S3CodeV2[_c]={fqn:"aws-cdk-lib.aws_lambda.S3CodeV2",version:"2.188.0"};class InlineCode extends Code{constructor(code){if(super(),this.code=code,this.isInline=!0,code.length===0)throw new(errors_1()).UnscopedValidationError("Lambda inline code cannot be empty")}bind(_scope){return{inlineCode:this.code}}}exports.InlineCode=InlineCode,_d=JSII_RTTI_SYMBOL_1,InlineCode[_d]={fqn:"aws-cdk-lib.aws_lambda.InlineCode",version:"2.188.0"};class AssetCode extends Code{constructor(path,options={}){super(),this.path=path,this.options=options,this.isInline=!1;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_assets_AssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AssetCode),error}}bind(scope){if(!this.asset)this.asset=new(s3_assets()).Asset(scope,"Code",{path:this.path,deployTime:!0,...this.options});else if(cdk().Stack.of(this.asset)!==cdk().Stack.of(scope))throw new(errors_1()).ValidationError(`Asset is already associated with another stack '${cdk().Stack.of(this.asset).stackName}'. Create a new Code instance for every stack.`,scope);if(!this.asset.isZipArchive)throw new(errors_1()).ValidationError(`Asset must be a .zip file or a directory (${this.path})`,scope);return{s3Location:{bucketName:this.asset.s3BucketName,objectKey:this.asset.s3ObjectKey},sourceKMSKeyArn:this.options.sourceKMSKey?.keyArn}}bindToResource(resource,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_CfnResource(resource),jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_ResourceBindOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindToResource),error}if(!this.asset)throw new(errors_1()).ValidationError("bindToResource() must be called after bind()",resource);const resourceProperty=options.resourceProperty||"Code";this.asset.addResourceMetadata(resource,resourceProperty)}}exports.AssetCode=AssetCode,_e=JSII_RTTI_SYMBOL_1,AssetCode[_e]={fqn:"aws-cdk-lib.aws_lambda.AssetCode",version:"2.188.0"};class CfnParametersCode extends Code{constructor(props={}){super(),this.isInline=!1;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_CfnParametersCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnParametersCode),error}this._bucketNameParam=props.bucketNameParam,this._objectKeyParam=props.objectKeyParam,this._sourceKMSKey=props.sourceKMSKey}bind(scope){return this._bucketNameParam||(this._bucketNameParam=new(cdk()).CfnParameter(scope,"LambdaSourceBucketNameParameter",{type:"String"})),this._objectKeyParam||(this._objectKeyParam=new(cdk()).CfnParameter(scope,"LambdaSourceObjectKeyParameter",{type:"String"})),{s3Location:{bucketName:this._bucketNameParam.valueAsString,objectKey:this._objectKeyParam.valueAsString},sourceKMSKeyArn:this._sourceKMSKey?.keyArn}}assign(location){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_Location(location)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.assign),error}const ret={};return ret[this.bucketNameParam]=location.bucketName,ret[this.objectKeyParam]=location.objectKey,ret}get bucketNameParam(){if(this._bucketNameParam)return this._bucketNameParam.logicalId;throw new(errors_1()).UnscopedValidationError("Pass CfnParametersCode to a Lambda Function before accessing the bucketNameParam property")}get objectKeyParam(){if(this._objectKeyParam)return this._objectKeyParam.logicalId;throw new(errors_1()).UnscopedValidationError("Pass CfnParametersCode to a Lambda Function before accessing the objectKeyParam property")}}exports.CfnParametersCode=CfnParametersCode,_f=JSII_RTTI_SYMBOL_1,CfnParametersCode[_f]={fqn:"aws-cdk-lib.aws_lambda.CfnParametersCode",version:"2.188.0"};class EcrImageCode extends Code{constructor(repository,props={}){super(),this.repository=repository,this.props=props,this.isInline=!1;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_IRepository(repository),jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_EcrImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EcrImageCode),error}}bind(_scope){return this.repository.grantPull(new(iam()).ServicePrincipal("lambda.amazonaws.com")),{image:{imageUri:this.repository.repositoryUriForTagOrDigest(this.props?.tagOrDigest??this.props?.tag??"latest"),cmd:this.props.cmd,entrypoint:this.props.entrypoint,workingDirectory:this.props.workingDirectory}}}}exports.EcrImageCode=EcrImageCode,_g=JSII_RTTI_SYMBOL_1,EcrImageCode[_g]={fqn:"aws-cdk-lib.aws_lambda.EcrImageCode",version:"2.188.0"};class AssetImageCode extends Code{constructor(directory,props){super(),this.directory=directory,this.props=props,this.isInline=!1;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_AssetImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AssetImageCode),error}}bind(scope){if(!this.asset)this.asset=new(ecr_assets()).DockerImageAsset(scope,"AssetImage",{directory:this.directory,...this.props}),this.asset.repository.grantPull(new(iam()).ServicePrincipal("lambda.amazonaws.com"));else if(cdk().Stack.of(this.asset)!==cdk().Stack.of(scope))throw new(errors_1()).ValidationError(`Asset is already associated with another stack '${cdk().Stack.of(this.asset).stackName}'. Create a new Code instance for every stack.`,scope);return{image:{imageUri:this.asset.imageUri,entrypoint:this.props.entrypoint,cmd:this.props.cmd,workingDirectory:this.props.workingDirectory}}}bindToResource(resource,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_CfnResource(resource),jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_ResourceBindOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindToResource),error}if(!this.asset)throw new(errors_1()).ValidationError("bindToResource() must be called after bind()",resource);const resourceProperty=options.resourceProperty||"Code.ImageUri";this.asset.addResourceMetadata(resource,resourceProperty)}}exports.AssetImageCode=AssetImageCode,_h=JSII_RTTI_SYMBOL_1,AssetImageCode[_h]={fqn:"aws-cdk-lib.aws_lambda.AssetImageCode",version:"2.188.0"};
