import { Construct } from 'constructs';
import * as lambda from '../../aws-lambda';
import * as s3 from '../../aws-s3';
/**
 * Use a S3 bucket as a Lambda destination
 */
export declare class S3Destination implements lambda.IDestination {
    private readonly bucket;
    constructor(bucket: s3.IBucket);
    /**
     * Returns a destination configuration
     */
    bind(_scope: Construct, fn: lambda.IFunction, _options?: lambda.DestinationOptions): lambda.DestinationConfig;
}
