"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.createLoggingOptions=createLoggingOptions,exports.createBufferingHints=createBufferingHints,exports.createEncryptionConfig=createEncryptionConfig,exports.createProcessingConfig=createProcessingConfig,exports.createBackupConfig=createBackupConfig;var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},logs=()=>{var tmp=require("../../../aws-logs");return logs=()=>tmp,tmp},s3=()=>{var tmp=require("../../../aws-s3");return s3=()=>tmp,tmp},cdk=()=>{var tmp=require("../../../core");return cdk=()=>tmp,tmp};function createLoggingOptions(scope,props){if(props.loggingConfig?.logging!==!1||props.loggingConfig?.logGroup){const logGroup=props.loggingConfig?.logGroup??constructs_1().Node.of(scope).tryFindChild("LogGroup")??new(logs()).LogGroup(scope,"LogGroup"),logGroupGrant=logGroup.grantWrite(props.role);return{loggingOptions:{enabled:!0,logGroupName:logGroup.logGroupName,logStreamName:logGroup.addStream(props.streamId).logStreamName},dependables:[logGroupGrant]}}}function createBufferingHints(scope,interval,size){if(!interval&&!size)return;const intervalInSeconds=interval?.toSeconds()??300;if(intervalInSeconds>900)throw new(cdk()).ValidationError(`Buffering interval must be less than 900 seconds. Buffering interval provided was ${intervalInSeconds} seconds.`,scope);const sizeInMBs=size?.toMebibytes()??5;if(sizeInMBs<1||sizeInMBs>128)throw new(cdk()).ValidationError(`Buffering size must be between 1 and 128 MiBs. Buffering size provided was ${sizeInMBs} MiBs.`,scope);return{intervalInSeconds,sizeInMBs}}function createEncryptionConfig(role,encryptionKey){return encryptionKey?.grantEncryptDecrypt(role),encryptionKey?{kmsEncryptionConfig:{awskmsKeyArn:encryptionKey.keyArn}}:void 0}function createProcessingConfig(scope,role,dataProcessor){return dataProcessor?{enabled:!0,processors:[renderDataProcessor(dataProcessor,scope,role)]}:void 0}function renderDataProcessor(processor,scope,role){const processorConfig=processor.bind(scope,{role}),parameters=[{parameterName:"RoleArn",parameterValue:role.roleArn}];return parameters.push(processorConfig.processorIdentifier),processor.props.bufferInterval&&parameters.push({parameterName:"BufferIntervalInSeconds",parameterValue:processor.props.bufferInterval.toSeconds().toString()}),processor.props.bufferSize&&parameters.push({parameterName:"BufferSizeInMBs",parameterValue:processor.props.bufferSize.toMebibytes().toString()}),processor.props.retries&&parameters.push({parameterName:"NumberOfRetries",parameterValue:processor.props.retries.toString()}),{type:processorConfig.processorType,parameters}}function createBackupConfig(scope,role,props){if(!props||props.mode===void 0&&!props.bucket)return;const bucket=props.bucket??new(s3()).Bucket(scope,"BackupBucket"),bucketGrant=bucket.grantReadWrite(role),{loggingOptions,dependables:loggingDependables}=createLoggingOptions(scope,{loggingConfig:props.loggingConfig,role,streamId:"S3Backup"})??{};return{backupConfig:{bucketArn:bucket.bucketArn,roleArn:role.roleArn,prefix:props.dataOutputPrefix,errorOutputPrefix:props.errorOutputPrefix,bufferingHints:createBufferingHints(scope,props.bufferingInterval,props.bufferingSize),compressionFormat:props.compression?.value,encryptionConfiguration:createEncryptionConfig(role,props.encryptionKey),cloudWatchLoggingOptions:loggingOptions},dependables:[bucketGrant,...loggingDependables??[]]}}
