import { Construct, IDependable } from 'constructs';
import * as iam from '../../../aws-iam';
import * as kms from '../../../aws-kms';
import * as cdk from '../../../core';
import { DestinationS3BackupProps } from '../common';
import { CfnDeliveryStream } from '../kinesisfirehose.generated';
import { ILoggingConfig } from '../logging-config';
import { IDataProcessor } from '../processor';
export interface DestinationLoggingProps {
    /**
     * Configuration that determines whether to log errors during data transformation or delivery failures,
     * and specifies the CloudWatch log group for storing error logs.
     *
     * @default - errors will be logged and a log group will be created for you.
     */
    readonly loggingConfig?: ILoggingConfig;
    /**
     * The IAM role associated with this destination.
     */
    readonly role: iam.IRole;
    /**
     * The ID of the stream that is created in the log group where logs will be placed.
     *
     * Must be unique within the log group, so should be different every time this function is called.
     */
    readonly streamId: string;
}
interface ConfigWithDependables {
    /**
     * Resources that were created by the sub-config creator that must be deployed before the delivery stream is deployed.
     */
    readonly dependables: IDependable[];
}
export interface DestinationLoggingConfig extends ConfigWithDependables {
    /**
     * Logging options that will be injected into the destination configuration.
     */
    readonly loggingOptions: CfnDeliveryStream.CloudWatchLoggingOptionsProperty;
}
export interface DestinationBackupConfig extends ConfigWithDependables {
    /**
     * S3 backup configuration that will be injected into the destination configuration.
     */
    readonly backupConfig: CfnDeliveryStream.S3DestinationConfigurationProperty;
}
export declare function createLoggingOptions(scope: Construct, props: DestinationLoggingProps): DestinationLoggingConfig | undefined;
export declare function createBufferingHints(scope: Construct, interval?: cdk.Duration, size?: cdk.Size): CfnDeliveryStream.BufferingHintsProperty | undefined;
export declare function createEncryptionConfig(role: iam.IRole, encryptionKey?: kms.IKey): CfnDeliveryStream.EncryptionConfigurationProperty | undefined;
export declare function createProcessingConfig(scope: Construct, role: iam.IRole, dataProcessor?: IDataProcessor): CfnDeliveryStream.ProcessingConfigurationProperty | undefined;
export declare function createBackupConfig(scope: Construct, role: iam.IRole, props?: DestinationS3BackupProps): DestinationBackupConfig | undefined;
export {};
