import { StreamEncryptionType } from './delivery-stream';
import { IKey } from '../../aws-kms';
/**
 * Represents server-side encryption for an Amazon Firehose Delivery Stream.
 */
export declare abstract class StreamEncryption {
    readonly type: StreamEncryptionType;
    readonly encryptionKey?: IKey | undefined;
    /**
     * No server-side encryption is configured.
     */
    static unencrypted(): StreamEncryption;
    /**
     * Configure server-side encryption using an AWS owned key.
     */
    static awsOwnedKey(): StreamEncryption;
    /**
     * Configure server-side encryption using customer managed keys.
     *
     * @param encryptionKey the KMS key for the delivery stream.
     */
    static customerManagedKey(encryptionKey?: IKey): StreamEncryption;
    /**
     * Constructor for StreamEncryption.
     *
     * @param type The type of server-side encryption for the Amazon Firehose delivery stream.
     * @param encryptionKey Optional KMS key used for customer managed encryption.
     */
    private constructor();
}
