"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DeliveryStream=exports.StreamEncryptionType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},kinesisfirehose_canned_metrics_generated_1=()=>{var tmp=require("./kinesisfirehose-canned-metrics.generated");return kinesisfirehose_canned_metrics_generated_1=()=>tmp,tmp},kinesisfirehose_generated_1=()=>{var tmp=require("./kinesisfirehose.generated");return kinesisfirehose_generated_1=()=>tmp,tmp},cloudwatch=()=>{var tmp=require("../../aws-cloudwatch");return cloudwatch=()=>tmp,tmp},ec2=()=>{var tmp=require("../../aws-ec2");return ec2=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},kms=()=>{var tmp=require("../../aws-kms");return kms=()=>tmp,tmp},cdk=()=>{var tmp=require("../../core");return cdk=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},region_info_1=()=>{var tmp=require("../../region-info");return region_info_1=()=>tmp,tmp};const PUT_RECORD_ACTIONS=["firehose:PutRecord","firehose:PutRecordBatch"];class DeliveryStreamBase extends cdk().Resource{constructor(scope,id,props={}){super(scope,id,props),this.connections=setConnections(this)}grant(grantee,...actions){return iam().Grant.addToPrincipal({resourceArns:[this.deliveryStreamArn],grantee,actions})}grantPutRecords(grantee){return this.grant(grantee,...PUT_RECORD_ACTIONS)}metric(metricName,props){return new(cloudwatch()).Metric({namespace:"AWS/Firehose",metricName,dimensionsMap:{DeliveryStreamName:this.deliveryStreamName},...props}).attachTo(this)}metricIncomingBytes(props){return this.cannedMetric(kinesisfirehose_canned_metrics_generated_1().FirehoseMetrics.incomingBytesSum,props)}metricIncomingRecords(props){return this.cannedMetric(kinesisfirehose_canned_metrics_generated_1().FirehoseMetrics.incomingRecordsSum,props)}metricBackupToS3Bytes(props){return this.cannedMetric(kinesisfirehose_canned_metrics_generated_1().FirehoseMetrics.backupToS3BytesSum,props)}metricBackupToS3DataFreshness(props){return this.cannedMetric(kinesisfirehose_canned_metrics_generated_1().FirehoseMetrics.backupToS3DataFreshnessAverage,props)}metricBackupToS3Records(props){return this.cannedMetric(kinesisfirehose_canned_metrics_generated_1().FirehoseMetrics.backupToS3RecordsSum,props)}cannedMetric(fn,props){return new(cloudwatch()).Metric({...fn({DeliveryStreamName:this.deliveryStreamName}),...props}).attachTo(this)}}var StreamEncryptionType;(function(StreamEncryptionType2){StreamEncryptionType2[StreamEncryptionType2.UNENCRYPTED=0]="UNENCRYPTED",StreamEncryptionType2[StreamEncryptionType2.CUSTOMER_MANAGED=1]="CUSTOMER_MANAGED",StreamEncryptionType2[StreamEncryptionType2.AWS_OWNED=2]="AWS_OWNED"})(StreamEncryptionType||(exports.StreamEncryptionType=StreamEncryptionType={}));class DeliveryStream extends DeliveryStreamBase{static fromDeliveryStreamName(scope,id,deliveryStreamName){return this.fromDeliveryStreamAttributes(scope,id,{deliveryStreamName})}static fromDeliveryStreamArn(scope,id,deliveryStreamArn){return this.fromDeliveryStreamAttributes(scope,id,{deliveryStreamArn})}static fromDeliveryStreamAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_kinesisfirehose_DeliveryStreamAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDeliveryStreamAttributes),error}if(!attrs.deliveryStreamName&&!attrs.deliveryStreamArn)throw new(cdk()).ValidationError("Either deliveryStreamName or deliveryStreamArn must be provided in DeliveryStreamAttributes",scope);const deliveryStreamName=attrs.deliveryStreamName??cdk().Stack.of(scope).splitArn(attrs.deliveryStreamArn,cdk().ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!deliveryStreamName)throw new(cdk()).ValidationError(`No delivery stream name found in ARN: '${attrs.deliveryStreamArn}'`,scope);const deliveryStreamArn=attrs.deliveryStreamArn??cdk().Stack.of(scope).formatArn({service:"firehose",resource:"deliverystream",resourceName:attrs.deliveryStreamName,arnFormat:cdk().ArnFormat.SLASH_RESOURCE_NAME});class Import extends DeliveryStreamBase{constructor(){super(...arguments),this.deliveryStreamName=deliveryStreamName,this.deliveryStreamArn=deliveryStreamArn,this.grantPrincipal=attrs.role??new(iam()).UnknownPrincipal({resource:this})}}return new Import(scope,id)}get grantPrincipal(){return this._role?this._role:new(iam()).Role(this,"Service Role",{assumedBy:new(iam()).ServicePrincipal("firehose.amazonaws.com")})}constructor(scope,id,props){super(scope,id,{physicalName:props.deliveryStreamName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_kinesisfirehose_DeliveryStreamProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DeliveryStream),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),this._role=props.role,(props.encryption?.encryptionKey||props.source)&&(this._role=this._role??new(iam()).Role(this,"Service Role",{assumedBy:new(iam()).ServicePrincipal("firehose.amazonaws.com")})),props.source&&(props.encryption?.type===StreamEncryptionType.AWS_OWNED||props.encryption?.type===StreamEncryptionType.CUSTOMER_MANAGED))throw new(cdk()).ValidationError("Requested server-side encryption but delivery stream source is a Kinesis data stream. Specify server-side encryption on the data stream instead.",this);const encryptionKey=props.encryption?.encryptionKey??(props.encryption?.type===StreamEncryptionType.CUSTOMER_MANAGED?new(kms()).Key(this,"Key"):void 0),encryptionConfig=encryptionKey||props.encryption?.type===StreamEncryptionType.AWS_OWNED?{keyArn:encryptionKey?.keyArn,keyType:encryptionKey?"CUSTOMER_MANAGED_CMK":"AWS_OWNED_CMK"}:void 0;this._role&&encryptionKey&&encryptionKey?.grantEncryptDecrypt(this._role);let readStreamGrant;this._role&&props.source&&(readStreamGrant=props.source.grantRead(this._role));const destinationConfig=props.destination.bind(this,{}),sourceConfig=props.source?._bind(this,this._role?.roleArn),resource=new(kinesisfirehose_generated_1()).CfnDeliveryStream(this,"Resource",{deliveryStreamEncryptionConfigurationInput:encryptionConfig,deliveryStreamName:props.deliveryStreamName,deliveryStreamType:props.source?"KinesisStreamAsSource":"DirectPut",...sourceConfig,...destinationConfig});destinationConfig.dependables?.forEach(dependable=>resource.node.addDependency(dependable)),readStreamGrant&&resource.node.addDependency(readStreamGrant),this.deliveryStreamArn=this.getResourceArnAttribute(resource.attrArn,{service:"kinesis",resource:"deliverystream",resourceName:this.physicalName}),this.deliveryStreamName=this.getResourceNameAttribute(resource.ref)}}exports.DeliveryStream=DeliveryStream,_a=JSII_RTTI_SYMBOL_1,DeliveryStream[_a]={fqn:"aws-cdk-lib.aws_kinesisfirehose.DeliveryStream",version:"2.188.0"};function setConnections(scope){const stack=cdk().Stack.of(scope),mappingId="@aws-cdk/aws-kinesisfirehose.CidrBlocks";let cfnMapping=constructs_1().Node.of(stack).tryFindChild(mappingId);if(!cfnMapping){const mapping={};region_info_1().RegionInfo.regions.forEach(regionInfo=>{regionInfo.firehoseCidrBlock&&(mapping[regionInfo.name]={FirehoseCidrBlock:regionInfo.firehoseCidrBlock})}),cfnMapping=new(cdk()).CfnMapping(stack,mappingId,{mapping,lazy:!0})}const cidrBlock=cfnMapping.findInMap(stack.region,"FirehoseCidrBlock");return new(ec2()).Connections({peer:ec2().Peer.ipv4(cidrBlock)})}
