"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StreamMode=exports.StreamEncryption=exports.Stream=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var kinesis_fixed_canned_metrics_1=()=>{var tmp=require("./kinesis-fixed-canned-metrics");return kinesis_fixed_canned_metrics_1=()=>tmp,tmp},kinesis_generated_1=()=>{var tmp=require("./kinesis.generated");return kinesis_generated_1=()=>tmp,tmp},resource_policy_1=()=>{var tmp=require("./resource-policy");return resource_policy_1=()=>tmp,tmp},cloudwatch=()=>{var tmp=require("../../aws-cloudwatch");return cloudwatch=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},kms=()=>{var tmp=require("../../aws-kms");return kms=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};const READ_OPERATIONS=["kinesis:DescribeStreamSummary","kinesis:GetRecords","kinesis:GetShardIterator","kinesis:ListShards","kinesis:SubscribeToShard","kinesis:DescribeStream","kinesis:ListStreams","kinesis:DescribeStreamConsumer"],UNSUPPORTED_RESOURCE_POLICY_READ_OPERATIONS=new Set(["kinesis:DescribeStreamConsumer","kinesis:ListStreams","kinesis:SubscribeToShard"]),WRITE_OPERATIONS=["kinesis:ListShards","kinesis:PutRecord","kinesis:PutRecords"];class StreamBase extends core_1().Resource{constructor(scope,id,props={}){super(scope,id,props),this.node.addValidation({validate:()=>this.resourcePolicy?.document.validateForResourcePolicy()??[]})}addToResourcePolicy(statement){return!this.resourcePolicy&&this.autoCreatePolicy&&(this.resourcePolicy=new(resource_policy_1()).ResourcePolicy(this,"Policy",{stream:this})),this.resourcePolicy?(this.resourcePolicy.document.addStatements(statement),{statementAdded:!0,policyDependable:this.resourcePolicy}):{statementAdded:!1}}grantRead(grantee){const ret=this.grant(grantee,...READ_OPERATIONS);return this.encryptionKey&&this.encryptionKey.grantDecrypt(grantee),ret}grantWrite(grantee){const ret=this.grant(grantee,...WRITE_OPERATIONS);return this.encryptionKey?.grantEncrypt(grantee),ret}grantReadWrite(grantee){const ret=this.grant(grantee,...Array.from(new Set([...READ_OPERATIONS,...WRITE_OPERATIONS])));return this.encryptionKey?.grantEncryptDecrypt(grantee),ret}grant(grantee,...actions){return iam().Grant.addToPrincipalOrResource({grantee,actions,resourceArns:[this.streamArn],resource:{addToResourcePolicy:statement=>{const filteredActions=statement.actions.filter(action=>!UNSUPPORTED_RESOURCE_POLICY_READ_OPERATIONS.has(action));if(filteredActions.length>0){const filteredActionsStatement=statement.copy({actions:filteredActions});return this.addToResourcePolicy(filteredActionsStatement)}return{statementAdded:!1}},node:this.node,stack:this.stack,env:this.env,applyRemovalPolicy:x=>this.applyRemovalPolicy(x)}})}metric(metricName,props){return new(cloudwatch()).Metric({namespace:"AWS/Kinesis",metricName,dimensionsMap:{StreamName:this.streamName},...props}).attachTo(this)}metricGetRecordsBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.getRecordsBytesAverage,props)}metricGetRecordsIteratorAgeMilliseconds(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.getRecordsIteratorAgeMillisecondsMaximum,props)}metricGetRecordsSuccess(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.getRecordsSuccessAverage,props)}metricGetRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.getRecordsRecordsAverage,props)}metricGetRecordsLatency(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.getRecordsLatencyAverage,props)}metricPutRecordBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordBytesAverage,props)}metricPutRecordLatency(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordLatencyAverage,props)}metricPutRecordSuccess(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordSuccessAverage,props)}metricPutRecordsBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordsBytesAverage,props)}metricPutRecordsLatency(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordsLatencyAverage,props)}metricPutRecordsSuccess(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordsSuccessAverage,props)}metricPutRecordsTotalRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordsTotalRecordsAverage,props)}metricPutRecordsSuccessfulRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordsSuccessfulRecordsAverage,props)}metricPutRecordsFailedRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordsFailedRecordsAverage,props)}metricPutRecordsThrottledRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.putRecordsThrottledRecordsAverage,props)}metricIncomingBytes(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.incomingBytesAverage,props)}metricIncomingRecords(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.incomingRecordsAverage,props)}metricReadProvisionedThroughputExceeded(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.readProvisionedThroughputExceededAverage,props)}metricWriteProvisionedThroughputExceeded(props){return this.metricFromCannedFunction(kinesis_fixed_canned_metrics_1().KinesisMetrics.writeProvisionedThroughputExceededAverage,props)}metricFromCannedFunction(createCannedProps,props){return new(cloudwatch()).Metric({...createCannedProps({StreamName:this.streamName}),...props}).attachTo(this)}}class Stream extends StreamBase{static fromStreamArn(scope,id,streamArn){return Stream.fromStreamAttributes(scope,id,{streamArn})}static fromStreamAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_kinesis_StreamAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromStreamAttributes),error}class Import extends StreamBase{constructor(){super(...arguments),this.streamArn=attrs.streamArn,this.streamName=core_1().Stack.of(scope).splitArn(attrs.streamArn,core_1().ArnFormat.SLASH_RESOURCE_NAME).resourceName,this.encryptionKey=attrs.encryptionKey,this.autoCreatePolicy=!1}}return new Import(scope,id,{environmentFromArn:attrs.streamArn})}constructor(scope,id,props={}){super(scope,id,{physicalName:props.streamName}),this.autoCreatePolicy=!0;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_kinesis_StreamProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Stream),error}(0,metadata_resource_1().addConstructMetadata)(this,props);let shardCount=props.shardCount;const streamMode=props.streamMode;if(streamMode===StreamMode.ON_DEMAND&&shardCount!==void 0)throw new Error(`streamMode must be set to ${StreamMode.PROVISIONED} (default) when specifying shardCount`);(streamMode===StreamMode.PROVISIONED||streamMode===void 0)&&shardCount===void 0&&(shardCount=1);const retentionPeriodHours=props.retentionPeriod?.toHours()??24;if(!core_1().Token.isUnresolved(retentionPeriodHours)&&(retentionPeriodHours<24||retentionPeriodHours>8760))throw new Error(`retentionPeriod must be between 24 and 8760 hours. Received ${retentionPeriodHours}`);const{streamEncryption,encryptionKey}=this.parseEncryption(props);this.stream=new(kinesis_generated_1()).CfnStream(this,"Resource",{name:this.physicalName,retentionPeriodHours,shardCount,streamEncryption,...props.streamMode!==void 0?{streamModeDetails:{streamMode:props.streamMode}}:void 0}),this.stream.applyRemovalPolicy(props.removalPolicy),this.streamArn=this.getResourceArnAttribute(this.stream.attrArn,{service:"kinesis",resource:"stream",resourceName:this.physicalName}),this.streamName=this.getResourceNameAttribute(this.stream.ref),this.encryptionKey=encryptionKey}parseEncryption(props){if(!props.encryption&&!props.encryptionKey){const conditionName="AwsCdkKinesisEncryptedStreamsUnsupportedRegions";return core_1().Stack.of(this).node.tryFindChild(conditionName)||new(core_1()).CfnCondition(core_1().Stack.of(this),conditionName,{expression:core_1().Fn.conditionOr(core_1().Fn.conditionEquals(core_1().Aws.REGION,"cn-north-1"),core_1().Fn.conditionEquals(core_1().Aws.REGION,"cn-northwest-1"))}),{streamEncryption:core_1().Fn.conditionIf(conditionName,core_1().Aws.NO_VALUE,{EncryptionType:"KMS",KeyId:"alias/aws/kinesis"})}}const encryptionType=props.encryption??(props.encryptionKey?StreamEncryption.KMS:StreamEncryption.UNENCRYPTED);if(encryptionType!==StreamEncryption.KMS&&props.encryptionKey)throw new Error(`encryptionKey is specified, so 'encryption' must be set to KMS (value: ${encryptionType})`);if(encryptionType===StreamEncryption.UNENCRYPTED)return{};if(encryptionType===StreamEncryption.MANAGED)return{streamEncryption:{encryptionType:"KMS",keyId:"alias/aws/kinesis"}};if(encryptionType===StreamEncryption.KMS){const encryptionKey=props.encryptionKey||new(kms()).Key(this,"Key",{description:`Created by ${this.node.path}`}),streamEncryption={encryptionType:"KMS",keyId:encryptionKey.keyArn};return{encryptionKey,streamEncryption}}throw new Error(`Unexpected 'encryptionType': ${encryptionType}`)}}exports.Stream=Stream,_a=JSII_RTTI_SYMBOL_1,Stream[_a]={fqn:"aws-cdk-lib.aws_kinesis.Stream",version:"2.188.0"};var StreamEncryption;(function(StreamEncryption2){StreamEncryption2.UNENCRYPTED="NONE",StreamEncryption2.KMS="KMS",StreamEncryption2.MANAGED="MANAGED"})(StreamEncryption||(exports.StreamEncryption=StreamEncryption={}));var StreamMode;(function(StreamMode2){StreamMode2.PROVISIONED="PROVISIONED",StreamMode2.ON_DEMAND="ON_DEMAND"})(StreamMode||(exports.StreamMode=StreamMode={}));
