import * as cdk from "../../core";
import * as constructs from "constructs";
import * as cfn_parse from "../../core/lib/helpers-internal";
/**
 * The `AWS::GameLiftStreams::Application` resource defines an Amazon GameLift Streams application.
 *
 * An application specifies the content that you want to stream, such as a game or other software, and its runtime environment (Microsoft Windows, Ubuntu, or Proton).
 *
 * Before you create an Amazon GameLift Streams application, upload your *uncompressed* game files to an Amazon Simple Storage Service (Amazon S3) bucket.
 *
 * @cloudformationResource AWS::GameLiftStreams::Application
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable, cdk.ITaggableV2 {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME: string;
    /**
     * Build a CfnApplication from CloudFormation properties
     *
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplication;
    /**
     * An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the application resource across all AWS Regions. For example:
     *
     * `arn:aws:gameliftstreams:us-west-2:123456789012:application/a-9ZY8X7Wv6` .
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * An ID that uniquely identifies the application resource. For example: `a-9ZY8X7Wv6` .
     *
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs.
     */
    applicationLogOutputUri?: string;
    /**
     * Locations of log files that your content generates during a stream session.
     */
    applicationLogPaths?: Array<string>;
    /**
     * The location of the content that you want to stream.
     */
    applicationSourceUri: string;
    /**
     * Tag Manager which manages the tags for this resource
     */
    readonly cdkTagManager: cdk.TagManager;
    /**
     * A human-readable label for the application.
     */
    description: string;
    /**
     * The path and file name of the executable file that launches the content for streaming.
     */
    executablePath: string;
    /**
     * A set of configuration settings to run the application on a stream group.
     */
    runtimeEnvironment: cdk.IResolvable | CfnApplication.RuntimeEnvironmentProperty;
    /**
     * A list of labels to assign to the new application resource.
     */
    tags?: Record<string, string>;
    /**
     * @param scope Scope in which this resource is defined
     * @param id Construct identifier for this resource (unique in its scope)
     * @param props Resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnApplicationProps);
    protected get cfnProperties(): Record<string, any>;
    /**
     * Examines the CloudFormation resource and discloses attributes
     *
     * @param inspector tree inspector to collect and process attributes
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected renderProperties(props: Record<string, any>): Record<string, any>;
}
export declare namespace CfnApplication {
    /**
     * Configuration settings that identify the operating system for an application resource.
     *
     * This can also include a compatibility layer and other drivers.
     *
     * A runtime environment can be one of the following:
     *
     * - For Linux applications
     *
     * - Ubuntu 22.04 LTS ( `Type=UBUNTU, Version=22_04_LTS` )
     * - For Windows applications
     *
     * - Microsoft Windows Server 2022 Base ( `Type=WINDOWS, Version=2022` )
     * - Proton 8.0-5 ( `Type=PROTON, Version=20241007` )
     * - Proton 8.0-2c ( `Type=PROTON, Version=20230704` )
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-application-runtimeenvironment.html
     */
    interface RuntimeEnvironmentProperty {
        /**
         * The operating system and other drivers.
         *
         * For Proton, this also includes the Proton compatibility layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-application-runtimeenvironment.html#cfn-gameliftstreams-application-runtimeenvironment-type
         */
        readonly type: string;
        /**
         * Versioned container environment for the application operating system.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-application-runtimeenvironment.html#cfn-gameliftstreams-application-runtimeenvironment-version
         */
        readonly version: string;
    }
}
/**
 * Properties for defining a `CfnApplication`
 *
 * @struct
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html
 */
export interface CfnApplicationProps {
    /**
     * An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to save application logs.
     *
     * Required if you specify one or more `ApplicationLogPaths` .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationlogoutputuri
     */
    readonly applicationLogOutputUri?: string;
    /**
     * Locations of log files that your content generates during a stream session.
     *
     * Enter path values that are relative to the `ApplicationSourceUri` location. You can specify up to 10 log paths. Amazon GameLift Streams uploads designated log files to the Amazon S3 bucket that you specify in `ApplicationLogOutputUri` at the end of a stream session. To retrieve stored log files, call [GetStreamSession](https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html) and get the `LogFileLocationUri` .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationlogpaths
     */
    readonly applicationLogPaths?: Array<string>;
    /**
     * The location of the content that you want to stream.
     *
     * Enter an Amazon S3 URI to a bucket that contains your game or other application. The location can have a multi-level prefix structure, but it must include all the files needed to run the content. Amazon GameLift Streams copies everything under the specified location.
     *
     * This value is immutable. To designate a different content location, create a new application.
     *
     * > The Amazon S3 bucket and the Amazon GameLift Streams application must be in the same AWS Region.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationsourceuri
     */
    readonly applicationSourceUri: string;
    /**
     * A human-readable label for the application.
     *
     * You can update this value later.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-description
     */
    readonly description: string;
    /**
     * The path and file name of the executable file that launches the content for streaming.
     *
     * Enter a path value that is relative to the location set in `ApplicationSourceUri` .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-executablepath
     */
    readonly executablePath: string;
    /**
     * A set of configuration settings to run the application on a stream group.
     *
     * This configures the operating system, and can include compatibility layers and other drivers.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-runtimeenvironment
     */
    readonly runtimeEnvironment: cdk.IResolvable | CfnApplication.RuntimeEnvironmentProperty;
    /**
     * A list of labels to assign to the new application resource.
     *
     * Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *AWS General Reference* .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-tags
     */
    readonly tags?: Record<string, string>;
}
/**
 * The `AWS::GameLiftStreams::StreamGroup` resource defines a group of compute resources that will be running and streaming your game.
 *
 * When you create a stream group, you specify the hardware configuration (CPU, GPU, RAM) that will run your game (known as the *stream class* ), the geographical locations where your game can run, and the number of streams that can run simultaneously in each location (known as *stream capacity* ). Stream groups manage how Amazon GameLift Streams allocates resources and handles concurrent streams, allowing you to effectively manage capacity and costs.
 *
 * There are two types of stream capacity: always-on and on-demand.
 *
 * - *Always-on* : The streaming capacity that is allocated and ready to handle stream requests without delay. You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
 * - *On-demand* : The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated. This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).
 *
 * > Application association is not currently supported in AWS CloudFormation . To link additional applications to a stream group, use the Amazon GameLift Streams console or the AWS CLI .
 *
 * @cloudformationResource AWS::GameLiftStreams::StreamGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html
 */
export declare class CfnStreamGroup extends cdk.CfnResource implements cdk.IInspectable, cdk.ITaggableV2 {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME: string;
    /**
     * Build a CfnStreamGroup from CloudFormation properties
     *
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStreamGroup;
    /**
     * An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the stream group resource. For example: `arn:aws:gameliftstreams:us-west-2:123456789012:streamgroup/sg-1AB2C3De4` .
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * An ID that uniquely identifies the stream group resource. For example: `sg-1AB2C3De4` .
     *
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * Tag Manager which manages the tags for this resource
     */
    readonly cdkTagManager: cdk.TagManager;
    /**
     * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
     */
    defaultApplication?: CfnStreamGroup.DefaultApplicationProperty | cdk.IResolvable;
    /**
     * A descriptive label for the stream group.
     */
    description: string;
    /**
     * A set of one or more locations and the streaming capacity for each location.
     */
    locationConfigurations: Array<cdk.IResolvable | CfnStreamGroup.LocationConfigurationProperty> | cdk.IResolvable;
    /**
     * The target stream quality for sessions that are hosted in this stream group.
     */
    streamClass: string;
    /**
     * A list of labels to assign to the new stream group resource.
     */
    tags?: Record<string, string>;
    /**
     * @param scope Scope in which this resource is defined
     * @param id Construct identifier for this resource (unique in its scope)
     * @param props Resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnStreamGroupProps);
    protected get cfnProperties(): Record<string, any>;
    /**
     * Examines the CloudFormation resource and discloses attributes
     *
     * @param inspector tree inspector to collect and process attributes
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected renderProperties(props: Record<string, any>): Record<string, any>;
}
export declare namespace CfnStreamGroup {
    /**
     * Represents the default Amazon GameLift Streams application that a stream group hosts.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html
     */
    interface DefaultApplicationProperty {
        /**
         * An [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) that uniquely identifies the application resource. Format example: `arn:aws:gameliftstreams:us-west-2:123456789012:application/a-9ZY8X7Wv6` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html#cfn-gameliftstreams-streamgroup-defaultapplication-arn
         */
        readonly arn?: string;
        /**
         * An ID that uniquely identifies the application resource.
         *
         * For example: `a-9ZY8X7Wv6` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-defaultapplication.html#cfn-gameliftstreams-streamgroup-defaultapplication-id
         */
        readonly id?: string;
    }
    /**
     * Configuration settings that define a stream group's stream capacity for a location.
     *
     * When configuring a location for the first time, you must specify a numeric value for at least one of the two capacity types.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html
     */
    interface LocationConfigurationProperty {
        /**
         * The streaming capacity that is allocated and ready to handle stream requests without delay.
         *
         * You pay for this capacity whether it's in use or not. Best for quickest time from streaming request to streaming session.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-alwaysoncapacity
         */
        readonly alwaysOnCapacity?: number;
        /**
         * A location's name.
         *
         * For example, `us-east-1` . For a complete list of locations that Amazon GameLift Streams supports, refer to [Regions and quotas](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html) in the *Amazon GameLift Streams Developer Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-locationname
         */
        readonly locationName: string;
        /**
         * The streaming capacity that Amazon GameLift Streams can allocate in response to stream requests, and then de-allocate when the session has terminated.
         *
         * This offers a cost control measure at the expense of a greater startup time (typically under 5 minutes).
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gameliftstreams-streamgroup-locationconfiguration.html#cfn-gameliftstreams-streamgroup-locationconfiguration-ondemandcapacity
         */
        readonly onDemandCapacity?: number;
    }
}
/**
 * Properties for defining a `CfnStreamGroup`
 *
 * @struct
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html
 */
export interface CfnStreamGroupProps {
    /**
     * Object that identifies the Amazon GameLift Streams application to stream with this stream group.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-defaultapplication
     */
    readonly defaultApplication?: CfnStreamGroup.DefaultApplicationProperty | cdk.IResolvable;
    /**
     * A descriptive label for the stream group.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-description
     */
    readonly description: string;
    /**
     * A set of one or more locations and the streaming capacity for each location.
     *
     * One of the locations MUST be your primary location, which is the AWS Region where you are specifying this resource.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-locationconfigurations
     */
    readonly locationConfigurations: Array<cdk.IResolvable | CfnStreamGroup.LocationConfigurationProperty> | cdk.IResolvable;
    /**
     * The target stream quality for sessions that are hosted in this stream group.
     *
     * Set a stream class that is appropriate to the type of content that you're streaming. Stream class determines the type of computing resources Amazon GameLift Streams uses and impacts the cost of streaming. The following options are available:
     *
     * A stream class can be one of the following:
     *
     * - *`gen5n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
     *
     * - Reference resolution: 1080p
     * - Reference frame rate: 60 fps
     * - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * - Tenancy: Supports 1 concurrent stream session
     * - *`gen5n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA A10G Tensor GPU.
     *
     * - Reference resolution: 1080p
     * - Reference frame rate: 60 fps
     * - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
     * - Tenancy: Supports up to 2 concurrent stream sessions
     * - *`gen5n_ultra` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
     *
     * - Reference resolution: 1080p
     * - Reference frame rate: 60 fps
     * - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
     * - Tenancy: Supports 1 concurrent stream session
     * - *`gen4n_win2022` (NVIDIA, ultra)* Supports applications with extremely high 3D scene complexity. Runs applications on Microsoft Windows Server 2022 Base and supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32 and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
     *
     * - Reference resolution: 1080p
     * - Reference frame rate: 60 fps
     * - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * - Tenancy: Supports 1 concurrent stream session
     * - *`gen4n_high` (NVIDIA, high)* Supports applications with moderate to high 3D scene complexity. Uses NVIDIA T4 Tensor GPU.
     *
     * - Reference resolution: 1080p
     * - Reference frame rate: 60 fps
     * - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
     * - Tenancy: Supports up to 2 concurrent stream sessions
     * - *`gen4n_ultra` (NVIDIA, ultra)* Supports applications with high 3D scene complexity. Uses dedicated NVIDIA T4 Tensor GPU.
     *
     * - Reference resolution: 1080p
     * - Reference frame rate: 60 fps
     * - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
     * - Tenancy: Supports 1 concurrent stream session
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-streamclass
     */
    readonly streamClass: string;
    /**
     * A list of labels to assign to the new stream group resource.
     *
     * Tags are developer-defined key-value pairs. Tagging AWS resources is useful for resource management, access management and cost allocation. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *AWS General Reference* .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-tags
     */
    readonly tags?: Record<string, string>;
}
