"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.EventBusPolicy=exports.EventBus=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var archive_1=()=>{var tmp=require("./archive");return archive_1=()=>tmp,tmp},events_generated_1=()=>{var tmp=require("./events.generated");return events_generated_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../cx-api");return cxapi=()=>tmp,tmp};class EventBusBase extends core_1().Resource{archive(id,props){return new(archive_1()).Archive(this,id,{sourceEventBus:this,description:props.description||`Event Archive for ${this.eventBusName} Event Bus`,eventPattern:props.eventPattern,retention:props.retention,archiveName:props.archiveName})}grantPutEventsTo(grantee,sid){const actions=["events:PutEvents"],resourceArns=[this.eventBusArn],options={grantee,actions,resourceArns:[this.eventBusArn]},grantResult=iam().Grant.addToPrincipal(options);if(grantResult.success)return grantResult;if(core_1().FeatureFlags.of(this).isEnabled(cxapi().EVENTBUS_POLICY_SID_REQUIRED)){const statement=new(iam()).PolicyStatement({actions,resources:resourceArns,principals:[grantee.grantPrincipal],sid});return iam().Grant.addStatementToResourcePolicy({...options,statement,resource:this})}else return core_1().Annotations.of(this).addWarningV2("@aws-cdk/aws-events:eventBusServicePrincipalGrant","Unable to grant PutEvents to service principal: Statement ID is required for EventBus resource policies. Either provide a 'sid' parameter or enable the '@aws-cdk/aws-events:requireEventBusPolicySid' feature flag."),iam().Grant.drop(grantee,"")}}class EventBus extends EventBusBase{static fromEventBusArn(scope,id,eventBusArn){const parts=core_1().Stack.of(scope).splitArn(eventBusArn,core_1().ArnFormat.SLASH_RESOURCE_NAME);return new ImportedEventBus(scope,id,{eventBusArn,eventBusName:parts.resourceName||"",eventBusPolicy:""})}static fromEventBusName(scope,id,eventBusName){const eventBusArn=core_1().Stack.of(scope).formatArn({resource:"event-bus",service:"events",resourceName:eventBusName});return EventBus.fromEventBusAttributes(scope,id,{eventBusName,eventBusArn,eventBusPolicy:""})}static fromEventBusAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_events_EventBusAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEventBusAttributes),error}return new ImportedEventBus(scope,id,attrs)}static grantPutEvents(grantee){return iam().Grant.addToPrincipal({grantee,actions:["events:PutEvents"],resourceArns:["*"]})}static grantAllPutEvents(grantee){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantAllPutEvents),error}return iam().Grant.addToPrincipal({grantee,actions:["events:PutEvents"],resourceArns:["*"]})}static eventBusProps(defaultEventBusName,props={}){const{eventBusName,eventSourceName}=props,eventBusNameRegex=/^[\/\.\-_A-Za-z0-9]{1,256}$/;if(eventBusName!==void 0&&eventSourceName!==void 0)throw new Error("'eventBusName' and 'eventSourceName' cannot both be provided");if(eventBusName!==void 0){if(!core_1().Token.isUnresolved(eventBusName)){if(eventBusName==="default")throw new Error("'eventBusName' must not be 'default'");if(eventBusName.indexOf("/")>-1)throw new Error("'eventBusName' must not contain '/'");if(!eventBusNameRegex.test(eventBusName))throw new Error(`'eventBusName' must satisfy: ${eventBusNameRegex}`)}return{eventBusName}}if(eventSourceName!==void 0){if(!core_1().Token.isUnresolved(eventSourceName)){const eventSourceNameRegex=/^aws\.partner(\/[\.\-_A-Za-z0-9]+){2,}$/;if(eventSourceNameRegex.test(eventSourceName)){if(!eventBusNameRegex.test(eventSourceName))throw new Error(`'eventSourceName' must satisfy: ${eventBusNameRegex}`)}else throw new Error(`'eventSourceName' must satisfy: ${eventSourceNameRegex}`)}return{eventBusName:eventSourceName,eventSourceName}}return{eventBusName:defaultEventBusName}}constructor(scope,id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_events_EventBusProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EventBus),error}const{eventBusName,eventSourceName}=EventBus.eventBusProps(core_1().Lazy.string({produce:()=>core_1().Names.uniqueId(this)}),props);if(super(scope,id,{physicalName:eventBusName}),(0,metadata_resource_1().addConstructMetadata)(this,props),props?.description&&!core_1().Token.isUnresolved(props.description)&&props.description.length>512)throw new Error(`description must be less than or equal to 512 characters, got ${props.description.length}`);const eventBus=new(events_generated_1()).CfnEventBus(this,"Resource",{name:this.physicalName,eventSourceName,deadLetterConfig:props?.deadLetterQueue?{arn:props.deadLetterQueue.queueArn}:void 0,description:props?.description,kmsKeyIdentifier:props?.kmsKey?.keyArn});this.eventBusArn=this.getResourceArnAttribute(eventBus.attrArn,{service:"events",resource:"event-bus",resourceName:eventBus.name}),props?.kmsKey&&props?.kmsKey.addToResourcePolicy(new(iam()).PolicyStatement({resources:["*"],actions:["kms:Decrypt","kms:GenerateDataKey","kms:DescribeKey"],principals:[new(iam()).ServicePrincipal("events.amazonaws.com")],conditions:{StringEquals:{"aws:SourceAccount":this.stack.account,"aws:SourceArn":core_1().Stack.of(this).formatArn({service:"events",resource:"event-bus",resourceName:eventBusName}),"kms:EncryptionContext:aws:events:event-bus:arn":core_1().Stack.of(this).formatArn({service:"events",resource:"event-bus",resourceName:eventBusName})}}})),this.eventBusName=this.getResourceNameAttribute(eventBus.ref),this.eventBusPolicy=eventBus.attrPolicy,this.eventSourceName=eventBus.eventSourceName}addToResourcePolicy(statement){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToResourcePolicy),error}if(statement.sid==null)throw new Error("Event Bus policy statements must have a sid");const statementId=`cdk-${statement.sid}`.slice(0,64);return statement.sid=statementId,{statementAdded:!0,policyDependable:new EventBusPolicy(this,statementId,{eventBus:this,statement:statement.toJSON(),statementId})}}}exports.EventBus=EventBus,_a=JSII_RTTI_SYMBOL_1,EventBus[_a]={fqn:"aws-cdk-lib.aws_events.EventBus",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],EventBus.prototype,"addToResourcePolicy",null);class ImportedEventBus extends EventBusBase{constructor(scope,id,attrs){const arnParts=core_1().Stack.of(scope).splitArn(attrs.eventBusArn,core_1().ArnFormat.SLASH_RESOURCE_NAME);super(scope,id,{account:arnParts.account,region:arnParts.region}),(0,metadata_resource_1().addConstructMetadata)(this,attrs),this.eventBusArn=attrs.eventBusArn,this.eventBusName=attrs.eventBusName,this.eventBusPolicy=attrs.eventBusPolicy,this.eventSourceName=attrs.eventSourceName}addToResourcePolicy(_statement){return core_1().Annotations.of(this).addWarningV2("@aws-cdk/aws-events:eventBusAddToResourcePolicy",`Unable to add necessary permissions to imported target event bus: ${this.eventBusArn}`),{statementAdded:!1}}}__decorate([(0,metadata_resource_1().MethodMetadata)()],ImportedEventBus.prototype,"addToResourcePolicy",null);class EventBusPolicy extends core_1().Resource{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_events_EventBusPolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EventBusPolicy),error}(0,metadata_resource_1().addConstructMetadata)(this,props),new(events_generated_1()).CfnEventBusPolicy(this,"Resource",{statementId:props.statementId,statement:props.statement,eventBusName:props.eventBus.eventBusName})}}exports.EventBusPolicy=EventBusPolicy,_b=JSII_RTTI_SYMBOL_1,EventBusPolicy[_b]={fqn:"aws-cdk-lib.aws_events.EventBusPolicy",version:"2.188.0"};
