"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.TargetGroupBase=exports.TargetGroupIpAddressType=void 0,exports.loadBalancerNameFromListenerArn=loadBalancerNameFromListenerArn;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},enums_1=()=>{var tmp=require("./enums");return enums_1=()=>tmp,tmp},util_1=()=>{var tmp=require("./util");return util_1=()=>tmp,tmp},cdk=()=>{var tmp=require("../../../core");return cdk=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../../core/lib/errors");return errors_1=()=>tmp,tmp},elasticloadbalancingv2_generated_1=()=>{var tmp=require("../elasticloadbalancingv2.generated");return elasticloadbalancingv2_generated_1=()=>tmp,tmp},TargetGroupIpAddressType;(function(TargetGroupIpAddressType2){TargetGroupIpAddressType2.IPV4="ipv4",TargetGroupIpAddressType2.IPV6="ipv6"})(TargetGroupIpAddressType||(exports.TargetGroupIpAddressType=TargetGroupIpAddressType={}));class TargetGroupBase extends constructs_1().Construct{constructor(scope,id,baseProps,additionalProps){super(scope,id),this.loadBalancerAttachedDependencies=new(constructs_1()).DependencyGroup,this.attributes={},this.targetsJson=new Array;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_BaseTargetGroupProps(baseProps)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,TargetGroupBase),error}baseProps.deregistrationDelay!==void 0&&this.setAttribute("deregistration_delay.timeout_seconds",baseProps.deregistrationDelay.toSeconds().toString()),baseProps.crossZoneEnabled!==void 0&&this.setAttribute("load_balancing.cross_zone.enabled",baseProps.crossZoneEnabled===!0?"true":"false"),this.healthCheck=baseProps.healthCheck||{},this.vpc=baseProps.vpc,this.targetType=baseProps.targetType,this.resource=new(elasticloadbalancingv2_generated_1()).CfnTargetGroup(this,"Resource",{name:baseProps.targetGroupName,targetGroupAttributes:cdk().Lazy.any({produce:()=>(0,util_1().renderAttributes)(this.attributes)},{omitEmptyArray:!0}),targetType:cdk().Lazy.string({produce:()=>this.targetType}),targets:cdk().Lazy.any({produce:()=>this.targetsJson},{omitEmptyArray:!0}),vpcId:cdk().Lazy.string({produce:()=>this.vpc&&this.targetType!==enums_1().TargetType.LAMBDA?this.vpc.vpcId:void 0}),healthCheckEnabled:cdk().Lazy.any({produce:()=>this.healthCheck?.enabled}),healthCheckIntervalSeconds:cdk().Lazy.number({produce:()=>this.healthCheck?.interval?.toSeconds()}),healthCheckPath:cdk().Lazy.string({produce:()=>this.healthCheck?.path}),healthCheckPort:cdk().Lazy.string({produce:()=>this.healthCheck?.port}),healthCheckProtocol:cdk().Lazy.string({produce:()=>this.healthCheck?.protocol}),healthCheckTimeoutSeconds:cdk().Lazy.number({produce:()=>this.healthCheck?.timeout?.toSeconds()}),healthyThresholdCount:cdk().Lazy.number({produce:()=>this.healthCheck?.healthyThresholdCount}),unhealthyThresholdCount:cdk().Lazy.number({produce:()=>this.healthCheck?.unhealthyThresholdCount}),matcher:cdk().Lazy.any({produce:()=>this.healthCheck?.healthyHttpCodes!==void 0||this.healthCheck?.healthyGrpcCodes!==void 0?{grpcCode:this.healthCheck.healthyGrpcCodes,httpCode:this.healthCheck.healthyHttpCodes}:void 0}),ipAddressType:baseProps.ipAddressType,...additionalProps}),this.targetGroupLoadBalancerArns=this.resource.attrLoadBalancerArns,this.targetGroupArn=this.resource.ref,this.targetGroupFullName=this.resource.attrTargetGroupFullName,this.loadBalancerArns=this.resource.attrLoadBalancerArns.toString(),this.targetGroupName=this.resource.attrTargetGroupName,this.defaultPort=additionalProps.port,this.node.addValidation({validate:()=>this.validateHealthCheck()}),this.node.addValidation({validate:()=>this.validateTargetGroup()})}get loadBalancerAttached(){return this.loadBalancerAttachedDependencies}configureHealthCheck(healthCheck){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_HealthCheck(healthCheck)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureHealthCheck),error}this.healthCheck=healthCheck}setAttribute(key,value){this.attributes[key]=value}addLoadBalancerTarget(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_LoadBalancerTargetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addLoadBalancerTarget),error}if(this.targetType!==void 0&&this.targetType!==props.targetType)throw new(errors_1()).ValidationError(`Already have a of type '${this.targetType}', adding '${props.targetType}'; make all targets the same type.`,this);if(this.targetType=props.targetType,this.targetType===enums_1().TargetType.LAMBDA&&this.targetsJson.length>=1)throw new(errors_1()).ValidationError("TargetGroup can only contain one LAMBDA target. Create a new TargetGroup.",this);props.targetJson&&this.targetsJson.push(props.targetJson)}validateTargetGroup(){const ret=new Array;this.targetType===void 0&&this.targetsJson.length===0&&cdk().Annotations.of(this).addWarningV2("@aws-cdk/aws-elbv2:targetGroupSpecifyTargetTypeForEmptyTargetGroup","When creating an empty TargetGroup, you should specify a 'targetType' (this warning may become an error in the future)."),this.targetType!==enums_1().TargetType.LAMBDA&&this.vpc===void 0&&ret.push("'vpc' is required for a non-Lambda TargetGroup");const targetGroupName=this.resource.name;return!cdk().Token.isUnresolved(targetGroupName)&&targetGroupName!==void 0&&(targetGroupName.length>32&&ret.push(`Target group name: "${targetGroupName}" can have a maximum of 32 characters.`),(targetGroupName.startsWith("-")||targetGroupName.endsWith("-"))&&ret.push(`Target group name: "${targetGroupName}" must not begin or end with a hyphen.`),/^[0-9a-z-]+$/i.test(targetGroupName)||ret.push(`Target group name: "${targetGroupName}" must contain only alphanumeric characters or hyphens.`)),ret}validateHealthCheck(){const ret=new Array,intervalSeconds=this.healthCheck.interval?.toSeconds(),timeoutSeconds=this.healthCheck.timeout?.toSeconds();return intervalSeconds&&timeoutSeconds&&intervalSeconds<timeoutSeconds&&ret.push(`Health check interval must be greater than or equal to the timeout; received interval ${intervalSeconds}, timeout ${timeoutSeconds}.`),ret}}exports.TargetGroupBase=TargetGroupBase,_a=JSII_RTTI_SYMBOL_1,TargetGroupBase[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.TargetGroupBase",version:"2.188.0"};function loadBalancerNameFromListenerArn(listenerArn){const arnParts=cdk().Fn.split("/",listenerArn);return`${cdk().Fn.select(1,arnParts)}/${cdk().Fn.select(2,arnParts)}/${cdk().Fn.select(3,arnParts)}`}
