import { Construct } from 'constructs';
import { IListenerAction } from './listener-action';
import * as cxschema from '../../../cloud-assembly-schema';
import { IResource, Resource } from '../../../core';
import * as cxapi from '../../../cx-api';
/**
 * Options for listener lookup
 */
export interface BaseListenerLookupOptions {
    /**
     * Filter listeners by associated load balancer arn
     * @default - does not filter by load balancer arn
     */
    readonly loadBalancerArn?: string;
    /**
     * Filter listeners by associated load balancer tags
     * @default - does not filter by load balancer tags
     */
    readonly loadBalancerTags?: Record<string, string>;
    /**
     * Filter listeners by listener port
     * @default - does not filter by listener port
     */
    readonly listenerPort?: number;
}
/**
 * Options for querying the load balancer listener context provider
 * @internal
 */
export interface ListenerQueryContextProviderOptions {
    /**
     * User's provided options
     */
    readonly userOptions: BaseListenerLookupOptions;
    /**
     * Type of load balancer expected
     */
    readonly loadBalancerType: cxschema.LoadBalancerType;
    /**
     * ARN of the listener to look up
     * @default - does not filter by listener arn
     */
    readonly listenerArn?: string;
    /**
     * Optional protocol of the listener to look up
     */
    readonly listenerProtocol?: cxschema.LoadBalancerListenerProtocol;
}
/**
 * Base interface for listeners
 */
export interface IListener extends IResource {
    /**
     * ARN of the listener
     * @attribute
     */
    readonly listenerArn: string;
}
/**
 * Base class for listeners
 */
export declare abstract class BaseListener extends Resource implements IListener {
    /**
     * Queries the load balancer listener context provider for load balancer
     * listener info.
     * @internal
     */
    protected static _queryContextProvider(scope: Construct, options: ListenerQueryContextProviderOptions): cxapi.LoadBalancerListenerContextResponse;
    /**
     * @attribute
     */
    readonly listenerArn: string;
    /**
     * Attributes set on this listener
     */
    private readonly attributes;
    private defaultAction?;
    constructor(scope: Construct, id: string, additionalProps: any);
    /**
     * Set a non-standard attribute on the listener
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-listenerattribute.html
     */
    setAttribute(key: string, value: string | undefined): void;
    /**
     * Remove an attribute from the listener
     */
    removeAttribute(key: string): void;
    /**
     * Validate this listener
     */
    protected validateListener(): string[];
    /**
     * Configure the default action
     *
     * @internal
     */
    protected _setDefaultAction(action: IListenerAction): void;
}
