"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.NetworkLoadBalancer=exports.ClientRoutingPolicy=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var network_listener_1=()=>{var tmp=require("./network-listener");return network_listener_1=()=>tmp,tmp},cloudwatch=()=>{var tmp=require("../../../aws-cloudwatch");return cloudwatch=()=>tmp,tmp},ec2=()=>{var tmp=require("../../../aws-ec2");return ec2=()=>tmp,tmp},cxschema=()=>{var tmp=require("../../../cloud-assembly-schema");return cxschema=()=>tmp,tmp},core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../../core/lib/errors");return errors_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../../cx-api");return cxapi=()=>tmp,tmp},elasticloadbalancingv2_canned_metrics_generated_1=()=>{var tmp=require("../elasticloadbalancingv2-canned-metrics.generated");return elasticloadbalancingv2_canned_metrics_generated_1=()=>tmp,tmp},base_load_balancer_1=()=>{var tmp=require("../shared/base-load-balancer");return base_load_balancer_1=()=>tmp,tmp},enums_1=()=>{var tmp=require("../shared/enums");return enums_1=()=>tmp,tmp},util_1=()=>{var tmp=require("../shared/util");return util_1=()=>tmp,tmp},ClientRoutingPolicy;(function(ClientRoutingPolicy2){ClientRoutingPolicy2.AVAILABILITY_ZONE_AFFINITY="availability_zone_affinity",ClientRoutingPolicy2.PARTIAL_AVAILABILITY_ZONE_AFFINITY="partial_availability_zone_affinity",ClientRoutingPolicy2.ANY_AVAILABILITY_ZONE="any_availability_zone"})(ClientRoutingPolicy||(exports.ClientRoutingPolicy=ClientRoutingPolicy={}));class NetworkLoadBalancerMetrics{constructor(scope,loadBalancerFullName){this.scope=scope,this.loadBalancerFullName=loadBalancerFullName}custom(metricName,props){return new(cloudwatch()).Metric({namespace:"AWS/NetworkELB",metricName,dimensionsMap:{LoadBalancer:this.loadBalancerFullName},...props}).attachTo(this.scope)}activeFlowCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1().NetworkELBMetrics.activeFlowCountAverage,props)}consumedLCUs(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1().NetworkELBMetrics.consumedLcUsAverage,{statistic:"Sum",...props})}newFlowCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1().NetworkELBMetrics.newFlowCountSum,props)}processedBytes(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1().NetworkELBMetrics.processedBytesSum,props)}tcpClientResetCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1().NetworkELBMetrics.tcpClientResetCountSum,props)}tcpElbResetCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1().NetworkELBMetrics.tcpElbResetCountSum,props)}tcpTargetResetCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1().NetworkELBMetrics.tcpTargetResetCountSum,props)}cannedMetric(fn,props){return new(cloudwatch()).Metric({...fn({LoadBalancer:this.loadBalancerFullName}),...props}).attachTo(this.scope)}}class NetworkLoadBalancer extends base_load_balancer_1().BaseLoadBalancer{static fromLookup(scope,id,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_NetworkLoadBalancerLookupOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLookup),error}const props=base_load_balancer_1().BaseLoadBalancer._queryContextProvider(scope,{userOptions:options,loadBalancerType:cxschema().LoadBalancerType.NETWORK});return new LookedUpNetworkLoadBalancer(scope,id,props)}static fromNetworkLoadBalancerAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_NetworkLoadBalancerAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromNetworkLoadBalancerAttributes),error}class Import extends core_1().Resource{constructor(){super(...arguments),this.connections=new(ec2()).Connections({securityGroups:attrs.loadBalancerSecurityGroups?.map((securityGroupId,index)=>ec2().SecurityGroup.fromSecurityGroupId(this,`SecurityGroup-${index}`,securityGroupId))}),this.loadBalancerArn=attrs.loadBalancerArn,this.vpc=attrs.vpc,this.metrics=new NetworkLoadBalancerMetrics(this,(0,util_1().parseLoadBalancerFullName)(attrs.loadBalancerArn)),this.securityGroups=attrs.loadBalancerSecurityGroups}addListener(lid,props){return new(network_listener_1()).NetworkListener(this,lid,{loadBalancer:this,...props})}get loadBalancerCanonicalHostedZoneId(){if(attrs.loadBalancerCanonicalHostedZoneId)return attrs.loadBalancerCanonicalHostedZoneId;throw new(errors_1()).ValidationError(`'loadBalancerCanonicalHostedZoneId' was not provided when constructing Network Load Balancer ${this.node.path} from attributes`,this)}get loadBalancerDnsName(){if(attrs.loadBalancerDnsName)return attrs.loadBalancerDnsName;throw new(errors_1()).ValidationError(`'loadBalancerDnsName' was not provided when constructing Network Load Balancer ${this.node.path} from attributes`,this)}}return new Import(scope,id,{environmentFromArn:attrs.loadBalancerArn})}get securityGroups(){return this.isSecurityGroupsPropertyDefined||this.connections.securityGroups.length?this.connections.securityGroups.map(sg=>sg.securityGroupId):void 0}constructor(scope,id,props){super(scope,id,props,{type:"network",securityGroups:core_1().Lazy.list({produce:()=>this.securityGroups}),ipAddressType:props.ipAddressType,enforceSecurityGroupInboundRulesOnPrivateLinkTraffic:core_1().Lazy.string({produce:()=>this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic}),enablePrefixForIpv6SourceNat:props.enablePrefixForIpv6SourceNat===!0?"on":props.enablePrefixForIpv6SourceNat===!1?"off":void 0});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_NetworkLoadBalancerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,NetworkLoadBalancer),error}(0,metadata_resource_1().addConstructMetadata)(this,props);const minimumCapacityUnit=props.minimumCapacityUnit;if(minimumCapacityUnit&&!core_1().Token.isUnresolved(minimumCapacityUnit)){const capacityUnitPerAz=minimumCapacityUnit/props.vpc.availabilityZones.length;if(!Number.isInteger(minimumCapacityUnit)||capacityUnitPerAz<2750||capacityUnitPerAz>45e3)throw new(errors_1()).ValidationError(`'minimumCapacityUnit' must be a positive value between 2750 and 45000 per AZ for Network Load Balancer, got ${capacityUnitPerAz} LCU per AZ.`,this)}this.enablePrefixForIpv6SourceNat=props.enablePrefixForIpv6SourceNat,this.metrics=new NetworkLoadBalancerMetrics(this,this.loadBalancerFullName),this.isSecurityGroupsPropertyDefined=!!props.securityGroups,this.connections=new(ec2()).Connections({securityGroups:props.securityGroups}),this.ipAddressType=props.ipAddressType??enums_1().IpAddressType.IPV4,props.clientRoutingPolicy&&this.setAttribute("dns_record.client_routing_policy",props.clientRoutingPolicy),props.zonalShift!==void 0&&this.setAttribute("zonal_shift.config.enabled",props.zonalShift?"true":"false"),this._enforceSecurityGroupInboundRulesOnPrivateLinkTraffic=props.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic}get enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(){if(this._enforceSecurityGroupInboundRulesOnPrivateLinkTraffic!==void 0)return this._enforceSecurityGroupInboundRulesOnPrivateLinkTraffic?"on":"off"}addListener(id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_BaseNetworkListenerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addListener),error}if((props.protocol===enums_1().Protocol.UDP||props.protocol===enums_1().Protocol.TCP_UDP)&&(this.ipAddressType===enums_1().IpAddressType.DUAL_STACK||this.ipAddressType===enums_1().IpAddressType.DUAL_STACK_WITHOUT_PUBLIC_IPV4)&&this.enablePrefixForIpv6SourceNat!==!0)throw new(errors_1()).ValidationError("To add a listener with UDP protocol to a dual stack NLB, 'enablePrefixForIpv6SourceNat' must be set to true.",this);return new(network_listener_1()).NetworkListener(this,id,{loadBalancer:this,...props})}addSecurityGroup(securityGroup){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_ISecurityGroup(securityGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecurityGroup),error}this.connections.addSecurityGroup(securityGroup)}metric(metricName,props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metric","Use ``NetworkLoadBalancer.metrics.custom`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new(cloudwatch()).Metric({namespace:"AWS/NetworkELB",metricName,dimensions:{LoadBalancer:this.loadBalancerFullName},...props}).attachTo(this)}metricActiveFlowCount(props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricActiveFlowCount","Use ``NetworkLoadBalancer.metrics.activeFlowCount`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricActiveFlowCount),error}return this.metrics.activeFlowCount(props)}metricConsumedLCUs(props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricConsumedLCUs","Use ``NetworkLoadBalancer.metrics.activeFlowCount`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricConsumedLCUs),error}return this.metrics.consumedLCUs(props)}metricHealthyHostCount(props){return this.metric("HealthyHostCount",{statistic:"Average",...props})}metricUnHealthyHostCount(props){return this.metric("UnHealthyHostCount",{statistic:"Average",...props})}metricNewFlowCount(props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricNewFlowCount","Use ``NetworkLoadBalancer.metrics.newFlowCount`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricNewFlowCount),error}return this.metrics.newFlowCount(props)}metricProcessedBytes(props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricProcessedBytes","Use ``NetworkLoadBalancer.metrics.processedBytes`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricProcessedBytes),error}return this.metrics.processedBytes(props)}metricTcpClientResetCount(props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricTcpClientResetCount","Use ``NetworkLoadBalancer.metrics.tcpClientResetCount`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTcpClientResetCount),error}return this.metrics.tcpClientResetCount(props)}metricTcpElbResetCount(props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricTcpElbResetCount","Use ``NetworkLoadBalancer.metrics.tcpElbResetCount`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTcpElbResetCount),error}return this.metrics.tcpElbResetCount(props)}metricTcpTargetResetCount(props){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer#metricTcpTargetResetCount","Use ``NetworkLoadBalancer.metrics.tcpTargetResetCount`` instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTcpTargetResetCount),error}return this.metrics.tcpTargetResetCount(props)}}exports.NetworkLoadBalancer=NetworkLoadBalancer,_a=JSII_RTTI_SYMBOL_1,NetworkLoadBalancer[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"addListener",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"addSecurityGroup",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metric",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricActiveFlowCount",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricConsumedLCUs",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricHealthyHostCount",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricUnHealthyHostCount",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricNewFlowCount",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricProcessedBytes",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricTcpClientResetCount",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricTcpElbResetCount",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],NetworkLoadBalancer.prototype,"metricTcpTargetResetCount",null);class LookedUpNetworkLoadBalancer extends core_1().Resource{constructor(scope,id,props){super(scope,id,{environmentFromArn:props.loadBalancerArn}),(0,metadata_resource_1().addConstructMetadata)(this,props),this.loadBalancerArn=props.loadBalancerArn,this.loadBalancerCanonicalHostedZoneId=props.loadBalancerCanonicalHostedZoneId,this.loadBalancerDnsName=props.loadBalancerDnsName,this.metrics=new NetworkLoadBalancerMetrics(this,(0,util_1().parseLoadBalancerFullName)(props.loadBalancerArn)),this.securityGroups=props.securityGroupIds,this.connections=new(ec2()).Connections({securityGroups:props.securityGroupIds.map((securityGroupId,index)=>ec2().SecurityGroup.fromLookupById(this,`SecurityGroup-${index}`,securityGroupId))}),props.ipAddressType===cxapi().LoadBalancerIpAddressType.IPV4?this.ipAddressType=enums_1().IpAddressType.IPV4:props.ipAddressType===cxapi().LoadBalancerIpAddressType.DUAL_STACK&&(this.ipAddressType=enums_1().IpAddressType.DUAL_STACK),this.vpc=ec2().Vpc.fromLookup(this,"Vpc",{vpcId:props.vpcId})}addListener(lid,props){return new(network_listener_1()).NetworkListener(this,lid,{loadBalancer:this,...props})}}__decorate([(0,metadata_resource_1().MethodMetadata)()],LookedUpNetworkLoadBalancer.prototype,"addListener",null);
