import { Construct } from 'constructs';
import { IBucket } from '../../../aws-s3';
import { IResource, Resource } from '../../../core';
/**
 * Represents a Trust Store
 */
export interface ITrustStore extends IResource {
    /**
     * The name of the trust store
     * @attribute
     */
    readonly trustStoreName: string;
    /**
     * The ARN of the trust store
     * @attribute
     */
    readonly trustStoreArn: string;
}
/**
 * Properties used for the Trust Store
 */
export interface TrustStoreProps {
    /**
     * The name of the trust store
     *
     * @default - Auto generated
     */
    readonly trustStoreName?: string;
    /**
     * The bucket that the trust store is hosted in
     */
    readonly bucket: IBucket;
    /**
     * The key in S3 to look at for the trust store
     */
    readonly key: string;
    /**
     * The version of the S3 object that contains your truststore.
     * To specify a version, you must have versioning enabled for the S3 bucket.
     *
     * @default - latest version
     */
    readonly version?: string;
}
/**
 * A new Trust Store
 */
export declare class TrustStore extends Resource implements ITrustStore {
    /**
     * Import from ARN
     */
    static fromTrustStoreArn(scope: Construct, id: string, trustStoreArn: string): ITrustStore;
    /**
     * The name of the trust store
     *
     * @attribute
     */
    readonly trustStoreName: string;
    /**
     * The number of CA certificates in the trust store
     *
     * @attribute
     */
    readonly numberOfCaCertificates: number;
    /**
     * The status of the trust store
     *
     * @attribute
     */
    readonly status: string;
    /**
     * The ARN of the trust store
     *
     * @attribute
     */
    readonly trustStoreArn: string;
    constructor(scope: Construct, id: string, props: TrustStoreProps);
}
