"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ApplicationListener=exports.MutualAuthenticationMode=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var application_listener_action_1=()=>{var tmp=require("./application-listener-action");return application_listener_action_1=()=>tmp,tmp},application_listener_certificate_1=()=>{var tmp=require("./application-listener-certificate");return application_listener_certificate_1=()=>tmp,tmp},application_listener_rule_1=()=>{var tmp=require("./application-listener-rule");return application_listener_rule_1=()=>tmp,tmp},application_target_group_1=()=>{var tmp=require("./application-target-group");return application_target_group_1=()=>tmp,tmp},ec2=()=>{var tmp=require("../../../aws-ec2");return ec2=()=>tmp,tmp},cxschema=()=>{var tmp=require("../../../cloud-assembly-schema");return cxschema=()=>tmp,tmp},core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../../core/lib/errors");return errors_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../../cx-api");return cxapi=()=>tmp,tmp},base_listener_1=()=>{var tmp=require("../shared/base-listener");return base_listener_1=()=>tmp,tmp},enums_1=()=>{var tmp=require("../shared/enums");return enums_1=()=>tmp,tmp},listener_certificate_1=()=>{var tmp=require("../shared/listener-certificate");return listener_certificate_1=()=>tmp,tmp},util_1=()=>{var tmp=require("../shared/util");return util_1=()=>tmp,tmp},MutualAuthenticationMode;(function(MutualAuthenticationMode2){MutualAuthenticationMode2.OFF="off",MutualAuthenticationMode2.PASS_THROUGH="passthrough",MutualAuthenticationMode2.VERIFY="verify"})(MutualAuthenticationMode||(exports.MutualAuthenticationMode=MutualAuthenticationMode={}));class ApplicationListener extends base_listener_1().BaseListener{static fromLookup(scope,id,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerLookupOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLookup),error}if(core_1().Token.isUnresolved(options.listenerArn))throw new(errors_1()).ValidationError("All arguments to look up a load balancer listener must be concrete (no Tokens)",scope);let listenerProtocol;switch(options.listenerProtocol){case enums_1().ApplicationProtocol.HTTP:listenerProtocol=cxschema().LoadBalancerListenerProtocol.HTTP;break;case enums_1().ApplicationProtocol.HTTPS:listenerProtocol=cxschema().LoadBalancerListenerProtocol.HTTPS;break}const props=base_listener_1().BaseListener._queryContextProvider(scope,{userOptions:options,loadBalancerType:cxschema().LoadBalancerType.APPLICATION,listenerArn:options.listenerArn,listenerProtocol});return new LookedUpApplicationListener(scope,id,props)}static fromApplicationListenerAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromApplicationListenerAttributes),error}return new ImportedApplicationListener(scope,id,attrs)}constructor(scope,id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ApplicationListener),error}const[protocol,port]=(0,util_1().determineProtocolAndPort)(props.protocol,props.port);if(protocol===void 0||port===void 0)throw new(errors_1()).ValidationError("At least one of 'port' or 'protocol' is required",scope);validateMutualAuthentication(scope,props.mutualAuthentication);let advertiseTrustStoreCaNames;if(props.mutualAuthentication?.advertiseTrustStoreCaNames!==void 0&&(advertiseTrustStoreCaNames=props.mutualAuthentication.advertiseTrustStoreCaNames?"on":"off"),super(scope,id,{loadBalancerArn:props.loadBalancer.loadBalancerArn,certificates:core_1().Lazy.any({produce:()=>this.certificateArns.map(certificateArn=>({certificateArn}))},{omitEmptyArray:!0}),protocol,port,sslPolicy:props.sslPolicy,mutualAuthentication:props.mutualAuthentication?{advertiseTrustStoreCaNames,ignoreClientCertificateExpiry:props.mutualAuthentication?.ignoreClientCertificateExpiry,mode:props.mutualAuthentication?.mutualAuthenticationMode,trustStoreArn:props.mutualAuthentication?.trustStore?.trustStoreArn}:void 0}),(0,metadata_resource_1().addConstructMetadata)(this,props),this.loadBalancer=props.loadBalancer,this.protocol=protocol,this.port=port,this.certificateArns=[],props.certificateArns&&props.certificateArns.length>0&&this.addCertificateArns("ListenerCertificate",props.certificateArns),props.certificates&&props.certificates.length>0&&this.addCertificates("DefaultCertificates",props.certificates),this.connections=new(ec2()).Connections({securityGroups:props.loadBalancer.connections.securityGroups,defaultPort:ec2().Port.tcp(port)}),props.defaultAction&&props.defaultTargetGroups)throw new(errors_1()).ValidationError("Specify at most one of 'defaultAction' and 'defaultTargetGroups'",this);props.defaultAction&&this.setDefaultAction(props.defaultAction),props.defaultTargetGroups&&this.setDefaultAction(application_listener_action_1().ListenerAction.forward(props.defaultTargetGroups)),props.open!==!1&&(this.connections.allowDefaultPortFrom(ec2().Peer.anyIpv4(),`Allow from anyone on port ${port}`),(this.loadBalancer.ipAddressType===enums_1().IpAddressType.DUAL_STACK||this.loadBalancer.ipAddressType===enums_1().IpAddressType.DUAL_STACK_WITHOUT_PUBLIC_IPV4&&core_1().FeatureFlags.of(this).isEnabled(cxapi().ALB_DUALSTACK_WITHOUT_PUBLIC_IPV4_SECURITY_GROUP_RULES_DEFAULT))&&this.connections.allowDefaultPortFrom(ec2().Peer.anyIpv6(),`Allow from anyone on port ${port}`))}addCertificateArns(id,arns){this.addCertificates(id,arns.map(listener_certificate_1().ListenerCertificate.fromArn))}addCertificates(id,certificates){const additionalCerts=[...certificates];if(this.certificateArns.length===0&&additionalCerts.length>0){const first=additionalCerts.splice(0,1)[0];this.certificateArns.push(first.certificateArn)}for(let i=0;i<additionalCerts.length;i++)new(application_listener_certificate_1()).ApplicationListenerCertificate(this,`${id}${i+1}`,{listener:this,certificates:[additionalCerts[i]]})}addAction(id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_AddApplicationActionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAction),error}checkAddRuleProps(this,props),props.priority!==void 0?new(application_listener_rule_1()).ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,...props}):this.setDefaultAction(props.action)}addTargetGroups(id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_AddApplicationTargetGroupsProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addTargetGroups),error}checkAddRuleProps(this,props),props.priority!==void 0?new(application_listener_rule_1()).ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,...props}):this.setDefaultAction(application_listener_action_1().ListenerAction.forward(props.targetGroups))}addTargets(id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_AddApplicationTargetsProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addTargets),error}if(!this.loadBalancer.vpc)throw new(errors_1()).ValidationError("Can only call addTargets() when using a constructed Load Balancer or an imported Load Balancer with specified vpc; construct a new TargetGroup and use addTargetGroup",this);const group=new(application_target_group_1()).ApplicationTargetGroup(this,id+"Group",{vpc:this.loadBalancer.vpc,...props});return this.addTargetGroups(id,{targetGroups:[group],...props}),group}addFixedResponse(id,props){checkAddRuleProps(this,props);const fixedResponse={statusCode:props.statusCode,contentType:props.contentType,messageBody:props.messageBody};if(fixedResponse.statusCode&&!/^(2|4|5)\d\d$/.test(fixedResponse.statusCode))throw new(errors_1()).ValidationError("`statusCode` must be 2XX, 4XX or 5XX.",this);if(fixedResponse.messageBody&&fixedResponse.messageBody.length>1024)throw new(errors_1()).ValidationError("`messageBody` cannot have more than 1024 characters.",this);props.priority?new(application_listener_rule_1()).ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,fixedResponse,...props}):this.setDefaultAction(application_listener_action_1().ListenerAction.fixedResponse(core_1().Token.asNumber(props.statusCode),{contentType:props.contentType,messageBody:props.messageBody}))}addRedirectResponse(id,props){checkAddRuleProps(this,props);const redirectResponse={host:props.host,path:props.path,port:props.port,protocol:props.protocol,query:props.query,statusCode:props.statusCode};if(redirectResponse.protocol&&!/^(HTTPS?|#\{protocol\})$/i.test(redirectResponse.protocol))throw new(errors_1()).ValidationError("`protocol` must be HTTP, HTTPS, or #{protocol}.",this);if(!redirectResponse.statusCode||!/^HTTP_30[12]$/.test(redirectResponse.statusCode))throw new(errors_1()).ValidationError("`statusCode` must be HTTP_301 or HTTP_302.",this);props.priority?new(application_listener_rule_1()).ApplicationListenerRule(this,id+"Rule",{listener:this,priority:props.priority,redirectResponse,...props}):this.setDefaultAction(application_listener_action_1().ListenerAction.redirect({host:props.host,path:props.path,port:props.port,protocol:props.protocol,query:props.query,permanent:props.statusCode==="HTTP_301"}))}registerConnectable(connectable,portRange){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_IConnectable(connectable),jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_Port(portRange)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.registerConnectable),error}connectable.connections.allowFrom(this.loadBalancer,portRange,"Load balancer to target")}validateListener(){const errors=super.validateListener();return this.protocol===enums_1().ApplicationProtocol.HTTPS&&this.certificateArns.length===0&&errors.push("HTTPS Listener needs at least one certificate (call addCertificates)"),errors}setDefaultAction(action){action.bind(this,this),this._setDefaultAction(action)}}exports.ApplicationListener=ApplicationListener,_a=JSII_RTTI_SYMBOL_1,ApplicationListener[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"addCertificateArns",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"addCertificates",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"addAction",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"addTargetGroups",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"addTargets",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"addFixedResponse",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"addRedirectResponse",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],ApplicationListener.prototype,"registerConnectable",null);class ExternalApplicationListener extends core_1().Resource{constructor(scope,id){super(scope,id)}registerConnectable(connectable,portRange){this.connections.allowTo(connectable,portRange,"Load balancer to target")}addCertificateArns(id,arns){this.addCertificates(id,arns.map(listener_certificate_1().ListenerCertificate.fromArn))}addCertificates(id,certificates){new(application_listener_certificate_1()).ApplicationListenerCertificate(this,id,{listener:this,certificates})}addTargetGroups(id,props){if(checkAddRuleProps(this,props),props.priority!==void 0)new(application_listener_rule_1()).ApplicationListenerRule(this,id,{listener:this,priority:props.priority,...props});else throw new(errors_1()).ValidationError("Cannot add default Target Groups to imported ApplicationListener",this)}addTargets(_id,_props){throw new(errors_1()).ValidationError("Can only call addTargets() when using a constructed ApplicationListener; construct a new TargetGroup and use addTargetGroup.",this)}addAction(id,props){if(checkAddRuleProps(this,props),props.priority!==void 0){const ruleId=props.removeSuffix?id:id+"Rule";new(application_listener_rule_1()).ApplicationListenerRule(this,ruleId,{listener:this,priority:props.priority,...props})}else throw new(errors_1()).ValidationError("priority must be set for actions added to an imported listener",this)}}class ImportedApplicationListener extends ExternalApplicationListener{constructor(scope,id,props){super(scope,id),(0,metadata_resource_1().addConstructMetadata)(this,props),this.listenerArn=props.listenerArn;const defaultPort=props.defaultPort!==void 0?ec2().Port.tcp(props.defaultPort):void 0;this.connections=new(ec2()).Connections({securityGroups:[props.securityGroup],defaultPort})}}class LookedUpApplicationListener extends ExternalApplicationListener{constructor(scope,id,props){super(scope,id),(0,metadata_resource_1().addConstructMetadata)(this,props),this.listenerArn=props.listenerArn,this.connections=new(ec2()).Connections({defaultPort:ec2().Port.tcp(props.listenerPort)});for(const securityGroupId of props.securityGroupIds){const securityGroup=ec2().SecurityGroup.fromLookupById(this,`SecurityGroup-${securityGroupId}`,securityGroupId);this.connections.addSecurityGroup(securityGroup)}}}function checkAddRuleProps(scope,props){const hasAnyConditions=(props.conditions?.length||0)!==0||props.hostHeader!==void 0||props.pathPattern!==void 0||props.pathPatterns!==void 0,hasPriority=props.priority!==void 0;if(hasAnyConditions!==hasPriority)throw new(errors_1()).ValidationError("Setting 'conditions', 'pathPattern' or 'hostHeader' also requires 'priority', and vice versa",scope)}function validateMutualAuthentication(scope,mutualAuthentication){if(!mutualAuthentication)return;const currentMode=mutualAuthentication.mutualAuthenticationMode;if(currentMode===MutualAuthenticationMode.VERIFY&&!mutualAuthentication.trustStore)throw new(errors_1()).ValidationError(`You must set 'trustStore' when 'mode' is '${MutualAuthenticationMode.VERIFY}'`,scope);if(currentMode===MutualAuthenticationMode.OFF||currentMode===MutualAuthenticationMode.PASS_THROUGH){if(mutualAuthentication.trustStore)throw new(errors_1()).ValidationError(`You cannot set 'trustStore' when 'mode' is '${MutualAuthenticationMode.OFF}' or '${MutualAuthenticationMode.PASS_THROUGH}'`,scope);if(mutualAuthentication.ignoreClientCertificateExpiry!==void 0)throw new(errors_1()).ValidationError(`You cannot set 'ignoreClientCertificateExpiry' when 'mode' is '${MutualAuthenticationMode.OFF}' or '${MutualAuthenticationMode.PASS_THROUGH}'`,scope);if(mutualAuthentication.advertiseTrustStoreCaNames!==void 0)throw new(errors_1()).ValidationError(`You cannot set 'advertiseTrustStoreCaNames' when 'mode' is '${MutualAuthenticationMode.OFF}' or '${MutualAuthenticationMode.PASS_THROUGH}'`,scope)}}
