"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ApplicationListenerRule=exports.ContentType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},application_listener_action_1=()=>{var tmp=require("./application-listener-action");return application_listener_action_1=()=>tmp,tmp},cdk=()=>{var tmp=require("../../../core");return cdk=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../../core/lib/errors");return errors_1=()=>tmp,tmp},elasticloadbalancingv2_generated_1=()=>{var tmp=require("../elasticloadbalancingv2.generated");return elasticloadbalancingv2_generated_1=()=>tmp,tmp},ContentType;(function(ContentType2){ContentType2.TEXT_PLAIN="text/plain",ContentType2.TEXT_CSS="text/css",ContentType2.TEXT_HTML="text/html",ContentType2.APPLICATION_JAVASCRIPT="application/javascript",ContentType2.APPLICATION_JSON="application/json"})(ContentType||(exports.ContentType=ContentType={}));class ApplicationListenerRule extends constructs_1().Construct{constructor(scope,id,props){super(scope,id),this.legacyConditions={};try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationListenerRuleProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ApplicationListenerRule),error}this.conditions=props.conditions||[];const hasPathPatterns=props.pathPatterns||props.pathPattern;if(this.conditions.length===0&&!props.hostHeader&&!hasPathPatterns)throw new(errors_1()).ValidationError("At least one of 'conditions', 'hostHeader', 'pathPattern' or 'pathPatterns' is required when defining a load balancing rule.",this);const providedActions=["action","targetGroups","fixedResponse","redirectResponse"].filter(action=>props[action]!==void 0);if(providedActions.length>1)throw new(errors_1()).ValidationError(`'${providedActions}' specified together, specify only one`,this);if(!cdk().Token.isUnresolved(props.priority)&&props.priority<=0)throw new(errors_1()).ValidationError("Priority must have value greater than or equal to 1",this);this.listener=props.listener;const resource=new(elasticloadbalancingv2_generated_1()).CfnListenerRule(this,"Resource",{listenerArn:props.listener.listenerArn,priority:props.priority,conditions:cdk().Lazy.any({produce:()=>this.renderConditions()}),actions:cdk().Lazy.any({produce:()=>this.action?this.action.renderRuleActions():[]})});if(props.hostHeader&&this.setCondition("host-header",[props.hostHeader]),hasPathPatterns){if(props.pathPattern&&props.pathPatterns)throw new(errors_1()).ValidationError("Both `pathPatterns` and `pathPattern` are specified, specify only one",this);const pathPattern=props.pathPattern?[props.pathPattern]:props.pathPatterns;this.setCondition("path-pattern",pathPattern)}props.action&&this.configureAction(props.action),props.targetGroups&&this.configureAction(application_listener_action_1().ListenerAction.forward(props.targetGroups)),props.fixedResponse?this.addFixedResponse(props.fixedResponse):props.redirectResponse&&this.addRedirectResponse(props.redirectResponse),this.listenerRuleArn=resource.ref,this.node.addValidation({validate:()=>this.validateListenerRule()})}setCondition(field,values){if(values===void 0){delete this.legacyConditions[field];return}this.legacyConditions[field]=values}addCondition(condition){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_ListenerCondition(condition)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addCondition),error}this.conditions.push(condition)}configureAction(action){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancingv2_ListenerAction(action)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureAction),error}this.action&&cdk().Annotations.of(this).addWarningV2("@aws-cdk/aws-elbv2:albListnerRuleDefaultActionReplaced","An Action already existed on this ListenerRule and was replaced. Configure exactly one default Action."),action.bind(this,this.listener,this),this.action=action}addTargetGroup(targetGroup){this.configureAction(application_listener_action_1().ListenerAction.forward([targetGroup]))}addFixedResponse(fixedResponse){validateFixedResponse(fixedResponse),this.configureAction(application_listener_action_1().ListenerAction.fixedResponse(cdk().Token.asNumber(fixedResponse.statusCode),{contentType:fixedResponse.contentType,messageBody:fixedResponse.messageBody}))}addRedirectResponse(redirectResponse){validateRedirectResponse(redirectResponse),this.configureAction(application_listener_action_1().ListenerAction.redirect({host:redirectResponse.host,path:redirectResponse.path,permanent:redirectResponse.statusCode==="HTTP_301",port:redirectResponse.port,protocol:redirectResponse.protocol,query:redirectResponse.query}))}validateListenerRule(){return this.action===void 0?["Listener rule needs at least one action"]:Object.keys(this.legacyConditions).length===0&&this.conditions.length===0?["Listener rule needs at least one condition"]:[]}renderConditions(){const legacyConditions=Object.entries(this.legacyConditions).map(([field,values])=>({field,values})),conditions=this.conditions.map(condition=>condition.renderRawCondition());return[...legacyConditions,...conditions]}}exports.ApplicationListenerRule=ApplicationListenerRule,_a=JSII_RTTI_SYMBOL_1,ApplicationListenerRule[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListenerRule",version:"2.188.0"};function validateFixedResponse(fixedResponse){if(fixedResponse.statusCode&&!/^(2|4|5)\d\d$/.test(fixedResponse.statusCode))throw new(errors_1()).UnscopedValidationError("`statusCode` must be 2XX, 4XX or 5XX.");if(fixedResponse.messageBody&&fixedResponse.messageBody.length>1024)throw new(errors_1()).UnscopedValidationError("`messageBody` cannot have more than 1024 characters.")}function validateRedirectResponse(redirectResponse){if(redirectResponse.protocol&&!/^(HTTPS?|#\{protocol\})$/i.test(redirectResponse.protocol))throw new(errors_1()).UnscopedValidationError("`protocol` must be HTTP, HTTPS, or #{protocol}.");if(!redirectResponse.statusCode||!/^HTTP_30[12]$/.test(redirectResponse.statusCode))throw new(errors_1()).UnscopedValidationError("`statusCode` must be HTTP_301 or HTTP_302.")}
