import * as elbv2 from '../../aws-elasticloadbalancingv2';
/**
 * A single Application Load Balancer as the target for load balancing.
 */
export declare class AlbArnTarget implements elbv2.INetworkLoadBalancerTarget {
    private readonly albArn;
    private readonly port;
    /**
     * Create a new alb target.
     * Note that the ALB must have a listener on the provided target port.
     *
     * @param albArn The ARN of the application load balancer to load balance to
     * @param port The port on which the target is listening
     */
    constructor(albArn: string, port: number);
    /**
     * Register this alb target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup: elbv2.INetworkTargetGroup): elbv2.LoadBalancerTargetProps;
    /**
     * @internal
     */
    protected _attach(_targetGroup: elbv2.ITargetGroup): elbv2.LoadBalancerTargetProps;
}
/**
 * A single Application Load Balancer as the target for load balancing.
 * @deprecated Use `AlbListenerTarget` instead or
 * `AlbArnTarget` for an imported load balancer. This target does not automatically
 * add a dependency between the ALB listener and resulting NLB target group,
 * without which may cause stack deployments to fail if the NLB target group is provisioned
 * before the listener has been fully created.
 */
export declare class AlbTarget extends AlbArnTarget {
    /**
     * @param alb The application load balancer to load balance to
     * @param port The port on which the target is listening
     */
    constructor(alb: elbv2.IApplicationLoadBalancer, port: number);
}
/**
 * A single Application Load Balancer's listener as the target for load balancing.
 */
export declare class AlbListenerTarget extends AlbArnTarget {
    private albListener;
    /**
     * Create a new ALB target.
     * The associated target group will automatically have a dependency added
     * against the ALB's listener.
     *
     * @param albListener The application load balancer listener to target.
     */
    constructor(albListener: elbv2.ApplicationListener);
    private attach;
    /**
     * Register this ALB target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * This adds dependency on albListener because creation of ALB listener and NLB can vary during runtime.
     * More Details on - https://github.com/aws/aws-cdk/issues/17208
     */
    attachToNetworkTargetGroup(targetGroup: elbv2.INetworkTargetGroup): elbv2.LoadBalancerTargetProps;
}
