"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Nodegroup=exports.TaintEffect=exports.CapacityType=exports.NodegroupAmiType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},cluster_1=()=>{var tmp=require("./cluster");return cluster_1=()=>tmp,tmp},eks_generated_1=()=>{var tmp=require("./eks.generated");return eks_generated_1=()=>tmp,tmp},aws_ec2_1=()=>{var tmp=require("../../aws-ec2");return aws_ec2_1=()=>tmp,tmp},aws_iam_1=()=>{var tmp=require("../../aws-iam");return aws_iam_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../cx-api");return cxapi=()=>tmp,tmp},nodegroup_1=()=>{var tmp=require("./private/nodegroup");return nodegroup_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},NodegroupAmiType;(function(NodegroupAmiType2){NodegroupAmiType2.AL2_X86_64="AL2_x86_64",NodegroupAmiType2.AL2_X86_64_GPU="AL2_x86_64_GPU",NodegroupAmiType2.AL2_ARM_64="AL2_ARM_64",NodegroupAmiType2.BOTTLEROCKET_ARM_64="BOTTLEROCKET_ARM_64",NodegroupAmiType2.BOTTLEROCKET_X86_64="BOTTLEROCKET_x86_64",NodegroupAmiType2.BOTTLEROCKET_ARM_64_NVIDIA="BOTTLEROCKET_ARM_64_NVIDIA",NodegroupAmiType2.BOTTLEROCKET_X86_64_NVIDIA="BOTTLEROCKET_x86_64_NVIDIA",NodegroupAmiType2.BOTTLEROCKET_ARM_64_FIPS="BOTTLEROCKET_ARM_64_FIPS",NodegroupAmiType2.BOTTLEROCKET_X86_64_FIPS="BOTTLEROCKET_x86_64_FIPS",NodegroupAmiType2.WINDOWS_CORE_2019_X86_64="WINDOWS_CORE_2019_x86_64",NodegroupAmiType2.WINDOWS_CORE_2022_X86_64="WINDOWS_CORE_2022_x86_64",NodegroupAmiType2.WINDOWS_FULL_2019_X86_64="WINDOWS_FULL_2019_x86_64",NodegroupAmiType2.WINDOWS_FULL_2022_X86_64="WINDOWS_FULL_2022_x86_64",NodegroupAmiType2.AL2023_X86_64_STANDARD="AL2023_x86_64_STANDARD",NodegroupAmiType2.AL2023_X86_64_NEURON="AL2023_x86_64_NEURON",NodegroupAmiType2.AL2023_X86_64_NVIDIA="AL2023_x86_64_NVIDIA",NodegroupAmiType2.AL2023_ARM_64_STANDARD="AL2023_ARM_64_STANDARD"})(NodegroupAmiType||(exports.NodegroupAmiType=NodegroupAmiType={}));var CapacityType;(function(CapacityType2){CapacityType2.SPOT="SPOT",CapacityType2.ON_DEMAND="ON_DEMAND",CapacityType2.CAPACITY_BLOCK="CAPACITY_BLOCK"})(CapacityType||(exports.CapacityType=CapacityType={}));var TaintEffect;(function(TaintEffect2){TaintEffect2.NO_SCHEDULE="NO_SCHEDULE",TaintEffect2.PREFER_NO_SCHEDULE="PREFER_NO_SCHEDULE",TaintEffect2.NO_EXECUTE="NO_EXECUTE"})(TaintEffect||(exports.TaintEffect=TaintEffect={}));class Nodegroup extends core_1().Resource{static fromNodegroupName(scope,id,nodegroupName){class Import extends core_1().Resource{constructor(){super(...arguments),this.nodegroupName=nodegroupName}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id,{physicalName:props.nodegroupName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_eks_NodegroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Nodegroup),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),this.cluster=props.cluster,this.desiredSize=props.desiredSize??props.minSize??2,this.maxSize=props.maxSize??this.desiredSize,this.minSize=props.minSize??1,(0,core_1().withResolved)(this.desiredSize,this.maxSize,(desired,max)=>{if(desired!==void 0&&desired>max)throw new Error(`Desired capacity ${desired} can't be greater than max size ${max}`)}),(0,core_1().withResolved)(this.desiredSize,this.minSize,(desired,min)=>{if(desired!==void 0&&desired<min)throw new Error(`Minimum capacity ${min} can't be greater than desired size ${desired}`)}),props.launchTemplateSpec&&props.diskSize)throw new Error("diskSize must be specified within the launch template");if(props.instanceType&&props.instanceTypes)throw new Error('"instanceType is deprecated, please use "instanceTypes" only.');props.instanceType&&core_1().Annotations.of(this).addWarningV2("@aws-cdk/aws-eks:managedNodeGroupDeprecatedInstanceType",'"instanceType" is deprecated and will be removed in the next major version. please use "instanceTypes" instead');const instanceTypes=props.instanceTypes??(props.instanceType?[props.instanceType]:void 0);let possibleAmiTypes=[];if(instanceTypes&&instanceTypes.length>0){if(possibleAmiTypes=getPossibleAmiTypes(instanceTypes),props.amiType&&!possibleAmiTypes.includes(props.amiType))throw new Error(`The specified AMI does not match the instance types architecture, either specify one of ${possibleAmiTypes.join(", ").toUpperCase()} or don't specify any`);if(props.amiType&&windowsAmiTypes.includes(props.amiType)&&instanceTypes.filter(isWindowsSupportedInstanceType).length<instanceTypes.length)throw new Error("The specified instanceType does not support Windows workloads. Amazon EC2 instance types C3, C4, D2, I2, M4 (excluding m4.16xlarge), M6a.x, and R3 instances aren't supported for Windows workloads.")}if(props.nodeRole)this.role=props.nodeRole;else{const ngRole=new(aws_iam_1()).Role(this,"NodeGroupRole",{assumedBy:new(aws_iam_1()).ServicePrincipal("ec2.amazonaws.com")});ngRole.addManagedPolicy(aws_iam_1().ManagedPolicy.fromAwsManagedPolicyName("AmazonEKSWorkerNodePolicy")),ngRole.addManagedPolicy(aws_iam_1().ManagedPolicy.fromAwsManagedPolicyName("AmazonEKS_CNI_Policy")),ngRole.addManagedPolicy(aws_iam_1().ManagedPolicy.fromAwsManagedPolicyName("AmazonEC2ContainerRegistryReadOnly")),props.cluster.ipFamily==cluster_1().IpFamily.IP_V6&&ngRole.addToPrincipalPolicy(new(aws_iam_1()).PolicyStatement({resources:["arn:aws:ec2:*:*:network-interface/*"],actions:["ec2:AssignIpv6Addresses","ec2:UnassignIpv6Addresses"]})),this.role=ngRole}this.validateUpdateConfig(props.maxUnavailable,props.maxUnavailablePercentage);const resource=new(eks_generated_1()).CfnNodegroup(this,"Resource",{clusterName:this.cluster.clusterName,nodegroupName:props.nodegroupName,nodeRole:this.role.roleArn,subnets:this.cluster.vpc.selectSubnets(props.subnets).subnetIds,amiType:props.launchTemplateSpec?props.amiType:props.amiType??possibleAmiTypes[0],capacityType:props.capacityType?props.capacityType.valueOf():void 0,diskSize:props.diskSize,forceUpdateEnabled:props.forceUpdate??!0,instanceTypes:instanceTypes?.map(t=>t.toString()),labels:props.labels,taints:props.taints,launchTemplate:props.launchTemplateSpec,releaseVersion:props.releaseVersion,remoteAccess:props.remoteAccess?{ec2SshKey:props.remoteAccess.sshKeyName,sourceSecurityGroups:props.remoteAccess.sourceSecurityGroups?props.remoteAccess.sourceSecurityGroups.map(m=>m.securityGroupId):void 0}:void 0,scalingConfig:{desiredSize:this.desiredSize,maxSize:this.maxSize,minSize:this.minSize},tags:props.tags,updateConfig:props.maxUnavailable||props.maxUnavailablePercentage?{maxUnavailable:props.maxUnavailable,maxUnavailablePercentage:props.maxUnavailablePercentage}:void 0,nodeRepairConfig:props.enableNodeAutoRepair?{enabled:props.enableNodeAutoRepair}:void 0});this.cluster instanceof cluster_1().Cluster&&(props.cluster.authenticationMode!==cluster_1().AuthenticationMode.API&&this.cluster.awsAuth.addRoleMapping(this.role,{username:"system:node:{{EC2PrivateDNSName}}",groups:["system:bootstrappers","system:nodes"]}),this.cluster.albController&&constructs_1().Node.of(this.cluster.albController).addDependency(this)),this.nodegroupArn=this.getResourceArnAttribute(resource.attrArn,{service:"eks",resource:"nodegroup",resourceName:this.physicalName}),core_1().FeatureFlags.of(this).isEnabled(cxapi().EKS_NODEGROUP_NAME)?this.nodegroupName=this.getResourceNameAttribute(resource.attrNodegroupName):this.nodegroupName=this.getResourceNameAttribute(resource.ref)}validateUpdateConfig(maxUnavailable,maxUnavailablePercentage){if(!(!maxUnavailable&&!maxUnavailablePercentage)){if(maxUnavailable&&maxUnavailablePercentage)throw new Error("maxUnavailable and maxUnavailablePercentage are not allowed to be defined together");if(maxUnavailablePercentage&&(maxUnavailablePercentage<1||maxUnavailablePercentage>100))throw new Error(`maxUnavailablePercentage must be between 1 and 100, got ${maxUnavailablePercentage}`);if(maxUnavailable){if(maxUnavailable>this.maxSize)throw new Error(`maxUnavailable must be lower than maxSize (${this.maxSize}), got ${maxUnavailable}`);if(maxUnavailable<1||maxUnavailable>100)throw new Error(`maxUnavailable must be between 1 and 100, got ${maxUnavailable}`)}}}}exports.Nodegroup=Nodegroup,_a=JSII_RTTI_SYMBOL_1,Nodegroup[_a]={fqn:"aws-cdk-lib.aws_eks.Nodegroup",version:"2.188.0"};const arm64AmiTypes=[NodegroupAmiType.AL2_ARM_64,NodegroupAmiType.AL2023_ARM_64_STANDARD,NodegroupAmiType.BOTTLEROCKET_ARM_64],x8664AmiTypes=[NodegroupAmiType.AL2_X86_64,NodegroupAmiType.AL2023_X86_64_STANDARD,NodegroupAmiType.BOTTLEROCKET_X86_64,NodegroupAmiType.WINDOWS_CORE_2019_X86_64,NodegroupAmiType.WINDOWS_CORE_2022_X86_64,NodegroupAmiType.WINDOWS_FULL_2019_X86_64,NodegroupAmiType.WINDOWS_FULL_2022_X86_64],windowsAmiTypes=[NodegroupAmiType.WINDOWS_CORE_2019_X86_64,NodegroupAmiType.WINDOWS_CORE_2022_X86_64,NodegroupAmiType.WINDOWS_FULL_2019_X86_64,NodegroupAmiType.WINDOWS_FULL_2022_X86_64],gpuAmiTypes=[NodegroupAmiType.AL2_X86_64_GPU,NodegroupAmiType.AL2023_X86_64_NEURON,NodegroupAmiType.AL2023_X86_64_NVIDIA,NodegroupAmiType.BOTTLEROCKET_X86_64_NVIDIA,NodegroupAmiType.BOTTLEROCKET_ARM_64_NVIDIA];function isWindowsSupportedInstanceType(instanceType){const forbiddenInstanceClasses=[aws_ec2_1().InstanceClass.C3,aws_ec2_1().InstanceClass.C4,aws_ec2_1().InstanceClass.D2,aws_ec2_1().InstanceClass.M4,aws_ec2_1().InstanceClass.M6A,aws_ec2_1().InstanceClass.R3];return instanceType.toString()===aws_ec2_1().InstanceType.of(aws_ec2_1().InstanceClass.M4,aws_ec2_1().InstanceSize.XLARGE16).toString()||forbiddenInstanceClasses.every(c=>!instanceType.sameInstanceClassAs(aws_ec2_1().InstanceType.of(c,aws_ec2_1().InstanceSize.LARGE))&&!instanceType.toString().match(/^i2/))}function getPossibleAmiTypes(instanceTypes){function typeToArch(instanceType){return(0,nodegroup_1().isGpuInstanceType)(instanceType)?"GPU":instanceType.architecture}const archAmiMap=new Map([[aws_ec2_1().InstanceArchitecture.ARM_64,arm64AmiTypes],[aws_ec2_1().InstanceArchitecture.X86_64,x8664AmiTypes],["GPU",gpuAmiTypes]]),architectures=new Set(instanceTypes.map(typeToArch));if(architectures.size===0)throw new Error(`Cannot determine any ami type compatible with instance types: ${instanceTypes.map(i=>i.toString()).join(", ")}`);if(architectures.size>1)throw new Error("instanceTypes of different architectures is not allowed");return archAmiMap.get(Array.from(architectures)[0])}
