"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FileSystem=exports.ReplicationConfiguration=exports.ReplicationOverwriteProtection=exports.ThroughputMode=exports.PerformanceMode=exports.OutOfInfrequentAccessPolicy=exports.LifecyclePolicy=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},access_point_1=()=>{var tmp=require("./access-point");return access_point_1=()=>tmp,tmp},efs_generated_1=()=>{var tmp=require("./efs.generated");return efs_generated_1=()=>tmp,tmp},ec2=()=>{var tmp=require("../../aws-ec2");return ec2=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../cx-api");return cxapi=()=>tmp,tmp},LifecyclePolicy;(function(LifecyclePolicy2){LifecyclePolicy2.AFTER_1_DAY="AFTER_1_DAY",LifecyclePolicy2.AFTER_7_DAYS="AFTER_7_DAYS",LifecyclePolicy2.AFTER_14_DAYS="AFTER_14_DAYS",LifecyclePolicy2.AFTER_30_DAYS="AFTER_30_DAYS",LifecyclePolicy2.AFTER_60_DAYS="AFTER_60_DAYS",LifecyclePolicy2.AFTER_90_DAYS="AFTER_90_DAYS",LifecyclePolicy2.AFTER_180_DAYS="AFTER_180_DAYS",LifecyclePolicy2.AFTER_270_DAYS="AFTER_270_DAYS",LifecyclePolicy2.AFTER_365_DAYS="AFTER_365_DAYS"})(LifecyclePolicy||(exports.LifecyclePolicy=LifecyclePolicy={}));var OutOfInfrequentAccessPolicy;(function(OutOfInfrequentAccessPolicy2){OutOfInfrequentAccessPolicy2.AFTER_1_ACCESS="AFTER_1_ACCESS"})(OutOfInfrequentAccessPolicy||(exports.OutOfInfrequentAccessPolicy=OutOfInfrequentAccessPolicy={}));var PerformanceMode;(function(PerformanceMode2){PerformanceMode2.GENERAL_PURPOSE="generalPurpose",PerformanceMode2.MAX_IO="maxIO"})(PerformanceMode||(exports.PerformanceMode=PerformanceMode={}));var ThroughputMode;(function(ThroughputMode2){ThroughputMode2.BURSTING="bursting",ThroughputMode2.PROVISIONED="provisioned",ThroughputMode2.ELASTIC="elastic"})(ThroughputMode||(exports.ThroughputMode=ThroughputMode={}));var ReplicationOverwriteProtection;(function(ReplicationOverwriteProtection2){ReplicationOverwriteProtection2.ENABLED="ENABLED",ReplicationOverwriteProtection2.DISABLED="DISABLED"})(ReplicationOverwriteProtection||(exports.ReplicationOverwriteProtection=ReplicationOverwriteProtection={}));class ReplicationConfiguration{static existingFileSystem(destinationFileSystem){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_efs_IFileSystem(destinationFileSystem)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.existingFileSystem),error}return new ExistingFileSystem({destinationFileSystem})}static regionalFileSystem(region,kmsKey){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_kms_IKey(kmsKey)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.regionalFileSystem),error}return new RegionalFileSystem({region,kmsKey})}static oneZoneFileSystem(region,availabilityZone,kmsKey){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_kms_IKey(kmsKey)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.oneZoneFileSystem),error}return new OneZoneFileSystem({region,availabilityZone,kmsKey})}constructor(options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_efs_ReplicationConfigurationProps(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ReplicationConfiguration),error}this.destinationFileSystem=options.destinationFileSystem,this.kmsKey=options.kmsKey,this.region=options.region,this.availabilityZone=options.availabilityZone}}exports.ReplicationConfiguration=ReplicationConfiguration,_a=JSII_RTTI_SYMBOL_1,ReplicationConfiguration[_a]={fqn:"aws-cdk-lib.aws_efs.ReplicationConfiguration",version:"2.188.0"};class ExistingFileSystem extends ReplicationConfiguration{constructor(props){super(props)}}class RegionalFileSystem extends ReplicationConfiguration{constructor(props){super(props)}}class OneZoneFileSystem extends ReplicationConfiguration{constructor(props){super(props)}}var ClientAction;(function(ClientAction2){ClientAction2.MOUNT="elasticfilesystem:ClientMount",ClientAction2.WRITE="elasticfilesystem:ClientWrite",ClientAction2.ROOT_ACCESS="elasticfilesystem:ClientRootAccess"})(ClientAction||(ClientAction={}));class FileSystemBase extends core_1().Resource{constructor(){super(...arguments),this._grantedClient=!1}grant(grantee,...actions){return iam().Grant.addToPrincipalOrResource({grantee,actions,resourceArns:[this.fileSystemArn],resource:this})}_grantClient(grantee,actions,conditions){return this._grantedClient=!0,iam().Grant.addToPrincipalOrResource({grantee,actions,resourceArns:[this.fileSystemArn],resource:this,conditions})}grantRead(grantee){return this._grantClient(grantee,[ClientAction.MOUNT],{Bool:{"elasticfilesystem:AccessedViaMountTarget":"true"}})}grantReadWrite(grantee){return this._grantClient(grantee,[ClientAction.MOUNT,ClientAction.WRITE],{Bool:{"elasticfilesystem:AccessedViaMountTarget":"true"}})}grantRootAccess(grantee){return this._grantClient(grantee,[ClientAction.MOUNT,ClientAction.WRITE,ClientAction.ROOT_ACCESS],{Bool:{"elasticfilesystem:AccessedViaMountTarget":"true"}})}addToResourcePolicy(statement){return this._resource?(this._fileSystemPolicy=this._fileSystemPolicy??new(iam()).PolicyDocument({statements:[]}),this._fileSystemPolicy.addStatements(statement),{statementAdded:!0,policyDependable:this}):{statementAdded:!1}}}class FileSystem extends FileSystemBase{static fromFileSystemAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_efs_FileSystemAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromFileSystemAttributes),error}return new ImportedFileSystem(scope,id,attrs)}constructor(scope,id,props){super(scope,id),this._mountTargetsAvailable=new(constructs_1()).DependencyGroup;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_efs_FileSystemProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,FileSystem),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),this.props=props,props.performanceMode===PerformanceMode.MAX_IO&&props.oneZone)throw new(core_1()).ValidationError("performanceMode MAX_IO is not supported for One Zone file systems.",this);if(props.oneZone&&this.oneZoneValidation(),props.throughputMode===ThroughputMode.PROVISIONED&&props.provisionedThroughputPerSecond===void 0)throw new(core_1()).ValidationError("Property provisionedThroughputPerSecond is required when throughputMode is PROVISIONED",this);if(props.throughputMode===ThroughputMode.ELASTIC&&props.performanceMode===PerformanceMode.MAX_IO)throw new(core_1()).ValidationError("ThroughputMode ELASTIC is not supported for file systems with performanceMode MAX_IO",this);if(props.replicationConfiguration&&props.replicationOverwriteProtection===ReplicationOverwriteProtection.DISABLED)throw new(core_1()).ValidationError("Cannot configure 'replicationConfiguration' when 'replicationOverwriteProtection' is set to 'DISABLED'",this);const encrypted=props.encrypted??(core_1().FeatureFlags.of(this).isEnabled(cxapi().EFS_DEFAULT_ENCRYPTION_AT_REST)?!0:void 0),lifecyclePolicies=[];props.lifecyclePolicy&&lifecyclePolicies.push({transitionToIa:props.lifecyclePolicy}),props.outOfInfrequentAccessPolicy&&lifecyclePolicies.push({transitionToPrimaryStorageClass:props.outOfInfrequentAccessPolicy}),props.transitionToArchivePolicy&&lifecyclePolicies.push({transitionToArchive:props.transitionToArchivePolicy});const oneZoneAzName=props.vpcSubnets?.availabilityZones?props.vpcSubnets.availabilityZones[0]:props.vpc.availabilityZones[0],fileSystemProtection=props.replicationOverwriteProtection!==void 0?{replicationOverwriteProtection:props.replicationOverwriteProtection}:void 0,replicationConfiguration=props.replicationConfiguration?{destinations:[{fileSystemId:props.replicationConfiguration.destinationFileSystem?.fileSystemId,kmsKeyId:props.replicationConfiguration.kmsKey?.keyArn,region:props.replicationConfiguration.destinationFileSystem?props.replicationConfiguration.destinationFileSystem.env.region:props.replicationConfiguration.region??core_1().Stack.of(this).region,availabilityZoneName:props.replicationConfiguration.availabilityZone}]}:void 0;this._resource=new(efs_generated_1()).CfnFileSystem(this,"Resource",{encrypted,kmsKeyId:props.kmsKey?.keyArn,lifecyclePolicies:lifecyclePolicies.length>0?lifecyclePolicies:void 0,performanceMode:props.performanceMode,throughputMode:props.throughputMode,provisionedThroughputInMibps:props.provisionedThroughputPerSecond?.toMebibytes(),backupPolicy:props.enableAutomaticBackups?{status:"ENABLED"}:void 0,fileSystemPolicy:core_1().Lazy.any({produce:()=>{const denyAnonymousAccessByDefault=(core_1().FeatureFlags.of(this).isEnabled(cxapi().EFS_DENY_ANONYMOUS_ACCESS)??!1)||this._grantedClient;return(props.allowAnonymousAccess??!denyAnonymousAccessByDefault)||this.addToResourcePolicy(new(iam()).PolicyStatement({principals:[new(iam()).AnyPrincipal],actions:[ClientAction.WRITE,ClientAction.ROOT_ACCESS],conditions:{Bool:{"elasticfilesystem:AccessedViaMountTarget":"true"}}})),this._fileSystemPolicy}}),fileSystemProtection,availabilityZoneName:props.oneZone?oneZoneAzName:void 0,replicationConfiguration}),this._resource.applyRemovalPolicy(props.removalPolicy),this.fileSystemId=this._resource.ref,this.fileSystemArn=this._resource.attrArn,this._fileSystemPolicy=props.fileSystemPolicy,core_1().Tags.of(this).add("Name",props.fileSystemName||this.node.path);const securityGroup=props.securityGroup||new(ec2()).SecurityGroup(this,"EfsSecurityGroup",{vpc:props.vpc});this.connections=new(ec2()).Connections({securityGroups:[securityGroup],defaultPort:ec2().Port.tcp(FileSystem.DEFAULT_PORT)});let subnetSelection;props.oneZone?subnetSelection={availabilityZones:[oneZoneAzName]}:subnetSelection=props.vpcSubnets??{onePerAz:!0};const subnets=props.vpc.selectSubnets(subnetSelection),useMountTargetOrderInsensitiveLogicalID=core_1().FeatureFlags.of(this).isEnabled(cxapi().EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID);if(this.mountTargetsAvailable=[],useMountTargetOrderInsensitiveLogicalID)subnets.subnets.forEach(subnet=>{const mountTarget=new(efs_generated_1()).CfnMountTarget(this,`EfsMountTarget-${subnet.node.id}`,{fileSystemId:this.fileSystemId,securityGroups:Array.of(securityGroup.securityGroupId),subnetId:subnet.subnetId});this._mountTargetsAvailable.add(mountTarget)});else{let mountTargetCount=0;subnets.subnetIds.forEach(subnetId=>{const mountTarget=new(efs_generated_1()).CfnMountTarget(this,"EfsMountTarget"+ ++mountTargetCount,{fileSystemId:this.fileSystemId,securityGroups:Array.of(securityGroup.securityGroupId),subnetId});this._mountTargetsAvailable.add(mountTarget)})}this.mountTargetsAvailable=this._mountTargetsAvailable}oneZoneValidation(){if(this.props.vpcSubnets&&!this.props.vpcSubnets.availabilityZones)throw new(core_1()).ValidationError("When oneZone is enabled and vpcSubnets defined, vpcSubnets.availabilityZones can not be undefined.",this);if(this.props.vpcSubnets&&this.props.vpcSubnets.availabilityZones){if(this.props.vpcSubnets.availabilityZones?.length!==1)throw new(core_1()).ValidationError("When oneZone is enabled, vpcSubnets.availabilityZones should exactly have one zone.",this);const isNotUnresolvedToken=x=>!core_1().Token.isUnresolved(x),isNotDummy=x=>!x.startsWith("dummy");if(this.props.vpc.availabilityZones.every(isNotUnresolvedToken)&&this.props.vpc.availabilityZones.every(isNotDummy)&&!this.props.vpc.availabilityZones.includes(this.props.vpcSubnets.availabilityZones[0]))throw new(core_1()).ValidationError("vpcSubnets.availabilityZones specified is not in vpc.availabilityZones.",this)}}addAccessPoint(id,accessPointOptions={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_efs_AccessPointOptions(accessPointOptions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAccessPoint),error}return new(access_point_1()).AccessPoint(this,id,{fileSystem:this,...accessPointOptions})}}exports.FileSystem=FileSystem,_b=JSII_RTTI_SYMBOL_1,FileSystem[_b]={fqn:"aws-cdk-lib.aws_efs.FileSystem",version:"2.188.0"},FileSystem.DEFAULT_PORT=2049,__decorate([(0,metadata_resource_1().MethodMetadata)()],FileSystem.prototype,"addAccessPoint",null);class ImportedFileSystem extends FileSystemBase{constructor(scope,id,attrs){if(super(scope,id),(0,metadata_resource_1().addConstructMetadata)(this,attrs),!!attrs.fileSystemId==!!attrs.fileSystemArn)throw new(core_1()).ValidationError("One of fileSystemId or fileSystemArn, but not both, must be provided.",this);this.fileSystemArn=attrs.fileSystemArn??core_1().Stack.of(scope).formatArn({service:"elasticfilesystem",resource:"file-system",resourceName:attrs.fileSystemId});const parsedArn=core_1().Stack.of(scope).splitArn(this.fileSystemArn,core_1().ArnFormat.SLASH_RESOURCE_NAME);if(!parsedArn.resourceName)throw new(core_1()).ValidationError(`Invalid FileSystem Arn ${this.fileSystemArn}`,this);this.fileSystemId=attrs.fileSystemId??parsedArn.resourceName,this.connections=new(ec2()).Connections({securityGroups:[attrs.securityGroup],defaultPort:ec2().Port.tcp(FileSystem.DEFAULT_PORT)}),this.mountTargetsAvailable=new(constructs_1()).DependencyGroup}}
