"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.removeEmpty=removeEmpty,exports.ensurePositiveInteger=ensurePositiveInteger,exports.ensureInRange=ensureInRange,exports.stringifyOptions=stringifyOptions,exports.renderCommonLogDriverOptions=renderCommonLogDriverOptions,exports.joinWithCommas=joinWithCommas,exports.renderLogDriverSecretOptions=renderLogDriverSecretOptions;var core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp};function removeEmpty(x){for(const key of Object.keys(x))x[key]===void 0&&delete x[key];return x}function ensurePositiveInteger(val){if(!core_1().Token.isUnresolved(val)&&Number.isInteger(val)&&val<0)throw new Error(`\`${val}\` must be a positive integer.`)}function ensureInRange(val,start,end){if(!core_1().Token.isUnresolved(val)&&!(val>=start&&val<=end))throw new Error(`\`${val}\` must be within range ${start}:${end}`)}function stringifyOptions(options){const _options={},filteredOptions=removeEmpty(options);for(const[key,value]of Object.entries(filteredOptions))_options[key]=core_1().SecretValue.isSecretValue(value)?value.unsafeUnwrap():`${value}`;return _options}function renderCommonLogDriverOptions(opts){return{tag:opts.tag,labels:joinWithCommas(opts.labels),env:joinWithCommas(opts.env),"env-regex":opts.envRegex}}function joinWithCommas(xs){return xs&&xs.join(",")}function renderLogDriverSecretOptions(secretValue,taskDefinition){const secrets=[];for(const[name,secret]of Object.entries(secretValue))secret.grantRead(taskDefinition.obtainExecutionRole()),secrets.push({name,valueFrom:secret.arn});return secrets}
