"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FirelensLogRouter=exports.FirelensConfigFileType=exports.FirelensLogRouterType=void 0,exports.obtainDefaultFluentBitECRImage=obtainDefaultFluentBitECRImage;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var container_definition_1=()=>{var tmp=require("./container-definition");return container_definition_1=()=>tmp,tmp},container_image_1=()=>{var tmp=require("./container-image");return container_image_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},ssm=()=>{var tmp=require("../../aws-ssm");return ssm=()=>tmp,tmp},cdk=()=>{var tmp=require("../../core");return cdk=()=>tmp,tmp},FirelensLogRouterType;(function(FirelensLogRouterType2){FirelensLogRouterType2.FLUENTBIT="fluentbit",FirelensLogRouterType2.FLUENTD="fluentd"})(FirelensLogRouterType||(exports.FirelensLogRouterType=FirelensLogRouterType={}));var FirelensConfigFileType;(function(FirelensConfigFileType2){FirelensConfigFileType2.S3="s3",FirelensConfigFileType2.FILE="file"})(FirelensConfigFileType||(exports.FirelensConfigFileType=FirelensConfigFileType={}));function renderFirelensConfig(firelensConfig){return firelensConfig.options?firelensConfig.options.configFileValue===void 0?{type:firelensConfig.type,options:{"enable-ecs-log-metadata":firelensConfig.options.enableECSLogMetadata?"true":"false"}}:{type:firelensConfig.type,options:{"enable-ecs-log-metadata":firelensConfig.options.enableECSLogMetadata?"true":"false","config-file-type":firelensConfig.options.configFileType,"config-file-value":firelensConfig.options.configFileValue}}:{type:firelensConfig.type}}const fluentBitImageSSMPath="/aws/service/aws-for-fluent-bit";function obtainDefaultFluentBitECRImage(task,logDriverConfig,imageTag){task.addToExecutionRolePolicy(new(iam()).PolicyStatement({actions:["ecr:GetAuthorizationToken","ecr:BatchCheckLayerAvailability","ecr:GetDownloadUrlForLayer","ecr:BatchGetImage"],resources:["*"]}));const logName=logDriverConfig&&logDriverConfig.logDriver==="awsfirelens"&&logDriverConfig.options&&logDriverConfig.options.Name;if(logName==="cloudwatch"){const actions=["logs:CreateLogGroup","logs:CreateLogStream","logs:DescribeLogStreams","logs:PutLogEvents"];logDriverConfig&&logDriverConfig.options&&"log_retention_days"in logDriverConfig.options&&actions.push("logs:PutRetentionPolicy"),task.addToTaskRolePolicy(new(iam()).PolicyStatement({actions,resources:["*"]}))}else logName==="firehose"?task.addToTaskRolePolicy(new(iam()).PolicyStatement({actions:["firehose:PutRecordBatch"],resources:["*"]})):logName==="kinesis"&&task.addToTaskRolePolicy(new(iam()).PolicyStatement({actions:["kinesis:PutRecords"],resources:["*"]}));const fluentBitImage=`${fluentBitImageSSMPath}/${imageTag||"latest"}`;return container_image_1().ContainerImage.fromRegistry(ssm().StringParameter.valueForStringParameter(task,fluentBitImage))}class FirelensLogRouter extends container_definition_1().ContainerDefinition{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_FirelensLogRouterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,FirelensLogRouter),error}const options=props.firelensConfig.options;if(options){if(options.configFileValue&&options.configFileType===void 0||options.configFileValue===void 0&&options.configFileType)throw new Error("configFileValue and configFileType must be set together to define a custom config source");const hasConfig=options.configFileValue!==void 0,enableECSLogMetadata=options.enableECSLogMetadata||options.enableECSLogMetadata===void 0,configFileType=(options.configFileType===void 0||options.configFileType===FirelensConfigFileType.S3)&&(cdk().Token.isUnresolved(options.configFileValue)||/arn:aws[a-zA-Z-]*:s3:::.+/.test(options.configFileValue||""))?FirelensConfigFileType.S3:FirelensConfigFileType.FILE;this.firelensConfig={type:props.firelensConfig.type,options:{enableECSLogMetadata,...hasConfig?{configFileType,configFileValue:options.configFileValue}:{}}},hasConfig&&configFileType===FirelensConfigFileType.S3&&(props.taskDefinition.addToExecutionRolePolicy(new(iam()).PolicyStatement({actions:["s3:GetObject"],resources:[options.configFileValue??""]})),props.taskDefinition.addToExecutionRolePolicy(new(iam()).PolicyStatement({actions:["s3:GetBucketLocation"],resources:[(options.configFileValue??"").split("/")[0]]})))}else this.firelensConfig=props.firelensConfig}renderContainerDefinition(_taskDefinition){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_TaskDefinition(_taskDefinition)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.renderContainerDefinition),error}return{...super.renderContainerDefinition(),firelensConfiguration:this.firelensConfig&&renderFirelensConfig(this.firelensConfig)}}}exports.FirelensLogRouter=FirelensLogRouter,_a=JSII_RTTI_SYMBOL_1,FirelensLogRouter[_a]={fqn:"aws-cdk-lib.aws_ecs.FirelensLogRouter",version:"2.188.0"};
