"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BuiltInAttributes=exports.Ec2Service=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var ec2=()=>{var tmp=require("../../../aws-ec2");return ec2=()=>tmp,tmp},core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},availability_zone_rebalancing_1=()=>{var tmp=require("../availability-zone-rebalancing");return availability_zone_rebalancing_1=()=>tmp,tmp},base_service_1=()=>{var tmp=require("../base/base-service");return base_service_1=()=>tmp,tmp},from_service_attributes_1=()=>{var tmp=require("../base/from-service-attributes");return from_service_attributes_1=()=>tmp,tmp},task_definition_1=()=>{var tmp=require("../base/task-definition");return task_definition_1=()=>tmp,tmp};class Ec2Service extends base_service_1().BaseService{static fromEc2ServiceArn(scope,id,ec2ServiceArn){class Import extends core_1().Resource{constructor(){super(...arguments),this.serviceArn=ec2ServiceArn,this.serviceName=(0,from_service_attributes_1().extractServiceNameFromArn)(this,ec2ServiceArn)}}return new Import(scope,id)}static fromEc2ServiceAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_Ec2ServiceAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEc2ServiceAttributes),error}return(0,from_service_attributes_1().fromServiceAttributes)(scope,id,attrs)}constructor(scope,id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_Ec2ServiceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Ec2Service),error}if(props.daemon&&props.desiredCount!==void 0)throw new Error("Daemon mode launches one task on every instance. Don't supply desiredCount.");if(props.daemon&&props.maxHealthyPercent!==void 0&&props.maxHealthyPercent!==100)throw new Error("Maximum percent must be 100 for daemon mode.");if(props.minHealthyPercent!==void 0&&props.maxHealthyPercent!==void 0&&props.minHealthyPercent>=props.maxHealthyPercent)throw new Error("Minimum healthy percent must be less than maximum healthy percent.");if(!props.taskDefinition.isEc2Compatible)throw new Error("Supplied TaskDefinition is not configured for compatibility with EC2");if(props.securityGroup!==void 0&&props.securityGroups!==void 0)throw new Error("Only one of SecurityGroup or SecurityGroups can be populated.");if(props.availabilityZoneRebalancing===availability_zone_rebalancing_1().AvailabilityZoneRebalancing.ENABLED){if(props.daemon)throw new Error("AvailabilityZoneRebalancing.ENABLED cannot be used with daemon mode");if(!core_1().Token.isUnresolved(props.maxHealthyPercent)&&props.maxHealthyPercent===100)throw new Error("AvailabilityZoneRebalancing.ENABLED requires maxHealthyPercent > 100")}super(scope,id,{...props,desiredCount:props.desiredCount,maxHealthyPercent:props.daemon&&props.maxHealthyPercent===void 0?100:props.maxHealthyPercent,minHealthyPercent:props.daemon&&props.minHealthyPercent===void 0?0:props.minHealthyPercent,launchType:base_service_1().LaunchType.EC2,enableECSManagedTags:props.enableECSManagedTags},{cluster:props.cluster.clusterName,taskDefinition:props.deploymentController?.type===base_service_1().DeploymentControllerType.EXTERNAL?void 0:props.taskDefinition.taskDefinitionArn,placementConstraints:core_1().Lazy.any({produce:()=>this.constraints}),placementStrategies:core_1().Lazy.any({produce:()=>this.strategies},{omitEmptyArray:!0}),schedulingStrategy:props.daemon?"DAEMON":"REPLICA",availabilityZoneRebalancing:props.availabilityZoneRebalancing},props.taskDefinition),(0,metadata_resource_1().addConstructMetadata)(this,props),this.constraints=void 0,this.strategies=[],this.daemon=props.daemon||!1,this.availabilityZoneRebalancingEnabled=props.availabilityZoneRebalancing===availability_zone_rebalancing_1().AvailabilityZoneRebalancing.ENABLED;let securityGroups;props.securityGroup!==void 0?securityGroups=[props.securityGroup]:props.securityGroups!==void 0&&(securityGroups=props.securityGroups),props.taskDefinition.networkMode===task_definition_1().NetworkMode.AWS_VPC?this.configureAwsVpcNetworkingWithSecurityGroups(props.cluster.vpc,props.assignPublicIp,props.vpcSubnets,securityGroups):(validateNoNetworkingProps(props),this.connections.addSecurityGroup(...securityGroupsInThisStack(this,props.cluster.connections.securityGroups))),props.placementConstraints&&this.addPlacementConstraints(...props.placementConstraints),this.addPlacementStrategies(...props.placementStrategies||[]),this.node.addValidation({validate:()=>this.taskDefinition.defaultContainer?[]:["A TaskDefinition must have at least one essential container"]}),this.node.addValidation({validate:this.validateEc2Service.bind(this)}),props.minHealthyPercent===void 0&&props.daemon&&core_1().Annotations.of(this).addWarningV2("@aws-cdk/aws-ecs:minHealthyPercentDaemon","minHealthyPercent has not been configured so the default value of 0% for a daemon service is used. See https://github.com/aws/aws-cdk/issues/31705")}addPlacementStrategies(...strategies){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_PlacementStrategy(strategies)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPlacementStrategies),error}if(strategies.length>0&&this.daemon)throw new Error("Can't configure placement strategies when daemon=true");if(strategies.length>0&&this.strategies.length===0&&this.availabilityZoneRebalancingEnabled){const[placement]=strategies[0].toJson();if(placement.type!=="spread"||placement.field!==BuiltInAttributes.AVAILABILITY_ZONE)throw new Error(`AvailabilityZoneBalancing.ENABLED requires that the first placement strategy, if any, be 'spread across "${BuiltInAttributes.AVAILABILITY_ZONE}"'`)}for(const strategy of strategies)this.strategies.push(...strategy.toJson())}addPlacementConstraints(...constraints){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_PlacementConstraint(constraints)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPlacementConstraints),error}this.constraints=[];for(const constraint of constraints){const items=constraint.toJson();if(this.availabilityZoneRebalancingEnabled){for(const item of items)if(item.type==="memberOf"&&item.expression?.includes(BuiltInAttributes.AVAILABILITY_ZONE))throw new Error(`AvailabilityZoneBalancing.ENABLED disallows usage of "${BuiltInAttributes.AVAILABILITY_ZONE}"`)}this.constraints.push(...items)}}validateEc2Service(){const ret=new Array;return!this.daemon&&!this.cluster.hasEc2Capacity&&ret.push("Cluster for this service needs Ec2 capacity. Call addXxxCapacity() on the cluster."),ret}attachToClassicLB(loadBalancer){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_elasticloadbalancing_LoadBalancer(loadBalancer)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachToClassicLB),error}if(this.availabilityZoneRebalancingEnabled)throw new Error("AvailabilityZoneRebalancing.ENABLED disallows using the service as a target of a Classic Load Balancer");super.attachToClassicLB(loadBalancer)}}exports.Ec2Service=Ec2Service,_a=JSII_RTTI_SYMBOL_1,Ec2Service[_a]={fqn:"aws-cdk-lib.aws_ecs.Ec2Service",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],Ec2Service.prototype,"addPlacementStrategies",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Ec2Service.prototype,"addPlacementConstraints",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Ec2Service.prototype,"attachToClassicLB",null);function validateNoNetworkingProps(props){if(props.vpcSubnets!==void 0||props.securityGroup!==void 0||props.securityGroups!==void 0||props.assignPublicIp)throw new Error("vpcSubnets, securityGroup(s) and assignPublicIp can only be used in AwsVpc networking mode")}function securityGroupsInThisStack(scope,groups){const thisStack=core_1().Stack.of(scope);let i=1;return groups.map(group=>thisStack===core_1().Stack.of(group)?group:ec2().SecurityGroup.fromSecurityGroupId(scope,`SecurityGroup${i++}`,group.securityGroupId,{allowAllOutbound:group.allowAllOutbound,mutable:!0}))}class BuiltInAttributes{}exports.BuiltInAttributes=BuiltInAttributes,_b=JSII_RTTI_SYMBOL_1,BuiltInAttributes[_b]={fqn:"aws-cdk-lib.aws_ecs.BuiltInAttributes",version:"2.188.0"},BuiltInAttributes.INSTANCE_ID="instanceId",BuiltInAttributes.AVAILABILITY_ZONE="attribute:ecs.availability-zone",BuiltInAttributes.AMI_ID="attribute:ecs.ami-id",BuiltInAttributes.INSTANCE_TYPE="attribute:ecs.instance-type",BuiltInAttributes.OS_TYPE="attribute:ecs.os-type";
