"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.TaskDefinitionRevision=exports.Compatibility=exports.Scope=exports.PidMode=exports.IpcMode=exports.NetworkMode=exports.TaskDefinition=void 0,exports.isEc2Compatible=isEc2Compatible,exports.isFargateCompatible=isFargateCompatible,exports.isExternalCompatible=isExternalCompatible;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var _imported_task_definition_1=()=>{var tmp=require("./_imported-task-definition");return _imported_task_definition_1=()=>tmp,tmp},ec2=()=>{var tmp=require("../../../aws-ec2");return ec2=()=>tmp,tmp},iam=()=>{var tmp=require("../../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},container_definition_1=()=>{var tmp=require("../container-definition");return container_definition_1=()=>tmp,tmp},ecs_generated_1=()=>{var tmp=require("../ecs.generated");return ecs_generated_1=()=>tmp,tmp},firelens_log_router_1=()=>{var tmp=require("../firelens-log-router");return firelens_log_router_1=()=>tmp,tmp},aws_log_driver_1=()=>{var tmp=require("../log-drivers/aws-log-driver");return aws_log_driver_1=()=>tmp,tmp};class TaskDefinitionBase extends core_1().Resource{get isEc2Compatible(){return isEc2Compatible(this.compatibility)}get isFargateCompatible(){return isFargateCompatible(this.compatibility)}get isExternalCompatible(){return isExternalCompatible(this.compatibility)}}class TaskDefinition extends TaskDefinitionBase{static fromTaskDefinitionArn(scope,id,taskDefinitionArn){return new(_imported_task_definition_1()).ImportedTaskDefinition(scope,id,{taskDefinitionArn})}static fromTaskDefinitionAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_TaskDefinitionAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTaskDefinitionAttributes),error}return new(_imported_task_definition_1()).ImportedTaskDefinition(scope,id,{taskDefinitionArn:attrs.taskDefinitionArn,compatibility:attrs.compatibility,networkMode:attrs.networkMode,taskRole:attrs.taskRole,executionRole:attrs.executionRole})}constructor(scope,id,props){super(scope,id),this.containers=new Array,this.volumes=[],this.placementConstraints=new Array,this._inferenceAccelerators=[];try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_TaskDefinitionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,TaskDefinition),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),this.family=props.family||core_1().Names.uniqueId(this),this.compatibility=props.compatibility,props.volumes&&props.volumes.forEach(v=>this.addVolume(v)),this.networkMode=props.networkMode??(this.isFargateCompatible?NetworkMode.AWS_VPC:NetworkMode.BRIDGE),props.proxyConfiguration&&this.networkMode!==NetworkMode.AWS_VPC)throw new Error(`ProxyConfiguration can only be used with AwsVpc network mode, got: ${this.networkMode}`);if(this.isExternalCompatible&&![NetworkMode.BRIDGE,NetworkMode.HOST,NetworkMode.NONE].includes(this.networkMode))throw new Error(`External tasks can only have Bridge, Host or None network mode, got: ${this.networkMode}`);if(!this.isFargateCompatible&&props.runtimePlatform)throw new Error("Cannot specify runtimePlatform in non-Fargate compatible tasks");if(this.isFargateCompatible){if(this.networkMode!==NetworkMode.AWS_VPC)throw new Error(`Fargate tasks can only have AwsVpc network mode, got: ${this.networkMode}`);if(props.placementConstraints&&props.placementConstraints.length>0)throw new Error("Cannot set placement constraints on tasks that run on Fargate");if(!props.cpu||!props.memoryMiB)throw new Error(`Fargate-compatible tasks require both CPU (${props.cpu}) and memory (${props.memoryMiB}) specifications`);if(props.inferenceAccelerators&&props.inferenceAccelerators.length>0)throw new Error("Cannot use inference accelerators on tasks that run on Fargate");this.node.addValidation({validate:()=>this.validateFargateTaskDefinitionMemoryCpu(props.cpu,props.memoryMiB)})}if(props.enableFaultInjection&&![NetworkMode.AWS_VPC,NetworkMode.HOST].includes(this.networkMode))throw new Error(`Only AWS_VPC and HOST Network Modes are supported for enabling Fault Injection, got ${this.networkMode} mode.`);this._executionRole=props.executionRole,this.taskRole=props.taskRole||new(iam()).Role(this,"TaskRole",{assumedBy:new(iam()).ServicePrincipal("ecs-tasks.amazonaws.com")}),props.inferenceAccelerators&&props.inferenceAccelerators.forEach(ia=>this.addInferenceAccelerator(ia)),this.ephemeralStorageGiB=props.ephemeralStorageGiB,this.pidMode=props.pidMode,props.runtimePlatform?.operatingSystemFamily?.isWindows()&&this.checkFargateWindowsBasedTasksSize(props.cpu,props.memoryMiB,props.runtimePlatform),this.runtimePlatform=props.runtimePlatform,this._cpu=props.cpu,this._memory=props.memoryMiB;const taskDef=new(ecs_generated_1()).CfnTaskDefinition(this,"Resource",{containerDefinitions:core_1().Lazy.any({produce:()=>this.renderContainers()},{omitEmptyArray:!0}),volumes:core_1().Lazy.any({produce:()=>this.renderVolumes()},{omitEmptyArray:!0}),executionRoleArn:core_1().Lazy.string({produce:()=>this.executionRole&&this.executionRole.roleArn}),family:this.family,taskRoleArn:this.taskRole.roleArn,requiresCompatibilities:[...isEc2Compatible(props.compatibility)?["EC2"]:[],...isFargateCompatible(props.compatibility)?["FARGATE"]:[],...isExternalCompatible(props.compatibility)?["EXTERNAL"]:[]],networkMode:this.renderNetworkMode(this.networkMode),placementConstraints:core_1().Lazy.any({produce:()=>isFargateCompatible(this.compatibility)?void 0:this.placementConstraints},{omitEmptyArray:!0}),proxyConfiguration:props.proxyConfiguration?props.proxyConfiguration.bind(this.stack,this):void 0,cpu:props.cpu,memory:props.memoryMiB,ipcMode:props.ipcMode,pidMode:this.pidMode,inferenceAccelerators:core_1().Lazy.any({produce:()=>isFargateCompatible(this.compatibility)?void 0:this.renderInferenceAccelerators()},{omitEmptyArray:!0}),ephemeralStorage:this.ephemeralStorageGiB?{sizeInGiB:this.ephemeralStorageGiB}:void 0,runtimePlatform:this.isFargateCompatible&&this.runtimePlatform?{cpuArchitecture:this.runtimePlatform?.cpuArchitecture?._cpuArchitecture,operatingSystemFamily:this.runtimePlatform?.operatingSystemFamily?._operatingSystemFamily}:void 0,enableFaultInjection:props.enableFaultInjection});props.placementConstraints&&props.placementConstraints.forEach(pc=>this.addPlacementConstraint(pc)),this.taskDefinitionArn=taskDef.ref,this.node.addValidation({validate:()=>this.validateTaskDefinition()})}get executionRole(){return this._executionRole}get inferenceAccelerators(){return this._inferenceAccelerators}renderVolumes(){return this.volumes.map(renderVolume);function renderVolume(spec){return{host:spec.host,name:spec.name,configuredAtLaunch:spec.configuredAtLaunch,dockerVolumeConfiguration:spec.dockerVolumeConfiguration&&{autoprovision:spec.dockerVolumeConfiguration.autoprovision,driver:spec.dockerVolumeConfiguration.driver,driverOpts:spec.dockerVolumeConfiguration.driverOpts,labels:spec.dockerVolumeConfiguration.labels,scope:spec.dockerVolumeConfiguration.scope},efsVolumeConfiguration:spec.efsVolumeConfiguration&&{filesystemId:spec.efsVolumeConfiguration.fileSystemId,authorizationConfig:spec.efsVolumeConfiguration.authorizationConfig,rootDirectory:spec.efsVolumeConfiguration.rootDirectory,transitEncryption:spec.efsVolumeConfiguration.transitEncryption,transitEncryptionPort:spec.efsVolumeConfiguration.transitEncryptionPort}}}}renderInferenceAccelerators(){return this._inferenceAccelerators.map(renderInferenceAccelerator);function renderInferenceAccelerator(inferenceAccelerator){return{deviceName:inferenceAccelerator.deviceName,deviceType:inferenceAccelerator.deviceType}}}_validateTarget(options){const targetContainer=this.findContainer(options.containerName);if(targetContainer===void 0)throw new Error(`No container named '${options.containerName}'. Did you call "addContainer()"?`);const targetProtocol=options.protocol||container_definition_1().Protocol.TCP,targetContainerPort=options.containerPort||targetContainer.containerPort,portMapping=targetContainer.findPortMapping(targetContainerPort,targetProtocol);if(portMapping===void 0)throw new Error(`Container '${targetContainer}' has no mapping for port ${options.containerPort} and protocol ${targetProtocol}. Did you call "container.addPortMappings()"?`);return{containerName:options.containerName,portMapping}}_portRangeFromPortMapping(portMapping){if(portMapping.hostPort!==void 0&&portMapping.hostPort!==0)return portMapping.protocol===container_definition_1().Protocol.UDP?ec2().Port.udp(portMapping.hostPort):ec2().Port.tcp(portMapping.hostPort);if(this.networkMode===NetworkMode.BRIDGE||this.networkMode===NetworkMode.NAT)return EPHEMERAL_PORT_RANGE;if(portMapping.containerPort!==container_definition_1().ContainerDefinition.CONTAINER_PORT_USE_RANGE)return portMapping.protocol===container_definition_1().Protocol.UDP?ec2().Port.udp(portMapping.containerPort):ec2().Port.tcp(portMapping.containerPort);const[startPort,endPort]=portMapping.containerPortRange.split("-",2).map(v=>Number(v));return portMapping.protocol===container_definition_1().Protocol.UDP?ec2().Port.udpRange(startPort,endPort):ec2().Port.tcpRange(startPort,endPort)}addToTaskRolePolicy(statement){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToTaskRolePolicy),error}this.taskRole.addToPrincipalPolicy(statement)}addToExecutionRolePolicy(statement){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToExecutionRolePolicy),error}this.obtainExecutionRole().addToPrincipalPolicy(statement)}addContainer(id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_ContainerDefinitionOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addContainer),error}return new(container_definition_1()).ContainerDefinition(this,id,{taskDefinition:this,...props})}addFirelensLogRouter(id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_FirelensLogRouterDefinitionOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFirelensLogRouter),error}if(this.containers.find(x=>x instanceof firelens_log_router_1().FirelensLogRouter))throw new Error("Firelens log router is already added in this task.");return new(firelens_log_router_1()).FirelensLogRouter(this,id,{taskDefinition:this,...props})}_linkContainer(container){if(this._cpu){const taskCpu=Number(this._cpu),sumOfContainerCpu=[...this.containers,container].map(c=>c.cpu).filter(cpu=>typeof cpu=="number").reduce((a,c)=>a+c,0);if(taskCpu<sumOfContainerCpu)throw new Error("The sum of all container cpu values cannot be greater than the value of the task cpu")}this.containers.push(container),this.defaultContainer===void 0&&container.essential&&(this.defaultContainer=container)}addVolume(volume){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_Volume(volume)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addVolume),error}this.validateVolume(volume),this.volumes.push(volume)}validateVolume(volume){if(volume.configuredAtLaunch===!0&&(volume.host||volume.dockerVolumeConfiguration||volume.efsVolumeConfiguration))throw new Error(`Volume Configurations must not be specified for '${volume.name}' when 'configuredAtLaunch' is set to true`)}addPlacementConstraint(constraint){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_PlacementConstraint(constraint)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addPlacementConstraint),error}if(isFargateCompatible(this.compatibility))throw new Error("Cannot set placement constraints on tasks that run on Fargate");this.placementConstraints.push(...constraint.toJson())}addExtension(extension){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_ITaskDefinitionExtension(extension)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addExtension),error}extension.extend(this)}addInferenceAccelerator(inferenceAccelerator){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_ecs.TaskDefinition#addInferenceAccelerator","ECS TaskDefinition's inferenceAccelerator is EOL since April 2024"),jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_InferenceAccelerator(inferenceAccelerator)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addInferenceAccelerator),error}if(isFargateCompatible(this.compatibility))throw new Error("Cannot use inference accelerators on tasks that run on Fargate");this._inferenceAccelerators.push(inferenceAccelerator)}grantRun(grantee){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantRun),error}return grantee.grantPrincipal.addToPrincipalPolicy(this.passRoleStatement),iam().Grant.addToPrincipal({grantee,actions:["ecs:RunTask"],resourceArns:[this.taskDefinitionArn]})}obtainExecutionRole(){return this._executionRole||(this._executionRole=new(iam()).Role(this,"ExecutionRole",{assumedBy:new(iam()).ServicePrincipal("ecs-tasks.amazonaws.com"),roleName:core_1().PhysicalName.GENERATE_IF_NEEDED}),this.passRoleStatement.addResources(this._executionRole.roleArn)),this._executionRole}get referencesSecretJsonField(){for(const container of this.containers)if(container.referencesSecretJsonField)return!0;return!1}validateTaskDefinition(){const ret=new Array;if(isEc2Compatible(this.compatibility)&&!this._memory)for(const container of this.containers)container.memoryLimitSpecified||ret.push(`ECS Container ${container.containerName} must have at least one of 'memoryLimitMiB' or 'memoryReservationMiB' specified`);const portMappingNames=new Map;this.containers.forEach(container=>{for(const pm of container.portMappings)pm.name&&(portMappingNames.has(pm.name)&&ret.push(`Port mapping name '${pm.name}' cannot appear in both '${container.containerName}' and '${portMappingNames.get(pm.name)}'`),portMappingNames.set(pm.name,container.containerName))});const runtimeVolumes=this.volumes.filter(vol=>vol.configuredAtLaunch);if(runtimeVolumes.length>1){const volumeNames=runtimeVolumes.map(vol=>vol.name).join(",");ret.push(`More than one volume is configured at launch: [${volumeNames}]`)}for(const volume of this.volumes)volume.configuredAtLaunch&&(this.containers.some(container=>container.mountPoints.some(mp=>mp.sourceVolume===volume.name))||ret.push(`Volume '${volume.name}' should be mounted by at least one container when 'configuredAtLaunch' is true`));return ret}findPortMappingByName(name){let portMapping;return this.containers.forEach(container=>{const pm=container.findPortMappingByName(name);pm&&(portMapping=pm)}),portMapping}findContainer(containerName){return this.containers.find(c=>c.containerName===containerName)}get passRoleStatement(){return this._passRoleStatement||(this._passRoleStatement=new(iam()).PolicyStatement({effect:iam().Effect.ALLOW,actions:["iam:PassRole"],resources:this.executionRole?[this.taskRole.roleArn,this.executionRole.roleArn]:[this.taskRole.roleArn],conditions:{StringLike:{"iam:PassedToService":"ecs-tasks.amazonaws.com"}}})),this._passRoleStatement}renderNetworkMode(networkMode){return networkMode===NetworkMode.NAT?void 0:networkMode}renderContainers(){for(const container of this.containers)if(container.logDriverConfig&&container.logDriverConfig.logDriver==="awsfirelens"&&!this.containers.find(x=>x instanceof firelens_log_router_1().FirelensLogRouter)){this.addFirelensLogRouter("log-router",{image:(0,firelens_log_router_1().obtainDefaultFluentBitECRImage)(this,container.logDriverConfig),firelensConfig:{type:firelens_log_router_1().FirelensLogRouterType.FLUENTBIT},logging:new(aws_log_driver_1()).AwsLogDriver({streamPrefix:"firelens"}),memoryReservationMiB:50});break}return this.containers.map(x=>x.renderContainerDefinition())}checkFargateWindowsBasedTasksSize(cpu,memory,runtimePlatform){if(!core_1().Token.isUnresolved(cpu)&&!core_1().Token.isUnresolved(memory))if(Number(cpu)===1024){if(Number(memory)<1024||Number(memory)>8192||Number(memory)%1024!==0)throw new Error(`If provided cpu is ${cpu}, then memoryMiB must have a min of 1024 and a max of 8192, in 1024 increments. Provided memoryMiB was ${Number(memory)}.`)}else if(Number(cpu)===2048){if(Number(memory)<4096||Number(memory)>16384||Number(memory)%1024!==0)throw new Error(`If provided cpu is ${cpu}, then memoryMiB must have a min of 4096 and max of 16384, in 1024 increments. Provided memoryMiB ${Number(memory)}.`)}else if(Number(cpu)===4096){if(Number(memory)<8192||Number(memory)>30720||Number(memory)%1024!==0)throw new Error(`If provided cpu is ${cpu}, then memoryMiB must have a min of 8192 and a max of 30720, in 1024 increments.Provided memoryMiB was ${Number(memory)}.`)}else throw new Error(`If operatingSystemFamily is ${runtimePlatform.operatingSystemFamily._operatingSystemFamily}, then cpu must be in 1024 (1 vCPU), 2048 (2 vCPU), or 4096 (4 vCPU). Provided value was: ${cpu}`)}validateFargateTaskDefinitionMemoryCpu(cpu,memory){const ret=new Array;if(core_1().Token.isUnresolved(cpu)||core_1().Token.isUnresolved(memory))return ret;const resolvedCpu=this.stack.resolve(cpu),resolvedMemoryMiB=this.stack.resolve(memory);return[{cpu:"256",memory:["512","1024","2048"]},{cpu:"512",memory:this.range(1024,4096,1024)},{cpu:"1024",memory:this.range(2048,8192,1024)},{cpu:"2048",memory:this.range(4096,16384,1024)},{cpu:"4096",memory:this.range(8192,30720,1024)},{cpu:"8192",memory:this.range(16384,61440,4096)},{cpu:"16384",memory:this.range(32768,122880,8192)}].some(combo=>combo.cpu===resolvedCpu&&combo.memory.includes(resolvedMemoryMiB))||ret.push(`Invalid CPU and memory combinations [${resolvedCpu} and ${resolvedMemoryMiB}] for FARGATE compatible task definition - https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-cpu-memory-error.html`),ret}range(start,end,step){const result=[];for(let i=start;i<=end;i+=step)result.push(String(i));return result}}exports.TaskDefinition=TaskDefinition,_a=JSII_RTTI_SYMBOL_1,TaskDefinition[_a]={fqn:"aws-cdk-lib.aws_ecs.TaskDefinition",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addToTaskRolePolicy",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addToExecutionRolePolicy",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addContainer",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addFirelensLogRouter",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addVolume",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addPlacementConstraint",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addExtension",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"addInferenceAccelerator",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"grantRun",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"obtainExecutionRole",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"findPortMappingByName",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],TaskDefinition.prototype,"findContainer",null);const EPHEMERAL_PORT_RANGE=ec2().Port.tcpRange(32768,65535);var NetworkMode;(function(NetworkMode2){NetworkMode2.NONE="none",NetworkMode2.BRIDGE="bridge",NetworkMode2.AWS_VPC="awsvpc",NetworkMode2.HOST="host",NetworkMode2.NAT="nat"})(NetworkMode||(exports.NetworkMode=NetworkMode={}));var IpcMode;(function(IpcMode2){IpcMode2.NONE="none",IpcMode2.HOST="host",IpcMode2.TASK="task"})(IpcMode||(exports.IpcMode=IpcMode={}));var PidMode;(function(PidMode2){PidMode2.HOST="host",PidMode2.TASK="task"})(PidMode||(exports.PidMode=PidMode={}));var Scope;(function(Scope2){Scope2.TASK="task",Scope2.SHARED="shared"})(Scope||(exports.Scope=Scope={}));var Compatibility;(function(Compatibility2){Compatibility2[Compatibility2.EC2=0]="EC2",Compatibility2[Compatibility2.FARGATE=1]="FARGATE",Compatibility2[Compatibility2.EC2_AND_FARGATE=2]="EC2_AND_FARGATE",Compatibility2[Compatibility2.EXTERNAL=3]="EXTERNAL"})(Compatibility||(exports.Compatibility=Compatibility={}));function isEc2Compatible(compatibility){return[Compatibility.EC2,Compatibility.EC2_AND_FARGATE].includes(compatibility)}function isFargateCompatible(compatibility){return[Compatibility.FARGATE,Compatibility.EC2_AND_FARGATE].includes(compatibility)}function isExternalCompatible(compatibility){return[Compatibility.EXTERNAL].includes(compatibility)}class TaskDefinitionRevision{static of(revision){if(revision<1)throw new Error(`A task definition revision must be 'latest' or a positive number, got ${revision}`);return new TaskDefinitionRevision(revision.toString())}constructor(revision){this.revision=revision}}exports.TaskDefinitionRevision=TaskDefinitionRevision,_b=JSII_RTTI_SYMBOL_1,TaskDefinitionRevision[_b]={fqn:"aws-cdk-lib.aws_ecs.TaskDefinitionRevision",version:"2.188.0"},TaskDefinitionRevision.LATEST=new TaskDefinitionRevision("latest");
