"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FlowLog=exports.LogFormat=exports.FlowLogMaxAggregationInterval=exports.FlowLogDestination=exports.FlowLogFileFormat=exports.FlowLogResourceType=exports.FlowLogDestinationType=exports.FlowLogTrafficType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var ec2_generated_1=()=>{var tmp=require("./ec2.generated");return ec2_generated_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},logs=()=>{var tmp=require("../../aws-logs");return logs=()=>tmp,tmp},s3=()=>{var tmp=require("../../aws-s3");return s3=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},cx_api_1=()=>{var tmp=require("../../cx-api");return cx_api_1=()=>tmp,tmp};const NAME_TAG="Name";var FlowLogTrafficType;(function(FlowLogTrafficType2){FlowLogTrafficType2.ACCEPT="ACCEPT",FlowLogTrafficType2.ALL="ALL",FlowLogTrafficType2.REJECT="REJECT"})(FlowLogTrafficType||(exports.FlowLogTrafficType=FlowLogTrafficType={}));var FlowLogDestinationType;(function(FlowLogDestinationType2){FlowLogDestinationType2.CLOUD_WATCH_LOGS="cloud-watch-logs",FlowLogDestinationType2.S3="s3",FlowLogDestinationType2.KINESIS_DATA_FIREHOSE="kinesis-data-firehose"})(FlowLogDestinationType||(exports.FlowLogDestinationType=FlowLogDestinationType={}));class FlowLogResourceType{static fromSubnet(subnet){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_ISubnet(subnet)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSubnet),error}return{resourceType:"Subnet",resourceId:subnet.subnetId}}static fromVpc(vpc){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_IVpc(vpc)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromVpc),error}return{resourceType:"VPC",resourceId:vpc.vpcId}}static fromNetworkInterfaceId(id){return{resourceType:"NetworkInterface",resourceId:id}}static fromTransitGatewayId(id){return{resourceType:"TransitGateway",resourceId:id}}static fromTransitGatewayAttachmentId(id){return{resourceType:"TransitGatewayAttachment",resourceId:id}}}exports.FlowLogResourceType=FlowLogResourceType,_a=JSII_RTTI_SYMBOL_1,FlowLogResourceType[_a]={fqn:"aws-cdk-lib.aws_ec2.FlowLogResourceType",version:"2.188.0"};var FlowLogFileFormat;(function(FlowLogFileFormat2){FlowLogFileFormat2.PLAIN_TEXT="plain-text",FlowLogFileFormat2.PARQUET="parquet"})(FlowLogFileFormat||(exports.FlowLogFileFormat=FlowLogFileFormat={}));class FlowLogDestination{static toCloudWatchLogs(logGroup,iamRole){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_logs_ILogGroup(logGroup),jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_IRole(iamRole)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.toCloudWatchLogs),error}return new CloudWatchLogsDestination({logDestinationType:FlowLogDestinationType.CLOUD_WATCH_LOGS,logGroup,iamRole})}static toS3(bucket,keyPrefix,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_S3DestinationOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.toS3),error}return new S3Destination({logDestinationType:FlowLogDestinationType.S3,s3Bucket:bucket,keyPrefix,destinationOptions:options})}static toKinesisDataFirehoseDestination(deliveryStreamArn){return new KinesisDataFirehoseDestination({logDestinationType:FlowLogDestinationType.KINESIS_DATA_FIREHOSE,deliveryStreamArn})}}exports.FlowLogDestination=FlowLogDestination,_b=JSII_RTTI_SYMBOL_1,FlowLogDestination[_b]={fqn:"aws-cdk-lib.aws_ec2.FlowLogDestination",version:"2.188.0"};class S3Destination extends FlowLogDestination{constructor(props){super(),this.props=props}bind(scope,_flowLog){let s3Bucket;if(this.props.s3Bucket===void 0?s3Bucket=new(s3()).Bucket(scope,"Bucket",{removalPolicy:core_1().RemovalPolicy.RETAIN}):s3Bucket=this.props.s3Bucket,core_1().FeatureFlags.of(scope).isEnabled(cx_api_1().S3_CREATE_DEFAULT_LOGGING_POLICY)){const stack=core_1().Stack.of(scope);let keyPrefix=this.props.keyPrefix??"";keyPrefix&&!keyPrefix.endsWith("/")&&(keyPrefix=keyPrefix+"/");const prefix=this.props.destinationOptions?.hiveCompatiblePartitions?s3Bucket.arnForObjects(`${keyPrefix}AWSLogs/aws-account-id=${stack.account}/*`):s3Bucket.arnForObjects(`${keyPrefix}AWSLogs/${stack.account}/*`);s3Bucket.addToResourcePolicy(new(iam()).PolicyStatement({effect:iam().Effect.ALLOW,principals:[new(iam()).ServicePrincipal("delivery.logs.amazonaws.com")],resources:[prefix],actions:["s3:PutObject"],conditions:{StringEquals:{"s3:x-amz-acl":"bucket-owner-full-control","aws:SourceAccount":stack.account},ArnLike:{"aws:SourceArn":stack.formatArn({service:"logs",resource:"*"})}}})),s3Bucket.addToResourcePolicy(new(iam()).PolicyStatement({effect:iam().Effect.ALLOW,principals:[new(iam()).ServicePrincipal("delivery.logs.amazonaws.com")],resources:[s3Bucket.bucketArn],actions:["s3:GetBucketAcl","s3:ListBucket"],conditions:{StringEquals:{"aws:SourceAccount":stack.account},ArnLike:{"aws:SourceArn":stack.formatArn({service:"logs",resource:"*"})}}}))}return{logDestinationType:FlowLogDestinationType.S3,s3Bucket,keyPrefix:this.props.keyPrefix,destinationOptions:this.props.destinationOptions?.fileFormat||this.props.destinationOptions?.perHourPartition||this.props.destinationOptions?.hiveCompatiblePartitions?{fileFormat:this.props.destinationOptions.fileFormat??FlowLogFileFormat.PLAIN_TEXT,perHourPartition:this.props.destinationOptions.perHourPartition??!1,hiveCompatiblePartitions:this.props.destinationOptions.hiveCompatiblePartitions??!1}:void 0}}}class CloudWatchLogsDestination extends FlowLogDestination{constructor(props){super(),this.props=props}bind(scope,_flowLog){let iamRole,logGroup;return this.props.iamRole===void 0?iamRole=new(iam()).Role(scope,"IAMRole",{roleName:core_1().PhysicalName.GENERATE_IF_NEEDED,assumedBy:new(iam()).ServicePrincipal("vpc-flow-logs.amazonaws.com")}):iamRole=this.props.iamRole,this.props.logGroup===void 0?logGroup=new(logs()).LogGroup(scope,"LogGroup"):logGroup=this.props.logGroup,iamRole.addToPrincipalPolicy(new(iam()).PolicyStatement({actions:["logs:CreateLogStream","logs:PutLogEvents","logs:DescribeLogStreams"],effect:iam().Effect.ALLOW,resources:[logGroup.logGroupArn]})),iamRole.addToPrincipalPolicy(new(iam()).PolicyStatement({actions:["iam:PassRole"],effect:iam().Effect.ALLOW,resources:[iamRole.roleArn]})),{logDestinationType:FlowLogDestinationType.CLOUD_WATCH_LOGS,logGroup,iamRole}}}class KinesisDataFirehoseDestination extends FlowLogDestination{constructor(props){super(),this.props=props}bind(_scope,_flowLog){if(this.props.deliveryStreamArn===void 0)throw new Error("deliveryStreamArn is required");const deliveryStreamArn=this.props.deliveryStreamArn;return{logDestinationType:FlowLogDestinationType.KINESIS_DATA_FIREHOSE,deliveryStreamArn}}}var FlowLogMaxAggregationInterval;(function(FlowLogMaxAggregationInterval2){FlowLogMaxAggregationInterval2[FlowLogMaxAggregationInterval2.ONE_MINUTE=60]="ONE_MINUTE",FlowLogMaxAggregationInterval2[FlowLogMaxAggregationInterval2.TEN_MINUTES=600]="TEN_MINUTES"})(FlowLogMaxAggregationInterval||(exports.FlowLogMaxAggregationInterval=FlowLogMaxAggregationInterval={}));class LogFormat{static custom(formatString){return new LogFormat(formatString)}static field(field){return new LogFormat(`\${${field}}`)}constructor(value){this.value=value}}exports.LogFormat=LogFormat,_c=JSII_RTTI_SYMBOL_1,LogFormat[_c]={fqn:"aws-cdk-lib.aws_ec2.LogFormat",version:"2.188.0"},LogFormat.VERSION=LogFormat.field("version"),LogFormat.ACCOUNT_ID=LogFormat.field("account-id"),LogFormat.INTERFACE_ID=LogFormat.field("interface-id"),LogFormat.SRC_ADDR=LogFormat.field("srcaddr"),LogFormat.DST_ADDR=LogFormat.field("dstaddr"),LogFormat.SRC_PORT=LogFormat.field("srcport"),LogFormat.DST_PORT=LogFormat.field("dstport"),LogFormat.PROTOCOL=LogFormat.field("protocol"),LogFormat.PACKETS=LogFormat.field("packets"),LogFormat.BYTES=LogFormat.field("bytes"),LogFormat.START_TIMESTAMP=LogFormat.field("start"),LogFormat.END_TIMESTAMP=LogFormat.field("end"),LogFormat.ACTION=LogFormat.field("action"),LogFormat.LOG_STATUS=LogFormat.field("log-status"),LogFormat.VPC_ID=LogFormat.field("vpc-id"),LogFormat.SUBNET_ID=LogFormat.field("subnet-id"),LogFormat.INSTANCE_ID=LogFormat.field("instance-id"),LogFormat.TCP_FLAGS=LogFormat.field("tcp-flags"),LogFormat.TRAFFIC_TYPE=LogFormat.field("type"),LogFormat.PKT_SRC_ADDR=LogFormat.field("pkt-srcaddr"),LogFormat.PKT_DST_ADDR=LogFormat.field("pkt-dstaddr"),LogFormat.REGION=LogFormat.field("region"),LogFormat.AZ_ID=LogFormat.field("az-id"),LogFormat.SUBLOCATION_TYPE=LogFormat.field("sublocation-type"),LogFormat.SUBLOCATION_ID=LogFormat.field("sublocation-id"),LogFormat.PKT_SRC_AWS_SERVICE=LogFormat.field("pkt-src-aws-service"),LogFormat.PKT_DST_AWS_SERVICE=LogFormat.field("pkt-dst-aws-service"),LogFormat.FLOW_DIRECTION=LogFormat.field("flow-direction"),LogFormat.TRAFFIC_PATH=LogFormat.field("traffic-path"),LogFormat.ECS_CLUSTER_ARN=LogFormat.field("ecs-cluster-arn"),LogFormat.ECS_CLUSTER_NAME=LogFormat.field("ecs-cluster-name"),LogFormat.ECS_CONTAINER_INSTANCE_ARN=LogFormat.field("ecs-container-instance-arn"),LogFormat.ECS_CONTAINER_INSTANCE_ID=LogFormat.field("ecs-container-instance-id"),LogFormat.ECS_CONTAINER_ID=LogFormat.field("ecs-container-id"),LogFormat.ECS_SECOND_CONTAINER_ID=LogFormat.field("ecs-second-container-id"),LogFormat.ECS_SERVICE_NAME=LogFormat.field("ecs-service-name"),LogFormat.ECS_TASK_DEFINITION_ARN=LogFormat.field("ecs-task-definition-arn"),LogFormat.ECS_TASK_ARN=LogFormat.field("ecs-task-arn"),LogFormat.ECS_TASK_ID=LogFormat.field("ecs-task-id"),LogFormat.ALL_DEFAULT_FIELDS=new LogFormat("${version} ${account-id} ${interface-id} ${srcaddr} ${dstaddr} ${srcport} ${dstport} ${protocol} ${packets} ${bytes} ${start} ${end} ${action} ${log-status}");class FlowLogBase extends core_1().Resource{}class FlowLog extends FlowLogBase{static fromFlowLogId(scope,id,flowLogId){class Import extends FlowLogBase{constructor(){super(...arguments),this.flowLogId=flowLogId}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_FlowLogProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,FlowLog),error}(0,metadata_resource_1().addConstructMetadata)(this,props);const destinationConfig=(props.destination||FlowLogDestination.toCloudWatchLogs()).bind(this,this);this.logGroup=destinationConfig.logGroup,this.bucket=destinationConfig.s3Bucket,this.iamRole=destinationConfig.iamRole,this.keyPrefix=destinationConfig.keyPrefix,this.deliveryStreamArn=destinationConfig.deliveryStreamArn,core_1().Tags.of(this).add(NAME_TAG,props.flowLogName||this.node.path);let logDestination;this.bucket&&(logDestination=this.keyPrefix?this.bucket.arnForObjects(this.keyPrefix):this.bucket.bucketArn),this.deliveryStreamArn&&(logDestination=this.deliveryStreamArn);let customLogFormat;props.logFormat&&(customLogFormat=props.logFormat.map(elm=>elm.value).join(" "));let trafficType=props.trafficType??FlowLogTrafficType.ALL;if(props.resourceType.resourceType==="TransitGateway"||props.resourceType.resourceType==="TransitGatewayAttachment"){if(props.trafficType)throw new Error("trafficType is not supported for Transit Gateway and Transit Gateway Attachment");if(props.maxAggregationInterval&&props.maxAggregationInterval!==FlowLogMaxAggregationInterval.ONE_MINUTE)throw new Error("maxAggregationInterval must be set to ONE_MINUTE for Transit Gateway and Transit Gateway Attachment");trafficType=void 0}const flowLog=new(ec2_generated_1()).CfnFlowLog(this,"FlowLog",{destinationOptions:destinationConfig.destinationOptions,deliverLogsPermissionArn:this.iamRole?this.iamRole.roleArn:void 0,logDestinationType:destinationConfig.logDestinationType,logGroupName:this.logGroup?this.logGroup.logGroupName:void 0,maxAggregationInterval:props.maxAggregationInterval,resourceId:props.resourceType.resourceId,resourceType:props.resourceType.resourceType,trafficType,logFormat:customLogFormat,logDestination});this.bucket?.policy?.node.defaultChild instanceof core_1().CfnResource&&flowLog.addDependency(this.bucket?.policy.node.defaultChild);const deleteObjects=this.bucket?.node.tryFindChild("AutoDeleteObjectsCustomResource")?.node.defaultChild;deleteObjects instanceof core_1().CfnResource&&flowLog.addDependency(deleteObjects),this.flowLogId=flowLog.ref,this.node.defaultChild=flowLog}}exports.FlowLog=FlowLog,_d=JSII_RTTI_SYMBOL_1,FlowLog[_d]={fqn:"aws-cdk-lib.aws_ec2.FlowLog",version:"2.188.0"};
