"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.instanceBlockDeviceMappings=instanceBlockDeviceMappings,exports.launchTemplateBlockDeviceMappings=launchTemplateBlockDeviceMappings;var core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},volume_1=()=>{var tmp=require("../volume");return volume_1=()=>tmp,tmp};function instanceBlockDeviceMappings(construct,blockDevices){return synthesizeBlockDeviceMappings(construct,blockDevices,{})}function launchTemplateBlockDeviceMappings(construct,blockDevices){return synthesizeBlockDeviceMappings(construct,blockDevices,"")}function synthesizeBlockDeviceMappings(construct,blockDevices,noDeviceValue){return blockDevices.map(({deviceName,volume,mappingEnabled})=>{const{virtualName,ebsDevice:ebs}=volume;let finalEbs;if(ebs){const{iops,throughput,volumeType,kmsKey,...rest}=ebs;if(throughput){if(volumeType!==volume_1().EbsDeviceVolumeType.GP3)throw new Error(`'throughput' requires 'volumeType': ${volume_1().EbsDeviceVolumeType.GP3}, got: ${volumeType}.`);if(!Number.isInteger(throughput))throw new Error(`'throughput' must be an integer, got: ${throughput}.`);if(throughput<125||throughput>1e3)throw new Error(`'throughput' must be between 125 and 1000, got ${throughput}.`);const maximumThroughputRatio=.25;if(iops){const iopsRatio=throughput/iops;if(iopsRatio>maximumThroughputRatio)throw new Error(`Throughput (MiBps) to iops ratio of ${iopsRatio} is too high; maximum is ${maximumThroughputRatio} MiBps per iops`)}}if(iops)volumeType!==volume_1().EbsDeviceVolumeType.IO1&&volumeType!==volume_1().EbsDeviceVolumeType.IO2&&volumeType!==volume_1().EbsDeviceVolumeType.GP3&&core_1().Annotations.of(construct).addWarningV2("@aws-cdk/aws-ec2:iopsIgnored","iops will be ignored without volumeType: IO1, IO2, or GP3");else if(volumeType===volume_1().EbsDeviceVolumeType.IO1||volumeType===volume_1().EbsDeviceVolumeType.IO2)throw new Error("iops property is required with volumeType: EbsDeviceVolumeType.IO1 and EbsDeviceVolumeType.IO2");finalEbs={...rest,iops,throughput,volumeType,kmsKeyId:kmsKey?.keyArn}}else finalEbs=void 0;return{deviceName,ebs:finalEbs,virtualName,noDevice:mappingEnabled===!1?noDeviceValue:void 0}})}
