"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Ipv6Addresses=exports.IpAddresses=void 0,exports.cidrSplitToCfnExpression=cidrSplitToCfnExpression;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var cidr_splits_1=()=>{var tmp=require("./cidr-splits");return cidr_splits_1=()=>tmp,tmp},ec2_generated_1=()=>{var tmp=require("./ec2.generated");return ec2_generated_1=()=>tmp,tmp},network_util_1=()=>{var tmp=require("./network-util");return network_util_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp};class IpAddresses{static cidr(cidrBlock){return new Cidr(cidrBlock)}static awsIpamAllocation(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_AwsIpamProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.awsIpamAllocation),error}return new AwsIpam(props)}constructor(){}}exports.IpAddresses=IpAddresses,_a=JSII_RTTI_SYMBOL_1,IpAddresses[_a]={fqn:"aws-cdk-lib.aws_ec2.IpAddresses",version:"2.188.0"};class AwsIpam{constructor(props){this.props=props}allocateVpcCidr(){return{ipv4NetmaskLength:this.props.ipv4NetmaskLength,ipv4IpamPoolId:this.props.ipv4IpamPoolId}}allocateSubnetsCidr(input){return{allocatedSubnets:(0,cidr_splits_1().calculateCidrSplits)(this.props.ipv4NetmaskLength,input.requestedSubnets.map(mask=>{if(mask.configuration.cidrMask===void 0&&this.props.defaultSubnetIpv4NetmaskLength===void 0)throw new Error("If you have not set a cidr for all subnets in this case you must set a defaultCidrMask in AwsIpam Options");const cidrMask=mask.configuration.cidrMask??this.props.defaultSubnetIpv4NetmaskLength;if(cidrMask===void 0)throw new Error("Should not have happened, but satisfies the type checker");return cidrMask})).map(subnet=>({cidr:cidrSplitToCfnExpression(input.vpcCidr,subnet)}))}}}function cidrSplitToCfnExpression(parentCidr,split){if(split.count===1)return parentCidr;if(split.count<=256)return core_1().Fn.select(split.index,core_1().Fn.cidr(parentCidr,split.count,`${32-split.netmask}`));if(split.netmask-8<1)throw new Error(`Cannot split an IP range into ${split.count} /${split.netmask}s`);const parentSplit={netmask:split.netmask-8,count:Math.ceil(split.count/256),index:Math.floor(split.index/256)};return cidrSplitToCfnExpression(cidrSplitToCfnExpression(parentCidr,parentSplit),{netmask:split.netmask,count:256,index:split.index-parentSplit.index*256})}class Cidr{constructor(cidrBlock){if(this.cidrBlock=cidrBlock,core_1().Token.isUnresolved(cidrBlock))throw new Error("'cidr' property must be a concrete CIDR string, got a Token (we need to parse it for automatic subdivision)");this.networkBuilder=new(network_util_1()).NetworkBuilder(this.cidrBlock)}allocateVpcCidr(){return{cidrBlock:this.networkBuilder.networkCidr.cidr}}allocateSubnetsCidr(input){const allocatedSubnets=[],subnetsWithoutDefinedCidr=[];input.requestedSubnets.forEach((requestedSubnet,index)=>{requestedSubnet.configuration.cidrMask===void 0?subnetsWithoutDefinedCidr.push({index,requestedSubnet}):allocatedSubnets.push({cidr:this.networkBuilder.addSubnet(requestedSubnet.configuration.cidrMask)})});const cidrMaskForRemaining=this.networkBuilder.maskForRemainingSubnets(subnetsWithoutDefinedCidr.length);return subnetsWithoutDefinedCidr.forEach(subnet=>{allocatedSubnets.splice(subnet.index,0,{cidr:this.networkBuilder.addSubnet(cidrMaskForRemaining)})}),{allocatedSubnets}}}class Ipv6Addresses{static amazonProvided(){return new AmazonProvided}constructor(){}}exports.Ipv6Addresses=Ipv6Addresses,_b=JSII_RTTI_SYMBOL_1,Ipv6Addresses[_b]={fqn:"aws-cdk-lib.aws_ec2.Ipv6Addresses",version:"2.188.0"};class AmazonProvided{constructor(){this.amazonProvided=!0}allocateVpcIpv6Cidr(input){return new(ec2_generated_1()).CfnVPCCidrBlock(input.scope,"ipv6cidr",{vpcId:input.vpcId,amazonProvidedIpv6CidrBlock:this.amazonProvided})}createIpv6CidrBlocks(input){const sizeMask=input.sizeMask??"64";return core_1().Fn.cidr(input.ipv6SelectedCidr,input.subnetCount,sizeMask)}allocateSubnetsIpv6Cidr(input){const allocatedSubnets=[];return input.allocatedSubnets.forEach((allocated,i)=>{const allocatedIpv6={cidr:allocated.cidr,ipv6Cidr:core_1().Fn.select(i,input.ipv6Cidrs)};allocatedSubnets.push(allocatedIpv6)}),{allocatedSubnets}}}
