"use strict";var _a,_b,_c,_d,_e,_f,_g,_h,_j,_k;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ServiceManager=exports.InitSource=exports.InitService=exports.InitPackage=exports.InitUser=exports.InitGroup=exports.InitFile=exports.InitCommand=exports.InitCommandWaitDuration=exports.InitElement=exports.InitServiceRestartHandle=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var fs=()=>{var tmp=require("fs");return fs=()=>tmp,tmp},cfn_init_internal_1=()=>{var tmp=require("./private/cfn-init-internal");return cfn_init_internal_1=()=>tmp,tmp},s3_assets=()=>{var tmp=require("../../aws-s3-assets");return s3_assets=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},helpers_internal_1=()=>{var tmp=require("../../core/lib/helpers-internal");return helpers_internal_1=()=>tmp,tmp};class InitServiceRestartHandle{constructor(){this.commands=new Array,this.files=new Array,this.sources=new Array,this.packages={}}_addCommand(key){return this.commands.push(key)}_addFile(key){return this.files.push(key)}_addSource(key){return this.sources.push(key)}_addPackage(packageType,key){this.packages[packageType]||(this.packages[packageType]=[]),this.packages[packageType].push(key)}_renderRestartHandles(){const nonEmpty=x=>x.length>0?x:void 0;return{commands:nonEmpty(this.commands),files:nonEmpty(this.files),packages:Object.keys(this.packages).length>0?this.packages:void 0,sources:nonEmpty(this.sources)}}}exports.InitServiceRestartHandle=InitServiceRestartHandle,_a=JSII_RTTI_SYMBOL_1,InitServiceRestartHandle[_a]={fqn:"aws-cdk-lib.aws_ec2.InitServiceRestartHandle",version:"2.188.0"};class InitElement{}exports.InitElement=InitElement,_b=JSII_RTTI_SYMBOL_1,InitElement[_b]={fqn:"aws-cdk-lib.aws_ec2.InitElement",version:"2.188.0"};class InitCommandWaitDuration{static of(duration){try{jsiiDeprecationWarnings().aws_cdk_lib_Duration(duration)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.of),error}return new class extends InitCommandWaitDuration{_render(){return duration.toSeconds()}}}static none(){return InitCommandWaitDuration.of(core_1().Duration.seconds(0))}static forever(){return new class extends InitCommandWaitDuration{_render(){return"forever"}}}}exports.InitCommandWaitDuration=InitCommandWaitDuration,_c=JSII_RTTI_SYMBOL_1,InitCommandWaitDuration[_c]={fqn:"aws-cdk-lib.aws_ec2.InitCommandWaitDuration",version:"2.188.0"};class InitCommand extends InitElement{static shellCommand(shellCommand,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitCommandOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.shellCommand),error}return new InitCommand(shellCommand,options)}static argvCommand(argv,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitCommandOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.argvCommand),error}if(argv.length===0)throw new Error("Cannot define argvCommand with an empty arguments");return new InitCommand(argv,options)}constructor(command,options){super(),this.command=command,this.options=options,this.elementType=cfn_init_internal_1().InitElementType.COMMAND.toString()}_bind(options){const commandKey=this.options.key||`${options.index}`.padStart(3,"0");if(options.platform!==cfn_init_internal_1().InitPlatform.WINDOWS&&this.options.waitAfterCompletion!==void 0)throw new Error(`Command '${this.command}': 'waitAfterCompletion' is only valid for Windows systems.`);for(const handle of this.options.serviceRestartHandles??[])handle._addCommand(commandKey);return{config:{[commandKey]:{command:this.command,env:this.options.env,cwd:this.options.cwd,test:this.options.testCmd,ignoreErrors:this.options.ignoreErrors,waitAfterCompletion:this.options.waitAfterCompletion?._render()}}}}}exports.InitCommand=InitCommand,_d=JSII_RTTI_SYMBOL_1,InitCommand[_d]={fqn:"aws-cdk-lib.aws_ec2.InitCommand",version:"2.188.0"};class InitFile extends InitElement{static fromString(fileName,content,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromString),error}if(!content)throw new Error(`InitFile ${fileName}: cannot create empty file. Please supply at least one character of content.`);return new class extends InitFile{_doBind(bindOptions){return{config:this._standardConfig(options,bindOptions.platform,{content,encoding:this.options.base64Encoded?"base64":"plain"})}}}(fileName,options)}static symlink(fileName,target,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.symlink),error}const{mode,...otherOptions}=options;if(mode&&mode.slice(0,3)!=="120")throw new Error("File mode for symlinks must begin with 120XXX");return InitFile.fromString(fileName,target,{mode:mode||"120644",...otherOptions})}static fromObject(fileName,obj,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromObject),error}return new class extends InitFile{_doBind(bindOptions){return{config:this._standardConfig(options,bindOptions.platform,{content:obj})}}}(fileName,options)}static fromFileInline(targetFileName,sourceFileName,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromFileInline),error}const encoding=options.base64Encoded?"base64":"utf8",fileContents=fs().readFileSync(sourceFileName).toString(encoding);return InitFile.fromString(targetFileName,fileContents,options)}static fromUrl(fileName,url,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromUrl),error}return new class extends InitFile{_doBind(bindOptions){return{config:this._standardConfig(options,bindOptions.platform,{source:url})}}}(fileName,options)}static fromS3Object(fileName,bucket,key,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromS3Object),error}return new class extends InitFile{_doBind(bindOptions){return bucket.grantRead(bindOptions.instanceRole,key),{config:this._standardConfig(options,bindOptions.platform,{source:bucket.urlForObject(key)}),authentication:standardS3Auth(bindOptions.instanceRole,bucket.bucketName)}}}(fileName,options)}static fromAsset(targetFileName,path,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileAssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}return new class extends InitFile{_doBind(bindOptions){const asset=new(s3_assets()).Asset(bindOptions.scope,`${(0,helpers_internal_1().md5hash)(bindOptions.scope.node.children.toString())}${targetFileName}Asset`,{path,...options});return asset.grantRead(bindOptions.instanceRole),{config:this._standardConfig(options,bindOptions.platform,{source:asset.httpUrl}),authentication:standardS3Auth(bindOptions.instanceRole,asset.s3BucketName),assetHash:asset.assetHash}}}(targetFileName,options)}static fromExistingAsset(targetFileName,asset,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_assets_Asset(asset),jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromExistingAsset),error}return new class extends InitFile{_doBind(bindOptions){return asset.grantRead(bindOptions.instanceRole),{config:this._standardConfig(options,bindOptions.platform,{source:asset.httpUrl}),authentication:standardS3Auth(bindOptions.instanceRole,asset.s3BucketName),assetHash:asset.assetHash}}}(targetFileName,options)}constructor(fileName,options){super(),this.fileName=fileName,this.options=options,this.elementType=cfn_init_internal_1().InitElementType.FILE.toString();try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,InitFile),error}}_bind(bindOptions){for(const handle of this.options.serviceRestartHandles??[])handle._addFile(this.fileName);return this._doBind(bindOptions)}_standardConfig(fileOptions,platform,contentVars){if(platform===cfn_init_internal_1().InitPlatform.WINDOWS){if(fileOptions.group||fileOptions.owner||fileOptions.mode)throw new Error("Owner, group, and mode options not supported for Windows.");return{[this.fileName]:{...contentVars}}}return{[this.fileName]:{...contentVars,mode:fileOptions.mode||"000644",owner:fileOptions.owner||"root",group:fileOptions.group||"root"}}}}exports.InitFile=InitFile,_e=JSII_RTTI_SYMBOL_1,InitFile[_e]={fqn:"aws-cdk-lib.aws_ec2.InitFile",version:"2.188.0"};class InitGroup extends InitElement{static fromName(groupName,groupId){return new InitGroup(groupName,groupId)}constructor(groupName,groupId){super(),this.groupName=groupName,this.groupId=groupId,this.elementType=cfn_init_internal_1().InitElementType.GROUP.toString()}_bind(options){if(options.platform===cfn_init_internal_1().InitPlatform.WINDOWS)throw new Error("Init groups are not supported on Windows");return{config:{[this.groupName]:this.groupId!==void 0?{gid:this.groupId}:{}}}}}exports.InitGroup=InitGroup,_f=JSII_RTTI_SYMBOL_1,InitGroup[_f]={fqn:"aws-cdk-lib.aws_ec2.InitGroup",version:"2.188.0"};class InitUser extends InitElement{static fromName(userName,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitUserOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromName),error}return new InitUser(userName,options)}constructor(userName,userOptions){super(),this.userName=userName,this.userOptions=userOptions,this.elementType=cfn_init_internal_1().InitElementType.USER.toString();try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitUserOptions(userOptions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,InitUser),error}}_bind(options){if(options.platform===cfn_init_internal_1().InitPlatform.WINDOWS)throw new Error("Init users are not supported on Windows");return{config:{[this.userName]:{uid:this.userOptions.userId,groups:this.userOptions.groups,homeDir:this.userOptions.homeDir}}}}}exports.InitUser=InitUser,_g=JSII_RTTI_SYMBOL_1,InitUser[_g]={fqn:"aws-cdk-lib.aws_ec2.InitUser",version:"2.188.0"};class InitPackage extends InitElement{static rpm(location,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_LocationPackageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.rpm),error}return new InitPackage("rpm",[location],options.key,options.serviceRestartHandles)}static yum(packageName,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_NamedPackageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.yum),error}return new InitPackage("yum",options.version??[],packageName,options.serviceRestartHandles)}static rubyGem(gemName,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_NamedPackageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.rubyGem),error}return new InitPackage("rubygems",options.version??[],gemName,options.serviceRestartHandles)}static python(packageName,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_NamedPackageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.python),error}return new InitPackage("python",options.version??[],packageName,options.serviceRestartHandles)}static apt(packageName,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_NamedPackageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.apt),error}return new InitPackage("apt",options.version??[],packageName,options.serviceRestartHandles)}static msi(location,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_LocationPackageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.msi),error}return new class extends InitPackage{renderPackageVersions(){return location}}("msi",[location],options.key,options.serviceRestartHandles)}constructor(type,versions,packageName,serviceHandles){super(),this.type=type,this.versions=versions,this.packageName=packageName,this.serviceHandles=serviceHandles,this.elementType=cfn_init_internal_1().InitElementType.PACKAGE.toString()}_bind(options){if(this.type==="msi"!=(options.platform===cfn_init_internal_1().InitPlatform.WINDOWS))throw this.type==="msi"?new Error("MSI installers are only supported on Windows systems."):new Error("Windows only supports the MSI package type");if(!this.packageName&&!["rpm","msi"].includes(this.type))throw new Error("Package name must be specified for all package types besides RPM and MSI.");const packageName=this.packageName||`${options.index}`.padStart(3,"0");for(const handle of this.serviceHandles??[])handle._addPackage(this.type,packageName);return{config:{[this.type]:{[packageName]:this.renderPackageVersions()}}}}renderPackageVersions(){return this.versions}}exports.InitPackage=InitPackage,_h=JSII_RTTI_SYMBOL_1,InitPackage[_h]={fqn:"aws-cdk-lib.aws_ec2.InitPackage",version:"2.188.0"};class InitService extends InitElement{static enable(serviceName,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitServiceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.enable),error}const{enabled,ensureRunning,...otherOptions}=options;return new InitService(serviceName,{enabled:enabled??!0,ensureRunning:ensureRunning??enabled??!0,...otherOptions})}static disable(serviceName){return new InitService(serviceName,{enabled:!1,ensureRunning:!1})}static systemdConfigFile(serviceName,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_SystemdConfigFileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.systemdConfigFile),error}if(!options.command.startsWith("/"))throw new Error(`SystemD executables must use an absolute path, got '${options.command}'`);if(options.environmentFiles?.some(file=>!file.startsWith("/")))throw new Error("SystemD environment files must use absolute paths");const lines=["[Unit]",...options.description?[`Description=${options.description}`]:[],...options.afterNetwork??!0?["After=network.target"]:[],"[Service]",`ExecStart=${options.command}`,...options.cwd?[`WorkingDirectory=${options.cwd}`]:[],...options.user?[`User=${options.user}`]:[],...options.group?[`Group=${options.user}`]:[],...options.keepRunning??!0?["Restart=always"]:[],...options.environmentFiles?options.environmentFiles.map(file=>`EnvironmentFile=${file}`):[],...options.environmentVariables?Object.entries(options.environmentVariables).map(([key,value])=>`Environment="${key}=${value}"`):[],"[Install]","WantedBy=multi-user.target"];return InitFile.fromString(`/etc/systemd/system/${serviceName}.service`,lines.join(`
`))}constructor(serviceName,serviceOptions){super(),this.serviceName=serviceName,this.serviceOptions=serviceOptions,this.elementType=cfn_init_internal_1().InitElementType.SERVICE.toString()}_bind(options){const serviceManager=this.serviceOptions.serviceManager??(options.platform===cfn_init_internal_1().InitPlatform.LINUX?ServiceManager.SYSVINIT:ServiceManager.WINDOWS);return{config:{[serviceManagerToString(serviceManager)]:{[this.serviceName]:{enabled:this.serviceOptions.enabled,ensureRunning:this.serviceOptions.ensureRunning,...this.serviceOptions.serviceRestartHandle?._renderRestartHandles()}}}}}}exports.InitService=InitService,_j=JSII_RTTI_SYMBOL_1,InitService[_j]={fqn:"aws-cdk-lib.aws_ec2.InitService",version:"2.188.0"};class InitSource extends InitElement{static fromUrl(targetDirectory,url,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitSourceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromUrl),error}return new class extends InitSource{_doBind(){return{config:{[this.targetDirectory]:url}}}}(targetDirectory,options.serviceRestartHandles)}static fromGitHub(targetDirectory,owner,repo,refSpec,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitSourceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromGitHub),error}return InitSource.fromUrl(targetDirectory,`https://github.com/${owner}/${repo}/tarball/${refSpec??"master"}`,options)}static fromS3Object(targetDirectory,bucket,key,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitSourceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromS3Object),error}return new class extends InitSource{_doBind(bindOptions){return bucket.grantRead(bindOptions.instanceRole,key),{config:{[this.targetDirectory]:bucket.urlForObject(key)},authentication:standardS3Auth(bindOptions.instanceRole,bucket.bucketName)}}}(targetDirectory,options.serviceRestartHandles)}static fromAsset(targetDirectory,path,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitSourceAssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}return new class extends InitSource{_doBind(bindOptions){const asset=new(s3_assets()).Asset(bindOptions.scope,`${(0,helpers_internal_1().md5hash)(bindOptions.scope.node.children.toString())}${targetDirectory}Asset`,{path,...bindOptions});return asset.grantRead(bindOptions.instanceRole),{config:{[this.targetDirectory]:asset.httpUrl},authentication:standardS3Auth(bindOptions.instanceRole,asset.s3BucketName),assetHash:asset.assetHash}}}(targetDirectory,options.serviceRestartHandles)}static fromExistingAsset(targetDirectory,asset,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_assets_Asset(asset),jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_InitSourceOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromExistingAsset),error}return new class extends InitSource{_doBind(bindOptions){return asset.grantRead(bindOptions.instanceRole),{config:{[this.targetDirectory]:asset.httpUrl},authentication:standardS3Auth(bindOptions.instanceRole,asset.s3BucketName),assetHash:asset.assetHash}}}(targetDirectory,options.serviceRestartHandles)}constructor(targetDirectory,serviceHandles){super(),this.targetDirectory=targetDirectory,this.serviceHandles=serviceHandles,this.elementType=cfn_init_internal_1().InitElementType.SOURCE.toString()}_bind(options){for(const handle of this.serviceHandles??[])handle._addSource(this.targetDirectory);return this._doBind(options)}}exports.InitSource=InitSource,_k=JSII_RTTI_SYMBOL_1,InitSource[_k]={fqn:"aws-cdk-lib.aws_ec2.InitSource",version:"2.188.0"};function standardS3Auth(role,bucketName){return{S3AccessCreds:{type:"S3",roleName:role.roleName,buckets:[bucketName]}}}var ServiceManager;(function(ServiceManager2){ServiceManager2[ServiceManager2.SYSVINIT=0]="SYSVINIT",ServiceManager2[ServiceManager2.WINDOWS=1]="WINDOWS",ServiceManager2[ServiceManager2.SYSTEMD=2]="SYSTEMD"})(ServiceManager||(exports.ServiceManager=ServiceManager={}));function serviceManagerToString(x){switch(x){case ServiceManager.SYSTEMD:return"systemd";case ServiceManager.SYSVINIT:return"sysvinit";case ServiceManager.WINDOWS:return"windows"}}
