import * as cdk from "../../core";
import * as constructs from "constructs";
import * as cfn_parse from "../../core/lib/helpers-internal";
/**
 * Creates an outbound campaign.
 *
 * > - For users to be able to view or edit a campaign at a later date by using the Amazon Connect user interface, you must add the instance ID as a tag. For example, `{ "tags": {"owner": "arn:aws:connect:{REGION}:{AWS_ACCOUNT_ID}:instance/{CONNECT_INSTANCE_ID}"}}` .
 * > - After a campaign is created, you can't add/remove source.
 *
 * @cloudformationResource AWS::ConnectCampaignsV2::Campaign
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html
 */
export declare class CfnCampaign extends cdk.CfnResource implements cdk.IInspectable, cdk.ITaggableV2 {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME: string;
    /**
     * Build a CfnCampaign from CloudFormation properties
     *
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCampaign;
    /**
     * The Amazon Resource Name (ARN).
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * Tag Manager which manages the tags for this resource
     */
    readonly cdkTagManager: cdk.TagManager;
    /**
     * Contains channel subtype configuration for an outbound campaign.
     */
    channelSubtypeConfig: CfnCampaign.ChannelSubtypeConfigProperty | cdk.IResolvable;
    /**
     * Communication limits configuration for an outbound campaign.
     */
    communicationLimitsOverride?: CfnCampaign.CommunicationLimitsConfigProperty | cdk.IResolvable;
    /**
     * Contains communication time configuration for an outbound campaign.
     */
    communicationTimeConfig?: CfnCampaign.CommunicationTimeConfigProperty | cdk.IResolvable;
    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
     */
    connectCampaignFlowArn?: string;
    /**
     * The identifier of the Amazon Connect instance.
     */
    connectInstanceId: string;
    /**
     * The name of the outbound campaign.
     */
    name: string;
    /**
     * Contains the schedule configuration.
     */
    schedule?: cdk.IResolvable | CfnCampaign.ScheduleProperty;
    /**
     * Contains source configuration.
     */
    source?: cdk.IResolvable | CfnCampaign.SourceProperty;
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    tags?: Array<cdk.CfnTag>;
    /**
     * @param scope Scope in which this resource is defined
     * @param id Construct identifier for this resource (unique in its scope)
     * @param props Resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCampaignProps);
    protected get cfnProperties(): Record<string, any>;
    /**
     * Examines the CloudFormation resource and discloses attributes
     *
     * @param inspector tree inspector to collect and process attributes
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected renderProperties(props: Record<string, any>): Record<string, any>;
}
export declare namespace CfnCampaign {
    /**
     * Contains channel subtype configuration for an outbound campaign.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html
     */
    interface ChannelSubtypeConfigProperty {
        /**
         * The configuration of the email channel subtype.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-email
         */
        readonly email?: CfnCampaign.EmailChannelSubtypeConfigProperty | cdk.IResolvable;
        /**
         * The configuration of the SMS channel subtype.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-sms
         */
        readonly sms?: cdk.IResolvable | CfnCampaign.SmsChannelSubtypeConfigProperty;
        /**
         * The configuration of the telephony channel subtype.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-telephony
         */
        readonly telephony?: cdk.IResolvable | CfnCampaign.TelephonyChannelSubtypeConfigProperty;
    }
    /**
     * The configuration for the telephony channel subtype.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html
     */
    interface TelephonyChannelSubtypeConfigProperty {
        /**
         * The allocation of telephony capacity between multiple running outbound campaigns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-capacity
         */
        readonly capacity?: number;
        /**
         * The identifier of the Amazon Connect queue associated with telephony outbound requests of an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-connectqueueid
         */
        readonly connectQueueId?: string;
        /**
         * The default telephony outbound configuration of an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-defaultoutboundconfig
         */
        readonly defaultOutboundConfig: cdk.IResolvable | CfnCampaign.TelephonyOutboundConfigProperty;
        /**
         * The outbound mode of telephony for an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-outboundmode
         */
        readonly outboundMode: cdk.IResolvable | CfnCampaign.TelephonyOutboundModeProperty;
    }
    /**
     * Contains information about telephony outbound mode.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html
     */
    interface TelephonyOutboundModeProperty {
        /**
         * The agentless outbound mode configuration for telephony.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-agentlessconfig
         */
        readonly agentlessConfig?: any | cdk.IResolvable;
        /**
         * Contains predictive outbound mode configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-predictiveconfig
         */
        readonly predictiveConfig?: cdk.IResolvable | CfnCampaign.PredictiveConfigProperty;
        /**
         * Contains progressive telephony outbound mode configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-progressiveconfig
         */
        readonly progressiveConfig?: cdk.IResolvable | CfnCampaign.ProgressiveConfigProperty;
    }
    /**
     * Contains the progressive outbound mode configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html
     */
    interface ProgressiveConfigProperty {
        /**
         * Bandwidth allocation for the progressive outbound mode.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html#cfn-connectcampaignsv2-campaign-progressiveconfig-bandwidthallocation
         */
        readonly bandwidthAllocation: number;
    }
    /**
     * Contains predictive outbound mode configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html
     */
    interface PredictiveConfigProperty {
        /**
         * Bandwidth allocation for the predictive outbound mode.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html#cfn-connectcampaignsv2-campaign-predictiveconfig-bandwidthallocation
         */
        readonly bandwidthAllocation: number;
    }
    /**
     * The outbound configuration for telephony.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html
     */
    interface TelephonyOutboundConfigProperty {
        /**
         * The answering machine detection configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-answermachinedetectionconfig
         */
        readonly answerMachineDetectionConfig?: CfnCampaign.AnswerMachineDetectionConfigProperty | cdk.IResolvable;
        /**
         * The identifier of the published Amazon Connect contact flow.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectcontactflowid
         */
        readonly connectContactFlowId: string;
        /**
         * The Amazon Connect source phone number.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectsourcephonenumber
         */
        readonly connectSourcePhoneNumber?: string;
    }
    /**
     * Contains answering machine detection configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html
     */
    interface AnswerMachineDetectionConfigProperty {
        /**
         * Whether or not waiting for an answer machine prompt is enabled.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-awaitanswermachineprompt
         */
        readonly awaitAnswerMachinePrompt?: boolean | cdk.IResolvable;
        /**
         * Enables answering machine detection.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-enableanswermachinedetection
         */
        readonly enableAnswerMachineDetection: boolean | cdk.IResolvable;
    }
    /**
     * The configuration for the SMS channel subtype.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html
     */
    interface SmsChannelSubtypeConfigProperty {
        /**
         * The allocation of SMS capacity between multiple running outbound campaigns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-capacity
         */
        readonly capacity?: number;
        /**
         * The default SMS outbound configuration of an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-defaultoutboundconfig
         */
        readonly defaultOutboundConfig: cdk.IResolvable | CfnCampaign.SmsOutboundConfigProperty;
        /**
         * The outbound mode of SMS for an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-outboundmode
         */
        readonly outboundMode: cdk.IResolvable | CfnCampaign.SmsOutboundModeProperty;
    }
    /**
     * Contains information about the SMS outbound mode.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html
     */
    interface SmsOutboundModeProperty {
        /**
         * Contains agentless outbound mode configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html#cfn-connectcampaignsv2-campaign-smsoutboundmode-agentlessconfig
         */
        readonly agentlessConfig?: any | cdk.IResolvable;
    }
    /**
     * The outbound configuration for SMS.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html
     */
    interface SmsOutboundConfigProperty {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Connect source SMS phone number.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-connectsourcephonenumberarn
         */
        readonly connectSourcePhoneNumberArn: string;
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-wisdomtemplatearn
         */
        readonly wisdomTemplateArn: string;
    }
    /**
     * The configuration for the email channel subtype.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html
     */
    interface EmailChannelSubtypeConfigProperty {
        /**
         * The allocation of email capacity between multiple running outbound campaigns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-capacity
         */
        readonly capacity?: number;
        /**
         * The default email outbound configuration of an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-defaultoutboundconfig
         */
        readonly defaultOutboundConfig: CfnCampaign.EmailOutboundConfigProperty | cdk.IResolvable;
        /**
         * The outbound mode for email of an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-outboundmode
         */
        readonly outboundMode: CfnCampaign.EmailOutboundModeProperty | cdk.IResolvable;
    }
    /**
     * Contains information about email outbound mode.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html
     */
    interface EmailOutboundModeProperty {
        /**
         * The agentless outbound mode configuration for email.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html#cfn-connectcampaignsv2-campaign-emailoutboundmode-agentlessconfig
         */
        readonly agentlessConfig?: any | cdk.IResolvable;
    }
    /**
     * The outbound configuration for email.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html
     */
    interface EmailOutboundConfigProperty {
        /**
         * The Amazon Connect source email address.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-connectsourceemailaddress
         */
        readonly connectSourceEmailAddress: string;
        /**
         * The display name for the Amazon Connect source email address.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-sourceemailaddressdisplayname
         */
        readonly sourceEmailAddressDisplayName?: string;
        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-wisdomtemplatearn
         */
        readonly wisdomTemplateArn: string;
    }
    /**
     * Contains source configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html
     */
    interface SourceProperty {
        /**
         * The Amazon Resource Name (ARN) of the Customer Profiles segment.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-customerprofilessegmentarn
         */
        readonly customerProfilesSegmentArn?: string;
        /**
         * The event trigger of the campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-eventtrigger
         */
        readonly eventTrigger?: CfnCampaign.EventTriggerProperty | cdk.IResolvable;
    }
    /**
     * The event trigger of the campaign.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-eventtrigger.html
     */
    interface EventTriggerProperty {
        /**
         * The Amazon Resource Name (ARN) of the Customer Profiles domain.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-eventtrigger.html#cfn-connectcampaignsv2-campaign-eventtrigger-customerprofilesdomainarn
         */
        readonly customerProfilesDomainArn?: string;
    }
    /**
     * Contains the schedule configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html
     */
    interface ScheduleProperty {
        /**
         * The end time of the schedule in UTC.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-endtime
         */
        readonly endTime: string;
        /**
         * The refresh frequency of the campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-refreshfrequency
         */
        readonly refreshFrequency?: string;
        /**
         * The start time of the schedule in UTC.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-starttime
         */
        readonly startTime: string;
    }
    /**
     * Communication time configuration for an outbound campaign.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html
     */
    interface CommunicationTimeConfigProperty {
        /**
         * The communication time configuration for the email channel subtype.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-email
         */
        readonly email?: cdk.IResolvable | CfnCampaign.TimeWindowProperty;
        /**
         * The local timezone configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-localtimezoneconfig
         */
        readonly localTimeZoneConfig: cdk.IResolvable | CfnCampaign.LocalTimeZoneConfigProperty;
        /**
         * The communication time configuration for the SMS channel subtype.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-sms
         */
        readonly sms?: cdk.IResolvable | CfnCampaign.TimeWindowProperty;
        /**
         * The communication time configuration for the telephony channel subtype.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-telephony
         */
        readonly telephony?: cdk.IResolvable | CfnCampaign.TimeWindowProperty;
    }
    /**
     * The configuration of timezone for recipient.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html
     */
    interface LocalTimeZoneConfigProperty {
        /**
         * The timezone to use for all recipients.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-defaulttimezone
         */
        readonly defaultTimeZone?: string;
        /**
         * Detects methods for the recipient's timezone.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-localtimezonedetection
         */
        readonly localTimeZoneDetection?: Array<string>;
    }
    /**
     * Contains information about a time window.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html
     */
    interface TimeWindowProperty {
        /**
         * The open hours configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-openhours
         */
        readonly openHours: cdk.IResolvable | CfnCampaign.OpenHoursProperty;
        /**
         * The restricted periods configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-restrictedperiods
         */
        readonly restrictedPeriods?: cdk.IResolvable | CfnCampaign.RestrictedPeriodsProperty;
    }
    /**
     * Contains information about open hours.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html
     */
    interface OpenHoursProperty {
        /**
         * The daily hours configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html#cfn-connectcampaignsv2-campaign-openhours-dailyhours
         */
        readonly dailyHours: Array<CfnCampaign.DailyHourProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The daily hours configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html
     */
    interface DailyHourProperty {
        /**
         * The key for DailyHour.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-key
         */
        readonly key?: string;
        /**
         * The value for DailyHour.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-value
         */
        readonly value?: Array<cdk.IResolvable | CfnCampaign.TimeRangeProperty> | cdk.IResolvable;
    }
    /**
     * Contains information about a time range.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html
     */
    interface TimeRangeProperty {
        /**
         * The end time of the time range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-endtime
         */
        readonly endTime: string;
        /**
         * The start time of the time range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-starttime
         */
        readonly startTime: string;
    }
    /**
     * Contains information about restricted periods.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html
     */
    interface RestrictedPeriodsProperty {
        /**
         * The restricted period list.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html#cfn-connectcampaignsv2-campaign-restrictedperiods-restrictedperiodlist
         */
        readonly restrictedPeriodList: Array<cdk.IResolvable | CfnCampaign.RestrictedPeriodProperty> | cdk.IResolvable;
    }
    /**
     * Contains information about a restricted period.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html
     */
    interface RestrictedPeriodProperty {
        /**
         * The end date of the restricted period.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-enddate
         */
        readonly endDate: string;
        /**
         * The name of the restricted period.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-name
         */
        readonly name?: string;
        /**
         * The start date of the restricted period.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-startdate
         */
        readonly startDate: string;
    }
    /**
     * Contains the communication limits configuration for an outbound campaign.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html
     */
    interface CommunicationLimitsConfigProperty {
        /**
         * The CommunicationLimits that apply to all channel subtypes defined in an outbound campaign.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html#cfn-connectcampaignsv2-campaign-communicationlimitsconfig-allchannelssubtypes
         */
        readonly allChannelsSubtypes?: CfnCampaign.CommunicationLimitsProperty | cdk.IResolvable;
    }
    /**
     * Contains information about communication limits.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html
     */
    interface CommunicationLimitsProperty {
        /**
         * The list of CommunicationLimits.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html#cfn-connectcampaignsv2-campaign-communicationlimits-communicationlimitlist
         */
        readonly communicationLimitList?: Array<CfnCampaign.CommunicationLimitProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * Contains information about a communication limit.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html
     */
    interface CommunicationLimitProperty {
        /**
         * The frequency of communication limit evaluation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-frequency
         */
        readonly frequency: number;
        /**
         * The maximum outreaching count for each recipient.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-maxcountperrecipient
         */
        readonly maxCountPerRecipient: number;
        /**
         * The unit of communication limit evaluation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-unit
         */
        readonly unit: string;
    }
}
/**
 * Properties for defining a `CfnCampaign`
 *
 * @struct
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html
 */
export interface CfnCampaignProps {
    /**
     * Contains channel subtype configuration for an outbound campaign.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig
     */
    readonly channelSubtypeConfig: CfnCampaign.ChannelSubtypeConfigProperty | cdk.IResolvable;
    /**
     * Communication limits configuration for an outbound campaign.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride
     */
    readonly communicationLimitsOverride?: CfnCampaign.CommunicationLimitsConfigProperty | cdk.IResolvable;
    /**
     * Contains communication time configuration for an outbound campaign.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig
     */
    readonly communicationTimeConfig?: CfnCampaign.CommunicationTimeConfigProperty | cdk.IResolvable;
    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectcampaignflowarn
     */
    readonly connectCampaignFlowArn?: string;
    /**
     * The identifier of the Amazon Connect instance.
     *
     * You can find the `instanceId` in the ARN of the instance.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectinstanceid
     */
    readonly connectInstanceId: string;
    /**
     * The name of the outbound campaign.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-name
     */
    readonly name: string;
    /**
     * Contains the schedule configuration.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule
     */
    readonly schedule?: cdk.IResolvable | CfnCampaign.ScheduleProperty;
    /**
     * Contains source configuration.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source
     */
    readonly source?: cdk.IResolvable | CfnCampaign.SourceProperty;
    /**
     * The tags used to organize, track, or control access for this resource.
     *
     * For example, `{ "tags": {"key1":"value1", "key2":"value2"} }` .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-tags
     */
    readonly tags?: Array<cdk.CfnTag>;
}
