import { Construct } from 'constructs';
import { IUserPool } from './user-pool';
import { IRole } from '../../aws-iam';
import { IResource, Resource } from '../../core';
/**
 * Represents a user pool group.
 */
export interface IUserPoolGroup extends IResource {
    /**
     * The user group name
     * @attribute
     */
    readonly groupName: string;
}
/**
 * Options to create a UserPoolGroup
 */
export interface UserPoolGroupOptions {
    /**
     * A string containing the description of the group.
     *
     * @default - no description
     */
    readonly description?: string;
    /**
     * The name of the group. Must be unique.
     *
     * @default - auto generate a name
     */
    readonly groupName?: string;
    /**
     * A non-negative integer value that specifies the precedence of this group relative to the other groups
     * that a user can belong to in the user pool. Zero is the highest precedence value.
     *
     * Groups with lower Precedence values take precedence over groups with higher or null Precedence values.
     * If a user belongs to two or more groups, it is the group with the lowest precedence value
     * whose role ARN is given in the user's tokens for the cognito:roles and cognito:preferred_role claims.
     *
     * Two groups can have the same Precedence value. If this happens, neither group takes precedence over the other.
     * If two groups with the same Precedence have the same role ARN, that role is used in the cognito:preferred_role
     * claim in tokens for users in each group.
     * If the two groups have different role ARNs, the cognito:preferred_role claim isn't set in users' tokens.
     *
     * @default - null
     */
    readonly precedence?: number;
    /**
     * The role for the group.
     *
     * @default - no description
     */
    readonly role?: IRole;
}
/**
 * Props for UserPoolGroup construct
 */
export interface UserPoolGroupProps extends UserPoolGroupOptions {
    /**
     * The user pool to which this group is associated.
     */
    readonly userPool: IUserPool;
}
/**
 * Define a user pool group
 */
export declare class UserPoolGroup extends Resource implements IUserPoolGroup {
    /**
     * Import a UserPoolGroup given its group name
     */
    static fromGroupName(scope: Construct, id: string, groupName: string): IUserPoolGroup;
    readonly groupName: string;
    constructor(scope: Construct, id: string, props: UserPoolGroupProps);
}
