import { Construct } from 'constructs';
import * as codepipeline from '../../../aws-codepipeline';
import { Action } from '../action';
/**
 * The CodePipeline variables emitted by the InspectorScan Action.
 */
export interface InspectorScanVariables {
    /**
     * The highest severity output from the scan.
     *
     * Valid values are medium | high | critical.
     */
    readonly highestScannedSeverity: string;
}
/**
 * Base construction properties of the `InspectorScanActionBase`.
 */
export interface InspectorScanActionBaseProps extends codepipeline.CommonAwsActionProps {
    /**
     * The number of critical severity vulnerabilities found in your source
     * beyond which CodePipeline should fail the action.
     *
     * @default - no threshold
     */
    readonly criticalThreshold?: number;
    /**
     * The number of high severity vulnerabilities found in your source
     * beyond which CodePipeline should fail the action.
     *
     * @default - no threshold
     */
    readonly highThreshold?: number;
    /**
     * The number of medium severity vulnerabilities found in your source
     * beyond which CodePipeline should fail the action.
     *
     * @default - no threshold
     */
    readonly mediumThreshold?: number;
    /**
     * The number of low severity vulnerabilities found in your source
     * beyond which CodePipeline should fail the action.
     *
     * @default - no threshold
     */
    readonly lowThreshold?: number;
    /**
     * Vulnerability details of your source in the form of a Software Bill of Materials (SBOM) file.
     */
    readonly output: codepipeline.Artifact;
}
/**
 * CodePipeline invoke action that uses AWS InspectorScan.
 */
export declare abstract class InspectorScanActionBase extends Action {
    protected readonly props: InspectorScanActionBaseProps;
    constructor(props: InspectorScanActionBaseProps);
    /** The variables emitted by this action. */
    get variables(): InspectorScanVariables;
    protected abstract renderActionConfiguration(): Record<string, any>;
    protected bound(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
