import { Construct } from 'constructs';
import * as codepipeline from '../../../aws-codepipeline';
import { Action } from '../action';
/**
 * The CodePipeline variables emitted by the ECR build and publish Action.
 */
export interface EcrBuildAndPublishVariables {
    /**
     * The sha256 digest of the image manifest.
     */
    readonly ecrImageDigestId: string;
    /**
     * The name of the Amazon ECR repository where the image was pushed.
     */
    readonly ecrRepositoryName: string;
}
/**
 * The type of registry to use for the EcrBuildAndPublish action.
 */
export declare enum RegistryType {
    /**
     * Private registry
     */
    PRIVATE = "private",
    /**
     * Public registry
     */
    PUBLIC = "public"
}
/**
 * Construction properties of the `EcrBuildAndPublishAction`.
 */
export interface EcrBuildAndPublishActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The name of the ECR repository where the image is pushed.
     */
    readonly repositoryName: string;
    /**
     * The directory path of Dockerfile used to build the image.
     *
     * Optionally, you can provide an alternate directory path if Dockerfile is not at the root level.
     *
     * @default - the source repository root level
     */
    readonly dockerfileDirectoryPath?: string;
    /**
     * The tags used for the image.
     *
     * @default - latest
     */
    readonly imageTags?: string[];
    /**
     * Specifies whether the repository is public or private.
     *
     * @default - RegistryType.PRIVATE
     */
    readonly registryType?: RegistryType;
    /**
     * The artifact produced by the source action that contains the Dockerfile needed to build the image.
     */
    readonly input: codepipeline.Artifact;
}
/**
 * CodePipeline build action that uses AWS EcrBuildAndPublish.
 */
export declare class EcrBuildAndPublishAction extends Action {
    private readonly props;
    constructor(props: EcrBuildAndPublishActionProps);
    /** The variables emitted by this action. */
    get variables(): EcrBuildAndPublishVariables;
    protected bound(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
