import { Construct } from 'constructs';
import * as codepipeline from '../../../aws-codepipeline';
import { Action } from '../action';
/**
 * Construction properties of the `CommandsAction`.
 */
export interface CommandsActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The source to use as input for this action.
     */
    readonly input: codepipeline.Artifact;
    /**
     * The list of additional input artifacts for this action.
     *
     * @default - no extra inputs
     */
    readonly extraInputs?: codepipeline.Artifact[];
    /**
     * The output artifact for this action.
     *
     * You can filter files that you want to export as the output artifact for the action.
     *
     * @example
     * new codepipeline.Artifact('CommandsArtifact', ['my-dir/**']);
     *
     * @default - no output artifact
     */
    readonly output?: codepipeline.Artifact;
    /**
     * The names of the variables in your environment that you want to export.
     *
     * These variables can be referenced in other actions by using the `variable` method
     * of this class.
     *
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html
     * @default - No output variables are exported
     */
    readonly outputVariables?: string[];
    /**
     * Shell commands for the Commands action to run.
     *
     * All formats are supported except multi-line formats.
     *
     * The length of the commands array must be between 1 and 50.
     */
    readonly commands: string[];
}
/**
 * CodePipeline compute action that uses AWS Commands.
 */
export declare class CommandsAction extends Action {
    private readonly outputVariables;
    constructor(props: CommandsActionProps);
    /**
     * Reference a CodePipeline variable exported in the Commands action.
     *
     * @param variableName the name of the variable exported by `outputVariables`
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html
     */
    variable(variableName: string): string;
    protected bound(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
