"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ProjectNotificationEvents=exports.ProjectVisibility=exports.BuildEnvironmentVariableType=exports.MacBuildImage=exports.WindowsBuildImage=exports.WindowsImageType=exports.LinuxBuildImage=exports.ImagePullPrincipalType=exports.Project=void 0,exports.isLambdaComputeType=isLambdaComputeType;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var build_spec_1=()=>{var tmp=require("./build-spec");return build_spec_1=()=>tmp,tmp},cache_1=()=>{var tmp=require("./cache");return cache_1=()=>tmp,tmp},codebuild_canned_metrics_generated_1=()=>{var tmp=require("./codebuild-canned-metrics.generated");return codebuild_canned_metrics_generated_1=()=>tmp,tmp},codebuild_generated_1=()=>{var tmp=require("./codebuild.generated");return codebuild_generated_1=()=>tmp,tmp},codepipeline_artifacts_1=()=>{var tmp=require("./codepipeline-artifacts");return codepipeline_artifacts_1=()=>tmp,tmp},compute_type_1=()=>{var tmp=require("./compute-type");return compute_type_1=()=>tmp,tmp},environment_type_1=()=>{var tmp=require("./environment-type");return environment_type_1=()=>tmp,tmp},linux_arm_lambda_build_image_1=()=>{var tmp=require("./linux-arm-lambda-build-image");return linux_arm_lambda_build_image_1=()=>tmp,tmp},linux_lambda_build_image_1=()=>{var tmp=require("./linux-lambda-build-image");return linux_lambda_build_image_1=()=>tmp,tmp},no_artifacts_1=()=>{var tmp=require("./no-artifacts");return no_artifacts_1=()=>tmp,tmp},no_source_1=()=>{var tmp=require("./no-source");return no_source_1=()=>tmp,tmp},run_script_linux_build_spec_1=()=>{var tmp=require("./private/run-script-linux-build-spec");return run_script_linux_build_spec_1=()=>tmp,tmp},report_group_utils_1=()=>{var tmp=require("./report-group-utils");return report_group_utils_1=()=>tmp,tmp},source_types_1=()=>{var tmp=require("./source-types");return source_types_1=()=>tmp,tmp},cloudwatch=()=>{var tmp=require("../../aws-cloudwatch");return cloudwatch=()=>tmp,tmp},notifications=()=>{var tmp=require("../../aws-codestarnotifications");return notifications=()=>tmp,tmp},ec2=()=>{var tmp=require("../../aws-ec2");return ec2=()=>tmp,tmp},aws_ecr_assets_1=()=>{var tmp=require("../../aws-ecr-assets");return aws_ecr_assets_1=()=>tmp,tmp},events=()=>{var tmp=require("../../aws-events");return events=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},kms=()=>{var tmp=require("../../aws-kms");return kms=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};const VPC_POLICY_SYM=Symbol.for("@aws-cdk/aws-codebuild.roleVpcPolicy");class ProjectBase extends core_1().Resource{get connections(){if(!this._connections)throw new(core_1()).ValidationError('Only VPC-associated Projects have security groups to manage. Supply the "vpc" parameter when creating the Project',this);return this._connections}enableBatchBuilds(){}addToRolePolicy(statement){this.role&&this.role.addToPrincipalPolicy(statement)}onEvent(id,options={}){const rule=new(events()).Rule(this,id,options);return rule.addTarget(options.target),rule.addEventPattern({source:["aws.codebuild"],detail:{"project-name":[this.projectName]}}),rule}onStateChange(id,options={}){const rule=this.onEvent(id,options);return rule.addEventPattern({detailType:["CodeBuild Build State Change"]}),rule}onPhaseChange(id,options={}){const rule=this.onEvent(id,options);return rule.addEventPattern({detailType:["CodeBuild Build Phase Change"]}),rule}onBuildStarted(id,options={}){const rule=this.onStateChange(id,options);return rule.addEventPattern({detail:{"build-status":["IN_PROGRESS"]}}),rule}onBuildFailed(id,options={}){const rule=this.onStateChange(id,options);return rule.addEventPattern({detail:{"build-status":["FAILED"]}}),rule}onBuildSucceeded(id,options={}){const rule=this.onStateChange(id,options);return rule.addEventPattern({detail:{"build-status":["SUCCEEDED"]}}),rule}metric(metricName,props){return new(cloudwatch()).Metric({namespace:"AWS/CodeBuild",metricName,dimensionsMap:{ProjectName:this.projectName},...props}).attachTo(this)}metricBuilds(props){return this.cannedMetric(codebuild_canned_metrics_generated_1().CodeBuildMetrics.buildsSum,props)}metricDuration(props){return this.cannedMetric(codebuild_canned_metrics_generated_1().CodeBuildMetrics.durationAverage,props)}metricSucceededBuilds(props){return this.cannedMetric(codebuild_canned_metrics_generated_1().CodeBuildMetrics.succeededBuildsSum,props)}metricFailedBuilds(props){return this.cannedMetric(codebuild_canned_metrics_generated_1().CodeBuildMetrics.failedBuildsSum,props)}notifyOn(id,target,options){return new(notifications()).NotificationRule(this,id,{...options,source:this,targets:[target]})}notifyOnBuildSucceeded(id,target,options){return this.notifyOn(id,target,{...options,events:[ProjectNotificationEvents.BUILD_SUCCEEDED]})}notifyOnBuildFailed(id,target,options){return this.notifyOn(id,target,{...options,events:[ProjectNotificationEvents.BUILD_FAILED]})}bindAsNotificationRuleSource(_scope){return{sourceArn:this.projectArn}}cannedMetric(fn,props){return new(cloudwatch()).Metric({...fn({ProjectName:this.projectName}),...props}).attachTo(this)}}class Project extends ProjectBase{static fromProjectArn(scope,id,projectArn){const parsedArn=core_1().Stack.of(scope).splitArn(projectArn,core_1().ArnFormat.SLASH_RESOURCE_NAME);class Import extends ProjectBase{constructor(s,i){super(s,i,{account:parsedArn.account,region:parsedArn.region}),this.projectArn=projectArn,this.projectName=parsedArn.resourceName,this.role=void 0,this.grantPrincipal=new(iam()).UnknownPrincipal({resource:this})}}return new Import(scope,id)}static fromProjectName(scope,id,projectName){class Import extends ProjectBase{constructor(s,i){super(s,i),this.role=void 0,this.projectArn=core_1().Stack.of(this).formatArn({service:"codebuild",resource:"project",resourceName:projectName}),this.grantPrincipal=new(iam()).UnknownPrincipal({resource:this}),this.projectName=projectName}}return new Import(scope,id)}static serializeEnvVariables(environmentVariables,validateNoPlainTextSecrets=!1,principal){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_IGrantable(principal)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.serializeEnvVariables),error}const ret=new Array,ssmIamResources=new Array,secretsManagerIamResources=new Set,kmsIamResources=new Set;for(const[name,envVariable]of Object.entries(environmentVariables)){const envVariableValue=envVariable.value?.toString(),cfnEnvVariable={name,type:envVariable.type||BuildEnvironmentVariableType.PLAINTEXT,value:envVariableValue};if(ret.push(cfnEnvVariable),validateNoPlainTextSecrets&&cfnEnvVariable.type===BuildEnvironmentVariableType.PLAINTEXT){const fragments=core_1().Tokenization.reverseString(cfnEnvVariable.value);for(const token of fragments.tokens)if(token instanceof core_1().SecretValue)throw new(core_1()).UnscopedValidationError(`Plaintext environment variable '${name}' contains a secret value! This means the value of this variable will be visible in plain text in the AWS Console. Please consider using CodeBuild's SecretsManager environment variables feature instead. If you'd like to continue with having this secret in the plaintext environment variables, please set the checkSecretsInPlainTextEnvVariables property to false`)}if(principal){const stack=core_1().Stack.of(principal);if(envVariable.type===BuildEnvironmentVariableType.PARAMETER_STORE&&ssmIamResources.push(stack.formatArn({service:"ssm",resource:"parameter",resourceName:envVariableValue.startsWith("/")?envVariableValue.slice(1):envVariableValue})),envVariable.type===BuildEnvironmentVariableType.SECRETS_MANAGER)if(envVariableValue.startsWith("arn:")){const parsedArn=stack.splitArn(envVariableValue,core_1().ArnFormat.COLON_RESOURCE_NAME);if(!parsedArn.resourceName)throw new(core_1()).UnscopedValidationError("SecretManager ARN is missing the name of the secret: "+envVariableValue);const secretName=parsedArn.resourceName.split(":")[0];secretsManagerIamResources.add(stack.formatArn({service:"secretsmanager",resource:"secret",resourceName:`${secretName}*`,arnFormat:core_1().ArnFormat.COLON_RESOURCE_NAME,partition:parsedArn.partition,account:parsedArn.account,region:parsedArn.region})),parsedArn.account&&core_1().Token.compareStrings(parsedArn.account,stack.account)===core_1().TokenComparison.DIFFERENT&&kmsIamResources.add(stack.formatArn({service:"kms",resource:"key",resourceName:"*",arnFormat:core_1().ArnFormat.SLASH_RESOURCE_NAME,partition:parsedArn.partition,account:parsedArn.account,region:parsedArn.region}))}else if(core_1().Token.isUnresolved(envVariableValue)){let secretArn=envVariableValue.split(":")[0];const fragments=core_1().Tokenization.reverseString(envVariableValue);if(fragments.tokens.length===1){const resolvable=fragments.tokens[0];if(core_1().Reference.isReference(resolvable)){const resourceStack=core_1().Stack.of(resolvable.target);core_1().Token.compareStrings(stack.account,resourceStack.account)===core_1().TokenComparison.DIFFERENT&&(kmsIamResources.add(stack.formatArn({service:"kms",resource:"key",resourceName:"*",arnFormat:core_1().ArnFormat.SLASH_RESOURCE_NAME,partition:resourceStack.partition,account:resourceStack.account,region:resourceStack.region})),secretArn=`${secretArn}-??????`)}}secretsManagerIamResources.add(secretArn)}else{const secretName=envVariableValue.split(":")[0];secretsManagerIamResources.add(stack.formatArn({service:"secretsmanager",resource:"secret",resourceName:`${secretName}-??????`,arnFormat:core_1().ArnFormat.COLON_RESOURCE_NAME}))}}}return ssmIamResources.length!==0&&principal?.grantPrincipal.addToPrincipalPolicy(new(iam()).PolicyStatement({actions:["ssm:GetParameters"],resources:ssmIamResources})),secretsManagerIamResources.size!==0&&principal?.grantPrincipal.addToPrincipalPolicy(new(iam()).PolicyStatement({actions:["secretsmanager:GetSecretValue"],resources:Array.from(secretsManagerIamResources)})),kmsIamResources.size!==0&&principal?.grantPrincipal.addToPrincipalPolicy(new(iam()).PolicyStatement({actions:["kms:Decrypt"],resources:Array.from(kmsIamResources)})),ret}constructor(scope,id,props){super(scope,id,{physicalName:props.projectName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_ProjectProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Project),error}(0,metadata_resource_1().addConstructMetadata)(this,props),this.role=props.role||new(iam()).Role(this,"Role",{roleName:core_1().PhysicalName.GENERATE_IF_NEEDED,assumedBy:new(iam()).ServicePrincipal("codebuild.amazonaws.com")}),this.grantPrincipal=this.role,this.buildImage=props.environment&&props.environment.buildImage||LinuxBuildImage.STANDARD_7_0,this.source=props.source||new(no_source_1()).NoSource;const sourceConfig=this.source.bind(this,this);if(props.badge&&!this.source.badgeSupported)throw new(core_1()).ValidationError(`Badge is not supported for source type ${this.source.type}`,this);const artifacts=props.artifacts?props.artifacts:this.source.type===source_types_1().CODEPIPELINE_SOURCE_ARTIFACTS_TYPE?new(codepipeline_artifacts_1()).CodePipelineArtifacts:new(no_artifacts_1()).NoArtifacts,artifactsConfig=artifacts.bind(this,this),cache=props.cache||cache_1().Cache.none();cache._bind(this);const environmentVariables=props.environmentVariables||{},buildSpec=props.buildSpec;if(this.source.type===source_types_1().NO_SOURCE_TYPE&&(buildSpec===void 0||!buildSpec.isImmediate))throw new(core_1()).ValidationError("If the Project's source is NoSource, you need to provide a concrete buildSpec",this);this._secondarySources=[],this._secondarySourceVersions=[],this._fileSystemLocations=[];for(const secondarySource of props.secondarySources||[])this.addSecondarySource(secondarySource);this._secondaryArtifacts=[];for(const secondaryArtifact of props.secondaryArtifacts||[])this.addSecondaryArtifact(secondaryArtifact);this.validateCodePipelineSettings(artifacts);for(const fileSystemLocation of props.fileSystemLocations||[])this.addFileSystemLocation(fileSystemLocation);if(!core_1().Token.isUnresolved(props.autoRetryLimit)&&props.autoRetryLimit!==void 0&&(props.autoRetryLimit<0||props.autoRetryLimit>10))throw new(core_1()).ValidationError(`autoRetryLimit must be a value between 0 and 10, got ${props.autoRetryLimit}.`,this);const resource=new(codebuild_generated_1()).CfnProject(this,"Resource",{description:props.description,source:{...sourceConfig.sourceProperty,buildSpec:buildSpec&&buildSpec.toBuildSpec(this)},artifacts:artifactsConfig.artifactsProperty,serviceRole:this.role.roleArn,environment:this.renderEnvironment(props,environmentVariables),fileSystemLocations:core_1().Lazy.any({produce:()=>this.renderFileSystemLocations()}),encryptionKey:core_1().Lazy.string({produce:()=>this._encryptionKey?this._encryptionKey.keyArn:"alias/aws/s3"}),badgeEnabled:props.badge,cache:cache._toCloudFormation(),name:this.physicalName,timeoutInMinutes:props.timeout&&props.timeout.toMinutes(),queuedTimeoutInMinutes:props.queuedTimeout&&props.queuedTimeout.toMinutes(),concurrentBuildLimit:props.concurrentBuildLimit,secondarySources:core_1().Lazy.any({produce:()=>this.renderSecondarySources()}),secondarySourceVersions:core_1().Lazy.any({produce:()=>this.renderSecondarySourceVersions()}),secondaryArtifacts:core_1().Lazy.any({produce:()=>this.renderSecondaryArtifacts()}),triggers:sourceConfig.buildTriggers,sourceVersion:sourceConfig.sourceVersion,vpcConfig:this.configureVpc(props),visibility:props.visibility,logsConfig:this.renderLoggingConfiguration(props.logging),buildBatchConfig:core_1().Lazy.any({produce:()=>this._batchServiceRole?{serviceRole:this._batchServiceRole.roleArn}:void 0}),autoRetryLimit:props.autoRetryLimit});this.addVpcRequiredPermissions(props,resource),this.projectArn=this.getResourceArnAttribute(resource.attrArn,{service:"codebuild",resource:"project",resourceName:this.physicalName}),this.projectName=this.getResourceNameAttribute(resource.ref),this.addToRolePolicy(this.createLoggingPermission()),props.grantReportGroupPermissions!==!1&&this.addToRolePolicy(new(iam()).PolicyStatement({actions:["codebuild:CreateReportGroup","codebuild:CreateReport","codebuild:UpdateReport","codebuild:BatchPutTestCases","codebuild:BatchPutCodeCoverages"],resources:[(0,report_group_utils_1().renderReportGroupArn)(this,`${this.projectName}-*`)]})),props.ssmSessionPermissions&&this.addToRolePolicy(new(iam()).PolicyStatement({actions:["ssmmessages:CreateControlChannel","ssmmessages:CreateDataChannel","ssmmessages:OpenControlChannel","ssmmessages:OpenDataChannel","logs:DescribeLogGroups","logs:CreateLogStream","logs:PutLogEvents","s3:GetEncryptionConfiguration","s3:PutObject"],resources:["*"]})),props.encryptionKey&&(this.encryptionKey=props.encryptionKey),isBindableBuildImage(this.buildImage)&&this.buildImage.bind(this,this,{}),this.node.addValidation({validate:()=>this.validateProject()})}enableBatchBuilds(){return this._batchServiceRole||(this._batchServiceRole=new(iam()).Role(this,"BatchServiceRole",{assumedBy:new(iam()).ServicePrincipal("codebuild.amazonaws.com")}),this._batchServiceRole.addToPrincipalPolicy(new(iam()).PolicyStatement({resources:[core_1().Lazy.string({produce:()=>this.projectArn})],actions:["codebuild:StartBuild","codebuild:StopBuild","codebuild:RetryBuild"]}))),{role:this._batchServiceRole}}addSecondarySource(secondarySource){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_ISource(secondarySource)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecondarySource),error}if(!secondarySource.identifier)throw new(core_1()).ValidationError("The identifier attribute is mandatory for secondary sources",this);const secondarySourceConfig=secondarySource.bind(this,this);this._secondarySources.push(secondarySourceConfig.sourceProperty),secondarySourceConfig.sourceVersion&&this._secondarySourceVersions.push({sourceIdentifier:secondarySource.identifier,sourceVersion:secondarySourceConfig.sourceVersion})}addFileSystemLocation(fileSystemLocation){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_IFileSystemLocation(fileSystemLocation)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFileSystemLocation),error}const fileSystemConfig=fileSystemLocation.bind(this,this);this._fileSystemLocations.push(fileSystemConfig.location)}addSecondaryArtifact(secondaryArtifact){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_IArtifacts(secondaryArtifact)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecondaryArtifact),error}if(!secondaryArtifact.identifier)throw new(core_1()).ValidationError("The identifier attribute is mandatory for secondary artifacts",this);this._secondaryArtifacts.push(secondaryArtifact.bind(this,this).artifactsProperty)}bindToCodePipeline(_scope,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_BindToCodePipelineOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindToCodePipeline),error}if(options.artifactBucket.encryptionKey&&!this._encryptionKey){const keyStack=core_1().Stack.of(options.artifactBucket.encryptionKey),projectStack=core_1().Stack.of(this);options.artifactBucket.encryptionKey instanceof kms().Key&&(keyStack.account!==projectStack.account||keyStack.region!==projectStack.region)||(this.encryptionKey=options.artifactBucket.encryptionKey)}}validateProject(){const ret=new Array;return this.source.type===source_types_1().CODEPIPELINE_SOURCE_ARTIFACTS_TYPE&&(this._secondarySources.length>0&&ret.push("A Project with a CodePipeline Source cannot have secondary sources. Use the CodeBuild Pipeline Actions' `extraInputs` property instead"),this._secondaryArtifacts.length>0&&ret.push("A Project with a CodePipeline Source cannot have secondary artifacts. Use the CodeBuild Pipeline Actions' `outputs` property instead")),ret}set encryptionKey(encryptionKey){this._encryptionKey=encryptionKey,encryptionKey.grantEncryptDecrypt(this)}createLoggingPermission(){const logGroupArn=core_1().Stack.of(this).formatArn({service:"logs",resource:"log-group",arnFormat:core_1().ArnFormat.COLON_RESOURCE_NAME,resourceName:`/aws/codebuild/${this.projectName}`}),logGroupStarArn=`${logGroupArn}:*`;return new(iam()).PolicyStatement({resources:[logGroupArn,logGroupStarArn],actions:["logs:CreateLogGroup","logs:CreateLogStream","logs:PutLogEvents"]})}renderEnvironment(props,projectVars={}){const env=props.environment??{},vars={},containerVars=env.environmentVariables||{};for(const name of Object.keys(containerVars))vars[name]=containerVars[name];for(const name of Object.keys(projectVars))vars[name]=projectVars[name];const hasEnvironmentVars=Object.keys(vars).length>0,errors=this.buildImage.validate(env);if(errors.push(...this.validateLambdaBuildImage(this.buildImage,props)),errors.length>0)throw new(core_1()).ValidationError("Invalid CodeBuild environment: "+errors.join(`
`),this);const imagePullPrincipalType=this.isLambdaBuildImage(this.buildImage)?void 0:this.buildImage.imagePullPrincipalType===ImagePullPrincipalType.CODEBUILD?ImagePullPrincipalType.CODEBUILD:ImagePullPrincipalType.SERVICE_ROLE;if(this.buildImage.repository)if(imagePullPrincipalType===ImagePullPrincipalType.SERVICE_ROLE)this.buildImage.repository.grantPull(this);else{const statement=new(iam()).PolicyStatement({principals:[new(iam()).ServicePrincipal("codebuild.amazonaws.com")],actions:["ecr:GetDownloadUrlForLayer","ecr:BatchGetImage","ecr:BatchCheckLayerAvailability"]});statement.sid="CodeBuild",this.buildImage.repository.addToResourcePolicy(statement)}imagePullPrincipalType===ImagePullPrincipalType.SERVICE_ROLE&&this.buildImage.secretsManagerCredentials?.grantRead(this);const secret=this.buildImage.secretsManagerCredentials;return{type:this.buildImage.type,image:this.buildImage.imageId,imagePullCredentialsType:imagePullPrincipalType,registryCredential:secret?{credentialProvider:"SECRETS_MANAGER",credential:secret.secretFullArn??secret.secretName}:void 0,certificate:env.certificate?.bucket.arnForObjects(env.certificate.objectKey),privilegedMode:env.privileged||!1,fleet:this.configureFleet(env),computeType:env.computeType||this.buildImage.defaultComputeType,environmentVariables:hasEnvironmentVars?Project.serializeEnvVariables(vars,props.checkSecretsInPlainTextEnvVariables??!0,this):void 0}}renderFileSystemLocations(){return this._fileSystemLocations.length===0?void 0:this._fileSystemLocations}renderSecondarySources(){return this._secondarySources.length===0?void 0:this._secondarySources}renderSecondarySourceVersions(){return this._secondarySourceVersions.length===0?void 0:this._secondarySourceVersions}renderSecondaryArtifacts(){return this._secondaryArtifacts.length===0?void 0:this._secondaryArtifacts}configureFleet({fleet}){if(fleet){if(core_1().Token.isUnresolved(fleet.fleetArn)&&this.buildImage.type!==fleet.environmentType)throw new(core_1()).ValidationError(`The environment type of the fleet (${fleet.environmentType}) must match the environment type of the build image (${this.buildImage.type})`,this);return{fleetArn:fleet.fleetArn}}}configureVpc(props){if((props.securityGroups||props.allowAllOutbound!==void 0)&&!props.vpc)throw new(core_1()).ValidationError("Cannot configure 'securityGroup' or 'allowAllOutbound' without configuring a VPC",this);if(!props.vpc)return;if(props.securityGroups&&props.securityGroups.length>0&&props.allowAllOutbound!==void 0)throw new(core_1()).ValidationError("Configure 'allowAllOutbound' directly on the supplied SecurityGroup.",this);let securityGroups;return props.securityGroups&&props.securityGroups.length>0?securityGroups=props.securityGroups:securityGroups=[new(ec2()).SecurityGroup(this,"SecurityGroup",{vpc:props.vpc,description:"Automatic generated security group for CodeBuild "+core_1().Names.uniqueId(this),allowAllOutbound:props.allowAllOutbound})],this._connections=new(ec2()).Connections({securityGroups}),{vpcId:props.vpc.vpcId,subnets:props.vpc.selectSubnets(props.subnetSelection).subnetIds,securityGroupIds:this.connections.securityGroups.map(s=>s.securityGroupId)}}renderLoggingConfiguration(props){if(props===void 0)return;let s3Config,cloudwatchConfig;if(props.s3){const s3Logs=props.s3;s3Config={status:s3Logs.enabled??!0?"ENABLED":"DISABLED",location:`${s3Logs.bucket.bucketName}`+(s3Logs.prefix?`/${s3Logs.prefix}`:""),encryptionDisabled:s3Logs.encrypted},s3Logs.bucket?.grantWrite(this)}if(props.cloudWatch){const cloudWatchLogs=props.cloudWatch,status=cloudWatchLogs.enabled??!0?"ENABLED":"DISABLED";if(status==="ENABLED"&&!cloudWatchLogs.logGroup)throw new(core_1()).ValidationError("Specifying a LogGroup is required if CloudWatch logging for CodeBuild is enabled",this);cloudWatchLogs.logGroup?.grantWrite(this),cloudwatchConfig={status,groupName:cloudWatchLogs.logGroup?.logGroupName,streamName:cloudWatchLogs.prefix}}return{s3Logs:s3Config,cloudWatchLogs:cloudwatchConfig}}addVpcRequiredPermissions(props,project){if(!props.vpc||!this.role)return;this.role.addToPrincipalPolicy(new(iam()).PolicyStatement({resources:[`arn:${core_1().Aws.PARTITION}:ec2:${core_1().Aws.REGION}:${core_1().Aws.ACCOUNT_ID}:network-interface/*`],actions:["ec2:CreateNetworkInterfacePermission"],conditions:{StringEquals:{"ec2:Subnet":props.vpc.selectSubnets(props.subnetSelection).subnetIds.map(si=>`arn:${core_1().Aws.PARTITION}:ec2:${core_1().Aws.REGION}:${core_1().Aws.ACCOUNT_ID}:subnet/${si}`),"ec2:AuthorizedService":"codebuild.amazonaws.com"}}}));let policy=this.role[VPC_POLICY_SYM];policy||(policy=new(iam()).Policy(this,"PolicyDocument",{statements:[new(iam()).PolicyStatement({resources:["*"],actions:["ec2:CreateNetworkInterface","ec2:DescribeNetworkInterfaces","ec2:DeleteNetworkInterface","ec2:DescribeSubnets","ec2:DescribeSecurityGroups","ec2:DescribeDhcpOptions","ec2:DescribeVpcs"]})]}),this.role.attachInlinePolicy(policy),this.role[VPC_POLICY_SYM]=policy),project.node.addDependency(policy)}validateCodePipelineSettings(artifacts){const sourceType=this.source.type,artifactsType=artifacts.type;if((sourceType===source_types_1().CODEPIPELINE_SOURCE_ARTIFACTS_TYPE||artifactsType===source_types_1().CODEPIPELINE_SOURCE_ARTIFACTS_TYPE)&&sourceType!==artifactsType)throw new(core_1()).ValidationError("Both source and artifacts must be set to CodePipeline",this)}isLambdaBuildImage(buildImage){return buildImage instanceof linux_lambda_build_image_1().LinuxLambdaBuildImage||buildImage instanceof linux_arm_lambda_build_image_1().LinuxArmLambdaBuildImage}validateLambdaBuildImage(buildImage,props){if(!this.isLambdaBuildImage(buildImage))return[];const errors=[];return props.timeout&&errors.push("Cannot specify timeout for Lambda compute"),props.queuedTimeout&&errors.push("Cannot specify queuedTimeout for Lambda compute"),props.cache&&errors.push("Cannot specify cache for Lambda compute"),props.badge&&errors.push("Cannot enable badge for Lambda compute"),errors}}exports.Project=Project,_a=JSII_RTTI_SYMBOL_1,Project[_a]={fqn:"aws-cdk-lib.aws_codebuild.Project",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],Project.prototype,"enableBatchBuilds",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Project.prototype,"addSecondarySource",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Project.prototype,"addFileSystemLocation",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Project.prototype,"addSecondaryArtifact",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Project.prototype,"bindToCodePipeline",null);var ImagePullPrincipalType;(function(ImagePullPrincipalType2){ImagePullPrincipalType2.CODEBUILD="CODEBUILD",ImagePullPrincipalType2.SERVICE_ROLE="SERVICE_ROLE"})(ImagePullPrincipalType||(exports.ImagePullPrincipalType=ImagePullPrincipalType={}));var linux_arm_build_image_1=()=>{var tmp=require("./linux-arm-build-image");return linux_arm_build_image_1=()=>tmp,tmp};class LinuxBuildImage{static fromDockerRegistry(name,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_DockerImageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDockerRegistry),error}return new LinuxBuildImage({...options,imageId:name,imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE})}static fromEcrRepository(repository,tagOrDigest="latest"){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_IRepository(repository)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEcrRepository),error}return new LinuxBuildImage({imageId:repository.repositoryUriForTagOrDigest(tagOrDigest),imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE,repository})}static fromAsset(scope,id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_assets_DockerImageAssetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}const asset=new(aws_ecr_assets_1()).DockerImageAsset(scope,id,props);return new LinuxBuildImage({imageId:asset.imageUri,imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE,repository:asset.repository})}static fromCodeBuildImageId(id){return LinuxBuildImage.codeBuildImage(id)}static codeBuildImage(name){return new LinuxBuildImage({imageId:name,imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD})}constructor(props){this.type=environment_type_1().EnvironmentType.LINUX_CONTAINER,this.defaultComputeType=compute_type_1().ComputeType.SMALL,this.imageId=props.imageId,this.imagePullPrincipalType=props.imagePullPrincipalType,this.secretsManagerCredentials=props.secretsManagerCredentials,this.repository=props.repository}validate(env){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_BuildEnvironment(env)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.validate),error}const errors=[];return env.computeType&&isLambdaComputeType(env.computeType)&&errors.push("x86-64 images do not support Lambda compute types"),errors}runScriptBuildspec(entrypoint){return(0,run_script_linux_build_spec_1().runScriptLinuxBuildSpec)(entrypoint)}}exports.LinuxBuildImage=LinuxBuildImage,_b=JSII_RTTI_SYMBOL_1,LinuxBuildImage[_b]={fqn:"aws-cdk-lib.aws_codebuild.LinuxBuildImage",version:"2.188.0"},LinuxBuildImage.STANDARD_1_0=LinuxBuildImage.codeBuildImage("aws/codebuild/standard:1.0"),LinuxBuildImage.STANDARD_2_0=LinuxBuildImage.codeBuildImage("aws/codebuild/standard:2.0"),LinuxBuildImage.STANDARD_3_0=LinuxBuildImage.codeBuildImage("aws/codebuild/standard:3.0"),LinuxBuildImage.STANDARD_4_0=LinuxBuildImage.codeBuildImage("aws/codebuild/standard:4.0"),LinuxBuildImage.STANDARD_5_0=LinuxBuildImage.codeBuildImage("aws/codebuild/standard:5.0"),LinuxBuildImage.STANDARD_6_0=LinuxBuildImage.codeBuildImage("aws/codebuild/standard:6.0"),LinuxBuildImage.STANDARD_7_0=LinuxBuildImage.codeBuildImage("aws/codebuild/standard:7.0"),LinuxBuildImage.AMAZON_LINUX_2=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux2-x86_64-standard:1.0"),LinuxBuildImage.AMAZON_LINUX_2_2=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux2-x86_64-standard:2.0"),LinuxBuildImage.AMAZON_LINUX_2_3=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux2-x86_64-standard:3.0"),LinuxBuildImage.AMAZON_LINUX_2_4=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux2-x86_64-standard:4.0"),LinuxBuildImage.AMAZON_LINUX_2_5=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux2-x86_64-standard:5.0"),LinuxBuildImage.AMAZON_LINUX_2023_4=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux-x86_64-standard:4.0"),LinuxBuildImage.AMAZON_LINUX_2023_5=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux-x86_64-standard:5.0"),LinuxBuildImage.AMAZON_LINUX_2_CORETTO_8=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux2-x86_64-standard:corretto8"),LinuxBuildImage.AMAZON_LINUX_2_CORETTO_11=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux2-x86_64-standard:corretto11"),LinuxBuildImage.AMAZON_LINUX_2023_CORETTO_8=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux-x86_64-standard:corretto8"),LinuxBuildImage.AMAZON_LINUX_2023_CORETTO_11=LinuxBuildImage.codeBuildImage("aws/codebuild/amazonlinux-x86_64-standard:corretto11"),LinuxBuildImage.AMAZON_LINUX_2_ARM=linux_arm_build_image_1().LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_1_0,LinuxBuildImage.AMAZON_LINUX_2_ARM_2=linux_arm_build_image_1().LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_2_0,LinuxBuildImage.AMAZON_LINUX_2_ARM_3=linux_arm_build_image_1().LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_3_0,LinuxBuildImage.UBUNTU_14_04_BASE=LinuxBuildImage.codeBuildImage("aws/codebuild/ubuntu-base:14.04"),LinuxBuildImage.UBUNTU_14_04_ANDROID_JAVA8_24_4_1=LinuxBuildImage.codeBuildImage("aws/codebuild/android-java-8:24.4.1"),LinuxBuildImage.UBUNTU_14_04_ANDROID_JAVA8_26_1_1=LinuxBuildImage.codeBuildImage("aws/codebuild/android-java-8:26.1.1"),LinuxBuildImage.UBUNTU_14_04_DOCKER_17_09_0=LinuxBuildImage.codeBuildImage("aws/codebuild/docker:17.09.0"),LinuxBuildImage.UBUNTU_14_04_DOCKER_18_09_0=LinuxBuildImage.codeBuildImage("aws/codebuild/docker:18.09.0"),LinuxBuildImage.UBUNTU_14_04_GOLANG_1_10=LinuxBuildImage.codeBuildImage("aws/codebuild/golang:1.10"),LinuxBuildImage.UBUNTU_14_04_GOLANG_1_11=LinuxBuildImage.codeBuildImage("aws/codebuild/golang:1.11"),LinuxBuildImage.UBUNTU_14_04_OPEN_JDK_8=LinuxBuildImage.codeBuildImage("aws/codebuild/java:openjdk-8"),LinuxBuildImage.UBUNTU_14_04_OPEN_JDK_9=LinuxBuildImage.codeBuildImage("aws/codebuild/java:openjdk-9"),LinuxBuildImage.UBUNTU_14_04_OPEN_JDK_11=LinuxBuildImage.codeBuildImage("aws/codebuild/java:openjdk-11"),LinuxBuildImage.UBUNTU_14_04_NODEJS_10_14_1=LinuxBuildImage.codeBuildImage("aws/codebuild/nodejs:10.14.1"),LinuxBuildImage.UBUNTU_14_04_NODEJS_10_1_0=LinuxBuildImage.codeBuildImage("aws/codebuild/nodejs:10.1.0"),LinuxBuildImage.UBUNTU_14_04_NODEJS_8_11_0=LinuxBuildImage.codeBuildImage("aws/codebuild/nodejs:8.11.0"),LinuxBuildImage.UBUNTU_14_04_NODEJS_6_3_1=LinuxBuildImage.codeBuildImage("aws/codebuild/nodejs:6.3.1"),LinuxBuildImage.UBUNTU_14_04_PHP_5_6=LinuxBuildImage.codeBuildImage("aws/codebuild/php:5.6"),LinuxBuildImage.UBUNTU_14_04_PHP_7_0=LinuxBuildImage.codeBuildImage("aws/codebuild/php:7.0"),LinuxBuildImage.UBUNTU_14_04_PHP_7_1=LinuxBuildImage.codeBuildImage("aws/codebuild/php:7.1"),LinuxBuildImage.UBUNTU_14_04_PYTHON_3_7_1=LinuxBuildImage.codeBuildImage("aws/codebuild/python:3.7.1"),LinuxBuildImage.UBUNTU_14_04_PYTHON_3_6_5=LinuxBuildImage.codeBuildImage("aws/codebuild/python:3.6.5"),LinuxBuildImage.UBUNTU_14_04_PYTHON_3_5_2=LinuxBuildImage.codeBuildImage("aws/codebuild/python:3.5.2"),LinuxBuildImage.UBUNTU_14_04_PYTHON_3_4_5=LinuxBuildImage.codeBuildImage("aws/codebuild/python:3.4.5"),LinuxBuildImage.UBUNTU_14_04_PYTHON_3_3_6=LinuxBuildImage.codeBuildImage("aws/codebuild/python:3.3.6"),LinuxBuildImage.UBUNTU_14_04_PYTHON_2_7_12=LinuxBuildImage.codeBuildImage("aws/codebuild/python:2.7.12"),LinuxBuildImage.UBUNTU_14_04_RUBY_2_5_3=LinuxBuildImage.codeBuildImage("aws/codebuild/ruby:2.5.3"),LinuxBuildImage.UBUNTU_14_04_RUBY_2_5_1=LinuxBuildImage.codeBuildImage("aws/codebuild/ruby:2.5.1"),LinuxBuildImage.UBUNTU_14_04_RUBY_2_3_1=LinuxBuildImage.codeBuildImage("aws/codebuild/ruby:2.3.1"),LinuxBuildImage.UBUNTU_14_04_RUBY_2_2_5=LinuxBuildImage.codeBuildImage("aws/codebuild/ruby:2.2.5"),LinuxBuildImage.UBUNTU_14_04_DOTNET_CORE_1_1=LinuxBuildImage.codeBuildImage("aws/codebuild/dot-net:core-1"),LinuxBuildImage.UBUNTU_14_04_DOTNET_CORE_2_0=LinuxBuildImage.codeBuildImage("aws/codebuild/dot-net:core-2.0"),LinuxBuildImage.UBUNTU_14_04_DOTNET_CORE_2_1=LinuxBuildImage.codeBuildImage("aws/codebuild/dot-net:core-2.1");var WindowsImageType;(function(WindowsImageType2){WindowsImageType2.STANDARD="WINDOWS_CONTAINER",WindowsImageType2.SERVER_2019="WINDOWS_SERVER_2019_CONTAINER",WindowsImageType2.SERVER_2022="WINDOWS_SERVER_2022_CONTAINER"})(WindowsImageType||(exports.WindowsImageType=WindowsImageType={}));class WindowsBuildImage{static fromDockerRegistry(name,options={},imageType=WindowsImageType.STANDARD){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_DockerImageOptions(options),jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_WindowsImageType(imageType)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDockerRegistry),error}return new WindowsBuildImage({...options,imageId:name,imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE,imageType})}static fromEcrRepository(repository,tagOrDigest="latest",imageType=WindowsImageType.STANDARD){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_IRepository(repository),jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_WindowsImageType(imageType)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEcrRepository),error}return new WindowsBuildImage({imageId:repository.repositoryUriForTagOrDigest(tagOrDigest),imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE,imageType,repository})}static fromAsset(scope,id,props,imageType=WindowsImageType.STANDARD){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_assets_DockerImageAssetProps(props),jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_WindowsImageType(imageType)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}const asset=new(aws_ecr_assets_1()).DockerImageAsset(scope,id,props);return new WindowsBuildImage({imageId:asset.imageUri,imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE,imageType,repository:asset.repository})}constructor(props){this.defaultComputeType=compute_type_1().ComputeType.MEDIUM,this.type=(props.imageType??WindowsImageType.STANDARD).toString(),this.imageId=props.imageId,this.imagePullPrincipalType=props.imagePullPrincipalType,this.secretsManagerCredentials=props.secretsManagerCredentials,this.repository=props.repository}validate(buildEnvironment){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_BuildEnvironment(buildEnvironment)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.validate),error}const errors=[];buildEnvironment.privileged&&errors.push("Windows images do not support privileged mode"),buildEnvironment.computeType&&isLambdaComputeType(buildEnvironment.computeType)&&errors.push("Windows images do not support Lambda compute types");const unsupportedComputeTypes=[compute_type_1().ComputeType.SMALL,compute_type_1().ComputeType.X_LARGE,compute_type_1().ComputeType.X2_LARGE];return buildEnvironment.computeType!==void 0&&unsupportedComputeTypes.includes(buildEnvironment.computeType)&&errors.push(`Windows images do not support the '${buildEnvironment.computeType}' compute type`),!buildEnvironment.fleet&&this.type===WindowsImageType.SERVER_2022&&errors.push("Windows Server 2022 images must be used with a fleet"),errors}runScriptBuildspec(entrypoint){return build_spec_1().BuildSpec.fromObject({version:"0.2",phases:{pre_build:{commands:[]},build:{commands:["Set-Variable -Name TEMPDIR -Value (New-TemporaryFile).DirectoryName",`aws s3 cp s3://$env:${run_script_linux_build_spec_1().S3_BUCKET_ENV}/$env:${run_script_linux_build_spec_1().S3_KEY_ENV} $TEMPDIR\\scripts.zip`,"New-Item -ItemType Directory -Path $TEMPDIR\\scriptdir","Expand-Archive -Path $TEMPDIR/scripts.zip -DestinationPath $TEMPDIR\\scriptdir",'$env:SCRIPT_DIR = "$TEMPDIR\\scriptdir"',`& $TEMPDIR\\scriptdir\\${entrypoint}`]}}})}}exports.WindowsBuildImage=WindowsBuildImage,_c=JSII_RTTI_SYMBOL_1,WindowsBuildImage[_c]={fqn:"aws-cdk-lib.aws_codebuild.WindowsBuildImage",version:"2.188.0"},WindowsBuildImage.WIN_SERVER_CORE_2016_BASE=new WindowsBuildImage({imageId:"aws/codebuild/windows-base:1.0",imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD}),WindowsBuildImage.WINDOWS_BASE_2_0=new WindowsBuildImage({imageId:"aws/codebuild/windows-base:2.0",imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD}),WindowsBuildImage.WIN_SERVER_CORE_2019_BASE=new WindowsBuildImage({imageId:"aws/codebuild/windows-base:2019-1.0",imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD,imageType:WindowsImageType.SERVER_2019}),WindowsBuildImage.WIN_SERVER_CORE_2019_BASE_2_0=new WindowsBuildImage({imageId:"aws/codebuild/windows-base:2019-2.0",imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD,imageType:WindowsImageType.SERVER_2019}),WindowsBuildImage.WIN_SERVER_CORE_2019_BASE_3_0=new WindowsBuildImage({imageId:"aws/codebuild/windows-base:2019-3.0",imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD,imageType:WindowsImageType.SERVER_2019}),WindowsBuildImage.WIN_SERVER_CORE_2022_BASE_3_0=new WindowsBuildImage({imageId:"aws/codebuild/windows-base:2022-1.0",imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD,imageType:WindowsImageType.SERVER_2022});class MacBuildImage{static fromDockerRegistry(name,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_DockerImageOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDockerRegistry),error}return new MacBuildImage({...options,imageId:name,imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE})}static fromEcrRepository(repository,tagOrDigest="latest"){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_IRepository(repository)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEcrRepository),error}return new MacBuildImage({imageId:repository.repositoryUriForTagOrDigest(tagOrDigest),imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE,repository})}static fromAsset(scope,id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_assets_DockerImageAssetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}const asset=new(aws_ecr_assets_1()).DockerImageAsset(scope,id,props);return new MacBuildImage({imageId:asset.imageUri,imagePullPrincipalType:ImagePullPrincipalType.SERVICE_ROLE,repository:asset.repository})}constructor(props){this.type=environment_type_1().EnvironmentType.MAC_ARM,this.defaultComputeType=compute_type_1().ComputeType.MEDIUM,this.imageId=props.imageId,this.imagePullPrincipalType=props.imagePullPrincipalType,this.secretsManagerCredentials=props.secretsManagerCredentials,this.repository=props.repository}validate(buildEnvironment){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_BuildEnvironment(buildEnvironment)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.validate),error}const errors=[];return buildEnvironment.computeType&&isLambdaComputeType(buildEnvironment.computeType)&&errors.push("Mac images do not support Lambda compute types"),buildEnvironment.fleet||errors.push("Mac images must be used with a fleet"),errors}runScriptBuildspec(entrypoint){return(0,run_script_linux_build_spec_1().runScriptLinuxBuildSpec)(entrypoint)}}exports.MacBuildImage=MacBuildImage,_d=JSII_RTTI_SYMBOL_1,MacBuildImage[_d]={fqn:"aws-cdk-lib.aws_codebuild.MacBuildImage",version:"2.188.0"},MacBuildImage.BASE_14=new MacBuildImage({imageId:"aws/codebuild/macos-arm-base:14",imagePullPrincipalType:ImagePullPrincipalType.CODEBUILD});var BuildEnvironmentVariableType;(function(BuildEnvironmentVariableType2){BuildEnvironmentVariableType2.PLAINTEXT="PLAINTEXT",BuildEnvironmentVariableType2.PARAMETER_STORE="PARAMETER_STORE",BuildEnvironmentVariableType2.SECRETS_MANAGER="SECRETS_MANAGER"})(BuildEnvironmentVariableType||(exports.BuildEnvironmentVariableType=BuildEnvironmentVariableType={}));var ProjectVisibility;(function(ProjectVisibility2){ProjectVisibility2.PUBLIC_READ="PUBLIC_READ",ProjectVisibility2.PRIVATE="PRIVATE"})(ProjectVisibility||(exports.ProjectVisibility=ProjectVisibility={}));var ProjectNotificationEvents;(function(ProjectNotificationEvents2){ProjectNotificationEvents2.BUILD_FAILED="codebuild-project-build-state-failed",ProjectNotificationEvents2.BUILD_SUCCEEDED="codebuild-project-build-state-succeeded",ProjectNotificationEvents2.BUILD_IN_PROGRESS="codebuild-project-build-state-in-progress",ProjectNotificationEvents2.BUILD_STOPPED="codebuild-project-build-state-stopped",ProjectNotificationEvents2.BUILD_PHASE_FAILED="codebuild-project-build-phase-failure",ProjectNotificationEvents2.BUILD_PHASE_SUCCEEDED="codebuild-project-build-phase-success"})(ProjectNotificationEvents||(exports.ProjectNotificationEvents=ProjectNotificationEvents={}));function isBindableBuildImage(x){return typeof x=="object"&&!!x&&!!x.bind}function isLambdaComputeType(computeType){return Object.values(compute_type_1().ComputeType).filter(value=>value.startsWith("BUILD_LAMBDA")).includes(computeType)}
