"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FleetComputeType=exports.Fleet=exports.MachineType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var codebuild_generated_1=()=>{var tmp=require("./codebuild.generated");return codebuild_generated_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},MachineType;(function(MachineType2){MachineType2.GENERAL="GENERAL",MachineType2.NVME="NVME"})(MachineType||(exports.MachineType=MachineType={}));class Fleet extends core_1().Resource{static fromFleetArn(scope,id,fleetArn){class Import extends core_1().Resource{constructor(){super(...arguments),this.fleetName=core_1().Arn.split(fleetArn,core_1().ArnFormat.SLASH_RESOURCE_NAME).resourceName.split(":")[0],this.fleetArn=fleetArn}get computeType(){throw new(core_1()).UnscopedValidationError("Cannot retrieve computeType property from an imported Fleet")}get environmentType(){throw new(core_1()).UnscopedValidationError("Cannot retrieve environmentType property from an imported Fleet")}get computeConfiguration(){throw new(core_1()).UnscopedValidationError("Cannot retrieve computeConfiguration property from an imported Fleet")}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id,{...props,physicalName:props.fleetName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codebuild_FleetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Fleet),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),props.fleetName&&!core_1().Token.isUnresolved(props.fleetName)){if(props.fleetName.length<2)throw new(core_1()).ValidationError(`Fleet name can not be shorter than 2 characters but has ${props.fleetName.length} characters.`,this);if(props.fleetName.length>128)throw new(core_1()).ValidationError(`Fleet name can not be longer than 128 characters but has ${props.fleetName.length} characters.`,this)}if((props.baseCapacity??1)<1)throw new(core_1()).ValidationError("baseCapacity must be greater than or equal to 1",this);if(props.computeType===FleetComputeType.ATTRIBUTE_BASED&&(!props.computeConfiguration||Object.keys(props.computeConfiguration).length===0))throw new(core_1()).ValidationError('At least one compute configuration criteria must be specified if computeType is "ATTRIBUTE_BASED"',this);if(props.computeConfiguration&&props.computeType!==FleetComputeType.ATTRIBUTE_BASED)throw new(core_1()).ValidationError(`'computeConfiguration' can only be specified if 'computeType' is 'ATTRIBUTE_BASED', got: ${props.computeType}`,this);const computeConfig=props.computeConfiguration,diskGiB=computeConfig?.disk?.toGibibytes()??0,memoryGiB=computeConfig?.memory?.toGibibytes()??0,vCpu=computeConfig?.vCpu??0;this.validatePositiveInteger(diskGiB,"disk size"),this.validatePositiveInteger(memoryGiB,"memory size"),this.validatePositiveInteger(vCpu,"vCPU count");const resource=new(codebuild_generated_1()).CfnFleet(this,"Resource",{name:props.fleetName,baseCapacity:props.baseCapacity,computeType:props.computeType,environmentType:props.environmentType,computeConfiguration:props.computeConfiguration?{disk:diskGiB,machineType:props.computeConfiguration.machineType,memory:memoryGiB,vCpu}:void 0});this.fleetArn=this.getResourceArnAttribute(resource.attrArn,{service:"codebuild",resource:"fleet",resourceName:this.physicalName,arnFormat:core_1().ArnFormat.SLASH_RESOURCE_NAME}),this.fleetName=this.getResourceNameAttribute(resource.ref),this.computeType=props.computeType,this.environmentType=props.environmentType}validatePositiveInteger(value,fieldName){if(!core_1().Token.isUnresolved(value)&&(value<0||!Number.isInteger(value)))throw new(core_1()).ValidationError(`${fieldName} must be a positive integer, got: ${value}`,this)}}exports.Fleet=Fleet,_a=JSII_RTTI_SYMBOL_1,Fleet[_a]={fqn:"aws-cdk-lib.aws_codebuild.Fleet",version:"2.188.0"};var FleetComputeType;(function(FleetComputeType2){FleetComputeType2.SMALL="BUILD_GENERAL1_SMALL",FleetComputeType2.MEDIUM="BUILD_GENERAL1_MEDIUM",FleetComputeType2.LARGE="BUILD_GENERAL1_LARGE",FleetComputeType2.X_LARGE="BUILD_GENERAL1_XLARGE",FleetComputeType2.X2_LARGE="BUILD_GENERAL1_2XLARGE",FleetComputeType2.ATTRIBUTE_BASED="ATTRIBUTE_BASED_COMPUTE"})(FleetComputeType||(exports.FleetComputeType=FleetComputeType={}));
