"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Alarm=exports.TreatMissingData=exports.ComparisonOperator=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var alarm_base_1=()=>{var tmp=require("./alarm-base");return alarm_base_1=()=>tmp,tmp},cloudwatch_generated_1=()=>{var tmp=require("./cloudwatch.generated");return cloudwatch_generated_1=()=>tmp,tmp},metric_util_1=()=>{var tmp=require("./private/metric-util");return metric_util_1=()=>tmp,tmp},object_1=()=>{var tmp=require("./private/object");return object_1=()=>tmp,tmp},rendering_1=()=>{var tmp=require("./private/rendering");return rendering_1=()=>tmp,tmp},statistic_1=()=>{var tmp=require("./private/statistic");return statistic_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},ComparisonOperator;(function(ComparisonOperator2){ComparisonOperator2.GREATER_THAN_OR_EQUAL_TO_THRESHOLD="GreaterThanOrEqualToThreshold",ComparisonOperator2.GREATER_THAN_THRESHOLD="GreaterThanThreshold",ComparisonOperator2.LESS_THAN_THRESHOLD="LessThanThreshold",ComparisonOperator2.LESS_THAN_OR_EQUAL_TO_THRESHOLD="LessThanOrEqualToThreshold",ComparisonOperator2.LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD="LessThanLowerOrGreaterThanUpperThreshold",ComparisonOperator2.GREATER_THAN_UPPER_THRESHOLD="GreaterThanUpperThreshold",ComparisonOperator2.LESS_THAN_LOWER_THRESHOLD="LessThanLowerThreshold"})(ComparisonOperator||(exports.ComparisonOperator=ComparisonOperator={}));const OPERATOR_SYMBOLS={GreaterThanOrEqualToThreshold:">=",GreaterThanThreshold:">",LessThanThreshold:"<",LessThanOrEqualToThreshold:"<="};var TreatMissingData;(function(TreatMissingData2){TreatMissingData2.BREACHING="breaching",TreatMissingData2.NOT_BREACHING="notBreaching",TreatMissingData2.IGNORE="ignore",TreatMissingData2.MISSING="missing"})(TreatMissingData||(exports.TreatMissingData=TreatMissingData={}));class Alarm extends alarm_base_1().AlarmBase{static fromAlarmName(scope,id,alarmName){const stack=core_1().Stack.of(scope);return this.fromAlarmArn(scope,id,stack.formatArn({service:"cloudwatch",resource:"alarm",resourceName:alarmName,arnFormat:core_1().ArnFormat.COLON_RESOURCE_NAME}))}static fromAlarmArn(scope,id,alarmArn){class Import extends alarm_base_1().AlarmBase{constructor(){super(...arguments),this.alarmArn=alarmArn,this.alarmName=core_1().Stack.of(scope).splitArn(alarmArn,core_1().ArnFormat.COLON_RESOURCE_NAME).resourceName}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id,{physicalName:props.alarmName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_AlarmProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Alarm),error}(0,metadata_resource_1().addConstructMetadata)(this,props);const comparisonOperator=props.comparisonOperator||ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,metricProps=this.renderMetric(props.metric);props.period&&(metricProps.period=props.period.toSeconds()),props.statistic&&Object.assign(metricProps,{statistic:renderIfSimpleStatistic(props.statistic),extendedStatistic:renderIfExtendedStatistic(props.statistic)});const alarm=new(cloudwatch_generated_1()).CfnAlarm(this,"Resource",{alarmDescription:props.alarmDescription,alarmName:this.physicalName,comparisonOperator,threshold:props.threshold,datapointsToAlarm:props.datapointsToAlarm,evaluateLowSampleCountPercentile:props.evaluateLowSampleCountPercentile,evaluationPeriods:props.evaluationPeriods,treatMissingData:props.treatMissingData,actionsEnabled:props.actionsEnabled,alarmActions:core_1().Lazy.list({produce:()=>this.alarmActionArns}),insufficientDataActions:core_1().Lazy.list({produce:()=>this.insufficientDataActionArns}),okActions:core_1().Lazy.list({produce:()=>this.okActionArns}),...metricProps});this.alarmArn=this.getResourceArnAttribute(alarm.attrArn,{service:"cloudwatch",resource:"alarm",resourceName:this.physicalName,arnFormat:core_1().ArnFormat.COLON_RESOURCE_NAME}),this.alarmName=this.getResourceNameAttribute(alarm.ref),this.metric=props.metric;const datapoints=props.datapointsToAlarm||props.evaluationPeriods;this.annotation={label:`${this.metric} ${OPERATOR_SYMBOLS[comparisonOperator]} ${props.threshold} for ${datapoints} datapoints within ${describePeriod(props.evaluationPeriods*(0,metric_util_1().metricPeriod)(props.metric).toSeconds())}`,value:props.threshold};for(const[i,message]of Object.entries(this.metric.warningsV2??{}))core_1().Annotations.of(this).addWarningV2(i,message)}toAnnotation(){return this.annotation}addAlarmAction(...actions){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_IAlarmAction(actions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAlarmAction),error}this.alarmActionArns===void 0&&(this.alarmActionArns=[]),this.alarmActionArns.push(...actions.map(a=>this.validateActionArn(a.bind(this,this).alarmActionArn)))}validateActionArn(actionArn){if(/arn:aws[a-z0-9-]*:automate:[a-z|\d|-]+:ec2:[a-z]+/.test(actionArn)){const metricConfig=this.metric.toMetricConfig();if(metricConfig.metricStat?.dimensions?.length!=1||!metricConfig.metricStat?.dimensions?.some(dimension=>dimension.name==="InstanceId"))throw new(core_1()).ValidationError(`EC2 alarm actions requires an EC2 Per-Instance Metric. (${JSON.stringify(metricConfig)} does not have an 'InstanceId' dimension)`,this)}return actionArn}renderMetric(metric){const self=this;return(0,metric_util_1().dispatchMetric)(metric,{withStat(stat,conf){return self.validateMetricStat(stat,metric),conf.renderingProperties?.label==null&&!self.requiresAccountId(stat)?(0,object_1().dropUndefined)({dimensions:stat.dimensions,namespace:stat.namespace,metricName:stat.metricName,period:stat.period?.toSeconds(),statistic:renderIfSimpleStatistic(stat.statistic),extendedStatistic:renderIfExtendedStatistic(stat.statistic),unit:stat.unitFilter}):{metrics:[{metricStat:{metric:{metricName:stat.metricName,namespace:stat.namespace,dimensions:stat.dimensions},period:stat.period.toSeconds(),stat:stat.statistic,unit:stat.unitFilter},id:"m1",accountId:self.requiresAccountId(stat)?stat.account:void 0,label:conf.renderingProperties?.label,returnData:!0}]}},withExpression(){const mset=new(rendering_1()).MetricSet;mset.addTopLevel(!0,metric);let eid=0;function uniqueMetricId(){return`expr_${++eid}`}return{metrics:mset.entries.map(entry=>(0,metric_util_1().dispatchMetric)(entry.metric,{withStat(stat,conf){return self.validateMetricStat(stat,entry.metric),{metricStat:{metric:{metricName:stat.metricName,namespace:stat.namespace,dimensions:stat.dimensions},period:stat.period.toSeconds(),stat:stat.statistic,unit:stat.unitFilter},id:entry.id||uniqueMetricId(),accountId:self.requiresAccountId(stat)?stat.account:void 0,label:conf.renderingProperties?.label,returnData:entry.tag?void 0:!1}},withExpression(expr,conf){const hasSubmetrics=mathExprHasSubmetrics(expr);return hasSubmetrics&&assertSubmetricsCount(self,expr),self.validateMetricExpression(expr),{expression:expr.expression,id:entry.id||uniqueMetricId(),label:conf.renderingProperties?.label,period:hasSubmetrics?void 0:expr.period,returnData:entry.tag?void 0:!1}}}))}}})}validateMetricStat(stat,metric){const stack=core_1().Stack.of(this);if(definitelyDifferent(stat.region,stack.region))throw new(core_1()).ValidationError(`Cannot create an Alarm in region '${stack.region}' based on metric '${metric}' in '${stat.region}'`,this)}validateMetricExpression(expr){if(expr.searchAccount!==void 0||expr.searchRegion!==void 0)throw new(core_1()).ValidationError("Cannot create an Alarm based on a MathExpression which specifies a searchAccount or searchRegion",this)}requiresAccountId(stat){const stackAccount=core_1().Stack.of(this).account;return stat.account===void 0?!1:stackAccount!==stat.account}}exports.Alarm=Alarm,_a=JSII_RTTI_SYMBOL_1,Alarm[_a]={fqn:"aws-cdk-lib.aws_cloudwatch.Alarm",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],Alarm.prototype,"toAnnotation",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Alarm.prototype,"addAlarmAction",null);function definitelyDifferent(x,y){return x&&!core_1().Token.isUnresolved(y)&&x!==y}function describePeriod(seconds){return seconds===60?"1 minute":seconds===1?"1 second":seconds>60?seconds/60+" minutes":seconds+" seconds"}function renderIfSimpleStatistic(statistic){if(statistic===void 0)return;const parsed=(0,statistic_1().parseStatistic)(statistic);if(parsed.type==="simple")return(0,statistic_1().normalizeStatistic)(parsed)}function renderIfExtendedStatistic(statistic){if(statistic===void 0)return;const parsed=(0,statistic_1().parseStatistic)(statistic);if(parsed.type!=="simple")return parsed.type==="single"||parsed.type==="pair"?(0,statistic_1().normalizeStatistic)(parsed):parsed.statistic}function mathExprHasSubmetrics(expr){return Object.keys(expr.usingMetrics).length>0}function assertSubmetricsCount(scope,expr){if(Object.keys(expr.usingMetrics).length>10)throw new(core_1()).ValidationError("Alarms on math expressions cannot contain more than 10 individual metrics",scope)}
