"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DataResourceType=exports.ManagementEventSources=exports.Trail=exports.InsightType=exports.ReadWriteType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var cloudtrail_generated_1=()=>{var tmp=require("./cloudtrail.generated");return cloudtrail_generated_1=()=>tmp,tmp},events=()=>{var tmp=require("../../aws-events");return events=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},logs=()=>{var tmp=require("../../aws-logs");return logs=()=>tmp,tmp},s3=()=>{var tmp=require("../../aws-s3");return s3=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},ReadWriteType;(function(ReadWriteType2){ReadWriteType2.READ_ONLY="ReadOnly",ReadWriteType2.WRITE_ONLY="WriteOnly",ReadWriteType2.ALL="All",ReadWriteType2.NONE="None"})(ReadWriteType||(exports.ReadWriteType=ReadWriteType={}));class InsightType{constructor(value){this.value=value}}exports.InsightType=InsightType,_a=JSII_RTTI_SYMBOL_1,InsightType[_a]={fqn:"aws-cdk-lib.aws_cloudtrail.InsightType",version:"2.188.0"},InsightType.API_CALL_RATE=new InsightType("ApiCallRateInsight"),InsightType.API_ERROR_RATE=new InsightType("ApiErrorRateInsight");class Trail extends core_1().Resource{static onEvent(scope,id,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_events_OnEventOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.onEvent),error}const rule=new(events()).Rule(scope,id,options);return rule.addTarget(options.target),rule.addEventPattern({detailType:["AWS API Call via CloudTrail"]}),rule}constructor(scope,id,props={}){super(scope,id,{physicalName:props.trailName}),this.eventSelectors=[];try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudtrail_TrailProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Trail),error}(0,metadata_resource_1().addConstructMetadata)(this,props);const cloudTrailPrincipal=new(iam()).ServicePrincipal("cloudtrail.amazonaws.com");this.s3bucket=props.bucket||new(s3()).Bucket(this,"S3",{enforceSSL:!0}),this.s3bucket.addToResourcePolicy(new(iam()).PolicyStatement({resources:[this.s3bucket.bucketArn],actions:["s3:GetBucketAcl"],principals:[cloudTrailPrincipal]})),this.s3bucket.addToResourcePolicy(new(iam()).PolicyStatement({resources:[this.s3bucket.arnForObjects(`${props.s3KeyPrefix?`${props.s3KeyPrefix}/`:""}AWSLogs/${core_1().Stack.of(this).account}/*`)],actions:["s3:PutObject"],principals:[cloudTrailPrincipal],conditions:{StringEquals:{"s3:x-amz-acl":"bucket-owner-full-control"}}})),props.isOrganizationTrail&&this.s3bucket.addToResourcePolicy(new(iam()).PolicyStatement({resources:[this.s3bucket.arnForObjects(`AWSLogs/${props.orgId}/*`)],actions:["s3:PutObject"],principals:[cloudTrailPrincipal],conditions:{StringEquals:{"s3:x-amz-acl":"bucket-owner-full-control","aws:SourceArn":`arn:${this.stack.partition}:cloudtrail:${this.s3bucket.stack.region}:${this.s3bucket.stack.account}:trail/${props.trailName}`}}})),this.topic=props.snsTopic,this.topic&&this.topic.grantPublish(cloudTrailPrincipal);let logsRole;if(props.sendToCloudWatchLogs&&(props.cloudWatchLogGroup?this.logGroup=props.cloudWatchLogGroup:this.logGroup=new(logs()).LogGroup(this,"LogGroup",{retention:props.cloudWatchLogsRetention??logs().RetentionDays.ONE_YEAR}),logsRole=new(iam()).Role(this,"LogsRole",{assumedBy:cloudTrailPrincipal}),logsRole.addToPrincipalPolicy(new(iam()).PolicyStatement({actions:["logs:PutLogEvents","logs:CreateLogStream"],resources:[this.logGroup.logGroupArn]}))),this.managementEvents=props.managementEvents,this.managementEvents&&this.managementEvents!==ReadWriteType.NONE&&this.eventSelectors.push({includeManagementEvents:!0,readWriteType:props.managementEvents}),this.node.addValidation({validate:()=>this.validateEventSelectors()}),props.kmsKey&&props.encryptionKey)throw new(core_1()).ValidationError("Both kmsKey and encryptionKey must not be specified. Use only encryptionKey",this);props.insightTypes&&(this.insightTypeValues=props.insightTypes.map(function(t){return{insightType:t.value}}));const trail=new(cloudtrail_generated_1()).CfnTrail(this,"Resource",{isLogging:!0,enableLogFileValidation:props.enableFileValidation==null?!0:props.enableFileValidation,isMultiRegionTrail:props.isMultiRegionTrail==null?!0:props.isMultiRegionTrail,includeGlobalServiceEvents:props.includeGlobalServiceEvents==null?!0:props.includeGlobalServiceEvents,trailName:this.physicalName,kmsKeyId:props.encryptionKey?.keyArn??props.kmsKey?.keyArn,s3BucketName:this.s3bucket.bucketName,s3KeyPrefix:props.s3KeyPrefix,cloudWatchLogsLogGroupArn:this.logGroup?.logGroupArn,cloudWatchLogsRoleArn:logsRole?.roleArn,snsTopicName:this.topic?.topicName,eventSelectors:this.eventSelectors,isOrganizationTrail:props.isOrganizationTrail,insightSelectors:this.insightTypeValues});this.trailArn=this.getResourceArnAttribute(trail.attrArn,{service:"cloudtrail",resource:"trail",resourceName:this.physicalName}),this.trailSnsTopicArn=trail.attrSnsTopicArn,this.s3bucket.policy&&trail.node.addDependency(this.s3bucket.policy),logsRole!==void 0&&trail.node.addDependency(logsRole)}addEventSelector(dataResourceType,dataResourceValues,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudtrail_DataResourceType(dataResourceType),jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudtrail_AddEventSelectorOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addEventSelector),error}if(dataResourceValues.length>250)throw new(core_1()).ValidationError("A maximum of 250 data elements can be in one event selector",this);if(this.eventSelectors.length>5)throw new(core_1()).ValidationError("A maximum of 5 event selectors are supported per trail.",this);let includeAllManagementEvents;this.managementEvents===ReadWriteType.NONE&&(includeAllManagementEvents=!1),this.eventSelectors.push({dataResources:[{type:dataResourceType,values:dataResourceValues}],includeManagementEvents:options.includeManagementEvents??includeAllManagementEvents,excludeManagementEventSources:options.excludeManagementEventSources,readWriteType:options.readWriteType})}addLambdaEventSelector(handlers,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudtrail_AddEventSelectorOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addLambdaEventSelector),error}if(handlers.length===0)return;const dataResourceValues=handlers.map(h=>h.functionArn);return this.addEventSelector(DataResourceType.LAMBDA_FUNCTION,dataResourceValues,options)}logAllLambdaDataEvents(options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudtrail_AddEventSelectorOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.logAllLambdaDataEvents),error}return this.addEventSelector(DataResourceType.LAMBDA_FUNCTION,[`arn:${this.stack.partition}:lambda`],options)}addS3EventSelector(s3Selector,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudtrail_AddEventSelectorOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addS3EventSelector),error}if(s3Selector.length===0)return;const dataResourceValues=s3Selector.map(sel=>`${sel.bucket.bucketArn}/${sel.objectPrefix??""}`);return this.addEventSelector(DataResourceType.S3_OBJECT,dataResourceValues,options)}logAllS3DataEvents(options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudtrail_AddEventSelectorOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.logAllS3DataEvents),error}return this.addEventSelector(DataResourceType.S3_OBJECT,[`arn:${this.stack.partition}:s3:::`],options)}onCloudTrailEvent(id,options={}){return Trail.onEvent(this,id,options)}validateEventSelectors(){const errors=[];return this.managementEvents===ReadWriteType.NONE&&this.eventSelectors.length===0&&errors.push("At least one event selector must be added when management event recording is set to None"),errors}}exports.Trail=Trail,_b=JSII_RTTI_SYMBOL_1,Trail[_b]={fqn:"aws-cdk-lib.aws_cloudtrail.Trail",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],Trail.prototype,"addEventSelector",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Trail.prototype,"addLambdaEventSelector",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Trail.prototype,"logAllLambdaDataEvents",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Trail.prototype,"addS3EventSelector",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Trail.prototype,"logAllS3DataEvents",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],Trail.prototype,"onCloudTrailEvent",null);var ManagementEventSources;(function(ManagementEventSources2){ManagementEventSources2.KMS="kms.amazonaws.com",ManagementEventSources2.RDS_DATA_API="rdsdata.amazonaws.com"})(ManagementEventSources||(exports.ManagementEventSources=ManagementEventSources={}));var DataResourceType;(function(DataResourceType2){DataResourceType2.LAMBDA_FUNCTION="AWS::Lambda::Function",DataResourceType2.S3_OBJECT="AWS::S3::Object"})(DataResourceType||(exports.DataResourceType=DataResourceType={}));
