"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.CacheBehavior=void 0;var iam=()=>{var tmp=require("../../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},cache_policy_1=()=>{var tmp=require("../cache-policy");return cache_policy_1=()=>tmp,tmp},distribution_1=()=>{var tmp=require("../distribution");return distribution_1=()=>tmp,tmp};class CacheBehavior{constructor(originId,props){if(this.props=props,this.originId=originId,props.enableGrpc){if(props.allowedMethods!==distribution_1().AllowedMethods.ALLOW_ALL)throw new(core_1()).UnscopedValidationError("'allowedMethods' can only be AllowedMethods.ALLOW_ALL if 'enableGrpc' is true");if(props.edgeLambdas!==void 0&&props.edgeLambdas.length>0)throw new(core_1()).UnscopedValidationError("'edgeLambdas' cannot be specified if 'enableGrpc' is true")}this.validateEdgeLambdas(props.edgeLambdas),this.grantEdgeLambdaFunctionExecutionRole(props.edgeLambdas)}_renderBehavior(){return{pathPattern:this.props.pathPattern,targetOriginId:this.originId,allowedMethods:this.props.allowedMethods?.methods,cachedMethods:this.props.cachedMethods?.methods,cachePolicyId:(this.props.cachePolicy??cache_policy_1().CachePolicy.CACHING_OPTIMIZED).cachePolicyId,compress:this.props.compress??!0,originRequestPolicyId:this.props.originRequestPolicy?.originRequestPolicyId,realtimeLogConfigArn:this.props?.realtimeLogConfig?.realtimeLogConfigArn,responseHeadersPolicyId:this.props.responseHeadersPolicy?.responseHeadersPolicyId,smoothStreaming:this.props.smoothStreaming,viewerProtocolPolicy:this.props.viewerProtocolPolicy??distribution_1().ViewerProtocolPolicy.ALLOW_ALL,functionAssociations:this.props.functionAssociations?.map(association=>({functionArn:association.function.functionArn,eventType:association.eventType.toString()})),lambdaFunctionAssociations:this.props.edgeLambdas?.map(edgeLambda=>({lambdaFunctionArn:edgeLambda.functionVersion.edgeArn,eventType:edgeLambda.eventType.toString(),includeBody:edgeLambda.includeBody})),trustedKeyGroups:this.props.trustedKeyGroups?.map(keyGroup=>keyGroup.keyGroupId),grpcConfig:this.props.enableGrpc!==void 0?{enabled:this.props.enableGrpc}:void 0}}validateEdgeLambdas(edgeLambdas){const includeBodyEventTypes=[distribution_1().LambdaEdgeEventType.ORIGIN_REQUEST,distribution_1().LambdaEdgeEventType.VIEWER_REQUEST];if(edgeLambdas&&edgeLambdas.some(lambda=>lambda.includeBody&&!includeBodyEventTypes.includes(lambda.eventType)))throw new(core_1()).UnscopedValidationError("'includeBody' can only be true for ORIGIN_REQUEST or VIEWER_REQUEST event types.")}grantEdgeLambdaFunctionExecutionRole(edgeLambdas){!edgeLambdas||edgeLambdas.length===0||edgeLambdas.forEach(edgeLambda=>{const role=edgeLambda.functionVersion.role;role&&iam().Role.isRole(role)&&role.assumeRolePolicy&&role.assumeRolePolicy.addStatements(new(iam()).PolicyStatement({actions:["sts:AssumeRole"],principals:[new(iam()).ServicePrincipal("edgelambda.amazonaws.com")]}))})}}exports.CacheBehavior=CacheBehavior;
