"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CacheQueryStringBehavior=exports.CacheHeaderBehavior=exports.CacheCookieBehavior=exports.CachePolicy=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var cloudfront_generated_1=()=>{var tmp=require("./cloudfront.generated");return cloudfront_generated_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};class CachePolicy extends core_1().Resource{static fromCachePolicyId(scope,id,cachePolicyId){return new class extends core_1().Resource{constructor(){super(...arguments),this.cachePolicyId=cachePolicyId}}(scope,id)}static fromManagedCachePolicy(managedCachePolicyId){return new class{constructor(){this.cachePolicyId=managedCachePolicyId}}}constructor(scope,id,props={}){super(scope,id,{physicalName:props.cachePolicyName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudfront_CachePolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CachePolicy),error}(0,metadata_resource_1().addConstructMetadata)(this,props);const cachePolicyName=props.cachePolicyName??`${core_1().Names.uniqueId(this).slice(0,110)}-${core_1().Stack.of(this).region}`;if(!core_1().Token.isUnresolved(cachePolicyName)&&!cachePolicyName.match(/^[\w-]+$/i))throw new(core_1()).ValidationError(`'cachePolicyName' can only include '-', '_', and alphanumeric characters, got: '${cachePolicyName}'`,this);if(cachePolicyName.length>128)throw new(core_1()).ValidationError(`'cachePolicyName' cannot be longer than 128 characters, got: '${cachePolicyName.length}'`,this);if(props.comment&&!core_1().Token.isUnresolved(props.comment)&&props.comment.length>128)throw new(core_1()).ValidationError(`'comment' cannot be longer than 128 characters, got: ${props.comment.length}`,this);const minTtl=(props.minTtl??core_1().Duration.seconds(0)).toSeconds();let defaultTtl=(props.defaultTtl??core_1().Duration.days(1)).toSeconds(),maxTtl=(props.maxTtl??core_1().Duration.days(365)).toSeconds();(0,core_1().withResolved)(defaultTtl,minTtl,()=>{defaultTtl=Math.max(defaultTtl,minTtl)}),(0,core_1().withResolved)(maxTtl,defaultTtl,()=>{maxTtl=Math.max(maxTtl,defaultTtl)});const resource=new(cloudfront_generated_1()).CfnCachePolicy(this,"Resource",{cachePolicyConfig:{name:cachePolicyName,comment:props.comment,minTtl,maxTtl,defaultTtl,parametersInCacheKeyAndForwardedToOrigin:this.renderCacheKey(props)}});this.cachePolicyId=resource.ref}renderCacheKey(props){const cookies=props.cookieBehavior??CacheCookieBehavior.none(),headers=props.headerBehavior??CacheHeaderBehavior.none(),queryStrings=props.queryStringBehavior??CacheQueryStringBehavior.none();return{cookiesConfig:{cookieBehavior:cookies.behavior,cookies:cookies.cookies},headersConfig:{headerBehavior:headers.behavior,headers:headers.headers},enableAcceptEncodingGzip:props.enableAcceptEncodingGzip??!1,enableAcceptEncodingBrotli:props.enableAcceptEncodingBrotli??!1,queryStringsConfig:{queryStringBehavior:queryStrings.behavior,queryStrings:queryStrings.queryStrings}}}}exports.CachePolicy=CachePolicy,_a=JSII_RTTI_SYMBOL_1,CachePolicy[_a]={fqn:"aws-cdk-lib.aws_cloudfront.CachePolicy",version:"2.188.0"},CachePolicy.AMPLIFY=CachePolicy.fromManagedCachePolicy("2e54312d-136d-493c-8eb9-b001f22f67d2"),CachePolicy.CACHING_OPTIMIZED=CachePolicy.fromManagedCachePolicy("658327ea-f89d-4fab-a63d-7e88639e58f6"),CachePolicy.CACHING_OPTIMIZED_FOR_UNCOMPRESSED_OBJECTS=CachePolicy.fromManagedCachePolicy("b2884449-e4de-46a7-ac36-70bc7f1ddd6d"),CachePolicy.CACHING_DISABLED=CachePolicy.fromManagedCachePolicy("4135ea2d-6df8-44a3-9df3-4b5a84be39ad"),CachePolicy.ELEMENTAL_MEDIA_PACKAGE=CachePolicy.fromManagedCachePolicy("08627262-05a9-4f76-9ded-b50ca2e3a84f"),CachePolicy.USE_ORIGIN_CACHE_CONTROL_HEADERS=CachePolicy.fromManagedCachePolicy("83da9c7e-98b4-4e11-a168-04f0df8e2c65"),CachePolicy.USE_ORIGIN_CACHE_CONTROL_HEADERS_QUERY_STRINGS=CachePolicy.fromManagedCachePolicy("4cc15a8a-d715-48a4-82b8-cc0b614638fe");class CacheCookieBehavior{static none(){return new CacheCookieBehavior("none")}static all(){return new CacheCookieBehavior("all")}static allowList(...cookies){if(cookies.length===0)throw new(core_1()).UnscopedValidationError("At least one cookie to allow must be provided");return new CacheCookieBehavior("whitelist",cookies)}static denyList(...cookies){if(cookies.length===0)throw new(core_1()).UnscopedValidationError("At least one cookie to deny must be provided");return new CacheCookieBehavior("allExcept",cookies)}constructor(behavior,cookies){this.behavior=behavior,this.cookies=cookies}}exports.CacheCookieBehavior=CacheCookieBehavior,_b=JSII_RTTI_SYMBOL_1,CacheCookieBehavior[_b]={fqn:"aws-cdk-lib.aws_cloudfront.CacheCookieBehavior",version:"2.188.0"};class CacheHeaderBehavior{static none(){return new CacheHeaderBehavior("none")}static allowList(...headers){if(headers.length===0)throw new(core_1()).UnscopedValidationError("At least one header to allow must be provided");return new CacheHeaderBehavior("whitelist",headers)}constructor(behavior,headers){this.behavior=behavior,this.headers=headers}}exports.CacheHeaderBehavior=CacheHeaderBehavior,_c=JSII_RTTI_SYMBOL_1,CacheHeaderBehavior[_c]={fqn:"aws-cdk-lib.aws_cloudfront.CacheHeaderBehavior",version:"2.188.0"};class CacheQueryStringBehavior{static none(){return new CacheQueryStringBehavior("none")}static all(){return new CacheQueryStringBehavior("all")}static allowList(...queryStrings){if(queryStrings.length===0)throw new(core_1()).UnscopedValidationError("At least one query string to allow must be provided");return new CacheQueryStringBehavior("whitelist",queryStrings)}static denyList(...queryStrings){if(queryStrings.length===0)throw new(core_1()).UnscopedValidationError("At least one query string to deny must be provided");return new CacheQueryStringBehavior("allExcept",queryStrings)}constructor(behavior,queryStrings){this.behavior=behavior,this.queryStrings=queryStrings}}exports.CacheQueryStringBehavior=CacheQueryStringBehavior,_d=JSII_RTTI_SYMBOL_1,CacheQueryStringBehavior[_d]={fqn:"aws-cdk-lib.aws_cloudfront.CacheQueryStringBehavior",version:"2.188.0"};
