import * as cloudfront from '../../aws-cloudfront';
import { IInstance } from '../../aws-ec2';
import { IApplicationLoadBalancer, INetworkLoadBalancer } from '../../aws-elasticloadbalancingv2';
import * as cdk from '../../core';
/**
 * Properties to define a VPC origin.
 */
export interface VpcOriginProps extends cloudfront.OriginProps {
    /**
     * The domain name associated with your VPC origin.
     * @default - The default domain name of the endpoint.
     */
    readonly domainName?: string;
    /**
     * Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
     * The valid range is from 1 to 180 seconds, inclusive.
     *
     * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
     * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
     *
     * @default Duration.seconds(30)
     */
    readonly readTimeout?: cdk.Duration;
    /**
     * Specifies how long, in seconds, CloudFront persists its connection to the origin.
     * The valid range is from 1 to 180 seconds, inclusive.
     *
     * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
     * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
     *
     * @default Duration.seconds(5)
     */
    readonly keepaliveTimeout?: cdk.Duration;
}
/**
 * Properties to define a VPC origin with endpoint.
 */
export interface VpcOriginWithEndpointProps extends VpcOriginProps, cloudfront.VpcOriginOptions {
}
/**
 * Represents a distribution's VPC origin.
 */
export declare abstract class VpcOrigin extends cloudfront.OriginBase {
    protected readonly props: VpcOriginProps;
    /**
     * Create a VPC origin with an existing VPC origin resource.
     */
    static withVpcOrigin(origin: cloudfront.IVpcOrigin, props?: VpcOriginProps): VpcOrigin;
    /**
     * Create a VPC origin with an EC2 instance.
     */
    static withEc2Instance(instance: IInstance, props?: VpcOriginWithEndpointProps): VpcOrigin;
    /**
     * Create a VPC origin with an Application Load Balancer.
     */
    static withApplicationLoadBalancer(alb: IApplicationLoadBalancer, props?: VpcOriginWithEndpointProps): VpcOrigin;
    /**
     * Create a VPC origin with a Network Load Balancer.
     */
    static withNetworkLoadBalancer(nlb: INetworkLoadBalancer, props?: VpcOriginWithEndpointProps): VpcOrigin;
    protected vpcOrigin?: cloudfront.IVpcOrigin;
    protected constructor(domainName: string, props: VpcOriginProps);
    protected renderVpcOriginConfig(): cloudfront.CfnDistribution.VpcOriginConfigProperty | undefined;
}
