import { Construct } from 'constructs';
import * as cloudfront from '../../aws-cloudfront';
import { AccessLevel } from '../../aws-cloudfront';
import { IBucket } from '../../aws-s3';
/**
 * Properties for configuring a origin using a standard S3 bucket
 */
export interface S3BucketOriginBaseProps extends cloudfront.OriginProps {
}
/**
 * Properties for configuring a S3 origin with OAC
 */
export interface S3BucketOriginWithOACProps extends S3BucketOriginBaseProps {
    /**
     * An optional Origin Access Control
     *
     * @default - an Origin Access Control will be created.
     */
    readonly originAccessControl?: cloudfront.IOriginAccessControl;
    /**
     * The level of permissions granted in the bucket policy and key policy (if applicable)
     * to the CloudFront distribution.
     *
     * @default [AccessLevel.READ]
     */
    readonly originAccessLevels?: AccessLevel[];
}
/**
 * Properties for configuring a S3 origin with OAI
 */
export interface S3BucketOriginWithOAIProps extends S3BucketOriginBaseProps {
    /**
     * An optional Origin Access Identity
     *
     * @default - an Origin Access Identity will be created.
     */
    readonly originAccessIdentity?: cloudfront.IOriginAccessIdentity;
}
/**
 * A S3 Bucket Origin
 */
export declare abstract class S3BucketOrigin extends cloudfront.OriginBase {
    /**
     * Create a S3 Origin with Origin Access Control (OAC) configured
     */
    static withOriginAccessControl(bucket: IBucket, props?: S3BucketOriginWithOACProps): cloudfront.IOrigin;
    /**
     * Create a S3 Origin with Origin Access Identity (OAI) configured
     * OAI is a legacy feature and we **strongly** recommend you to use OAC via `withOriginAccessControl()`
     * unless it is not supported in your required region (e.g. China regions).
     */
    static withOriginAccessIdentity(bucket: IBucket, props?: S3BucketOriginWithOAIProps): cloudfront.IOrigin;
    /**
     * Create a S3 Origin with default S3 bucket settings (no origin access control)
     */
    static withBucketDefaults(bucket: IBucket, props?: cloudfront.OriginProps): cloudfront.IOrigin;
    constructor(bucket: IBucket, props?: S3BucketOriginBaseProps);
    /** @internal */
    protected _bind(scope: Construct, options: cloudfront.OriginBindOptions): cloudfront.OriginBindConfig;
    protected renderS3OriginConfig(): cloudfront.CfnDistribution.S3OriginConfigProperty | undefined;
}
