"use strict";var _a,_b,_c,_d,_e,_f;Object.defineProperty(exports,"__esModule",{value:!0}),exports.EcsFargateContainerDefinition=exports.EcsEc2ContainerDefinition=exports.UlimitName=exports.HostVolume=exports.EfsVolume=exports.EcsVolume=exports.Secret=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},aws_logs_1=()=>{var tmp=require("../../aws-logs");return aws_logs_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp};const EFS_VOLUME_SYMBOL=Symbol.for("aws-cdk-lib/aws-batch/lib/container-definition.EfsVolume"),HOST_VOLUME_SYMBOL=Symbol.for("aws-cdk-lib/aws-batch/lib/container-definition.HostVolume");class Secret{static fromSsmParameter(parameter){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_IParameter(parameter)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSsmParameter),error}return{arn:parameter.parameterArn,grantRead:grantee=>parameter.grantRead(grantee)}}static fromSecretsManager(secret,field){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_secretsmanager_ISecret(secret)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecretsManager),error}return{arn:field?`${secret.secretArn}:${field}::`:secret.secretArn,hasField:!!field,grantRead:grantee=>secret.grantRead(grantee)}}static fromSecretsManagerVersion(secret,versionInfo,field){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_secretsmanager_ISecret(secret),jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_SecretVersionInfo(versionInfo)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecretsManagerVersion),error}return{arn:`${secret.secretArn}:${field??""}:${versionInfo.versionStage??""}:${versionInfo.versionId??""}`,hasField:!!field,grantRead:grantee=>secret.grantRead(grantee)}}}exports.Secret=Secret,_a=JSII_RTTI_SYMBOL_1,Secret[_a]={fqn:"aws-cdk-lib.aws_batch.Secret",version:"2.188.0"};class EcsVolume{static efs(options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_EfsVolumeOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.efs),error}return new EfsVolume(options)}static host(options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_HostVolumeOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.host),error}return new HostVolume(options)}constructor(options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_EcsVolumeOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EcsVolume),error}this.name=options.name,this.containerPath=options.containerPath,this.readonly=options.readonly}}exports.EcsVolume=EcsVolume,_b=JSII_RTTI_SYMBOL_1,EcsVolume[_b]={fqn:"aws-cdk-lib.aws_batch.EcsVolume",version:"2.188.0"};class EfsVolume extends EcsVolume{static isEfsVolume(x){return x!==null&&typeof x=="object"&&EFS_VOLUME_SYMBOL in x}constructor(options){super(options);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_EfsVolumeOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EfsVolume),error}this.fileSystem=options.fileSystem,this.rootDirectory=options.rootDirectory,this.enableTransitEncryption=options.enableTransitEncryption,this.transitEncryptionPort=options.transitEncryptionPort,this.accessPointId=options.accessPointId,this.useJobRole=options.useJobRole}}exports.EfsVolume=EfsVolume,_c=JSII_RTTI_SYMBOL_1,EfsVolume[_c]={fqn:"aws-cdk-lib.aws_batch.EfsVolume",version:"2.188.0"},Object.defineProperty(EfsVolume.prototype,EFS_VOLUME_SYMBOL,{value:!0,enumerable:!1,writable:!1});class HostVolume extends EcsVolume{static isHostVolume(x){return x!==null&&typeof x=="object"&&HOST_VOLUME_SYMBOL in x}constructor(options){super(options);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_HostVolumeOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,HostVolume),error}this.hostPath=options.hostPath}}exports.HostVolume=HostVolume,_d=JSII_RTTI_SYMBOL_1,HostVolume[_d]={fqn:"aws-cdk-lib.aws_batch.HostVolume",version:"2.188.0"},Object.defineProperty(HostVolume.prototype,HOST_VOLUME_SYMBOL,{value:!0,enumerable:!1,writable:!1});class EcsContainerDefinitionBase extends constructs_1().Construct{constructor(scope,id,props){super(scope,id),this.image=props.image,this.cpu=props.cpu,this.command=props.command,this.environment=props.environment,this.executionRole=props.executionRole??createExecutionRole(this,"ExecutionRole",!!props.logging),this.jobRole=props.jobRole,this.linuxParameters=props.linuxParameters,this.memory=props.memory,props.logging&&(this.logDriverConfig=props.logging.bind(this,{...this,taskDefinition:{obtainExecutionRole:()=>this.executionRole}})),this.readonlyRootFilesystem=props.readonlyRootFilesystem??!1,this.secrets=props.secrets,this.user=props.user,this.volumes=props.volumes??[],this.imageConfig=props.image.bind(this,{...this,taskDefinition:{obtainExecutionRole:()=>this.executionRole}})}_renderContainerDefinition(){return{image:this.imageConfig.imageName,command:this.command,environment:Object.keys(this.environment??{}).map(envKey=>({name:envKey,value:(this.environment??{})[envKey]})),jobRoleArn:this.jobRole?.roleArn,executionRoleArn:this.executionRole?.roleArn,linuxParameters:this.linuxParameters&&this.linuxParameters.renderLinuxParameters(),logConfiguration:this.logDriverConfig,readonlyRootFilesystem:this.readonlyRootFilesystem,resourceRequirements:this._renderResourceRequirements(),secrets:this.secrets?Object.entries(this.secrets).map(([name,secret])=>(secret.grantRead(this.executionRole),{name,valueFrom:secret.arn})):void 0,mountPoints:core_1().Lazy.any({produce:()=>{if(this.volumes.length!==0)return this.volumes.map(volume=>({containerPath:volume.containerPath,readOnly:volume.readonly,sourceVolume:volume.name}))}}),volumes:core_1().Lazy.any({produce:()=>{if(this.volumes.length!==0)return this.volumes.map(volume=>{if(EfsVolume.isEfsVolume(volume))return{name:volume.name,efsVolumeConfiguration:{fileSystemId:volume.fileSystem.fileSystemId,rootDirectory:volume.rootDirectory,transitEncryption:volume.enableTransitEncryption?"ENABLED":volume.enableTransitEncryption===!1?"DISABLED":void 0,transitEncryptionPort:volume.transitEncryptionPort,authorizationConfig:volume.accessPointId||volume.useJobRole?{accessPointId:volume.accessPointId,iam:volume.useJobRole?"ENABLED":volume.useJobRole===!1?"DISABLED":void 0}:void 0}};if(HostVolume.isHostVolume(volume))return{name:volume.name,host:{sourcePath:volume.hostPath}};throw new(core_1()).ValidationError("unsupported Volume encountered",this)})}}),user:this.user}}addVolume(volume){this.volumes.push(volume)}_renderResourceRequirements(){const resourceRequirements=[];return resourceRequirements.push({type:"MEMORY",value:this.memory.toMebibytes().toString()}),resourceRequirements.push({type:"VCPU",value:this.cpu.toString()}),resourceRequirements}}var UlimitName;(function(UlimitName2){UlimitName2.CORE="core",UlimitName2.CPU="cpu",UlimitName2.DATA="data",UlimitName2.FSIZE="fsize",UlimitName2.LOCKS="locks",UlimitName2.MEMLOCK="memlock",UlimitName2.MSGQUEUE="msgqueue",UlimitName2.NICE="nice",UlimitName2.NOFILE="nofile",UlimitName2.NPROC="nproc",UlimitName2.RSS="rss",UlimitName2.RTPRIO="rtprio",UlimitName2.RTTIME="rttime",UlimitName2.SIGPENDING="sigpending",UlimitName2.STACK="stack"})(UlimitName||(exports.UlimitName=UlimitName={}));class EcsEc2ContainerDefinition extends EcsContainerDefinitionBase{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_EcsEc2ContainerDefinitionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EcsEc2ContainerDefinition),error}this.privileged=props.privileged,this.ulimits=props.ulimits??[],this.gpu=props.gpu}_renderContainerDefinition(){return{...super._renderContainerDefinition(),ulimits:core_1().Lazy.any({produce:()=>{if(this.ulimits.length!==0)return this.ulimits.map(ulimit=>({hardLimit:ulimit.hardLimit,name:ulimit.name,softLimit:ulimit.softLimit}))}}),privileged:this.privileged,resourceRequirements:this._renderResourceRequirements()}}addUlimit(ulimit){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_Ulimit(ulimit)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addUlimit),error}this.ulimits.push(ulimit)}_renderResourceRequirements(){const resourceRequirements=super._renderResourceRequirements();return this.gpu&&resourceRequirements.push({type:"GPU",value:this.gpu.toString()}),resourceRequirements}}exports.EcsEc2ContainerDefinition=EcsEc2ContainerDefinition,_e=JSII_RTTI_SYMBOL_1,EcsEc2ContainerDefinition[_e]={fqn:"aws-cdk-lib.aws_batch.EcsEc2ContainerDefinition",version:"2.188.0"};class EcsFargateContainerDefinition extends EcsContainerDefinitionBase{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_batch_EcsFargateContainerDefinitionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EcsFargateContainerDefinition),error}if(this.assignPublicIp=props.assignPublicIp,this.fargatePlatformVersion=props.fargatePlatformVersion,this.ephemeralStorageSize=props.ephemeralStorageSize,this.fargateCpuArchitecture=props.fargateCpuArchitecture,this.fargateOperatingSystemFamily=props.fargateOperatingSystemFamily,this.fargateOperatingSystemFamily?.isWindows()&&this.readonlyRootFilesystem)throw new(core_1()).ValidationError("Readonly root filesystem is not possible on Windows; write access is required for registry & system processes to run inside the container",this);if(props.ephemeralStorageSize){if(props.ephemeralStorageSize.toGibibytes()>200)throw new(core_1()).ValidationError(`ECS Fargate container '${id}' specifies 'ephemeralStorageSize' at ${props.ephemeralStorageSize.toGibibytes()} > 200 GB`,this);if(props.ephemeralStorageSize.toGibibytes()<21)throw new(core_1()).ValidationError(`ECS Fargate container '${id}' specifies 'ephemeralStorageSize' at ${props.ephemeralStorageSize.toGibibytes()} < 21 GB`,this)}}_renderContainerDefinition(){let containerDef={...super._renderContainerDefinition(),ephemeralStorage:this.ephemeralStorageSize?{sizeInGiB:this.ephemeralStorageSize?.toGibibytes()}:void 0,fargatePlatformConfiguration:{platformVersion:this.fargatePlatformVersion?.toString()},networkConfiguration:{assignPublicIp:this.assignPublicIp?"ENABLED":"DISABLED"},runtimePlatform:{cpuArchitecture:this.fargateCpuArchitecture?._cpuArchitecture,operatingSystemFamily:this.fargateOperatingSystemFamily?._operatingSystemFamily}};return this.fargateOperatingSystemFamily?.isWindows()&&(containerDef.readonlyRootFilesystem=void 0),containerDef}}exports.EcsFargateContainerDefinition=EcsFargateContainerDefinition,_f=JSII_RTTI_SYMBOL_1,EcsFargateContainerDefinition[_f]={fqn:"aws-cdk-lib.aws_batch.EcsFargateContainerDefinition",version:"2.188.0"};function createExecutionRole(scope,id,logging){const execRole=new(iam()).Role(scope,id,{assumedBy:new(iam()).ServicePrincipal("ecs-tasks.amazonaws.com"),roleName:core_1().PhysicalName.GENERATE_IF_NEEDED});return logging||aws_logs_1().LogGroup.fromLogGroupName(scope,"batchDefaultLogGroup","/aws/batch/job").grantWrite(execRole),execRole}
