"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BackupVault=exports.BackupVaultEvents=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var backup_generated_1=()=>{var tmp=require("./backup.generated");return backup_generated_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},BackupVaultEvents;(function(BackupVaultEvents2){BackupVaultEvents2.BACKUP_JOB_STARTED="BACKUP_JOB_STARTED",BackupVaultEvents2.BACKUP_JOB_COMPLETED="BACKUP_JOB_COMPLETED",BackupVaultEvents2.BACKUP_JOB_SUCCESSFUL="BACKUP_JOB_SUCCESSFUL",BackupVaultEvents2.BACKUP_JOB_FAILED="BACKUP_JOB_FAILED",BackupVaultEvents2.BACKUP_JOB_EXPIRED="BACKUP_JOB_EXPIRED",BackupVaultEvents2.RESTORE_JOB_STARTED="RESTORE_JOB_STARTED",BackupVaultEvents2.RESTORE_JOB_COMPLETED="RESTORE_JOB_COMPLETED",BackupVaultEvents2.RESTORE_JOB_SUCCESSFUL="RESTORE_JOB_SUCCESSFUL",BackupVaultEvents2.RESTORE_JOB_FAILED="RESTORE_JOB_FAILED",BackupVaultEvents2.COPY_JOB_STARTED="COPY_JOB_STARTED",BackupVaultEvents2.COPY_JOB_SUCCESSFUL="COPY_JOB_SUCCESSFUL",BackupVaultEvents2.COPY_JOB_FAILED="COPY_JOB_FAILED",BackupVaultEvents2.RECOVERY_POINT_MODIFIED="RECOVERY_POINT_MODIFIED",BackupVaultEvents2.BACKUP_PLAN_CREATED="BACKUP_PLAN_CREATED",BackupVaultEvents2.BACKUP_PLAN_MODIFIED="BACKUP_PLAN_MODIFIED",BackupVaultEvents2.S3_BACKUP_OBJECT_FAILED="S3_BACKUP_OBJECT_FAILED",BackupVaultEvents2.S3_RESTORE_OBJECT_FAILED="S3_RESTORE_OBJECT_FAILED"})(BackupVaultEvents||(exports.BackupVaultEvents=BackupVaultEvents={}));class BackupVaultBase extends core_1().Resource{grant(grantee,...actions){for(const action of actions)if(action.indexOf("*")>=0)throw new(core_1()).ValidationError("AWS Backup access policies don't support a wildcard in the Action key.",this);return iam().Grant.addToPrincipal({grantee,actions,resourceArns:[this.backupVaultArn]})}}class BackupVault extends BackupVaultBase{static fromBackupVaultName(scope,id,backupVaultName){const backupVaultArn=core_1().Stack.of(scope).formatArn({service:"backup",resource:"backup-vault",resourceName:backupVaultName,arnFormat:core_1().ArnFormat.COLON_RESOURCE_NAME});return BackupVault.fromBackupVaultArn(scope,id,backupVaultArn)}static fromBackupVaultArn(scope,id,backupVaultArn){const parsedArn=core_1().Stack.of(scope).splitArn(backupVaultArn,core_1().ArnFormat.COLON_RESOURCE_NAME);if(parsedArn.arnFormat!==core_1().ArnFormat.COLON_RESOURCE_NAME)throw new(core_1()).ValidationError(`Backup Vault Arn ${backupVaultArn} has the wrong format, expected ${core_1().ArnFormat.COLON_RESOURCE_NAME}.`,scope);if(!parsedArn.resourceName)throw new(core_1()).ValidationError(`Backup Vault Arn ${backupVaultArn} does not have a resource name.`,scope);class Import extends BackupVaultBase{constructor(){super(...arguments),this.backupVaultName=parsedArn.resourceName,this.backupVaultArn=backupVaultArn}}return new Import(scope,id,{account:parsedArn.account,region:parsedArn.region})}constructor(scope,id,props={}){super(scope,id);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_backup_BackupVaultProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BackupVault),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),props.backupVaultName&&!core_1().Token.isUnresolved(props.backupVaultName)&&!/^[a-zA-Z0-9\-_]{2,50}$/.test(props.backupVaultName))throw new(core_1()).ValidationError("Expected vault name to match pattern `^[a-zA-Z0-9-_]{2,50}$`",this);let notifications;props.notificationTopic&&(notifications={backupVaultEvents:props.notificationEvents||Object.values(BackupVaultEvents),snsTopicArn:props.notificationTopic.topicArn},props.notificationTopic.grantPublish(new(iam()).ServicePrincipal("backup.amazonaws.com"))),this.accessPolicy=props.accessPolicy??new(iam()).PolicyDocument,props.blockRecoveryPointDeletion&&this.blockRecoveryPointDeletion();const vault=new(backup_generated_1()).CfnBackupVault(this,"Resource",{backupVaultName:props.backupVaultName||this.uniqueVaultName(),accessPolicy:core_1().Lazy.any({produce:()=>this.accessPolicy.toJSON()}),encryptionKeyArn:props.encryptionKey&&props.encryptionKey.keyArn,notifications,lockConfiguration:renderLockConfiguration(this,props.lockConfiguration)});vault.applyRemovalPolicy(props.removalPolicy),this.backupVaultName=vault.attrBackupVaultName,this.backupVaultArn=vault.attrBackupVaultArn}addToAccessPolicy(statement){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToAccessPolicy),error}this.accessPolicy.addStatements(statement)}blockRecoveryPointDeletion(){this.addToAccessPolicy(new(iam()).PolicyStatement({effect:iam().Effect.DENY,actions:["backup:DeleteRecoveryPoint","backup:UpdateRecoveryPointLifecycle"],principals:[new(iam()).AnyPrincipal],resources:["*"]}))}uniqueVaultName(){const id=core_1().Names.uniqueId(this);return id.substring(Math.max(id.length-50,0),id.length)}}exports.BackupVault=BackupVault,_a=JSII_RTTI_SYMBOL_1,BackupVault[_a]={fqn:"aws-cdk-lib.aws_backup.BackupVault",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],BackupVault.prototype,"addToAccessPolicy",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],BackupVault.prototype,"blockRecoveryPointDeletion",null);function renderLockConfiguration(scope,config){if(config){if(config.changeableFor&&config.changeableFor.toHours()<72)throw new(core_1()).ValidationError(`AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable, got ${config.changeableFor.toHours()} hours`,scope);if(config.maxRetention){if(config.maxRetention.toDays()>36500)throw new(core_1()).ValidationError(`The longest maximum retention period you can specify is 36500 days, got ${config.maxRetention.toDays()} days`,scope);if(config.maxRetention.toDays()<=config.minRetention.toDays())throw new(core_1()).ValidationError(`The maximum retention period (${config.maxRetention.toDays()} days) must be greater than the minimum retention period (${config.minRetention.toDays()} days)`,scope)}if(config.minRetention.toHours()<24)throw new(core_1()).ValidationError(`The shortest minimum retention period you can specify is 1 day, got ${config.minRetention.toHours()} hours`,scope);return{minRetentionDays:config.minRetention.toDays(),maxRetentionDays:config.maxRetention?.toDays(),changeableForDays:config.changeableFor?.toDays()}}}
