"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.renderTlsClientPolicy=renderTlsClientPolicy,exports.renderListenerTlsOptions=renderListenerTlsOptions,exports.renderMeshOwner=renderMeshOwner,exports.validateHttpMatchArrayLength=validateHttpMatchArrayLength,exports.validateGrpcMatchArrayLength=validateGrpcMatchArrayLength,exports.validateGrpcRouteMatch=validateGrpcRouteMatch,exports.validateGrpcGatewayRouteMatch=validateGrpcGatewayRouteMatch;var core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp};function renderTlsClientPolicy(scope,tlsClientPolicy){const certificate=tlsClientPolicy?.mutualTlsCertificate?.bind(scope).tlsCertificate,sans=tlsClientPolicy?.validation.subjectAlternativeNames;return tlsClientPolicy?{certificate,ports:tlsClientPolicy.ports,enforce:tlsClientPolicy.enforce,validation:{subjectAlternativeNames:sans?{match:sans.bind(scope).subjectAlternativeNamesMatch}:void 0,trust:tlsClientPolicy.validation.trust.bind(scope).tlsValidationTrust}}:void 0}function renderListenerTlsOptions(scope,listenerTls){const tlsValidation=listenerTls?.mutualTlsValidation;return listenerTls?{certificate:listenerTls.certificate.bind(scope).tlsCertificate,mode:listenerTls.mode,validation:tlsValidation?{subjectAlternativeNames:tlsValidation.subjectAlternativeNames?{match:tlsValidation.subjectAlternativeNames.bind(scope).subjectAlternativeNamesMatch}:void 0,trust:tlsValidation.trust.bind(scope).tlsValidationTrust}:void 0}:void 0}function renderMeshOwner(resourceAccount,meshAccount){const comparison=core_1().Token.compareStrings(resourceAccount,meshAccount);return comparison===core_1().TokenComparison.DIFFERENT||comparison===core_1().TokenComparison.ONE_UNRESOLVED?meshAccount:void 0}function validateHttpMatchArrayLength(scope,headers,queryParameters){if(headers&&(headers.length<1||headers.length>10))throw new(core_1()).ValidationError(`Number of headers provided for matching must be between 1 and 10, got: ${headers.length}`,scope);if(queryParameters&&(queryParameters.length<1||queryParameters.length>10))throw new(core_1()).ValidationError(`Number of query parameters provided for matching must be between 1 and 10, got: ${queryParameters.length}`,scope)}function validateGrpcMatchArrayLength(scope,metadata){if(metadata&&(metadata.length<1||metadata.length>10))throw new(core_1()).ValidationError(`Number of metadata provided for matching must be between 1 and 10, got: ${metadata.length}`,scope)}function validateGrpcRouteMatch(scope,match){if(match.serviceName===void 0&&match.metadata===void 0&&match.methodName===void 0&&match.port===void 0)throw new(core_1()).ValidationError("At least one gRPC route match property must be provided",scope)}function validateGrpcGatewayRouteMatch(scope,match){if(match.serviceName===void 0&&match.metadata===void 0&&match.hostname===void 0&&match.port===void 0)throw new(core_1()).ValidationError("At least one gRPC gateway route match property beside rewriteRequestHostname must be provided",scope)}
