"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.RolloutStrategy=exports.DeploymentStrategyId=exports.GrowthType=exports.DeploymentStrategy=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var appconfig_generated_1=()=>{var tmp=require("./appconfig.generated");return appconfig_generated_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};class DeploymentStrategy extends core_1().Resource{static fromDeploymentStrategyArn(scope,id,deploymentStrategyArn){const deploymentStrategyId=core_1().Stack.of(scope).splitArn(deploymentStrategyArn,core_1().ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!deploymentStrategyId)throw new(core_1()).ValidationError("Missing required deployment strategy id from deployment strategy ARN",scope);class Import extends core_1().Resource{constructor(){super(...arguments),this.deploymentStrategyId=deploymentStrategyId,this.deploymentStrategyArn=deploymentStrategyArn}}return new Import(scope,id,{environmentFromArn:deploymentStrategyArn})}static fromDeploymentStrategyId(scope,id,deploymentStrategyId){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_DeploymentStrategyId(deploymentStrategyId)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDeploymentStrategyId),error}const deploymentStrategyArn=core_1().Stack.of(scope).formatArn({service:"appconfig",resource:"deploymentstrategy",resourceName:deploymentStrategyId.id});class Import extends core_1().Resource{constructor(){super(...arguments),this.deploymentStrategyId=deploymentStrategyId.id,this.deploymentStrategyArn=deploymentStrategyArn}}return new Import(scope,id,{environmentFromArn:deploymentStrategyArn})}constructor(scope,id,props){super(scope,id,{physicalName:props.deploymentStrategyName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_DeploymentStrategyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DeploymentStrategy),error}(0,metadata_resource_1().addConstructMetadata)(this,props),this.deploymentDurationInMinutes=props.rolloutStrategy.deploymentDuration.toMinutes(),this.growthFactor=props.rolloutStrategy.growthFactor,this.description=props.description,this.finalBakeTimeInMinutes=props.rolloutStrategy.finalBakeTime?.toMinutes(),this.growthType=props.rolloutStrategy.growthType,this.name=props.deploymentStrategyName||core_1().Names.uniqueResourceName(this,{maxLength:64,separator:"-"});const resource=new(appconfig_generated_1()).CfnDeploymentStrategy(this,"Resource",{name:this.name,deploymentDurationInMinutes:this.deploymentDurationInMinutes,growthFactor:this.growthFactor,replicateTo:"NONE",description:this.description,finalBakeTimeInMinutes:this.finalBakeTimeInMinutes,growthType:this.growthType});this._cfnDeploymentStrategy=resource,this.deploymentStrategyId=this._cfnDeploymentStrategy.ref,this.deploymentStrategyArn=this.stack.formatArn({service:"appconfig",resource:"deploymentstrategy",resourceName:this.deploymentStrategyId})}}exports.DeploymentStrategy=DeploymentStrategy,_a=JSII_RTTI_SYMBOL_1,DeploymentStrategy[_a]={fqn:"aws-cdk-lib.aws_appconfig.DeploymentStrategy",version:"2.188.0"};var GrowthType;(function(GrowthType2){GrowthType2.LINEAR="LINEAR",GrowthType2.EXPONENTIAL="EXPONENTIAL"})(GrowthType||(exports.GrowthType=GrowthType={}));class DeploymentStrategyId{static fromString(deploymentStrategyId){return{id:deploymentStrategyId}}}exports.DeploymentStrategyId=DeploymentStrategyId,_b=JSII_RTTI_SYMBOL_1,DeploymentStrategyId[_b]={fqn:"aws-cdk-lib.aws_appconfig.DeploymentStrategyId",version:"2.188.0"},DeploymentStrategyId.CANARY_10_PERCENT_20_MINUTES=DeploymentStrategyId.fromString("AppConfig.Canary10Percent20Minutes"),DeploymentStrategyId.LINEAR_50_PERCENT_EVERY_30_SECONDS=DeploymentStrategyId.fromString("AppConfig.Linear50PercentEvery30Seconds"),DeploymentStrategyId.LINEAR_20_PERCENT_EVERY_6_MINUTES=DeploymentStrategyId.fromString("AppConfig.Linear20PercentEvery6Minutes"),DeploymentStrategyId.ALL_AT_ONCE=DeploymentStrategyId.fromString("AppConfig.AllAtOnce");class RolloutStrategy{static linear(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_RolloutStrategyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.linear),error}return{growthFactor:props.growthFactor,deploymentDuration:props.deploymentDuration,growthType:GrowthType.LINEAR,finalBakeTime:props.finalBakeTime}}static exponential(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_RolloutStrategyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.exponential),error}return{growthFactor:props.growthFactor,deploymentDuration:props.deploymentDuration,growthType:GrowthType.EXPONENTIAL,finalBakeTime:props.finalBakeTime}}}exports.RolloutStrategy=RolloutStrategy,_c=JSII_RTTI_SYMBOL_1,RolloutStrategy[_c]={fqn:"aws-cdk-lib.aws_appconfig.RolloutStrategy",version:"2.188.0"},RolloutStrategy.CANARY_10_PERCENT_20_MINUTES=RolloutStrategy.exponential({growthFactor:10,deploymentDuration:core_1().Duration.minutes(20),finalBakeTime:core_1().Duration.minutes(10)}),RolloutStrategy.LINEAR_50_PERCENT_EVERY_30_SECONDS=RolloutStrategy.linear({growthFactor:50,deploymentDuration:core_1().Duration.minutes(1),finalBakeTime:core_1().Duration.minutes(1)}),RolloutStrategy.LINEAR_20_PERCENT_EVERY_6_MINUTES=RolloutStrategy.linear({growthFactor:20,deploymentDuration:core_1().Duration.minutes(30),finalBakeTime:core_1().Duration.minutes(30)}),RolloutStrategy.ALL_AT_ONCE=RolloutStrategy.linear({growthFactor:100,deploymentDuration:core_1().Duration.minutes(0),finalBakeTime:core_1().Duration.minutes(10)});
