"use strict";var _a,_b,_c,_d,_e,_f;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ConfigurationSource=exports.ConfigurationContent=exports.LambdaValidator=exports.JsonSchemaValidator=exports.ConfigurationSourceType=exports.ValidatorType=exports.ConfigurationType=exports.SourcedConfiguration=exports.HostedConfiguration=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var fs=()=>{var tmp=require("fs");return fs=()=>tmp,tmp},path=()=>{var tmp=require("path");return path=()=>tmp,tmp},constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},appconfig_generated_1=()=>{var tmp=require("./appconfig.generated");return appconfig_generated_1=()=>tmp,tmp},deployment_strategy_1=()=>{var tmp=require("./deployment-strategy");return deployment_strategy_1=()=>tmp,tmp},extension_1=()=>{var tmp=require("./extension");return extension_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},mimeTypes=()=>{var tmp=require("mime-types");return mimeTypes=()=>tmp,tmp};class ConfigurationBase extends constructs_1().Construct{constructor(scope,id,props){super(scope,id),this.name=props.name||core_1().Names.uniqueResourceName(this,{maxLength:128,separator:"-"}),this.application=props.application,this.applicationId=this.application.applicationId,this.type=props.type,this.validators=props.validators,this.description=props.description,this.deployTo=props.deployTo,this.deploymentKey=props.deploymentKey,this.deploymentStrategy=props.deploymentStrategy||new(deployment_strategy_1()).DeploymentStrategy(this,"DeploymentStrategy",{rolloutStrategy:deployment_strategy_1().RolloutStrategy.CANARY_10_PERCENT_20_MINUTES})}on(actionPoint,eventDestination,options){this.extensible.on(actionPoint,eventDestination,options)}preCreateHostedConfigurationVersion(eventDestination,options){this.extensible.preCreateHostedConfigurationVersion(eventDestination,options)}preStartDeployment(eventDestination,options){this.extensible.preStartDeployment(eventDestination,options)}onDeploymentStart(eventDestination,options){this.extensible.onDeploymentStart(eventDestination,options)}onDeploymentStep(eventDestination,options){this.extensible.onDeploymentStep(eventDestination,options)}onDeploymentBaking(eventDestination,options){this.extensible.onDeploymentBaking(eventDestination,options)}onDeploymentComplete(eventDestination,options){this.extensible.onDeploymentComplete(eventDestination,options)}onDeploymentRolledBack(eventDestination,options){this.extensible.onDeploymentRolledBack(eventDestination,options)}atDeploymentTick(eventDestination,options){this.extensible.atDeploymentTick(eventDestination,options)}addExtension(extension){this.extensible.addExtension(extension)}addExistingEnvironmentsToApplication(){this.deployTo?.forEach(environment=>{this.application.environments().includes(environment)||this.application.addExistingEnvironment(environment)})}deployConfigToEnvironments(){!this.deployTo||!this.versionNumber||this.application.environments().forEach(environment=>{this.deployTo&&!this.deployTo.includes(environment)||environment.addDeployment(this)})}}class HostedConfiguration extends ConfigurationBase{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_HostedConfigurationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,HostedConfiguration),error}this._cfnConfigurationProfile=new(appconfig_generated_1()).CfnConfigurationProfile(this,"ConfigurationProfile",{applicationId:this.applicationId,locationUri:"hosted",name:this.name,description:this.description,type:this.type,validators:this.validators}),this.configurationProfileId=this._cfnConfigurationProfile.ref,this.configurationProfileArn=core_1().Stack.of(this).formatArn({service:"appconfig",resource:"application",resourceName:`${this.applicationId}/configurationprofile/${this.configurationProfileId}`}),this.extensible=new(extension_1()).ExtensibleBase(this,this.configurationProfileArn,this.name),this.content=props.content.content,this.contentType=props.content.contentType,this.latestVersionNumber=props.latestVersionNumber,this.versionLabel=props.versionLabel,this._cfnHostedConfigurationVersion=new(appconfig_generated_1()).CfnHostedConfigurationVersion(this,"Resource",{applicationId:this.applicationId,configurationProfileId:this.configurationProfileId,content:this.content,contentType:this.contentType,description:this.description,latestVersionNumber:this.latestVersionNumber,versionLabel:this.versionLabel}),this._cfnHostedConfigurationVersion.applyRemovalPolicy(core_1().RemovalPolicy.RETAIN),this.versionNumber=this._cfnHostedConfigurationVersion.ref,this.hostedConfigurationVersionArn=core_1().Stack.of(this).formatArn({service:"appconfig",resource:"application",resourceName:`${this.applicationId}/configurationprofile/${this.configurationProfileId}/hostedconfigurationversion/${this.versionNumber}`}),this.addExistingEnvironmentsToApplication(),this.deployConfigToEnvironments()}}exports.HostedConfiguration=HostedConfiguration,_a=JSII_RTTI_SYMBOL_1,HostedConfiguration[_a]={fqn:"aws-cdk-lib.aws_appconfig.HostedConfiguration",version:"2.188.0"};class SourcedConfiguration extends ConfigurationBase{constructor(scope,id,props){super(scope,id,props);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_SourcedConfigurationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SourcedConfiguration),error}this.location=props.location,this.locationUri=this.location.locationUri,this.versionNumber=props.versionNumber,this.sourceKey=this.location.key,this.retrievalRole=props.retrievalRole??this.getRetrievalRole(),this._cfnConfigurationProfile=new(appconfig_generated_1()).CfnConfigurationProfile(this,"Resource",{applicationId:this.applicationId,locationUri:this.locationUri,name:this.name,description:this.description,retrievalRoleArn:this.retrievalRole?.roleArn,type:this.type,validators:this.validators}),this.configurationProfileId=this._cfnConfigurationProfile.ref,this.configurationProfileArn=core_1().Stack.of(this).formatArn({service:"appconfig",resource:"application",resourceName:`${this.applicationId}/configurationprofile/${this.configurationProfileId}`}),this.extensible=new(extension_1()).ExtensibleBase(this,this.configurationProfileArn,this.name),this.addExistingEnvironmentsToApplication(),this.deployConfigToEnvironments()}getRetrievalRole(){if(this.location.type!=ConfigurationSourceType.CODE_PIPELINE)return new(iam()).Role(this,"Role",{roleName:core_1().PhysicalName.GENERATE_IF_NEEDED,assumedBy:new(iam()).ServicePrincipal("appconfig.amazonaws.com"),inlinePolicies:{AllowAppConfigReadFromSourcePolicy:this.getPolicyForRole()}})}getPolicyForRole(){const policy=new(iam()).PolicyStatement({effect:iam().Effect.ALLOW}),document=new(iam()).PolicyDocument({statements:[policy]});if(this.location.type==ConfigurationSourceType.SSM_PARAMETER)policy.addActions("ssm:GetParameter"),policy.addResources(this.locationUri);else if(this.location.type==ConfigurationSourceType.SSM_DOCUMENT)policy.addActions("ssm:GetDocument"),policy.addResources(core_1().Stack.of(this).formatArn({service:"ssm",resource:"document",resourceName:this.locationUri.split("://")[1]}));else if(this.location.type==ConfigurationSourceType.S3){const bucketAndObjectKey=this.locationUri.split("://")[1],sep=bucketAndObjectKey.search("/"),bucketName=bucketAndObjectKey.substring(0,sep),objectKey=bucketAndObjectKey.substring(sep+1);policy.addActions("s3:GetObject","s3:GetObjectMetadata","s3:GetObjectVersion"),policy.addResources(core_1().Stack.of(this).formatArn({region:"",account:"",service:"s3",arnFormat:core_1().ArnFormat.NO_RESOURCE_NAME,resource:`${bucketName}/${objectKey}`}));const bucketPolicy=new(iam()).PolicyStatement({effect:iam().Effect.ALLOW,actions:["s3:GetBucketLocation","s3:GetBucketVersioning","s3:ListBucket","s3:ListBucketVersions"],resources:[core_1().Stack.of(this).formatArn({region:"",account:"",service:"s3",arnFormat:core_1().ArnFormat.NO_RESOURCE_NAME,resource:bucketName})]}),listBucketsPolicy=new(iam()).PolicyStatement({effect:iam().Effect.ALLOW,actions:["s3:ListAllMyBuckets"],resources:["*"]});document.addStatements(bucketPolicy,listBucketsPolicy)}else policy.addActions("secretsmanager:GetSecretValue"),policy.addResources(this.locationUri);if(this.sourceKey){const keyPolicy=new(iam()).PolicyStatement({effect:iam().Effect.ALLOW,actions:["kms:Decrypt"],resources:[this.sourceKey.keyArn]});document.addStatements(keyPolicy)}return document}}exports.SourcedConfiguration=SourcedConfiguration,_b=JSII_RTTI_SYMBOL_1,SourcedConfiguration[_b]={fqn:"aws-cdk-lib.aws_appconfig.SourcedConfiguration",version:"2.188.0"};var ConfigurationType;(function(ConfigurationType2){ConfigurationType2.FREEFORM="AWS.Freeform",ConfigurationType2.FEATURE_FLAGS="AWS.AppConfig.FeatureFlags"})(ConfigurationType||(exports.ConfigurationType=ConfigurationType={}));var ValidatorType;(function(ValidatorType2){ValidatorType2.JSON_SCHEMA="JSON_SCHEMA",ValidatorType2.LAMBDA="LAMBDA"})(ValidatorType||(exports.ValidatorType=ValidatorType={}));var ConfigurationSourceType;(function(ConfigurationSourceType2){ConfigurationSourceType2.S3="S3",ConfigurationSourceType2.SECRETS_MANAGER="SECRETS_MANAGER",ConfigurationSourceType2.SSM_PARAMETER="SSM_PARAMETER",ConfigurationSourceType2.SSM_DOCUMENT="SSM_DOCUMENT",ConfigurationSourceType2.CODE_PIPELINE="CODE_PIPELINE"})(ConfigurationSourceType||(exports.ConfigurationSourceType=ConfigurationSourceType={}));class JsonSchemaValidator{static fromFile(inputPath){return{content:fs().readFileSync(path().resolve(inputPath)).toString(),type:ValidatorType.JSON_SCHEMA}}static fromInline(code){return{content:code,type:ValidatorType.JSON_SCHEMA}}}exports.JsonSchemaValidator=JsonSchemaValidator,_c=JSII_RTTI_SYMBOL_1,JsonSchemaValidator[_c]={fqn:"aws-cdk-lib.aws_appconfig.JsonSchemaValidator",version:"2.188.0"};class LambdaValidator{static fromFunction(func){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_Function(func)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromFunction),error}return func.permissionsNode.tryFindChild("AppConfigPermission")||func.addPermission("AppConfigPermission",{principal:new(iam()).ServicePrincipal("appconfig.amazonaws.com")}),{content:func.functionArn,type:ValidatorType.LAMBDA}}}exports.LambdaValidator=LambdaValidator,_d=JSII_RTTI_SYMBOL_1,LambdaValidator[_d]={fqn:"aws-cdk-lib.aws_appconfig.LambdaValidator",version:"2.188.0"};class ConfigurationContent{static fromFile(inputPath,contentType){return{content:fs().readFileSync(path().resolve(inputPath)).toString(),contentType:contentType||mimeTypes().lookup(inputPath)||"application/json"}}static fromInline(content,contentType){return{content,contentType:contentType||"application/octet-stream"}}static fromInlineJson(content,contentType){return{content,contentType:contentType||"application/json"}}static fromInlineText(content){return{content,contentType:"text/plain"}}static fromInlineYaml(content){return{content,contentType:"application/x-yaml"}}}exports.ConfigurationContent=ConfigurationContent,_e=JSII_RTTI_SYMBOL_1,ConfigurationContent[_e]={fqn:"aws-cdk-lib.aws_appconfig.ConfigurationContent",version:"2.188.0"};class ConfigurationSource{static fromBucket(bucket,objectKey,key){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings().aws_cdk_lib_aws_kms_IKey(key)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromBucket),error}return{locationUri:bucket.s3UrlForObject(objectKey),type:ConfigurationSourceType.S3,key}}static fromSecret(secret){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_secretsmanager_ISecret(secret)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecret),error}return{locationUri:secret.secretArn,type:ConfigurationSourceType.SECRETS_MANAGER,key:secret.encryptionKey}}static fromParameter(parameter,key){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_IParameter(parameter),jsiiDeprecationWarnings().aws_cdk_lib_aws_kms_IKey(key)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromParameter),error}return{locationUri:parameter.parameterArn,type:ConfigurationSourceType.SSM_PARAMETER,key}}static fromCfnDocument(document){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_CfnDocument(document)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCfnDocument),error}return{locationUri:`ssm-document://${document.ref}`,type:ConfigurationSourceType.SSM_DOCUMENT}}static fromPipeline(pipeline){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codepipeline_IPipeline(pipeline)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromPipeline),error}return{locationUri:`codepipeline://${pipeline.pipelineName}`,type:ConfigurationSourceType.CODE_PIPELINE}}}exports.ConfigurationSource=ConfigurationSource,_f=JSII_RTTI_SYMBOL_1,ConfigurationSource[_f]={fqn:"aws-cdk-lib.aws_appconfig.ConfigurationSource",version:"2.188.0"};
