"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Application=exports.Platform=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var appconfig_generated_1=()=>{var tmp=require("./appconfig.generated");return appconfig_generated_1=()=>tmp,tmp},configuration_1=()=>{var tmp=require("./configuration");return configuration_1=()=>tmp,tmp},environment_1=()=>{var tmp=require("./environment");return environment_1=()=>tmp,tmp},extension_1=()=>{var tmp=require("./extension");return extension_1=()=>tmp,tmp},ecs=()=>{var tmp=require("../../aws-ecs");return ecs=()=>tmp,tmp},cdk=()=>{var tmp=require("../../core");return cdk=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},Platform;(function(Platform2){Platform2.X86_64="x86-64",Platform2.ARM_64="ARM64"})(Platform||(exports.Platform=Platform={}));class ApplicationBase extends cdk().Resource{constructor(){super(...arguments),this._environments=[]}addEnvironment(id,options={}){return new(environment_1()).Environment(this,id,{application:this,...options})}addHostedConfiguration(id,options){return new(configuration_1()).HostedConfiguration(this,id,{application:this,...options})}addSourcedConfiguration(id,options){return new(configuration_1()).SourcedConfiguration(this,id,{application:this,...options})}addExistingEnvironment(environment){this._environments.push(environment)}environments(){return this._environments}on(actionPoint,eventDestination,options){this.extensible.on(actionPoint,eventDestination,options)}preCreateHostedConfigurationVersion(eventDestination,options){this.extensible.preCreateHostedConfigurationVersion(eventDestination,options)}preStartDeployment(eventDestination,options){this.extensible.preStartDeployment(eventDestination,options)}onDeploymentStart(eventDestination,options){this.extensible.onDeploymentStart(eventDestination,options)}onDeploymentStep(eventDestination,options){this.extensible.onDeploymentStep(eventDestination,options)}onDeploymentBaking(eventDestination,options){this.extensible.onDeploymentBaking(eventDestination,options)}onDeploymentComplete(eventDestination,options){this.extensible.onDeploymentComplete(eventDestination,options)}onDeploymentRolledBack(eventDestination,options){this.extensible.onDeploymentRolledBack(eventDestination,options)}atDeploymentTick(eventDestination,options){this.extensible.atDeploymentTick(eventDestination,options)}addExtension(extension){this.extensible.addExtension(extension)}}class Application extends ApplicationBase{static fromApplicationArn(scope,id,applicationArn){const applicationId=cdk().Stack.of(scope).splitArn(applicationArn,cdk().ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!applicationId)throw new(cdk()).ValidationError("Missing required application id from application ARN",scope);class Import extends ApplicationBase{constructor(){super(...arguments),this.applicationId=applicationId,this.applicationArn=applicationArn,this.extensible=new(extension_1()).ExtensibleBase(scope,this.applicationArn)}}return new Import(scope,id)}static fromApplicationId(scope,id,applicationId){const applicationArn=cdk().Stack.of(scope).formatArn({service:"appconfig",resource:"application",resourceName:applicationId});class Import extends ApplicationBase{constructor(){super(...arguments),this.applicationId=applicationId,this.applicationArn=applicationArn,this.extensible=new(extension_1()).ExtensibleBase(scope,this.applicationArn)}}return new Import(scope,id)}static getLambdaLayerVersionArn(region,platform){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_Platform(platform)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getLambdaLayerVersionArn),error}return lambdaLayerVersions[platform||Platform.X86_64][region]}static addAgentToEcs(taskDef){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecs_TaskDefinition(taskDef)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAgentToEcs),error}taskDef.addContainer("AppConfigAgentContainer",{image:ecs().ContainerImage.fromRegistry("public.ecr.aws/aws-appconfig/aws-appconfig-agent:latest"),containerName:"AppConfigAgentContainer"})}constructor(scope,id,props={}){super(scope,id);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_appconfig_ApplicationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Application),error}(0,metadata_resource_1().addConstructMetadata)(this,props),this.description=props.description,this.name=props.applicationName||cdk().Names.uniqueResourceName(this,{maxLength:64,separator:"-"}),this._application=new(appconfig_generated_1()).CfnApplication(this,"Resource",{name:this.name,description:this.description}),this.applicationId=this._application.ref,this.applicationArn=cdk().Stack.of(this).formatArn({service:"appconfig",resource:"application",resourceName:this.applicationId}),this.extensible=new(extension_1()).ExtensibleBase(this,this.applicationArn,this.name)}}exports.Application=Application,_a=JSII_RTTI_SYMBOL_1,Application[_a]={fqn:"aws-cdk-lib.aws_appconfig.Application",version:"2.188.0"};const lambdaLayerVersions={[Platform.X86_64]:{"us-east-1":"arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension:128","us-east-2":"arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension:93","us-west-1":"arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension:141","us-west-2":"arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension:161","ca-central-1":"arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension:93","eu-central-1":"arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension:106","eu-central-2":"arn:aws:lambda:eu-central-2:758369105281:layer:AWS-AppConfig-Extension:47","eu-west-1":"arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension:125","eu-west-2":"arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension:93","eu-west-3":"arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension:98","eu-north-1":"arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension:159","eu-south-1":"arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension:83","eu-south-2":"arn:aws:lambda:eu-south-2:586093569114:layer:AWS-AppConfig-Extension:44","cn-north-1":"arn:aws-cn:lambda:cn-north-1:615057806174:layer:AWS-AppConfig-Extension:76","cn-northwest-1":"arn:aws-cn:lambda:cn-northwest-1:615084187847:layer:AWS-AppConfig-Extension:76","ap-east-1":"arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension:83","ap-northeast-1":"arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension:98","ap-northeast-2":"arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension:108","ap-northeast-3":"arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension:101","ap-southeast-1":"arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension:106","ap-southeast-2":"arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension:106","ap-southeast-3":"arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension:79","ap-southeast-4":"arn:aws:lambda:ap-southeast-4:307021474294:layer:AWS-AppConfig-Extension:20","ap-south-1":"arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension:107","ap-south-2":"arn:aws:lambda:ap-south-2:489524808438:layer:AWS-AppConfig-Extension:47","sa-east-1":"arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension:128","af-south-1":"arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension:83","il-central-1":"arn:aws:lambda:il-central-1:895787185223:layer:AWS-AppConfig-Extension:22","me-central-1":"arn:aws:lambda:me-central-1:662846165436:layer:AWS-AppConfig-Extension:49","me-south-1":"arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension:85","us-gov-east-1":"arn:aws-us-gov:lambda:us-gov-east-1:946561847325:layer:AWS-AppConfig-Extension:54","us-gov-west-1":"arn:aws-us-gov:lambda:us-gov-west-1:946746059096:layer:AWS-AppConfig-Extension:54"},[Platform.ARM_64]:{"us-east-1":"arn:aws:lambda:us-east-1:027255383542:layer:AWS-AppConfig-Extension-Arm64:61","us-east-2":"arn:aws:lambda:us-east-2:728743619870:layer:AWS-AppConfig-Extension-Arm64:45","us-west-1":"arn:aws:lambda:us-west-1:958113053741:layer:AWS-AppConfig-Extension-Arm64:18","us-west-2":"arn:aws:lambda:us-west-2:359756378197:layer:AWS-AppConfig-Extension-Arm64:63","ca-central-1":"arn:aws:lambda:ca-central-1:039592058896:layer:AWS-AppConfig-Extension-Arm64:13","eu-central-1":"arn:aws:lambda:eu-central-1:066940009817:layer:AWS-AppConfig-Extension-Arm64:49","eu-central-2":"arn:aws:lambda:eu-central-2:758369105281:layer:AWS-AppConfig-Extension-Arm64:5","eu-west-1":"arn:aws:lambda:eu-west-1:434848589818:layer:AWS-AppConfig-Extension-Arm64:63","eu-west-2":"arn:aws:lambda:eu-west-2:282860088358:layer:AWS-AppConfig-Extension-Arm64:45","eu-west-3":"arn:aws:lambda:eu-west-3:493207061005:layer:AWS-AppConfig-Extension-Arm64:17","eu-north-1":"arn:aws:lambda:eu-north-1:646970417810:layer:AWS-AppConfig-Extension-Arm64:18","eu-south-1":"arn:aws:lambda:eu-south-1:203683718741:layer:AWS-AppConfig-Extension-Arm64:11","eu-south-2":"arn:aws:lambda:eu-south-2:586093569114:layer:AWS-AppConfig-Extension-Arm64:5","ap-east-1":"arn:aws:lambda:ap-east-1:630222743974:layer:AWS-AppConfig-Extension-Arm64:11","ap-northeast-1":"arn:aws:lambda:ap-northeast-1:980059726660:layer:AWS-AppConfig-Extension-Arm64:51","ap-northeast-2":"arn:aws:lambda:ap-northeast-2:826293736237:layer:AWS-AppConfig-Extension-Arm64:16","ap-northeast-3":"arn:aws:lambda:ap-northeast-3:706869817123:layer:AWS-AppConfig-Extension-Arm64:16","ap-southeast-1":"arn:aws:lambda:ap-southeast-1:421114256042:layer:AWS-AppConfig-Extension-Arm64:58","ap-southeast-2":"arn:aws:lambda:ap-southeast-2:080788657173:layer:AWS-AppConfig-Extension-Arm64:49","ap-southeast-3":"arn:aws:lambda:ap-southeast-3:418787028745:layer:AWS-AppConfig-Extension-Arm64:16","ap-southeast-4":"arn:aws:lambda:ap-southeast-4:307021474294:layer:AWS-AppConfig-Extension-Arm64:5","ap-south-1":"arn:aws:lambda:ap-south-1:554480029851:layer:AWS-AppConfig-Extension-Arm64:49","ap-south-2":"arn:aws:lambda:ap-south-2:489524808438:layer:AWS-AppConfig-Extension-Arm64:5","sa-east-1":"arn:aws:lambda:sa-east-1:000010852771:layer:AWS-AppConfig-Extension-Arm64:16","af-south-1":"arn:aws:lambda:af-south-1:574348263942:layer:AWS-AppConfig-Extension-Arm64:11","me-central-1":"arn:aws:lambda:me-central-1:662846165436:layer:AWS-AppConfig-Extension-Arm64:5","me-south-1":"arn:aws:lambda:me-south-1:559955524753:layer:AWS-AppConfig-Extension-Arm64:13","il-central-1":"arn:aws:lambda:il-central-1:895787185223:layer:AWS-AppConfig-Extension-Arm64:5"}};
