import * as apigwv2 from '../../../aws-apigatewayv2';
import * as sqs from '../../../aws-sqs';
/**
 * Properties to initialize `HttpSqsIntegration`.
 */
export interface HttpSqsIntegrationProps {
    /**
     * Specifies how to transform HTTP requests before sending them to the backend.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html#http-api-develop-integrations-aws-services-parameter-mapping
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html
     *
     * @default - specify `QueueUrl`. Additionally, set `MessageBody` to `$request.body.MessageBody` for `SQS_SEND_MESSAGE` subtype
     * and set `ReceiptHandle` to `$request.body.ReceiptHandle` for `SQS_DELETE_MESSAGE` subtype.
     */
    readonly parameterMapping?: apigwv2.ParameterMapping;
    /**
     * The subtype of the HTTP integration.
     *
     * Only subtypes starting with SQS_ can be specified.
     *
     * @default HttpIntegrationSubtype.SQS_SEND_MESSAGE
     */
    readonly subtype?: apigwv2.HttpIntegrationSubtype;
    /**
     * SQS queue that Integrates with API Gateway
     */
    readonly queue: sqs.IQueue;
}
/**
 * The Sqs integration resource for HTTP API
 */
export declare class HttpSqsIntegration extends apigwv2.HttpRouteIntegration {
    private readonly props;
    private readonly subtype;
    /**
     * @param id id of the underlying integration construct
     * @param props properties to configure the integration
     */
    constructor(id: string, props: HttpSqsIntegrationProps);
    bind(options: apigwv2.HttpRouteIntegrationBindOptions): apigwv2.HttpRouteIntegrationConfig;
    private determineActionBySubtype;
    private createDefaultParameterMapping;
}
