/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  DockerServiceConnection,
  DockerServiceConnectionRequest,
  GenericError,
  KubernetesServiceConnection,
  KubernetesServiceConnectionRequest,
  LDAPOutpostConfig,
  Outpost,
  OutpostDefaultConfig,
  OutpostHealth,
  OutpostRequest,
  PaginatedDockerServiceConnectionList,
  PaginatedKubernetesServiceConnectionList,
  PaginatedLDAPOutpostConfigList,
  PaginatedOutpostList,
  PaginatedProxyOutpostConfigList,
  PaginatedRadiusOutpostConfigList,
  PaginatedServiceConnectionList,
  PatchedDockerServiceConnectionRequest,
  PatchedKubernetesServiceConnectionRequest,
  PatchedOutpostRequest,
  ProxyOutpostConfig,
  RadiusOutpostConfig,
  ServiceConnection,
  ServiceConnectionState,
  TypeCreate,
  UsedBy,
  ValidationError,
} from '../models';
import {
    DockerServiceConnectionFromJSON,
    DockerServiceConnectionToJSON,
    DockerServiceConnectionRequestFromJSON,
    DockerServiceConnectionRequestToJSON,
    GenericErrorFromJSON,
    GenericErrorToJSON,
    KubernetesServiceConnectionFromJSON,
    KubernetesServiceConnectionToJSON,
    KubernetesServiceConnectionRequestFromJSON,
    KubernetesServiceConnectionRequestToJSON,
    LDAPOutpostConfigFromJSON,
    LDAPOutpostConfigToJSON,
    OutpostFromJSON,
    OutpostToJSON,
    OutpostDefaultConfigFromJSON,
    OutpostDefaultConfigToJSON,
    OutpostHealthFromJSON,
    OutpostHealthToJSON,
    OutpostRequestFromJSON,
    OutpostRequestToJSON,
    PaginatedDockerServiceConnectionListFromJSON,
    PaginatedDockerServiceConnectionListToJSON,
    PaginatedKubernetesServiceConnectionListFromJSON,
    PaginatedKubernetesServiceConnectionListToJSON,
    PaginatedLDAPOutpostConfigListFromJSON,
    PaginatedLDAPOutpostConfigListToJSON,
    PaginatedOutpostListFromJSON,
    PaginatedOutpostListToJSON,
    PaginatedProxyOutpostConfigListFromJSON,
    PaginatedProxyOutpostConfigListToJSON,
    PaginatedRadiusOutpostConfigListFromJSON,
    PaginatedRadiusOutpostConfigListToJSON,
    PaginatedServiceConnectionListFromJSON,
    PaginatedServiceConnectionListToJSON,
    PatchedDockerServiceConnectionRequestFromJSON,
    PatchedDockerServiceConnectionRequestToJSON,
    PatchedKubernetesServiceConnectionRequestFromJSON,
    PatchedKubernetesServiceConnectionRequestToJSON,
    PatchedOutpostRequestFromJSON,
    PatchedOutpostRequestToJSON,
    ProxyOutpostConfigFromJSON,
    ProxyOutpostConfigToJSON,
    RadiusOutpostConfigFromJSON,
    RadiusOutpostConfigToJSON,
    ServiceConnectionFromJSON,
    ServiceConnectionToJSON,
    ServiceConnectionStateFromJSON,
    ServiceConnectionStateToJSON,
    TypeCreateFromJSON,
    TypeCreateToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface OutpostsInstancesCreateRequest {
    outpostRequest: OutpostRequest;
}

export interface OutpostsInstancesDestroyRequest {
    uuid: string;
}

export interface OutpostsInstancesHealthListRequest {
    uuid: string;
    managedIcontains?: string;
    managedIexact?: string;
    nameIcontains?: string;
    nameIexact?: string;
    ordering?: string;
    providersIsnull?: boolean;
    providersByPk?: Array<number>;
    search?: string;
    serviceConnectionNameIcontains?: string;
    serviceConnectionNameIexact?: string;
}

export interface OutpostsInstancesListRequest {
    managedIcontains?: string;
    managedIexact?: string;
    nameIcontains?: string;
    nameIexact?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    providersIsnull?: boolean;
    providersByPk?: Array<number>;
    search?: string;
    serviceConnectionNameIcontains?: string;
    serviceConnectionNameIexact?: string;
}

export interface OutpostsInstancesPartialUpdateRequest {
    uuid: string;
    patchedOutpostRequest?: PatchedOutpostRequest;
}

export interface OutpostsInstancesRetrieveRequest {
    uuid: string;
}

export interface OutpostsInstancesUpdateRequest {
    uuid: string;
    outpostRequest: OutpostRequest;
}

export interface OutpostsInstancesUsedByListRequest {
    uuid: string;
}

export interface OutpostsLdapListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface OutpostsLdapRetrieveRequest {
    id: number;
}

export interface OutpostsProxyListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface OutpostsProxyRetrieveRequest {
    id: number;
}

export interface OutpostsRadiusListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface OutpostsRadiusRetrieveRequest {
    id: number;
}

export interface OutpostsServiceConnectionsAllDestroyRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsAllListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface OutpostsServiceConnectionsAllRetrieveRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsAllStateRetrieveRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsAllUsedByListRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsDockerCreateRequest {
    dockerServiceConnectionRequest: DockerServiceConnectionRequest;
}

export interface OutpostsServiceConnectionsDockerDestroyRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsDockerListRequest {
    local?: boolean;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    tlsAuthentication?: string;
    tlsVerification?: string;
    url?: string;
}

export interface OutpostsServiceConnectionsDockerPartialUpdateRequest {
    uuid: string;
    patchedDockerServiceConnectionRequest?: PatchedDockerServiceConnectionRequest;
}

export interface OutpostsServiceConnectionsDockerRetrieveRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsDockerUpdateRequest {
    uuid: string;
    dockerServiceConnectionRequest: DockerServiceConnectionRequest;
}

export interface OutpostsServiceConnectionsDockerUsedByListRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsKubernetesCreateRequest {
    kubernetesServiceConnectionRequest: KubernetesServiceConnectionRequest;
}

export interface OutpostsServiceConnectionsKubernetesDestroyRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsKubernetesListRequest {
    local?: boolean;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface OutpostsServiceConnectionsKubernetesPartialUpdateRequest {
    uuid: string;
    patchedKubernetesServiceConnectionRequest?: PatchedKubernetesServiceConnectionRequest;
}

export interface OutpostsServiceConnectionsKubernetesRetrieveRequest {
    uuid: string;
}

export interface OutpostsServiceConnectionsKubernetesUpdateRequest {
    uuid: string;
    kubernetesServiceConnectionRequest: KubernetesServiceConnectionRequest;
}

export interface OutpostsServiceConnectionsKubernetesUsedByListRequest {
    uuid: string;
}

/**
 * 
 */
export class OutpostsApi extends runtime.BaseAPI {

    /**
     * Outpost Viewset
     */
    async outpostsInstancesCreateRaw(requestParameters: OutpostsInstancesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Outpost>> {
        if (requestParameters.outpostRequest === null || requestParameters.outpostRequest === undefined) {
            throw new runtime.RequiredError('outpostRequest','Required parameter requestParameters.outpostRequest was null or undefined when calling outpostsInstancesCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: OutpostRequestToJSON(requestParameters.outpostRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => OutpostFromJSON(jsonValue));
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesCreate(requestParameters: OutpostsInstancesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Outpost> {
        const response = await this.outpostsInstancesCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Global default outpost config
     */
    async outpostsInstancesDefaultSettingsRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<OutpostDefaultConfig>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/default_settings/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => OutpostDefaultConfigFromJSON(jsonValue));
    }

    /**
     * Global default outpost config
     */
    async outpostsInstancesDefaultSettingsRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<OutpostDefaultConfig> {
        const response = await this.outpostsInstancesDefaultSettingsRetrieveRaw(initOverrides);
        return await response.value();
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesDestroyRaw(requestParameters: OutpostsInstancesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsInstancesDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesDestroy(requestParameters: OutpostsInstancesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.outpostsInstancesDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Get outposts current health
     */
    async outpostsInstancesHealthListRaw(requestParameters: OutpostsInstancesHealthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<OutpostHealth>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsInstancesHealthList.');
        }

        const queryParameters: any = {};

        if (requestParameters.managedIcontains !== undefined) {
            queryParameters['managed__icontains'] = requestParameters.managedIcontains;
        }

        if (requestParameters.managedIexact !== undefined) {
            queryParameters['managed__iexact'] = requestParameters.managedIexact;
        }

        if (requestParameters.nameIcontains !== undefined) {
            queryParameters['name__icontains'] = requestParameters.nameIcontains;
        }

        if (requestParameters.nameIexact !== undefined) {
            queryParameters['name__iexact'] = requestParameters.nameIexact;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.providersIsnull !== undefined) {
            queryParameters['providers__isnull'] = requestParameters.providersIsnull;
        }

        if (requestParameters.providersByPk) {
            queryParameters['providers_by_pk'] = requestParameters.providersByPk;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.serviceConnectionNameIcontains !== undefined) {
            queryParameters['service_connection__name__icontains'] = requestParameters.serviceConnectionNameIcontains;
        }

        if (requestParameters.serviceConnectionNameIexact !== undefined) {
            queryParameters['service_connection__name__iexact'] = requestParameters.serviceConnectionNameIexact;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/{uuid}/health/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(OutpostHealthFromJSON));
    }

    /**
     * Get outposts current health
     */
    async outpostsInstancesHealthList(requestParameters: OutpostsInstancesHealthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<OutpostHealth>> {
        const response = await this.outpostsInstancesHealthListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesListRaw(requestParameters: OutpostsInstancesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedOutpostList>> {
        const queryParameters: any = {};

        if (requestParameters.managedIcontains !== undefined) {
            queryParameters['managed__icontains'] = requestParameters.managedIcontains;
        }

        if (requestParameters.managedIexact !== undefined) {
            queryParameters['managed__iexact'] = requestParameters.managedIexact;
        }

        if (requestParameters.nameIcontains !== undefined) {
            queryParameters['name__icontains'] = requestParameters.nameIcontains;
        }

        if (requestParameters.nameIexact !== undefined) {
            queryParameters['name__iexact'] = requestParameters.nameIexact;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.providersIsnull !== undefined) {
            queryParameters['providers__isnull'] = requestParameters.providersIsnull;
        }

        if (requestParameters.providersByPk) {
            queryParameters['providers_by_pk'] = requestParameters.providersByPk;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.serviceConnectionNameIcontains !== undefined) {
            queryParameters['service_connection__name__icontains'] = requestParameters.serviceConnectionNameIcontains;
        }

        if (requestParameters.serviceConnectionNameIexact !== undefined) {
            queryParameters['service_connection__name__iexact'] = requestParameters.serviceConnectionNameIexact;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedOutpostListFromJSON(jsonValue));
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesList(requestParameters: OutpostsInstancesListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedOutpostList> {
        const response = await this.outpostsInstancesListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesPartialUpdateRaw(requestParameters: OutpostsInstancesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Outpost>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsInstancesPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedOutpostRequestToJSON(requestParameters.patchedOutpostRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => OutpostFromJSON(jsonValue));
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesPartialUpdate(requestParameters: OutpostsInstancesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Outpost> {
        const response = await this.outpostsInstancesPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesRetrieveRaw(requestParameters: OutpostsInstancesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Outpost>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsInstancesRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => OutpostFromJSON(jsonValue));
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesRetrieve(requestParameters: OutpostsInstancesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Outpost> {
        const response = await this.outpostsInstancesRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesUpdateRaw(requestParameters: OutpostsInstancesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Outpost>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsInstancesUpdate.');
        }

        if (requestParameters.outpostRequest === null || requestParameters.outpostRequest === undefined) {
            throw new runtime.RequiredError('outpostRequest','Required parameter requestParameters.outpostRequest was null or undefined when calling outpostsInstancesUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: OutpostRequestToJSON(requestParameters.outpostRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => OutpostFromJSON(jsonValue));
    }

    /**
     * Outpost Viewset
     */
    async outpostsInstancesUpdate(requestParameters: OutpostsInstancesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Outpost> {
        const response = await this.outpostsInstancesUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsInstancesUsedByListRaw(requestParameters: OutpostsInstancesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsInstancesUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/instances/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsInstancesUsedByList(requestParameters: OutpostsInstancesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.outpostsInstancesUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * LDAPProvider Viewset
     */
    async outpostsLdapListRaw(requestParameters: OutpostsLdapListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedLDAPOutpostConfigList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/ldap/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedLDAPOutpostConfigListFromJSON(jsonValue));
    }

    /**
     * LDAPProvider Viewset
     */
    async outpostsLdapList(requestParameters: OutpostsLdapListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedLDAPOutpostConfigList> {
        const response = await this.outpostsLdapListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * LDAPProvider Viewset
     */
    async outpostsLdapRetrieveRaw(requestParameters: OutpostsLdapRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LDAPOutpostConfig>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling outpostsLdapRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/ldap/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LDAPOutpostConfigFromJSON(jsonValue));
    }

    /**
     * LDAPProvider Viewset
     */
    async outpostsLdapRetrieve(requestParameters: OutpostsLdapRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LDAPOutpostConfig> {
        const response = await this.outpostsLdapRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ProxyProvider Viewset
     */
    async outpostsProxyListRaw(requestParameters: OutpostsProxyListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedProxyOutpostConfigList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/proxy/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedProxyOutpostConfigListFromJSON(jsonValue));
    }

    /**
     * ProxyProvider Viewset
     */
    async outpostsProxyList(requestParameters: OutpostsProxyListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedProxyOutpostConfigList> {
        const response = await this.outpostsProxyListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ProxyProvider Viewset
     */
    async outpostsProxyRetrieveRaw(requestParameters: OutpostsProxyRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ProxyOutpostConfig>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling outpostsProxyRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/proxy/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ProxyOutpostConfigFromJSON(jsonValue));
    }

    /**
     * ProxyProvider Viewset
     */
    async outpostsProxyRetrieve(requestParameters: OutpostsProxyRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ProxyOutpostConfig> {
        const response = await this.outpostsProxyRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * RadiusProvider Viewset
     */
    async outpostsRadiusListRaw(requestParameters: OutpostsRadiusListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedRadiusOutpostConfigList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/radius/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedRadiusOutpostConfigListFromJSON(jsonValue));
    }

    /**
     * RadiusProvider Viewset
     */
    async outpostsRadiusList(requestParameters: OutpostsRadiusListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedRadiusOutpostConfigList> {
        const response = await this.outpostsRadiusListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * RadiusProvider Viewset
     */
    async outpostsRadiusRetrieveRaw(requestParameters: OutpostsRadiusRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RadiusOutpostConfig>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling outpostsRadiusRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/radius/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RadiusOutpostConfigFromJSON(jsonValue));
    }

    /**
     * RadiusProvider Viewset
     */
    async outpostsRadiusRetrieve(requestParameters: OutpostsRadiusRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RadiusOutpostConfig> {
        const response = await this.outpostsRadiusRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ServiceConnection Viewset
     */
    async outpostsServiceConnectionsAllDestroyRaw(requestParameters: OutpostsServiceConnectionsAllDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsAllDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/all/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * ServiceConnection Viewset
     */
    async outpostsServiceConnectionsAllDestroy(requestParameters: OutpostsServiceConnectionsAllDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.outpostsServiceConnectionsAllDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * ServiceConnection Viewset
     */
    async outpostsServiceConnectionsAllListRaw(requestParameters: OutpostsServiceConnectionsAllListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedServiceConnectionList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/all/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedServiceConnectionListFromJSON(jsonValue));
    }

    /**
     * ServiceConnection Viewset
     */
    async outpostsServiceConnectionsAllList(requestParameters: OutpostsServiceConnectionsAllListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedServiceConnectionList> {
        const response = await this.outpostsServiceConnectionsAllListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ServiceConnection Viewset
     */
    async outpostsServiceConnectionsAllRetrieveRaw(requestParameters: OutpostsServiceConnectionsAllRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ServiceConnection>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsAllRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/all/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ServiceConnectionFromJSON(jsonValue));
    }

    /**
     * ServiceConnection Viewset
     */
    async outpostsServiceConnectionsAllRetrieve(requestParameters: OutpostsServiceConnectionsAllRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ServiceConnection> {
        const response = await this.outpostsServiceConnectionsAllRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the service connection\'s state
     */
    async outpostsServiceConnectionsAllStateRetrieveRaw(requestParameters: OutpostsServiceConnectionsAllStateRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ServiceConnectionState>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsAllStateRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/all/{uuid}/state/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ServiceConnectionStateFromJSON(jsonValue));
    }

    /**
     * Get the service connection\'s state
     */
    async outpostsServiceConnectionsAllStateRetrieve(requestParameters: OutpostsServiceConnectionsAllStateRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ServiceConnectionState> {
        const response = await this.outpostsServiceConnectionsAllStateRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get all creatable types
     */
    async outpostsServiceConnectionsAllTypesListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<TypeCreate>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/all/types/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(TypeCreateFromJSON));
    }

    /**
     * Get all creatable types
     */
    async outpostsServiceConnectionsAllTypesList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<TypeCreate>> {
        const response = await this.outpostsServiceConnectionsAllTypesListRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsServiceConnectionsAllUsedByListRaw(requestParameters: OutpostsServiceConnectionsAllUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsAllUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/all/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsServiceConnectionsAllUsedByList(requestParameters: OutpostsServiceConnectionsAllUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.outpostsServiceConnectionsAllUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerCreateRaw(requestParameters: OutpostsServiceConnectionsDockerCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DockerServiceConnection>> {
        if (requestParameters.dockerServiceConnectionRequest === null || requestParameters.dockerServiceConnectionRequest === undefined) {
            throw new runtime.RequiredError('dockerServiceConnectionRequest','Required parameter requestParameters.dockerServiceConnectionRequest was null or undefined when calling outpostsServiceConnectionsDockerCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/docker/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: DockerServiceConnectionRequestToJSON(requestParameters.dockerServiceConnectionRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DockerServiceConnectionFromJSON(jsonValue));
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerCreate(requestParameters: OutpostsServiceConnectionsDockerCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DockerServiceConnection> {
        const response = await this.outpostsServiceConnectionsDockerCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerDestroyRaw(requestParameters: OutpostsServiceConnectionsDockerDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsDockerDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/docker/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerDestroy(requestParameters: OutpostsServiceConnectionsDockerDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.outpostsServiceConnectionsDockerDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerListRaw(requestParameters: OutpostsServiceConnectionsDockerListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedDockerServiceConnectionList>> {
        const queryParameters: any = {};

        if (requestParameters.local !== undefined) {
            queryParameters['local'] = requestParameters.local;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.tlsAuthentication !== undefined) {
            queryParameters['tls_authentication'] = requestParameters.tlsAuthentication;
        }

        if (requestParameters.tlsVerification !== undefined) {
            queryParameters['tls_verification'] = requestParameters.tlsVerification;
        }

        if (requestParameters.url !== undefined) {
            queryParameters['url'] = requestParameters.url;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/docker/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedDockerServiceConnectionListFromJSON(jsonValue));
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerList(requestParameters: OutpostsServiceConnectionsDockerListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedDockerServiceConnectionList> {
        const response = await this.outpostsServiceConnectionsDockerListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerPartialUpdateRaw(requestParameters: OutpostsServiceConnectionsDockerPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DockerServiceConnection>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsDockerPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/docker/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedDockerServiceConnectionRequestToJSON(requestParameters.patchedDockerServiceConnectionRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DockerServiceConnectionFromJSON(jsonValue));
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerPartialUpdate(requestParameters: OutpostsServiceConnectionsDockerPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DockerServiceConnection> {
        const response = await this.outpostsServiceConnectionsDockerPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerRetrieveRaw(requestParameters: OutpostsServiceConnectionsDockerRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DockerServiceConnection>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsDockerRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/docker/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DockerServiceConnectionFromJSON(jsonValue));
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerRetrieve(requestParameters: OutpostsServiceConnectionsDockerRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DockerServiceConnection> {
        const response = await this.outpostsServiceConnectionsDockerRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerUpdateRaw(requestParameters: OutpostsServiceConnectionsDockerUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DockerServiceConnection>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsDockerUpdate.');
        }

        if (requestParameters.dockerServiceConnectionRequest === null || requestParameters.dockerServiceConnectionRequest === undefined) {
            throw new runtime.RequiredError('dockerServiceConnectionRequest','Required parameter requestParameters.dockerServiceConnectionRequest was null or undefined when calling outpostsServiceConnectionsDockerUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/docker/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: DockerServiceConnectionRequestToJSON(requestParameters.dockerServiceConnectionRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DockerServiceConnectionFromJSON(jsonValue));
    }

    /**
     * DockerServiceConnection Viewset
     */
    async outpostsServiceConnectionsDockerUpdate(requestParameters: OutpostsServiceConnectionsDockerUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DockerServiceConnection> {
        const response = await this.outpostsServiceConnectionsDockerUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsServiceConnectionsDockerUsedByListRaw(requestParameters: OutpostsServiceConnectionsDockerUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsDockerUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/docker/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsServiceConnectionsDockerUsedByList(requestParameters: OutpostsServiceConnectionsDockerUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.outpostsServiceConnectionsDockerUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesCreateRaw(requestParameters: OutpostsServiceConnectionsKubernetesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<KubernetesServiceConnection>> {
        if (requestParameters.kubernetesServiceConnectionRequest === null || requestParameters.kubernetesServiceConnectionRequest === undefined) {
            throw new runtime.RequiredError('kubernetesServiceConnectionRequest','Required parameter requestParameters.kubernetesServiceConnectionRequest was null or undefined when calling outpostsServiceConnectionsKubernetesCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/kubernetes/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: KubernetesServiceConnectionRequestToJSON(requestParameters.kubernetesServiceConnectionRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => KubernetesServiceConnectionFromJSON(jsonValue));
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesCreate(requestParameters: OutpostsServiceConnectionsKubernetesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<KubernetesServiceConnection> {
        const response = await this.outpostsServiceConnectionsKubernetesCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesDestroyRaw(requestParameters: OutpostsServiceConnectionsKubernetesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsKubernetesDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/kubernetes/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesDestroy(requestParameters: OutpostsServiceConnectionsKubernetesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.outpostsServiceConnectionsKubernetesDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesListRaw(requestParameters: OutpostsServiceConnectionsKubernetesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedKubernetesServiceConnectionList>> {
        const queryParameters: any = {};

        if (requestParameters.local !== undefined) {
            queryParameters['local'] = requestParameters.local;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/kubernetes/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedKubernetesServiceConnectionListFromJSON(jsonValue));
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesList(requestParameters: OutpostsServiceConnectionsKubernetesListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedKubernetesServiceConnectionList> {
        const response = await this.outpostsServiceConnectionsKubernetesListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesPartialUpdateRaw(requestParameters: OutpostsServiceConnectionsKubernetesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<KubernetesServiceConnection>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsKubernetesPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/kubernetes/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedKubernetesServiceConnectionRequestToJSON(requestParameters.patchedKubernetesServiceConnectionRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => KubernetesServiceConnectionFromJSON(jsonValue));
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesPartialUpdate(requestParameters: OutpostsServiceConnectionsKubernetesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<KubernetesServiceConnection> {
        const response = await this.outpostsServiceConnectionsKubernetesPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesRetrieveRaw(requestParameters: OutpostsServiceConnectionsKubernetesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<KubernetesServiceConnection>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsKubernetesRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/kubernetes/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => KubernetesServiceConnectionFromJSON(jsonValue));
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesRetrieve(requestParameters: OutpostsServiceConnectionsKubernetesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<KubernetesServiceConnection> {
        const response = await this.outpostsServiceConnectionsKubernetesRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesUpdateRaw(requestParameters: OutpostsServiceConnectionsKubernetesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<KubernetesServiceConnection>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsKubernetesUpdate.');
        }

        if (requestParameters.kubernetesServiceConnectionRequest === null || requestParameters.kubernetesServiceConnectionRequest === undefined) {
            throw new runtime.RequiredError('kubernetesServiceConnectionRequest','Required parameter requestParameters.kubernetesServiceConnectionRequest was null or undefined when calling outpostsServiceConnectionsKubernetesUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/kubernetes/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: KubernetesServiceConnectionRequestToJSON(requestParameters.kubernetesServiceConnectionRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => KubernetesServiceConnectionFromJSON(jsonValue));
    }

    /**
     * KubernetesServiceConnection Viewset
     */
    async outpostsServiceConnectionsKubernetesUpdate(requestParameters: OutpostsServiceConnectionsKubernetesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<KubernetesServiceConnection> {
        const response = await this.outpostsServiceConnectionsKubernetesUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsServiceConnectionsKubernetesUsedByListRaw(requestParameters: OutpostsServiceConnectionsKubernetesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling outpostsServiceConnectionsKubernetesUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/outposts/service_connections/kubernetes/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async outpostsServiceConnectionsKubernetesUsedByList(requestParameters: OutpostsServiceConnectionsKubernetesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.outpostsServiceConnectionsKubernetesUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
