/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Cache,
  ChallengeTypes,
  FilePathRequest,
  Flow,
  FlowChallengeResponseRequest,
  FlowDiagram,
  FlowImportResult,
  FlowInspection,
  FlowRequest,
  FlowStageBinding,
  FlowStageBindingRequest,
  GenericError,
  Link,
  PaginatedFlowList,
  PaginatedFlowStageBindingList,
  PatchedFlowRequest,
  PatchedFlowStageBindingRequest,
  UsedBy,
  ValidationError,
} from '../models';
import {
    CacheFromJSON,
    CacheToJSON,
    ChallengeTypesFromJSON,
    ChallengeTypesToJSON,
    FilePathRequestFromJSON,
    FilePathRequestToJSON,
    FlowFromJSON,
    FlowToJSON,
    FlowChallengeResponseRequestFromJSON,
    FlowChallengeResponseRequestToJSON,
    FlowDiagramFromJSON,
    FlowDiagramToJSON,
    FlowImportResultFromJSON,
    FlowImportResultToJSON,
    FlowInspectionFromJSON,
    FlowInspectionToJSON,
    FlowRequestFromJSON,
    FlowRequestToJSON,
    FlowStageBindingFromJSON,
    FlowStageBindingToJSON,
    FlowStageBindingRequestFromJSON,
    FlowStageBindingRequestToJSON,
    GenericErrorFromJSON,
    GenericErrorToJSON,
    LinkFromJSON,
    LinkToJSON,
    PaginatedFlowListFromJSON,
    PaginatedFlowListToJSON,
    PaginatedFlowStageBindingListFromJSON,
    PaginatedFlowStageBindingListToJSON,
    PatchedFlowRequestFromJSON,
    PatchedFlowRequestToJSON,
    PatchedFlowStageBindingRequestFromJSON,
    PatchedFlowStageBindingRequestToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface FlowsBindingsCreateRequest {
    flowStageBindingRequest: FlowStageBindingRequest;
}

export interface FlowsBindingsDestroyRequest {
    fsbUuid: string;
}

export interface FlowsBindingsListRequest {
    evaluateOnPlan?: boolean;
    fsbUuid?: string;
    invalidResponseAction?: FlowsBindingsListInvalidResponseActionEnum;
    order?: number;
    ordering?: string;
    page?: number;
    pageSize?: number;
    pbmUuid?: string;
    policies?: Array<string>;
    policyEngineMode?: FlowsBindingsListPolicyEngineModeEnum;
    reEvaluatePolicies?: boolean;
    search?: string;
    stage?: string;
    target?: string;
}

export interface FlowsBindingsPartialUpdateRequest {
    fsbUuid: string;
    patchedFlowStageBindingRequest?: PatchedFlowStageBindingRequest;
}

export interface FlowsBindingsRetrieveRequest {
    fsbUuid: string;
}

export interface FlowsBindingsUpdateRequest {
    fsbUuid: string;
    flowStageBindingRequest: FlowStageBindingRequest;
}

export interface FlowsBindingsUsedByListRequest {
    fsbUuid: string;
}

export interface FlowsExecutorGetRequest {
    flowSlug: string;
    query: string;
}

export interface FlowsExecutorSolveRequest {
    flowSlug: string;
    query: string;
    flowChallengeResponseRequest?: FlowChallengeResponseRequest;
}

export interface FlowsInspectorGetRequest {
    flowSlug: string;
}

export interface FlowsInstancesCreateRequest {
    flowRequest: FlowRequest;
}

export interface FlowsInstancesDestroyRequest {
    slug: string;
}

export interface FlowsInstancesDiagramRetrieveRequest {
    slug: string;
}

export interface FlowsInstancesExecuteRetrieveRequest {
    slug: string;
}

export interface FlowsInstancesExportRetrieveRequest {
    slug: string;
}

export interface FlowsInstancesImportCreateRequest {
    file?: Blob;
    clear?: boolean;
}

export interface FlowsInstancesListRequest {
    deniedAction?: FlowsInstancesListDeniedActionEnum;
    designation?: FlowsInstancesListDesignationEnum;
    flowUuid?: string;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    slug?: string;
}

export interface FlowsInstancesPartialUpdateRequest {
    slug: string;
    patchedFlowRequest?: PatchedFlowRequest;
}

export interface FlowsInstancesRetrieveRequest {
    slug: string;
}

export interface FlowsInstancesSetBackgroundCreateRequest {
    slug: string;
    file?: Blob;
    clear?: boolean;
}

export interface FlowsInstancesSetBackgroundUrlCreateRequest {
    slug: string;
    filePathRequest: FilePathRequest;
}

export interface FlowsInstancesUpdateRequest {
    slug: string;
    flowRequest: FlowRequest;
}

export interface FlowsInstancesUsedByListRequest {
    slug: string;
}

/**
 * 
 */
export class FlowsApi extends runtime.BaseAPI {

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsCreateRaw(requestParameters: FlowsBindingsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FlowStageBinding>> {
        if (requestParameters.flowStageBindingRequest === null || requestParameters.flowStageBindingRequest === undefined) {
            throw new runtime.RequiredError('flowStageBindingRequest','Required parameter requestParameters.flowStageBindingRequest was null or undefined when calling flowsBindingsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/bindings/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FlowStageBindingRequestToJSON(requestParameters.flowStageBindingRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowStageBindingFromJSON(jsonValue));
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsCreate(requestParameters: FlowsBindingsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FlowStageBinding> {
        const response = await this.flowsBindingsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsDestroyRaw(requestParameters: FlowsBindingsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.fsbUuid === null || requestParameters.fsbUuid === undefined) {
            throw new runtime.RequiredError('fsbUuid','Required parameter requestParameters.fsbUuid was null or undefined when calling flowsBindingsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/bindings/{fsb_uuid}/`.replace(`{${"fsb_uuid"}}`, encodeURIComponent(String(requestParameters.fsbUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsDestroy(requestParameters: FlowsBindingsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.flowsBindingsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsListRaw(requestParameters: FlowsBindingsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedFlowStageBindingList>> {
        const queryParameters: any = {};

        if (requestParameters.evaluateOnPlan !== undefined) {
            queryParameters['evaluate_on_plan'] = requestParameters.evaluateOnPlan;
        }

        if (requestParameters.fsbUuid !== undefined) {
            queryParameters['fsb_uuid'] = requestParameters.fsbUuid;
        }

        if (requestParameters.invalidResponseAction !== undefined) {
            queryParameters['invalid_response_action'] = requestParameters.invalidResponseAction;
        }

        if (requestParameters.order !== undefined) {
            queryParameters['order'] = requestParameters.order;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.pbmUuid !== undefined) {
            queryParameters['pbm_uuid'] = requestParameters.pbmUuid;
        }

        if (requestParameters.policies) {
            queryParameters['policies'] = requestParameters.policies;
        }

        if (requestParameters.policyEngineMode !== undefined) {
            queryParameters['policy_engine_mode'] = requestParameters.policyEngineMode;
        }

        if (requestParameters.reEvaluatePolicies !== undefined) {
            queryParameters['re_evaluate_policies'] = requestParameters.reEvaluatePolicies;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.stage !== undefined) {
            queryParameters['stage'] = requestParameters.stage;
        }

        if (requestParameters.target !== undefined) {
            queryParameters['target'] = requestParameters.target;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/bindings/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedFlowStageBindingListFromJSON(jsonValue));
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsList(requestParameters: FlowsBindingsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedFlowStageBindingList> {
        const response = await this.flowsBindingsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsPartialUpdateRaw(requestParameters: FlowsBindingsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FlowStageBinding>> {
        if (requestParameters.fsbUuid === null || requestParameters.fsbUuid === undefined) {
            throw new runtime.RequiredError('fsbUuid','Required parameter requestParameters.fsbUuid was null or undefined when calling flowsBindingsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/bindings/{fsb_uuid}/`.replace(`{${"fsb_uuid"}}`, encodeURIComponent(String(requestParameters.fsbUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedFlowStageBindingRequestToJSON(requestParameters.patchedFlowStageBindingRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowStageBindingFromJSON(jsonValue));
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsPartialUpdate(requestParameters: FlowsBindingsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FlowStageBinding> {
        const response = await this.flowsBindingsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsRetrieveRaw(requestParameters: FlowsBindingsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FlowStageBinding>> {
        if (requestParameters.fsbUuid === null || requestParameters.fsbUuid === undefined) {
            throw new runtime.RequiredError('fsbUuid','Required parameter requestParameters.fsbUuid was null or undefined when calling flowsBindingsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/bindings/{fsb_uuid}/`.replace(`{${"fsb_uuid"}}`, encodeURIComponent(String(requestParameters.fsbUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowStageBindingFromJSON(jsonValue));
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsRetrieve(requestParameters: FlowsBindingsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FlowStageBinding> {
        const response = await this.flowsBindingsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsUpdateRaw(requestParameters: FlowsBindingsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FlowStageBinding>> {
        if (requestParameters.fsbUuid === null || requestParameters.fsbUuid === undefined) {
            throw new runtime.RequiredError('fsbUuid','Required parameter requestParameters.fsbUuid was null or undefined when calling flowsBindingsUpdate.');
        }

        if (requestParameters.flowStageBindingRequest === null || requestParameters.flowStageBindingRequest === undefined) {
            throw new runtime.RequiredError('flowStageBindingRequest','Required parameter requestParameters.flowStageBindingRequest was null or undefined when calling flowsBindingsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/bindings/{fsb_uuid}/`.replace(`{${"fsb_uuid"}}`, encodeURIComponent(String(requestParameters.fsbUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: FlowStageBindingRequestToJSON(requestParameters.flowStageBindingRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowStageBindingFromJSON(jsonValue));
    }

    /**
     * FlowStageBinding Viewset
     */
    async flowsBindingsUpdate(requestParameters: FlowsBindingsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FlowStageBinding> {
        const response = await this.flowsBindingsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async flowsBindingsUsedByListRaw(requestParameters: FlowsBindingsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.fsbUuid === null || requestParameters.fsbUuid === undefined) {
            throw new runtime.RequiredError('fsbUuid','Required parameter requestParameters.fsbUuid was null or undefined when calling flowsBindingsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/bindings/{fsb_uuid}/used_by/`.replace(`{${"fsb_uuid"}}`, encodeURIComponent(String(requestParameters.fsbUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async flowsBindingsUsedByList(requestParameters: FlowsBindingsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.flowsBindingsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the next pending challenge from the currently active flow.
     */
    async flowsExecutorGetRaw(requestParameters: FlowsExecutorGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ChallengeTypes>> {
        if (requestParameters.flowSlug === null || requestParameters.flowSlug === undefined) {
            throw new runtime.RequiredError('flowSlug','Required parameter requestParameters.flowSlug was null or undefined when calling flowsExecutorGet.');
        }

        if (requestParameters.query === null || requestParameters.query === undefined) {
            throw new runtime.RequiredError('query','Required parameter requestParameters.query was null or undefined when calling flowsExecutorGet.');
        }

        const queryParameters: any = {};

        if (requestParameters.query !== undefined) {
            queryParameters['query'] = requestParameters.query;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/executor/{flow_slug}/`.replace(`{${"flow_slug"}}`, encodeURIComponent(String(requestParameters.flowSlug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ChallengeTypesFromJSON(jsonValue));
    }

    /**
     * Get the next pending challenge from the currently active flow.
     */
    async flowsExecutorGet(requestParameters: FlowsExecutorGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ChallengeTypes> {
        const response = await this.flowsExecutorGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Solve the previously retrieved challenge and advanced to the next stage.
     */
    async flowsExecutorSolveRaw(requestParameters: FlowsExecutorSolveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ChallengeTypes>> {
        if (requestParameters.flowSlug === null || requestParameters.flowSlug === undefined) {
            throw new runtime.RequiredError('flowSlug','Required parameter requestParameters.flowSlug was null or undefined when calling flowsExecutorSolve.');
        }

        if (requestParameters.query === null || requestParameters.query === undefined) {
            throw new runtime.RequiredError('query','Required parameter requestParameters.query was null or undefined when calling flowsExecutorSolve.');
        }

        const queryParameters: any = {};

        if (requestParameters.query !== undefined) {
            queryParameters['query'] = requestParameters.query;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/executor/{flow_slug}/`.replace(`{${"flow_slug"}}`, encodeURIComponent(String(requestParameters.flowSlug))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FlowChallengeResponseRequestToJSON(requestParameters.flowChallengeResponseRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ChallengeTypesFromJSON(jsonValue));
    }

    /**
     * Solve the previously retrieved challenge and advanced to the next stage.
     */
    async flowsExecutorSolve(requestParameters: FlowsExecutorSolveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ChallengeTypes> {
        const response = await this.flowsExecutorSolveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get current flow state and record it
     */
    async flowsInspectorGetRaw(requestParameters: FlowsInspectorGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FlowInspection>> {
        if (requestParameters.flowSlug === null || requestParameters.flowSlug === undefined) {
            throw new runtime.RequiredError('flowSlug','Required parameter requestParameters.flowSlug was null or undefined when calling flowsInspectorGet.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/inspector/{flow_slug}/`.replace(`{${"flow_slug"}}`, encodeURIComponent(String(requestParameters.flowSlug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowInspectionFromJSON(jsonValue));
    }

    /**
     * Get current flow state and record it
     */
    async flowsInspectorGet(requestParameters: FlowsInspectorGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FlowInspection> {
        const response = await this.flowsInspectorGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Clear flow cache
     */
    async flowsInstancesCacheClearCreateRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/cache_clear/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Clear flow cache
     */
    async flowsInstancesCacheClearCreate(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.flowsInstancesCacheClearCreateRaw(initOverrides);
    }

    /**
     * Info about cached flows
     */
    async flowsInstancesCacheInfoRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Cache>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/cache_info/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => CacheFromJSON(jsonValue));
    }

    /**
     * Info about cached flows
     */
    async flowsInstancesCacheInfoRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Cache> {
        const response = await this.flowsInstancesCacheInfoRetrieveRaw(initOverrides);
        return await response.value();
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesCreateRaw(requestParameters: FlowsInstancesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Flow>> {
        if (requestParameters.flowRequest === null || requestParameters.flowRequest === undefined) {
            throw new runtime.RequiredError('flowRequest','Required parameter requestParameters.flowRequest was null or undefined when calling flowsInstancesCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FlowRequestToJSON(requestParameters.flowRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowFromJSON(jsonValue));
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesCreate(requestParameters: FlowsInstancesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Flow> {
        const response = await this.flowsInstancesCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesDestroyRaw(requestParameters: FlowsInstancesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesDestroy(requestParameters: FlowsInstancesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.flowsInstancesDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Return diagram for flow with slug `slug`, in the format used by flowchart.js
     */
    async flowsInstancesDiagramRetrieveRaw(requestParameters: FlowsInstancesDiagramRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FlowDiagram>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesDiagramRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/diagram/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowDiagramFromJSON(jsonValue));
    }

    /**
     * Return diagram for flow with slug `slug`, in the format used by flowchart.js
     */
    async flowsInstancesDiagramRetrieve(requestParameters: FlowsInstancesDiagramRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FlowDiagram> {
        const response = await this.flowsInstancesDiagramRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Execute flow for current user
     */
    async flowsInstancesExecuteRetrieveRaw(requestParameters: FlowsInstancesExecuteRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Link>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesExecuteRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/execute/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LinkFromJSON(jsonValue));
    }

    /**
     * Execute flow for current user
     */
    async flowsInstancesExecuteRetrieve(requestParameters: FlowsInstancesExecuteRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Link> {
        const response = await this.flowsInstancesExecuteRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Export flow to .yaml file
     */
    async flowsInstancesExportRetrieveRaw(requestParameters: FlowsInstancesExportRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesExportRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/export/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * Export flow to .yaml file
     */
    async flowsInstancesExportRetrieve(requestParameters: FlowsInstancesExportRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.flowsInstancesExportRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Import flow from .yaml file
     */
    async flowsInstancesImportCreateRaw(requestParameters: FlowsInstancesImportCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FlowImportResult>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.file !== undefined) {
            formParams.append('file', requestParameters.file as any);
        }

        if (requestParameters.clear !== undefined) {
            formParams.append('clear', requestParameters.clear as any);
        }

        const response = await this.request({
            path: `/flows/instances/import/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowImportResultFromJSON(jsonValue));
    }

    /**
     * Import flow from .yaml file
     */
    async flowsInstancesImportCreate(requestParameters: FlowsInstancesImportCreateRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FlowImportResult> {
        const response = await this.flowsInstancesImportCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesListRaw(requestParameters: FlowsInstancesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedFlowList>> {
        const queryParameters: any = {};

        if (requestParameters.deniedAction !== undefined) {
            queryParameters['denied_action'] = requestParameters.deniedAction;
        }

        if (requestParameters.designation !== undefined) {
            queryParameters['designation'] = requestParameters.designation;
        }

        if (requestParameters.flowUuid !== undefined) {
            queryParameters['flow_uuid'] = requestParameters.flowUuid;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.slug !== undefined) {
            queryParameters['slug'] = requestParameters.slug;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedFlowListFromJSON(jsonValue));
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesList(requestParameters: FlowsInstancesListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedFlowList> {
        const response = await this.flowsInstancesListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesPartialUpdateRaw(requestParameters: FlowsInstancesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Flow>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedFlowRequestToJSON(requestParameters.patchedFlowRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowFromJSON(jsonValue));
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesPartialUpdate(requestParameters: FlowsInstancesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Flow> {
        const response = await this.flowsInstancesPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesRetrieveRaw(requestParameters: FlowsInstancesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Flow>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowFromJSON(jsonValue));
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesRetrieve(requestParameters: FlowsInstancesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Flow> {
        const response = await this.flowsInstancesRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Set Flow background
     */
    async flowsInstancesSetBackgroundCreateRaw(requestParameters: FlowsInstancesSetBackgroundCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesSetBackgroundCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.file !== undefined) {
            formParams.append('file', requestParameters.file as any);
        }

        if (requestParameters.clear !== undefined) {
            formParams.append('clear', requestParameters.clear as any);
        }

        const response = await this.request({
            path: `/flows/instances/{slug}/set_background/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Set Flow background
     */
    async flowsInstancesSetBackgroundCreate(requestParameters: FlowsInstancesSetBackgroundCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.flowsInstancesSetBackgroundCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Set Flow background (as URL)
     */
    async flowsInstancesSetBackgroundUrlCreateRaw(requestParameters: FlowsInstancesSetBackgroundUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesSetBackgroundUrlCreate.');
        }

        if (requestParameters.filePathRequest === null || requestParameters.filePathRequest === undefined) {
            throw new runtime.RequiredError('filePathRequest','Required parameter requestParameters.filePathRequest was null or undefined when calling flowsInstancesSetBackgroundUrlCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/set_background_url/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FilePathRequestToJSON(requestParameters.filePathRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Set Flow background (as URL)
     */
    async flowsInstancesSetBackgroundUrlCreate(requestParameters: FlowsInstancesSetBackgroundUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.flowsInstancesSetBackgroundUrlCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesUpdateRaw(requestParameters: FlowsInstancesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Flow>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesUpdate.');
        }

        if (requestParameters.flowRequest === null || requestParameters.flowRequest === undefined) {
            throw new runtime.RequiredError('flowRequest','Required parameter requestParameters.flowRequest was null or undefined when calling flowsInstancesUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: FlowRequestToJSON(requestParameters.flowRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FlowFromJSON(jsonValue));
    }

    /**
     * Flow Viewset
     */
    async flowsInstancesUpdate(requestParameters: FlowsInstancesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Flow> {
        const response = await this.flowsInstancesUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async flowsInstancesUsedByListRaw(requestParameters: FlowsInstancesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling flowsInstancesUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/flows/instances/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async flowsInstancesUsedByList(requestParameters: FlowsInstancesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.flowsInstancesUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const FlowsBindingsListInvalidResponseActionEnum = {
    Restart: 'restart',
    RestartWithContext: 'restart_with_context',
    Retry: 'retry',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type FlowsBindingsListInvalidResponseActionEnum = typeof FlowsBindingsListInvalidResponseActionEnum[keyof typeof FlowsBindingsListInvalidResponseActionEnum];
/**
 * @export
 */
export const FlowsBindingsListPolicyEngineModeEnum = {
    All: 'all',
    Any: 'any',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type FlowsBindingsListPolicyEngineModeEnum = typeof FlowsBindingsListPolicyEngineModeEnum[keyof typeof FlowsBindingsListPolicyEngineModeEnum];
/**
 * @export
 */
export const FlowsInstancesListDeniedActionEnum = {
    Continue: 'continue',
    Message: 'message',
    MessageContinue: 'message_continue',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type FlowsInstancesListDeniedActionEnum = typeof FlowsInstancesListDeniedActionEnum[keyof typeof FlowsInstancesListDeniedActionEnum];
/**
 * @export
 */
export const FlowsInstancesListDesignationEnum = {
    Authentication: 'authentication',
    Authorization: 'authorization',
    Enrollment: 'enrollment',
    Invalidation: 'invalidation',
    Recovery: 'recovery',
    StageConfiguration: 'stage_configuration',
    Unenrollment: 'unenrollment',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type FlowsInstancesListDesignationEnum = typeof FlowsInstancesListDesignationEnum[keyof typeof FlowsInstancesListDesignationEnum];
