/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Coordinate,
  Event,
  EventRequest,
  EventTopPerUser,
  GenericError,
  Notification,
  NotificationRequest,
  NotificationRule,
  NotificationRuleRequest,
  NotificationTransport,
  NotificationTransportRequest,
  NotificationTransportTest,
  PaginatedEventList,
  PaginatedNotificationList,
  PaginatedNotificationRuleList,
  PaginatedNotificationTransportList,
  PaginatedSystemTaskList,
  PatchedEventRequest,
  PatchedNotificationRequest,
  PatchedNotificationRuleRequest,
  PatchedNotificationTransportRequest,
  SystemTask,
  TypeCreate,
  UsedBy,
  ValidationError,
} from '../models';
import {
    CoordinateFromJSON,
    CoordinateToJSON,
    EventFromJSON,
    EventToJSON,
    EventRequestFromJSON,
    EventRequestToJSON,
    EventTopPerUserFromJSON,
    EventTopPerUserToJSON,
    GenericErrorFromJSON,
    GenericErrorToJSON,
    NotificationFromJSON,
    NotificationToJSON,
    NotificationRequestFromJSON,
    NotificationRequestToJSON,
    NotificationRuleFromJSON,
    NotificationRuleToJSON,
    NotificationRuleRequestFromJSON,
    NotificationRuleRequestToJSON,
    NotificationTransportFromJSON,
    NotificationTransportToJSON,
    NotificationTransportRequestFromJSON,
    NotificationTransportRequestToJSON,
    NotificationTransportTestFromJSON,
    NotificationTransportTestToJSON,
    PaginatedEventListFromJSON,
    PaginatedEventListToJSON,
    PaginatedNotificationListFromJSON,
    PaginatedNotificationListToJSON,
    PaginatedNotificationRuleListFromJSON,
    PaginatedNotificationRuleListToJSON,
    PaginatedNotificationTransportListFromJSON,
    PaginatedNotificationTransportListToJSON,
    PaginatedSystemTaskListFromJSON,
    PaginatedSystemTaskListToJSON,
    PatchedEventRequestFromJSON,
    PatchedEventRequestToJSON,
    PatchedNotificationRequestFromJSON,
    PatchedNotificationRequestToJSON,
    PatchedNotificationRuleRequestFromJSON,
    PatchedNotificationRuleRequestToJSON,
    PatchedNotificationTransportRequestFromJSON,
    PatchedNotificationTransportRequestToJSON,
    SystemTaskFromJSON,
    SystemTaskToJSON,
    TypeCreateFromJSON,
    TypeCreateToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface EventsEventsCreateRequest {
    eventRequest: EventRequest;
}

export interface EventsEventsDestroyRequest {
    eventUuid: string;
}

export interface EventsEventsListRequest {
    action?: string;
    brandName?: string;
    clientIp?: string;
    contextAuthorizedApp?: string;
    contextModelApp?: string;
    contextModelName?: string;
    contextModelPk?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    username?: string;
}

export interface EventsEventsPartialUpdateRequest {
    eventUuid: string;
    patchedEventRequest?: PatchedEventRequest;
}

export interface EventsEventsPerMonthListRequest {
    action?: string;
    query?: string;
}

export interface EventsEventsRetrieveRequest {
    eventUuid: string;
}

export interface EventsEventsTopPerUserListRequest {
    action?: string;
    topN?: number;
}

export interface EventsEventsUpdateRequest {
    eventUuid: string;
    eventRequest: EventRequest;
}

export interface EventsEventsVolumeListRequest {
    action?: string;
    brandName?: string;
    clientIp?: string;
    contextAuthorizedApp?: string;
    contextModelApp?: string;
    contextModelName?: string;
    contextModelPk?: string;
    ordering?: string;
    search?: string;
    username?: string;
}

export interface EventsNotificationsDestroyRequest {
    uuid: string;
}

export interface EventsNotificationsListRequest {
    body?: string;
    created?: Date;
    event?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    seen?: boolean;
    severity?: EventsNotificationsListSeverityEnum;
    user?: number;
}

export interface EventsNotificationsPartialUpdateRequest {
    uuid: string;
    patchedNotificationRequest?: PatchedNotificationRequest;
}

export interface EventsNotificationsRetrieveRequest {
    uuid: string;
}

export interface EventsNotificationsUpdateRequest {
    uuid: string;
    notificationRequest?: NotificationRequest;
}

export interface EventsNotificationsUsedByListRequest {
    uuid: string;
}

export interface EventsRulesCreateRequest {
    notificationRuleRequest: NotificationRuleRequest;
}

export interface EventsRulesDestroyRequest {
    pbmUuid: string;
}

export interface EventsRulesListRequest {
    groupName?: string;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    severity?: EventsRulesListSeverityEnum;
}

export interface EventsRulesPartialUpdateRequest {
    pbmUuid: string;
    patchedNotificationRuleRequest?: PatchedNotificationRuleRequest;
}

export interface EventsRulesRetrieveRequest {
    pbmUuid: string;
}

export interface EventsRulesUpdateRequest {
    pbmUuid: string;
    notificationRuleRequest: NotificationRuleRequest;
}

export interface EventsRulesUsedByListRequest {
    pbmUuid: string;
}

export interface EventsSystemTasksListRequest {
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    status?: EventsSystemTasksListStatusEnum;
    uid?: string;
}

export interface EventsSystemTasksRetrieveRequest {
    uuid: string;
}

export interface EventsSystemTasksRunCreateRequest {
    uuid: string;
}

export interface EventsTransportsCreateRequest {
    notificationTransportRequest: NotificationTransportRequest;
}

export interface EventsTransportsDestroyRequest {
    uuid: string;
}

export interface EventsTransportsListRequest {
    mode?: EventsTransportsListModeEnum;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    sendOnce?: boolean;
    webhookUrl?: string;
}

export interface EventsTransportsPartialUpdateRequest {
    uuid: string;
    patchedNotificationTransportRequest?: PatchedNotificationTransportRequest;
}

export interface EventsTransportsRetrieveRequest {
    uuid: string;
}

export interface EventsTransportsTestCreateRequest {
    uuid: string;
}

export interface EventsTransportsUpdateRequest {
    uuid: string;
    notificationTransportRequest: NotificationTransportRequest;
}

export interface EventsTransportsUsedByListRequest {
    uuid: string;
}

/**
 * 
 */
export class EventsApi extends runtime.BaseAPI {

    /**
     * Get all actions
     */
    async eventsEventsActionsListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<TypeCreate>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/actions/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(TypeCreateFromJSON));
    }

    /**
     * Get all actions
     */
    async eventsEventsActionsList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<TypeCreate>> {
        const response = await this.eventsEventsActionsListRaw(initOverrides);
        return await response.value();
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsCreateRaw(requestParameters: EventsEventsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Event>> {
        if (requestParameters.eventRequest === null || requestParameters.eventRequest === undefined) {
            throw new runtime.RequiredError('eventRequest','Required parameter requestParameters.eventRequest was null or undefined when calling eventsEventsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: EventRequestToJSON(requestParameters.eventRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EventFromJSON(jsonValue));
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsCreate(requestParameters: EventsEventsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Event> {
        const response = await this.eventsEventsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsDestroyRaw(requestParameters: EventsEventsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.eventUuid === null || requestParameters.eventUuid === undefined) {
            throw new runtime.RequiredError('eventUuid','Required parameter requestParameters.eventUuid was null or undefined when calling eventsEventsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/{event_uuid}/`.replace(`{${"event_uuid"}}`, encodeURIComponent(String(requestParameters.eventUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsDestroy(requestParameters: EventsEventsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.eventsEventsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsListRaw(requestParameters: EventsEventsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedEventList>> {
        const queryParameters: any = {};

        if (requestParameters.action !== undefined) {
            queryParameters['action'] = requestParameters.action;
        }

        if (requestParameters.brandName !== undefined) {
            queryParameters['brand_name'] = requestParameters.brandName;
        }

        if (requestParameters.clientIp !== undefined) {
            queryParameters['client_ip'] = requestParameters.clientIp;
        }

        if (requestParameters.contextAuthorizedApp !== undefined) {
            queryParameters['context_authorized_app'] = requestParameters.contextAuthorizedApp;
        }

        if (requestParameters.contextModelApp !== undefined) {
            queryParameters['context_model_app'] = requestParameters.contextModelApp;
        }

        if (requestParameters.contextModelName !== undefined) {
            queryParameters['context_model_name'] = requestParameters.contextModelName;
        }

        if (requestParameters.contextModelPk !== undefined) {
            queryParameters['context_model_pk'] = requestParameters.contextModelPk;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.username !== undefined) {
            queryParameters['username'] = requestParameters.username;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedEventListFromJSON(jsonValue));
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsList(requestParameters: EventsEventsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedEventList> {
        const response = await this.eventsEventsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsPartialUpdateRaw(requestParameters: EventsEventsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Event>> {
        if (requestParameters.eventUuid === null || requestParameters.eventUuid === undefined) {
            throw new runtime.RequiredError('eventUuid','Required parameter requestParameters.eventUuid was null or undefined when calling eventsEventsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/{event_uuid}/`.replace(`{${"event_uuid"}}`, encodeURIComponent(String(requestParameters.eventUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedEventRequestToJSON(requestParameters.patchedEventRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EventFromJSON(jsonValue));
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsPartialUpdate(requestParameters: EventsEventsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Event> {
        const response = await this.eventsEventsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the count of events per month
     */
    async eventsEventsPerMonthListRaw(requestParameters: EventsEventsPerMonthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Coordinate>>> {
        const queryParameters: any = {};

        if (requestParameters.action !== undefined) {
            queryParameters['action'] = requestParameters.action;
        }

        if (requestParameters.query !== undefined) {
            queryParameters['query'] = requestParameters.query;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/per_month/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(CoordinateFromJSON));
    }

    /**
     * Get the count of events per month
     */
    async eventsEventsPerMonthList(requestParameters: EventsEventsPerMonthListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Coordinate>> {
        const response = await this.eventsEventsPerMonthListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsRetrieveRaw(requestParameters: EventsEventsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Event>> {
        if (requestParameters.eventUuid === null || requestParameters.eventUuid === undefined) {
            throw new runtime.RequiredError('eventUuid','Required parameter requestParameters.eventUuid was null or undefined when calling eventsEventsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/{event_uuid}/`.replace(`{${"event_uuid"}}`, encodeURIComponent(String(requestParameters.eventUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EventFromJSON(jsonValue));
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsRetrieve(requestParameters: EventsEventsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Event> {
        const response = await this.eventsEventsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the top_n events grouped by user count
     */
    async eventsEventsTopPerUserListRaw(requestParameters: EventsEventsTopPerUserListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<EventTopPerUser>>> {
        const queryParameters: any = {};

        if (requestParameters.action !== undefined) {
            queryParameters['action'] = requestParameters.action;
        }

        if (requestParameters.topN !== undefined) {
            queryParameters['top_n'] = requestParameters.topN;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/top_per_user/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(EventTopPerUserFromJSON));
    }

    /**
     * Get the top_n events grouped by user count
     */
    async eventsEventsTopPerUserList(requestParameters: EventsEventsTopPerUserListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<EventTopPerUser>> {
        const response = await this.eventsEventsTopPerUserListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsUpdateRaw(requestParameters: EventsEventsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Event>> {
        if (requestParameters.eventUuid === null || requestParameters.eventUuid === undefined) {
            throw new runtime.RequiredError('eventUuid','Required parameter requestParameters.eventUuid was null or undefined when calling eventsEventsUpdate.');
        }

        if (requestParameters.eventRequest === null || requestParameters.eventRequest === undefined) {
            throw new runtime.RequiredError('eventRequest','Required parameter requestParameters.eventRequest was null or undefined when calling eventsEventsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/{event_uuid}/`.replace(`{${"event_uuid"}}`, encodeURIComponent(String(requestParameters.eventUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: EventRequestToJSON(requestParameters.eventRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EventFromJSON(jsonValue));
    }

    /**
     * Event Read-Only Viewset
     */
    async eventsEventsUpdate(requestParameters: EventsEventsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Event> {
        const response = await this.eventsEventsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get event volume for specified filters and timeframe
     */
    async eventsEventsVolumeListRaw(requestParameters: EventsEventsVolumeListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Coordinate>>> {
        const queryParameters: any = {};

        if (requestParameters.action !== undefined) {
            queryParameters['action'] = requestParameters.action;
        }

        if (requestParameters.brandName !== undefined) {
            queryParameters['brand_name'] = requestParameters.brandName;
        }

        if (requestParameters.clientIp !== undefined) {
            queryParameters['client_ip'] = requestParameters.clientIp;
        }

        if (requestParameters.contextAuthorizedApp !== undefined) {
            queryParameters['context_authorized_app'] = requestParameters.contextAuthorizedApp;
        }

        if (requestParameters.contextModelApp !== undefined) {
            queryParameters['context_model_app'] = requestParameters.contextModelApp;
        }

        if (requestParameters.contextModelName !== undefined) {
            queryParameters['context_model_name'] = requestParameters.contextModelName;
        }

        if (requestParameters.contextModelPk !== undefined) {
            queryParameters['context_model_pk'] = requestParameters.contextModelPk;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.username !== undefined) {
            queryParameters['username'] = requestParameters.username;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/events/volume/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(CoordinateFromJSON));
    }

    /**
     * Get event volume for specified filters and timeframe
     */
    async eventsEventsVolumeList(requestParameters: EventsEventsVolumeListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Coordinate>> {
        const response = await this.eventsEventsVolumeListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsDestroyRaw(requestParameters: EventsNotificationsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsNotificationsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/notifications/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsDestroy(requestParameters: EventsNotificationsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.eventsNotificationsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsListRaw(requestParameters: EventsNotificationsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedNotificationList>> {
        const queryParameters: any = {};

        if (requestParameters.body !== undefined) {
            queryParameters['body'] = requestParameters.body;
        }

        if (requestParameters.created !== undefined) {
            queryParameters['created'] = (requestParameters.created as any).toISOString();
        }

        if (requestParameters.event !== undefined) {
            queryParameters['event'] = requestParameters.event;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.seen !== undefined) {
            queryParameters['seen'] = requestParameters.seen;
        }

        if (requestParameters.severity !== undefined) {
            queryParameters['severity'] = requestParameters.severity;
        }

        if (requestParameters.user !== undefined) {
            queryParameters['user'] = requestParameters.user;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/notifications/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedNotificationListFromJSON(jsonValue));
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsList(requestParameters: EventsNotificationsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedNotificationList> {
        const response = await this.eventsNotificationsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Mark all the user\'s notifications as seen
     */
    async eventsNotificationsMarkAllSeenCreateRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/notifications/mark_all_seen/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Mark all the user\'s notifications as seen
     */
    async eventsNotificationsMarkAllSeenCreate(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.eventsNotificationsMarkAllSeenCreateRaw(initOverrides);
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsPartialUpdateRaw(requestParameters: EventsNotificationsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Notification>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsNotificationsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/notifications/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedNotificationRequestToJSON(requestParameters.patchedNotificationRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationFromJSON(jsonValue));
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsPartialUpdate(requestParameters: EventsNotificationsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Notification> {
        const response = await this.eventsNotificationsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsRetrieveRaw(requestParameters: EventsNotificationsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Notification>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsNotificationsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/notifications/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationFromJSON(jsonValue));
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsRetrieve(requestParameters: EventsNotificationsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Notification> {
        const response = await this.eventsNotificationsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsUpdateRaw(requestParameters: EventsNotificationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Notification>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsNotificationsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/notifications/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: NotificationRequestToJSON(requestParameters.notificationRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationFromJSON(jsonValue));
    }

    /**
     * Notification Viewset
     */
    async eventsNotificationsUpdate(requestParameters: EventsNotificationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Notification> {
        const response = await this.eventsNotificationsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async eventsNotificationsUsedByListRaw(requestParameters: EventsNotificationsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsNotificationsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/notifications/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async eventsNotificationsUsedByList(requestParameters: EventsNotificationsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.eventsNotificationsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesCreateRaw(requestParameters: EventsRulesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationRule>> {
        if (requestParameters.notificationRuleRequest === null || requestParameters.notificationRuleRequest === undefined) {
            throw new runtime.RequiredError('notificationRuleRequest','Required parameter requestParameters.notificationRuleRequest was null or undefined when calling eventsRulesCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/rules/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: NotificationRuleRequestToJSON(requestParameters.notificationRuleRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationRuleFromJSON(jsonValue));
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesCreate(requestParameters: EventsRulesCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationRule> {
        const response = await this.eventsRulesCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesDestroyRaw(requestParameters: EventsRulesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling eventsRulesDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/rules/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesDestroy(requestParameters: EventsRulesDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.eventsRulesDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesListRaw(requestParameters: EventsRulesListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedNotificationRuleList>> {
        const queryParameters: any = {};

        if (requestParameters.groupName !== undefined) {
            queryParameters['group__name'] = requestParameters.groupName;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.severity !== undefined) {
            queryParameters['severity'] = requestParameters.severity;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/rules/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedNotificationRuleListFromJSON(jsonValue));
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesList(requestParameters: EventsRulesListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedNotificationRuleList> {
        const response = await this.eventsRulesListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesPartialUpdateRaw(requestParameters: EventsRulesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationRule>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling eventsRulesPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/rules/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedNotificationRuleRequestToJSON(requestParameters.patchedNotificationRuleRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationRuleFromJSON(jsonValue));
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesPartialUpdate(requestParameters: EventsRulesPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationRule> {
        const response = await this.eventsRulesPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesRetrieveRaw(requestParameters: EventsRulesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationRule>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling eventsRulesRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/rules/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationRuleFromJSON(jsonValue));
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesRetrieve(requestParameters: EventsRulesRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationRule> {
        const response = await this.eventsRulesRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesUpdateRaw(requestParameters: EventsRulesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationRule>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling eventsRulesUpdate.');
        }

        if (requestParameters.notificationRuleRequest === null || requestParameters.notificationRuleRequest === undefined) {
            throw new runtime.RequiredError('notificationRuleRequest','Required parameter requestParameters.notificationRuleRequest was null or undefined when calling eventsRulesUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/rules/{pbm_uuid}/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: NotificationRuleRequestToJSON(requestParameters.notificationRuleRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationRuleFromJSON(jsonValue));
    }

    /**
     * NotificationRule Viewset
     */
    async eventsRulesUpdate(requestParameters: EventsRulesUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationRule> {
        const response = await this.eventsRulesUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async eventsRulesUsedByListRaw(requestParameters: EventsRulesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.pbmUuid === null || requestParameters.pbmUuid === undefined) {
            throw new runtime.RequiredError('pbmUuid','Required parameter requestParameters.pbmUuid was null or undefined when calling eventsRulesUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/rules/{pbm_uuid}/used_by/`.replace(`{${"pbm_uuid"}}`, encodeURIComponent(String(requestParameters.pbmUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async eventsRulesUsedByList(requestParameters: EventsRulesUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.eventsRulesUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Read-only view set that returns all background tasks
     */
    async eventsSystemTasksListRaw(requestParameters: EventsSystemTasksListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedSystemTaskList>> {
        const queryParameters: any = {};

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.status !== undefined) {
            queryParameters['status'] = requestParameters.status;
        }

        if (requestParameters.uid !== undefined) {
            queryParameters['uid'] = requestParameters.uid;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/system_tasks/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedSystemTaskListFromJSON(jsonValue));
    }

    /**
     * Read-only view set that returns all background tasks
     */
    async eventsSystemTasksList(requestParameters: EventsSystemTasksListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedSystemTaskList> {
        const response = await this.eventsSystemTasksListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Read-only view set that returns all background tasks
     */
    async eventsSystemTasksRetrieveRaw(requestParameters: EventsSystemTasksRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemTask>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsSystemTasksRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/system_tasks/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SystemTaskFromJSON(jsonValue));
    }

    /**
     * Read-only view set that returns all background tasks
     */
    async eventsSystemTasksRetrieve(requestParameters: EventsSystemTasksRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemTask> {
        const response = await this.eventsSystemTasksRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Run task
     */
    async eventsSystemTasksRunCreateRaw(requestParameters: EventsSystemTasksRunCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsSystemTasksRunCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/system_tasks/{uuid}/run/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Run task
     */
    async eventsSystemTasksRunCreate(requestParameters: EventsSystemTasksRunCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.eventsSystemTasksRunCreateRaw(requestParameters, initOverrides);
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsCreateRaw(requestParameters: EventsTransportsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationTransport>> {
        if (requestParameters.notificationTransportRequest === null || requestParameters.notificationTransportRequest === undefined) {
            throw new runtime.RequiredError('notificationTransportRequest','Required parameter requestParameters.notificationTransportRequest was null or undefined when calling eventsTransportsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: NotificationTransportRequestToJSON(requestParameters.notificationTransportRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationTransportFromJSON(jsonValue));
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsCreate(requestParameters: EventsTransportsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationTransport> {
        const response = await this.eventsTransportsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsDestroyRaw(requestParameters: EventsTransportsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsTransportsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsDestroy(requestParameters: EventsTransportsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.eventsTransportsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsListRaw(requestParameters: EventsTransportsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedNotificationTransportList>> {
        const queryParameters: any = {};

        if (requestParameters.mode !== undefined) {
            queryParameters['mode'] = requestParameters.mode;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.sendOnce !== undefined) {
            queryParameters['send_once'] = requestParameters.sendOnce;
        }

        if (requestParameters.webhookUrl !== undefined) {
            queryParameters['webhook_url'] = requestParameters.webhookUrl;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedNotificationTransportListFromJSON(jsonValue));
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsList(requestParameters: EventsTransportsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedNotificationTransportList> {
        const response = await this.eventsTransportsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsPartialUpdateRaw(requestParameters: EventsTransportsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationTransport>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsTransportsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedNotificationTransportRequestToJSON(requestParameters.patchedNotificationTransportRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationTransportFromJSON(jsonValue));
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsPartialUpdate(requestParameters: EventsTransportsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationTransport> {
        const response = await this.eventsTransportsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsRetrieveRaw(requestParameters: EventsTransportsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationTransport>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsTransportsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationTransportFromJSON(jsonValue));
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsRetrieve(requestParameters: EventsTransportsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationTransport> {
        const response = await this.eventsTransportsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Send example notification using selected transport. Requires Modify permissions.
     */
    async eventsTransportsTestCreateRaw(requestParameters: EventsTransportsTestCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationTransportTest>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsTransportsTestCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/{uuid}/test/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationTransportTestFromJSON(jsonValue));
    }

    /**
     * Send example notification using selected transport. Requires Modify permissions.
     */
    async eventsTransportsTestCreate(requestParameters: EventsTransportsTestCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationTransportTest> {
        const response = await this.eventsTransportsTestCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsUpdateRaw(requestParameters: EventsTransportsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NotificationTransport>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsTransportsUpdate.');
        }

        if (requestParameters.notificationTransportRequest === null || requestParameters.notificationTransportRequest === undefined) {
            throw new runtime.RequiredError('notificationTransportRequest','Required parameter requestParameters.notificationTransportRequest was null or undefined when calling eventsTransportsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: NotificationTransportRequestToJSON(requestParameters.notificationTransportRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NotificationTransportFromJSON(jsonValue));
    }

    /**
     * NotificationTransport Viewset
     */
    async eventsTransportsUpdate(requestParameters: EventsTransportsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NotificationTransport> {
        const response = await this.eventsTransportsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async eventsTransportsUsedByListRaw(requestParameters: EventsTransportsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling eventsTransportsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/events/transports/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async eventsTransportsUsedByList(requestParameters: EventsTransportsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.eventsTransportsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const EventsNotificationsListSeverityEnum = {
    Alert: 'alert',
    Notice: 'notice',
    Warning: 'warning',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type EventsNotificationsListSeverityEnum = typeof EventsNotificationsListSeverityEnum[keyof typeof EventsNotificationsListSeverityEnum];
/**
 * @export
 */
export const EventsRulesListSeverityEnum = {
    Alert: 'alert',
    Notice: 'notice',
    Warning: 'warning',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type EventsRulesListSeverityEnum = typeof EventsRulesListSeverityEnum[keyof typeof EventsRulesListSeverityEnum];
/**
 * @export
 */
export const EventsSystemTasksListStatusEnum = {
    Error: 'error',
    Successful: 'successful',
    Unknown: 'unknown',
    Warning: 'warning',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type EventsSystemTasksListStatusEnum = typeof EventsSystemTasksListStatusEnum[keyof typeof EventsSystemTasksListStatusEnum];
/**
 * @export
 */
export const EventsTransportsListModeEnum = {
    Email: 'email',
    Local: 'local',
    Webhook: 'webhook',
    WebhookSlack: 'webhook_slack',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type EventsTransportsListModeEnum = typeof EventsTransportsListModeEnum[keyof typeof EventsTransportsListModeEnum];
