/* tslint:disable */
/* eslint-disable */
/**
 * authentik
 * Making authentication simple.
 *
 * The version of the OpenAPI document: 2024.6.0
 * Contact: hello@goauthentik.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Application,
  ApplicationRequest,
  AuthenticatedSession,
  Brand,
  BrandRequest,
  Coordinate,
  CurrentBrand,
  FilePathRequest,
  GenericError,
  Group,
  GroupRequest,
  Link,
  PaginatedApplicationList,
  PaginatedAuthenticatedSessionList,
  PaginatedBrandList,
  PaginatedGroupList,
  PaginatedTokenList,
  PaginatedUserConsentList,
  PaginatedUserList,
  PatchedApplicationRequest,
  PatchedBrandRequest,
  PatchedGroupRequest,
  PatchedTokenRequest,
  PatchedUserRequest,
  PolicyTestResult,
  SessionUser,
  Token,
  TokenRequest,
  TokenSetKeyRequest,
  TokenView,
  TransactionApplicationRequest,
  TransactionApplicationResponse,
  UsedBy,
  User,
  UserAccountRequest,
  UserConsent,
  UserMetrics,
  UserPasswordSetRequest,
  UserPath,
  UserRequest,
  UserServiceAccountRequest,
  UserServiceAccountResponse,
  ValidationError,
} from '../models';
import {
    ApplicationFromJSON,
    ApplicationToJSON,
    ApplicationRequestFromJSON,
    ApplicationRequestToJSON,
    AuthenticatedSessionFromJSON,
    AuthenticatedSessionToJSON,
    BrandFromJSON,
    BrandToJSON,
    BrandRequestFromJSON,
    BrandRequestToJSON,
    CoordinateFromJSON,
    CoordinateToJSON,
    CurrentBrandFromJSON,
    CurrentBrandToJSON,
    FilePathRequestFromJSON,
    FilePathRequestToJSON,
    GenericErrorFromJSON,
    GenericErrorToJSON,
    GroupFromJSON,
    GroupToJSON,
    GroupRequestFromJSON,
    GroupRequestToJSON,
    LinkFromJSON,
    LinkToJSON,
    PaginatedApplicationListFromJSON,
    PaginatedApplicationListToJSON,
    PaginatedAuthenticatedSessionListFromJSON,
    PaginatedAuthenticatedSessionListToJSON,
    PaginatedBrandListFromJSON,
    PaginatedBrandListToJSON,
    PaginatedGroupListFromJSON,
    PaginatedGroupListToJSON,
    PaginatedTokenListFromJSON,
    PaginatedTokenListToJSON,
    PaginatedUserConsentListFromJSON,
    PaginatedUserConsentListToJSON,
    PaginatedUserListFromJSON,
    PaginatedUserListToJSON,
    PatchedApplicationRequestFromJSON,
    PatchedApplicationRequestToJSON,
    PatchedBrandRequestFromJSON,
    PatchedBrandRequestToJSON,
    PatchedGroupRequestFromJSON,
    PatchedGroupRequestToJSON,
    PatchedTokenRequestFromJSON,
    PatchedTokenRequestToJSON,
    PatchedUserRequestFromJSON,
    PatchedUserRequestToJSON,
    PolicyTestResultFromJSON,
    PolicyTestResultToJSON,
    SessionUserFromJSON,
    SessionUserToJSON,
    TokenFromJSON,
    TokenToJSON,
    TokenRequestFromJSON,
    TokenRequestToJSON,
    TokenSetKeyRequestFromJSON,
    TokenSetKeyRequestToJSON,
    TokenViewFromJSON,
    TokenViewToJSON,
    TransactionApplicationRequestFromJSON,
    TransactionApplicationRequestToJSON,
    TransactionApplicationResponseFromJSON,
    TransactionApplicationResponseToJSON,
    UsedByFromJSON,
    UsedByToJSON,
    UserFromJSON,
    UserToJSON,
    UserAccountRequestFromJSON,
    UserAccountRequestToJSON,
    UserConsentFromJSON,
    UserConsentToJSON,
    UserMetricsFromJSON,
    UserMetricsToJSON,
    UserPasswordSetRequestFromJSON,
    UserPasswordSetRequestToJSON,
    UserPathFromJSON,
    UserPathToJSON,
    UserRequestFromJSON,
    UserRequestToJSON,
    UserServiceAccountRequestFromJSON,
    UserServiceAccountRequestToJSON,
    UserServiceAccountResponseFromJSON,
    UserServiceAccountResponseToJSON,
    ValidationErrorFromJSON,
    ValidationErrorToJSON,
} from '../models';

export interface CoreApplicationsCheckAccessRetrieveRequest {
    slug: string;
    forUser?: number;
}

export interface CoreApplicationsCreateRequest {
    applicationRequest: ApplicationRequest;
}

export interface CoreApplicationsDestroyRequest {
    slug: string;
}

export interface CoreApplicationsListRequest {
    forUser?: number;
    group?: string;
    metaDescription?: string;
    metaLaunchUrl?: string;
    metaPublisher?: string;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    slug?: string;
    superuserFullList?: boolean;
}

export interface CoreApplicationsMetricsListRequest {
    slug: string;
}

export interface CoreApplicationsPartialUpdateRequest {
    slug: string;
    patchedApplicationRequest?: PatchedApplicationRequest;
}

export interface CoreApplicationsRetrieveRequest {
    slug: string;
}

export interface CoreApplicationsSetIconCreateRequest {
    slug: string;
    file?: Blob;
    clear?: boolean;
}

export interface CoreApplicationsSetIconUrlCreateRequest {
    slug: string;
    filePathRequest: FilePathRequest;
}

export interface CoreApplicationsUpdateRequest {
    slug: string;
    applicationRequest: ApplicationRequest;
}

export interface CoreApplicationsUsedByListRequest {
    slug: string;
}

export interface CoreAuthenticatedSessionsDestroyRequest {
    uuid: string;
}

export interface CoreAuthenticatedSessionsListRequest {
    lastIp?: string;
    lastUserAgent?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    userUsername?: string;
}

export interface CoreAuthenticatedSessionsRetrieveRequest {
    uuid: string;
}

export interface CoreAuthenticatedSessionsUsedByListRequest {
    uuid: string;
}

export interface CoreBrandsCreateRequest {
    brandRequest: BrandRequest;
}

export interface CoreBrandsDestroyRequest {
    brandUuid: string;
}

export interface CoreBrandsListRequest {
    brandUuid?: string;
    brandingFavicon?: string;
    brandingLogo?: string;
    brandingTitle?: string;
    _default?: boolean;
    domain?: string;
    flowAuthentication?: string;
    flowDeviceCode?: string;
    flowInvalidation?: string;
    flowRecovery?: string;
    flowUnenrollment?: string;
    flowUserSettings?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    webCertificate?: string;
}

export interface CoreBrandsPartialUpdateRequest {
    brandUuid: string;
    patchedBrandRequest?: PatchedBrandRequest;
}

export interface CoreBrandsRetrieveRequest {
    brandUuid: string;
}

export interface CoreBrandsUpdateRequest {
    brandUuid: string;
    brandRequest: BrandRequest;
}

export interface CoreBrandsUsedByListRequest {
    brandUuid: string;
}

export interface CoreGroupsAddUserCreateRequest {
    groupUuid: string;
    userAccountRequest: UserAccountRequest;
}

export interface CoreGroupsCreateRequest {
    groupRequest: GroupRequest;
}

export interface CoreGroupsDestroyRequest {
    groupUuid: string;
}

export interface CoreGroupsListRequest {
    attributes?: string;
    includeUsers?: boolean;
    isSuperuser?: boolean;
    membersByPk?: Array<number>;
    membersByUsername?: Array<string>;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
}

export interface CoreGroupsPartialUpdateRequest {
    groupUuid: string;
    patchedGroupRequest?: PatchedGroupRequest;
}

export interface CoreGroupsRemoveUserCreateRequest {
    groupUuid: string;
    userAccountRequest: UserAccountRequest;
}

export interface CoreGroupsRetrieveRequest {
    groupUuid: string;
    includeUsers?: boolean;
}

export interface CoreGroupsUpdateRequest {
    groupUuid: string;
    groupRequest: GroupRequest;
}

export interface CoreGroupsUsedByListRequest {
    groupUuid: string;
}

export interface CoreTokensCreateRequest {
    tokenRequest: TokenRequest;
}

export interface CoreTokensDestroyRequest {
    identifier: string;
}

export interface CoreTokensListRequest {
    description?: string;
    expires?: Date;
    expiring?: boolean;
    identifier?: string;
    intent?: CoreTokensListIntentEnum;
    managed?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    userUsername?: string;
}

export interface CoreTokensPartialUpdateRequest {
    identifier: string;
    patchedTokenRequest?: PatchedTokenRequest;
}

export interface CoreTokensRetrieveRequest {
    identifier: string;
}

export interface CoreTokensSetKeyCreateRequest {
    identifier: string;
    tokenSetKeyRequest: TokenSetKeyRequest;
}

export interface CoreTokensUpdateRequest {
    identifier: string;
    tokenRequest: TokenRequest;
}

export interface CoreTokensUsedByListRequest {
    identifier: string;
}

export interface CoreTokensViewKeyRetrieveRequest {
    identifier: string;
}

export interface CoreTransactionalApplicationsUpdateRequest {
    transactionApplicationRequest: TransactionApplicationRequest;
}

export interface CoreUserConsentDestroyRequest {
    id: number;
}

export interface CoreUserConsentListRequest {
    application?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    search?: string;
    user?: number;
}

export interface CoreUserConsentRetrieveRequest {
    id: number;
}

export interface CoreUserConsentUsedByListRequest {
    id: number;
}

export interface CoreUsersCreateRequest {
    userRequest: UserRequest;
}

export interface CoreUsersDestroyRequest {
    id: number;
}

export interface CoreUsersImpersonateCreateRequest {
    id: number;
}

export interface CoreUsersListRequest {
    attributes?: string;
    email?: string;
    groupsByName?: Array<string>;
    groupsByPk?: Array<string>;
    includeGroups?: boolean;
    isActive?: boolean;
    isSuperuser?: boolean;
    name?: string;
    ordering?: string;
    page?: number;
    pageSize?: number;
    path?: string;
    pathStartswith?: string;
    search?: string;
    type?: Array<CoreUsersListTypeEnum>;
    username?: string;
    uuid?: string;
}

export interface CoreUsersMetricsRetrieveRequest {
    id: number;
}

export interface CoreUsersPartialUpdateRequest {
    id: number;
    patchedUserRequest?: PatchedUserRequest;
}

export interface CoreUsersPathsRetrieveRequest {
    search?: string;
}

export interface CoreUsersRecoveryCreateRequest {
    id: number;
}

export interface CoreUsersRecoveryEmailCreateRequest {
    emailStage: string;
    id: number;
}

export interface CoreUsersRetrieveRequest {
    id: number;
}

export interface CoreUsersServiceAccountCreateRequest {
    userServiceAccountRequest: UserServiceAccountRequest;
}

export interface CoreUsersSetPasswordCreateRequest {
    id: number;
    userPasswordSetRequest: UserPasswordSetRequest;
}

export interface CoreUsersUpdateRequest {
    id: number;
    userRequest: UserRequest;
}

export interface CoreUsersUsedByListRequest {
    id: number;
}

/**
 * 
 */
export class CoreApi extends runtime.BaseAPI {

    /**
     * Check access to a single application by slug
     */
    async coreApplicationsCheckAccessRetrieveRaw(requestParameters: CoreApplicationsCheckAccessRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PolicyTestResult>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsCheckAccessRetrieve.');
        }

        const queryParameters: any = {};

        if (requestParameters.forUser !== undefined) {
            queryParameters['for_user'] = requestParameters.forUser;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/check_access/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PolicyTestResultFromJSON(jsonValue));
    }

    /**
     * Check access to a single application by slug
     */
    async coreApplicationsCheckAccessRetrieve(requestParameters: CoreApplicationsCheckAccessRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PolicyTestResult> {
        const response = await this.coreApplicationsCheckAccessRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Application Viewset
     */
    async coreApplicationsCreateRaw(requestParameters: CoreApplicationsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>> {
        if (requestParameters.applicationRequest === null || requestParameters.applicationRequest === undefined) {
            throw new runtime.RequiredError('applicationRequest','Required parameter requestParameters.applicationRequest was null or undefined when calling coreApplicationsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ApplicationRequestToJSON(requestParameters.applicationRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ApplicationFromJSON(jsonValue));
    }

    /**
     * Application Viewset
     */
    async coreApplicationsCreate(requestParameters: CoreApplicationsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application> {
        const response = await this.coreApplicationsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Application Viewset
     */
    async coreApplicationsDestroyRaw(requestParameters: CoreApplicationsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Application Viewset
     */
    async coreApplicationsDestroy(requestParameters: CoreApplicationsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreApplicationsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Custom list method that checks Policy based access instead of guardian
     */
    async coreApplicationsListRaw(requestParameters: CoreApplicationsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedApplicationList>> {
        const queryParameters: any = {};

        if (requestParameters.forUser !== undefined) {
            queryParameters['for_user'] = requestParameters.forUser;
        }

        if (requestParameters.group !== undefined) {
            queryParameters['group'] = requestParameters.group;
        }

        if (requestParameters.metaDescription !== undefined) {
            queryParameters['meta_description'] = requestParameters.metaDescription;
        }

        if (requestParameters.metaLaunchUrl !== undefined) {
            queryParameters['meta_launch_url'] = requestParameters.metaLaunchUrl;
        }

        if (requestParameters.metaPublisher !== undefined) {
            queryParameters['meta_publisher'] = requestParameters.metaPublisher;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.slug !== undefined) {
            queryParameters['slug'] = requestParameters.slug;
        }

        if (requestParameters.superuserFullList !== undefined) {
            queryParameters['superuser_full_list'] = requestParameters.superuserFullList;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedApplicationListFromJSON(jsonValue));
    }

    /**
     * Custom list method that checks Policy based access instead of guardian
     */
    async coreApplicationsList(requestParameters: CoreApplicationsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedApplicationList> {
        const response = await this.coreApplicationsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Metrics for application logins
     */
    async coreApplicationsMetricsListRaw(requestParameters: CoreApplicationsMetricsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Coordinate>>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsMetricsList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/metrics/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(CoordinateFromJSON));
    }

    /**
     * Metrics for application logins
     */
    async coreApplicationsMetricsList(requestParameters: CoreApplicationsMetricsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Coordinate>> {
        const response = await this.coreApplicationsMetricsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Application Viewset
     */
    async coreApplicationsPartialUpdateRaw(requestParameters: CoreApplicationsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedApplicationRequestToJSON(requestParameters.patchedApplicationRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ApplicationFromJSON(jsonValue));
    }

    /**
     * Application Viewset
     */
    async coreApplicationsPartialUpdate(requestParameters: CoreApplicationsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application> {
        const response = await this.coreApplicationsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Application Viewset
     */
    async coreApplicationsRetrieveRaw(requestParameters: CoreApplicationsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ApplicationFromJSON(jsonValue));
    }

    /**
     * Application Viewset
     */
    async coreApplicationsRetrieve(requestParameters: CoreApplicationsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application> {
        const response = await this.coreApplicationsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Set application icon
     */
    async coreApplicationsSetIconCreateRaw(requestParameters: CoreApplicationsSetIconCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsSetIconCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.file !== undefined) {
            formParams.append('file', requestParameters.file as any);
        }

        if (requestParameters.clear !== undefined) {
            formParams.append('clear', requestParameters.clear as any);
        }

        const response = await this.request({
            path: `/core/applications/{slug}/set_icon/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Set application icon
     */
    async coreApplicationsSetIconCreate(requestParameters: CoreApplicationsSetIconCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreApplicationsSetIconCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Set application icon (as URL)
     */
    async coreApplicationsSetIconUrlCreateRaw(requestParameters: CoreApplicationsSetIconUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsSetIconUrlCreate.');
        }

        if (requestParameters.filePathRequest === null || requestParameters.filePathRequest === undefined) {
            throw new runtime.RequiredError('filePathRequest','Required parameter requestParameters.filePathRequest was null or undefined when calling coreApplicationsSetIconUrlCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/set_icon_url/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FilePathRequestToJSON(requestParameters.filePathRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Set application icon (as URL)
     */
    async coreApplicationsSetIconUrlCreate(requestParameters: CoreApplicationsSetIconUrlCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreApplicationsSetIconUrlCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Application Viewset
     */
    async coreApplicationsUpdateRaw(requestParameters: CoreApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Application>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsUpdate.');
        }

        if (requestParameters.applicationRequest === null || requestParameters.applicationRequest === undefined) {
            throw new runtime.RequiredError('applicationRequest','Required parameter requestParameters.applicationRequest was null or undefined when calling coreApplicationsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: ApplicationRequestToJSON(requestParameters.applicationRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ApplicationFromJSON(jsonValue));
    }

    /**
     * Application Viewset
     */
    async coreApplicationsUpdate(requestParameters: CoreApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Application> {
        const response = await this.coreApplicationsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreApplicationsUsedByListRaw(requestParameters: CoreApplicationsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.slug === null || requestParameters.slug === undefined) {
            throw new runtime.RequiredError('slug','Required parameter requestParameters.slug was null or undefined when calling coreApplicationsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/applications/{slug}/used_by/`.replace(`{${"slug"}}`, encodeURIComponent(String(requestParameters.slug))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreApplicationsUsedByList(requestParameters: CoreApplicationsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.coreApplicationsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * AuthenticatedSession Viewset
     */
    async coreAuthenticatedSessionsDestroyRaw(requestParameters: CoreAuthenticatedSessionsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling coreAuthenticatedSessionsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/authenticated_sessions/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * AuthenticatedSession Viewset
     */
    async coreAuthenticatedSessionsDestroy(requestParameters: CoreAuthenticatedSessionsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreAuthenticatedSessionsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * AuthenticatedSession Viewset
     */
    async coreAuthenticatedSessionsListRaw(requestParameters: CoreAuthenticatedSessionsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedAuthenticatedSessionList>> {
        const queryParameters: any = {};

        if (requestParameters.lastIp !== undefined) {
            queryParameters['last_ip'] = requestParameters.lastIp;
        }

        if (requestParameters.lastUserAgent !== undefined) {
            queryParameters['last_user_agent'] = requestParameters.lastUserAgent;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.userUsername !== undefined) {
            queryParameters['user__username'] = requestParameters.userUsername;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/authenticated_sessions/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedAuthenticatedSessionListFromJSON(jsonValue));
    }

    /**
     * AuthenticatedSession Viewset
     */
    async coreAuthenticatedSessionsList(requestParameters: CoreAuthenticatedSessionsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedAuthenticatedSessionList> {
        const response = await this.coreAuthenticatedSessionsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * AuthenticatedSession Viewset
     */
    async coreAuthenticatedSessionsRetrieveRaw(requestParameters: CoreAuthenticatedSessionsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuthenticatedSession>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling coreAuthenticatedSessionsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/authenticated_sessions/{uuid}/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AuthenticatedSessionFromJSON(jsonValue));
    }

    /**
     * AuthenticatedSession Viewset
     */
    async coreAuthenticatedSessionsRetrieve(requestParameters: CoreAuthenticatedSessionsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuthenticatedSession> {
        const response = await this.coreAuthenticatedSessionsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreAuthenticatedSessionsUsedByListRaw(requestParameters: CoreAuthenticatedSessionsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.uuid === null || requestParameters.uuid === undefined) {
            throw new runtime.RequiredError('uuid','Required parameter requestParameters.uuid was null or undefined when calling coreAuthenticatedSessionsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/authenticated_sessions/{uuid}/used_by/`.replace(`{${"uuid"}}`, encodeURIComponent(String(requestParameters.uuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreAuthenticatedSessionsUsedByList(requestParameters: CoreAuthenticatedSessionsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.coreAuthenticatedSessionsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Brand Viewset
     */
    async coreBrandsCreateRaw(requestParameters: CoreBrandsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>> {
        if (requestParameters.brandRequest === null || requestParameters.brandRequest === undefined) {
            throw new runtime.RequiredError('brandRequest','Required parameter requestParameters.brandRequest was null or undefined when calling coreBrandsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: BrandRequestToJSON(requestParameters.brandRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BrandFromJSON(jsonValue));
    }

    /**
     * Brand Viewset
     */
    async coreBrandsCreate(requestParameters: CoreBrandsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand> {
        const response = await this.coreBrandsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get current brand
     */
    async coreBrandsCurrentRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CurrentBrand>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/current/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => CurrentBrandFromJSON(jsonValue));
    }

    /**
     * Get current brand
     */
    async coreBrandsCurrentRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CurrentBrand> {
        const response = await this.coreBrandsCurrentRetrieveRaw(initOverrides);
        return await response.value();
    }

    /**
     * Brand Viewset
     */
    async coreBrandsDestroyRaw(requestParameters: CoreBrandsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
            throw new runtime.RequiredError('brandUuid','Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Brand Viewset
     */
    async coreBrandsDestroy(requestParameters: CoreBrandsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreBrandsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Brand Viewset
     */
    async coreBrandsListRaw(requestParameters: CoreBrandsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedBrandList>> {
        const queryParameters: any = {};

        if (requestParameters.brandUuid !== undefined) {
            queryParameters['brand_uuid'] = requestParameters.brandUuid;
        }

        if (requestParameters.brandingFavicon !== undefined) {
            queryParameters['branding_favicon'] = requestParameters.brandingFavicon;
        }

        if (requestParameters.brandingLogo !== undefined) {
            queryParameters['branding_logo'] = requestParameters.brandingLogo;
        }

        if (requestParameters.brandingTitle !== undefined) {
            queryParameters['branding_title'] = requestParameters.brandingTitle;
        }

        if (requestParameters._default !== undefined) {
            queryParameters['default'] = requestParameters._default;
        }

        if (requestParameters.domain !== undefined) {
            queryParameters['domain'] = requestParameters.domain;
        }

        if (requestParameters.flowAuthentication !== undefined) {
            queryParameters['flow_authentication'] = requestParameters.flowAuthentication;
        }

        if (requestParameters.flowDeviceCode !== undefined) {
            queryParameters['flow_device_code'] = requestParameters.flowDeviceCode;
        }

        if (requestParameters.flowInvalidation !== undefined) {
            queryParameters['flow_invalidation'] = requestParameters.flowInvalidation;
        }

        if (requestParameters.flowRecovery !== undefined) {
            queryParameters['flow_recovery'] = requestParameters.flowRecovery;
        }

        if (requestParameters.flowUnenrollment !== undefined) {
            queryParameters['flow_unenrollment'] = requestParameters.flowUnenrollment;
        }

        if (requestParameters.flowUserSettings !== undefined) {
            queryParameters['flow_user_settings'] = requestParameters.flowUserSettings;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.webCertificate !== undefined) {
            queryParameters['web_certificate'] = requestParameters.webCertificate;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedBrandListFromJSON(jsonValue));
    }

    /**
     * Brand Viewset
     */
    async coreBrandsList(requestParameters: CoreBrandsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedBrandList> {
        const response = await this.coreBrandsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Brand Viewset
     */
    async coreBrandsPartialUpdateRaw(requestParameters: CoreBrandsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>> {
        if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
            throw new runtime.RequiredError('brandUuid','Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedBrandRequestToJSON(requestParameters.patchedBrandRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BrandFromJSON(jsonValue));
    }

    /**
     * Brand Viewset
     */
    async coreBrandsPartialUpdate(requestParameters: CoreBrandsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand> {
        const response = await this.coreBrandsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Brand Viewset
     */
    async coreBrandsRetrieveRaw(requestParameters: CoreBrandsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>> {
        if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
            throw new runtime.RequiredError('brandUuid','Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BrandFromJSON(jsonValue));
    }

    /**
     * Brand Viewset
     */
    async coreBrandsRetrieve(requestParameters: CoreBrandsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand> {
        const response = await this.coreBrandsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Brand Viewset
     */
    async coreBrandsUpdateRaw(requestParameters: CoreBrandsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Brand>> {
        if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
            throw new runtime.RequiredError('brandUuid','Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsUpdate.');
        }

        if (requestParameters.brandRequest === null || requestParameters.brandRequest === undefined) {
            throw new runtime.RequiredError('brandRequest','Required parameter requestParameters.brandRequest was null or undefined when calling coreBrandsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/{brand_uuid}/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: BrandRequestToJSON(requestParameters.brandRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BrandFromJSON(jsonValue));
    }

    /**
     * Brand Viewset
     */
    async coreBrandsUpdate(requestParameters: CoreBrandsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Brand> {
        const response = await this.coreBrandsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreBrandsUsedByListRaw(requestParameters: CoreBrandsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.brandUuid === null || requestParameters.brandUuid === undefined) {
            throw new runtime.RequiredError('brandUuid','Required parameter requestParameters.brandUuid was null or undefined when calling coreBrandsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/brands/{brand_uuid}/used_by/`.replace(`{${"brand_uuid"}}`, encodeURIComponent(String(requestParameters.brandUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreBrandsUsedByList(requestParameters: CoreBrandsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.coreBrandsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Add user to group
     */
    async coreGroupsAddUserCreateRaw(requestParameters: CoreGroupsAddUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
            throw new runtime.RequiredError('groupUuid','Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsAddUserCreate.');
        }

        if (requestParameters.userAccountRequest === null || requestParameters.userAccountRequest === undefined) {
            throw new runtime.RequiredError('userAccountRequest','Required parameter requestParameters.userAccountRequest was null or undefined when calling coreGroupsAddUserCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/{group_uuid}/add_user/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UserAccountRequestToJSON(requestParameters.userAccountRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Add user to group
     */
    async coreGroupsAddUserCreate(requestParameters: CoreGroupsAddUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreGroupsAddUserCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Group Viewset
     */
    async coreGroupsCreateRaw(requestParameters: CoreGroupsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>> {
        if (requestParameters.groupRequest === null || requestParameters.groupRequest === undefined) {
            throw new runtime.RequiredError('groupRequest','Required parameter requestParameters.groupRequest was null or undefined when calling coreGroupsCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: GroupRequestToJSON(requestParameters.groupRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GroupFromJSON(jsonValue));
    }

    /**
     * Group Viewset
     */
    async coreGroupsCreate(requestParameters: CoreGroupsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group> {
        const response = await this.coreGroupsCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Group Viewset
     */
    async coreGroupsDestroyRaw(requestParameters: CoreGroupsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
            throw new runtime.RequiredError('groupUuid','Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Group Viewset
     */
    async coreGroupsDestroy(requestParameters: CoreGroupsDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreGroupsDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Group Viewset
     */
    async coreGroupsListRaw(requestParameters: CoreGroupsListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedGroupList>> {
        const queryParameters: any = {};

        if (requestParameters.attributes !== undefined) {
            queryParameters['attributes'] = requestParameters.attributes;
        }

        if (requestParameters.includeUsers !== undefined) {
            queryParameters['include_users'] = requestParameters.includeUsers;
        }

        if (requestParameters.isSuperuser !== undefined) {
            queryParameters['is_superuser'] = requestParameters.isSuperuser;
        }

        if (requestParameters.membersByPk) {
            queryParameters['members_by_pk'] = requestParameters.membersByPk;
        }

        if (requestParameters.membersByUsername) {
            queryParameters['members_by_username'] = requestParameters.membersByUsername;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedGroupListFromJSON(jsonValue));
    }

    /**
     * Group Viewset
     */
    async coreGroupsList(requestParameters: CoreGroupsListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedGroupList> {
        const response = await this.coreGroupsListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Group Viewset
     */
    async coreGroupsPartialUpdateRaw(requestParameters: CoreGroupsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>> {
        if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
            throw new runtime.RequiredError('groupUuid','Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedGroupRequestToJSON(requestParameters.patchedGroupRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GroupFromJSON(jsonValue));
    }

    /**
     * Group Viewset
     */
    async coreGroupsPartialUpdate(requestParameters: CoreGroupsPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group> {
        const response = await this.coreGroupsPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Add user to group
     */
    async coreGroupsRemoveUserCreateRaw(requestParameters: CoreGroupsRemoveUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
            throw new runtime.RequiredError('groupUuid','Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsRemoveUserCreate.');
        }

        if (requestParameters.userAccountRequest === null || requestParameters.userAccountRequest === undefined) {
            throw new runtime.RequiredError('userAccountRequest','Required parameter requestParameters.userAccountRequest was null or undefined when calling coreGroupsRemoveUserCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/{group_uuid}/remove_user/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UserAccountRequestToJSON(requestParameters.userAccountRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Add user to group
     */
    async coreGroupsRemoveUserCreate(requestParameters: CoreGroupsRemoveUserCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreGroupsRemoveUserCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Group Viewset
     */
    async coreGroupsRetrieveRaw(requestParameters: CoreGroupsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>> {
        if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
            throw new runtime.RequiredError('groupUuid','Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsRetrieve.');
        }

        const queryParameters: any = {};

        if (requestParameters.includeUsers !== undefined) {
            queryParameters['include_users'] = requestParameters.includeUsers;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GroupFromJSON(jsonValue));
    }

    /**
     * Group Viewset
     */
    async coreGroupsRetrieve(requestParameters: CoreGroupsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group> {
        const response = await this.coreGroupsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Group Viewset
     */
    async coreGroupsUpdateRaw(requestParameters: CoreGroupsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Group>> {
        if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
            throw new runtime.RequiredError('groupUuid','Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsUpdate.');
        }

        if (requestParameters.groupRequest === null || requestParameters.groupRequest === undefined) {
            throw new runtime.RequiredError('groupRequest','Required parameter requestParameters.groupRequest was null or undefined when calling coreGroupsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/{group_uuid}/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: GroupRequestToJSON(requestParameters.groupRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GroupFromJSON(jsonValue));
    }

    /**
     * Group Viewset
     */
    async coreGroupsUpdate(requestParameters: CoreGroupsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Group> {
        const response = await this.coreGroupsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreGroupsUsedByListRaw(requestParameters: CoreGroupsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.groupUuid === null || requestParameters.groupUuid === undefined) {
            throw new runtime.RequiredError('groupUuid','Required parameter requestParameters.groupUuid was null or undefined when calling coreGroupsUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/groups/{group_uuid}/used_by/`.replace(`{${"group_uuid"}}`, encodeURIComponent(String(requestParameters.groupUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreGroupsUsedByList(requestParameters: CoreGroupsUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.coreGroupsUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Token Viewset
     */
    async coreTokensCreateRaw(requestParameters: CoreTokensCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>> {
        if (requestParameters.tokenRequest === null || requestParameters.tokenRequest === undefined) {
            throw new runtime.RequiredError('tokenRequest','Required parameter requestParameters.tokenRequest was null or undefined when calling coreTokensCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: TokenRequestToJSON(requestParameters.tokenRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TokenFromJSON(jsonValue));
    }

    /**
     * Token Viewset
     */
    async coreTokensCreate(requestParameters: CoreTokensCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token> {
        const response = await this.coreTokensCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Token Viewset
     */
    async coreTokensDestroyRaw(requestParameters: CoreTokensDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
            throw new runtime.RequiredError('identifier','Required parameter requestParameters.identifier was null or undefined when calling coreTokensDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Token Viewset
     */
    async coreTokensDestroy(requestParameters: CoreTokensDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreTokensDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Token Viewset
     */
    async coreTokensListRaw(requestParameters: CoreTokensListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedTokenList>> {
        const queryParameters: any = {};

        if (requestParameters.description !== undefined) {
            queryParameters['description'] = requestParameters.description;
        }

        if (requestParameters.expires !== undefined) {
            queryParameters['expires'] = (requestParameters.expires as any).toISOString();
        }

        if (requestParameters.expiring !== undefined) {
            queryParameters['expiring'] = requestParameters.expiring;
        }

        if (requestParameters.identifier !== undefined) {
            queryParameters['identifier'] = requestParameters.identifier;
        }

        if (requestParameters.intent !== undefined) {
            queryParameters['intent'] = requestParameters.intent;
        }

        if (requestParameters.managed !== undefined) {
            queryParameters['managed'] = requestParameters.managed;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.userUsername !== undefined) {
            queryParameters['user__username'] = requestParameters.userUsername;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedTokenListFromJSON(jsonValue));
    }

    /**
     * Token Viewset
     */
    async coreTokensList(requestParameters: CoreTokensListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedTokenList> {
        const response = await this.coreTokensListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Token Viewset
     */
    async coreTokensPartialUpdateRaw(requestParameters: CoreTokensPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>> {
        if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
            throw new runtime.RequiredError('identifier','Required parameter requestParameters.identifier was null or undefined when calling coreTokensPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedTokenRequestToJSON(requestParameters.patchedTokenRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TokenFromJSON(jsonValue));
    }

    /**
     * Token Viewset
     */
    async coreTokensPartialUpdate(requestParameters: CoreTokensPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token> {
        const response = await this.coreTokensPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Token Viewset
     */
    async coreTokensRetrieveRaw(requestParameters: CoreTokensRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>> {
        if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
            throw new runtime.RequiredError('identifier','Required parameter requestParameters.identifier was null or undefined when calling coreTokensRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TokenFromJSON(jsonValue));
    }

    /**
     * Token Viewset
     */
    async coreTokensRetrieve(requestParameters: CoreTokensRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token> {
        const response = await this.coreTokensRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Set token key. Action is logged as event. `authentik_core.set_token_key` permission is required.
     */
    async coreTokensSetKeyCreateRaw(requestParameters: CoreTokensSetKeyCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
            throw new runtime.RequiredError('identifier','Required parameter requestParameters.identifier was null or undefined when calling coreTokensSetKeyCreate.');
        }

        if (requestParameters.tokenSetKeyRequest === null || requestParameters.tokenSetKeyRequest === undefined) {
            throw new runtime.RequiredError('tokenSetKeyRequest','Required parameter requestParameters.tokenSetKeyRequest was null or undefined when calling coreTokensSetKeyCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/{identifier}/set_key/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: TokenSetKeyRequestToJSON(requestParameters.tokenSetKeyRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Set token key. Action is logged as event. `authentik_core.set_token_key` permission is required.
     */
    async coreTokensSetKeyCreate(requestParameters: CoreTokensSetKeyCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreTokensSetKeyCreateRaw(requestParameters, initOverrides);
    }

    /**
     * Token Viewset
     */
    async coreTokensUpdateRaw(requestParameters: CoreTokensUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Token>> {
        if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
            throw new runtime.RequiredError('identifier','Required parameter requestParameters.identifier was null or undefined when calling coreTokensUpdate.');
        }

        if (requestParameters.tokenRequest === null || requestParameters.tokenRequest === undefined) {
            throw new runtime.RequiredError('tokenRequest','Required parameter requestParameters.tokenRequest was null or undefined when calling coreTokensUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/{identifier}/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: TokenRequestToJSON(requestParameters.tokenRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TokenFromJSON(jsonValue));
    }

    /**
     * Token Viewset
     */
    async coreTokensUpdate(requestParameters: CoreTokensUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Token> {
        const response = await this.coreTokensUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreTokensUsedByListRaw(requestParameters: CoreTokensUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
            throw new runtime.RequiredError('identifier','Required parameter requestParameters.identifier was null or undefined when calling coreTokensUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/{identifier}/used_by/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreTokensUsedByList(requestParameters: CoreTokensUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.coreTokensUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Return token key and log access
     */
    async coreTokensViewKeyRetrieveRaw(requestParameters: CoreTokensViewKeyRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TokenView>> {
        if (requestParameters.identifier === null || requestParameters.identifier === undefined) {
            throw new runtime.RequiredError('identifier','Required parameter requestParameters.identifier was null or undefined when calling coreTokensViewKeyRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/tokens/{identifier}/view_key/`.replace(`{${"identifier"}}`, encodeURIComponent(String(requestParameters.identifier))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TokenViewFromJSON(jsonValue));
    }

    /**
     * Return token key and log access
     */
    async coreTokensViewKeyRetrieve(requestParameters: CoreTokensViewKeyRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TokenView> {
        const response = await this.coreTokensViewKeyRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Convert data into a blueprint, validate it and apply it
     */
    async coreTransactionalApplicationsUpdateRaw(requestParameters: CoreTransactionalApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TransactionApplicationResponse>> {
        if (requestParameters.transactionApplicationRequest === null || requestParameters.transactionApplicationRequest === undefined) {
            throw new runtime.RequiredError('transactionApplicationRequest','Required parameter requestParameters.transactionApplicationRequest was null or undefined when calling coreTransactionalApplicationsUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/transactional/applications/`,
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: TransactionApplicationRequestToJSON(requestParameters.transactionApplicationRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TransactionApplicationResponseFromJSON(jsonValue));
    }

    /**
     * Convert data into a blueprint, validate it and apply it
     */
    async coreTransactionalApplicationsUpdate(requestParameters: CoreTransactionalApplicationsUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TransactionApplicationResponse> {
        const response = await this.coreTransactionalApplicationsUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * UserConsent Viewset
     */
    async coreUserConsentDestroyRaw(requestParameters: CoreUserConsentDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUserConsentDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/user_consent/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * UserConsent Viewset
     */
    async coreUserConsentDestroy(requestParameters: CoreUserConsentDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreUserConsentDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * UserConsent Viewset
     */
    async coreUserConsentListRaw(requestParameters: CoreUserConsentListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserConsentList>> {
        const queryParameters: any = {};

        if (requestParameters.application !== undefined) {
            queryParameters['application'] = requestParameters.application;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.user !== undefined) {
            queryParameters['user'] = requestParameters.user;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/user_consent/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedUserConsentListFromJSON(jsonValue));
    }

    /**
     * UserConsent Viewset
     */
    async coreUserConsentList(requestParameters: CoreUserConsentListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserConsentList> {
        const response = await this.coreUserConsentListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * UserConsent Viewset
     */
    async coreUserConsentRetrieveRaw(requestParameters: CoreUserConsentRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserConsent>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUserConsentRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/user_consent/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserConsentFromJSON(jsonValue));
    }

    /**
     * UserConsent Viewset
     */
    async coreUserConsentRetrieve(requestParameters: CoreUserConsentRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserConsent> {
        const response = await this.coreUserConsentRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreUserConsentUsedByListRaw(requestParameters: CoreUserConsentUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUserConsentUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/user_consent/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreUserConsentUsedByList(requestParameters: CoreUserConsentUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.coreUserConsentUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * User Viewset
     */
    async coreUsersCreateRaw(requestParameters: CoreUsersCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>> {
        if (requestParameters.userRequest === null || requestParameters.userRequest === undefined) {
            throw new runtime.RequiredError('userRequest','Required parameter requestParameters.userRequest was null or undefined when calling coreUsersCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UserRequestToJSON(requestParameters.userRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserFromJSON(jsonValue));
    }

    /**
     * User Viewset
     */
    async coreUsersCreate(requestParameters: CoreUsersCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User> {
        const response = await this.coreUsersCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * User Viewset
     */
    async coreUsersDestroyRaw(requestParameters: CoreUsersDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersDestroy.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * User Viewset
     */
    async coreUsersDestroy(requestParameters: CoreUsersDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreUsersDestroyRaw(requestParameters, initOverrides);
    }

    /**
     * Impersonate a user
     */
    async coreUsersImpersonateCreateRaw(requestParameters: CoreUsersImpersonateCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersImpersonateCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/impersonate/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Impersonate a user
     */
    async coreUsersImpersonateCreate(requestParameters: CoreUsersImpersonateCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreUsersImpersonateCreateRaw(requestParameters, initOverrides);
    }

    /**
     * End Impersonation a user
     */
    async coreUsersImpersonateEndRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/impersonate_end/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * End Impersonation a user
     */
    async coreUsersImpersonateEndRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreUsersImpersonateEndRetrieveRaw(initOverrides);
    }

    /**
     * User Viewset
     */
    async coreUsersListRaw(requestParameters: CoreUsersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PaginatedUserList>> {
        const queryParameters: any = {};

        if (requestParameters.attributes !== undefined) {
            queryParameters['attributes'] = requestParameters.attributes;
        }

        if (requestParameters.email !== undefined) {
            queryParameters['email'] = requestParameters.email;
        }

        if (requestParameters.groupsByName) {
            queryParameters['groups_by_name'] = requestParameters.groupsByName;
        }

        if (requestParameters.groupsByPk) {
            queryParameters['groups_by_pk'] = requestParameters.groupsByPk;
        }

        if (requestParameters.includeGroups !== undefined) {
            queryParameters['include_groups'] = requestParameters.includeGroups;
        }

        if (requestParameters.isActive !== undefined) {
            queryParameters['is_active'] = requestParameters.isActive;
        }

        if (requestParameters.isSuperuser !== undefined) {
            queryParameters['is_superuser'] = requestParameters.isSuperuser;
        }

        if (requestParameters.name !== undefined) {
            queryParameters['name'] = requestParameters.name;
        }

        if (requestParameters.ordering !== undefined) {
            queryParameters['ordering'] = requestParameters.ordering;
        }

        if (requestParameters.page !== undefined) {
            queryParameters['page'] = requestParameters.page;
        }

        if (requestParameters.pageSize !== undefined) {
            queryParameters['page_size'] = requestParameters.pageSize;
        }

        if (requestParameters.path !== undefined) {
            queryParameters['path'] = requestParameters.path;
        }

        if (requestParameters.pathStartswith !== undefined) {
            queryParameters['path_startswith'] = requestParameters.pathStartswith;
        }

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        if (requestParameters.type) {
            queryParameters['type'] = requestParameters.type;
        }

        if (requestParameters.username !== undefined) {
            queryParameters['username'] = requestParameters.username;
        }

        if (requestParameters.uuid !== undefined) {
            queryParameters['uuid'] = requestParameters.uuid;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PaginatedUserListFromJSON(jsonValue));
    }

    /**
     * User Viewset
     */
    async coreUsersList(requestParameters: CoreUsersListRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PaginatedUserList> {
        const response = await this.coreUsersListRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get information about current user
     */
    async coreUsersMeRetrieveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionUser>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/me/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SessionUserFromJSON(jsonValue));
    }

    /**
     * Get information about current user
     */
    async coreUsersMeRetrieve(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionUser> {
        const response = await this.coreUsersMeRetrieveRaw(initOverrides);
        return await response.value();
    }

    /**
     * User metrics per 1h
     */
    async coreUsersMetricsRetrieveRaw(requestParameters: CoreUsersMetricsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserMetrics>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersMetricsRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/metrics/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserMetricsFromJSON(jsonValue));
    }

    /**
     * User metrics per 1h
     */
    async coreUsersMetricsRetrieve(requestParameters: CoreUsersMetricsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserMetrics> {
        const response = await this.coreUsersMetricsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * User Viewset
     */
    async coreUsersPartialUpdateRaw(requestParameters: CoreUsersPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersPartialUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchedUserRequestToJSON(requestParameters.patchedUserRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserFromJSON(jsonValue));
    }

    /**
     * User Viewset
     */
    async coreUsersPartialUpdate(requestParameters: CoreUsersPartialUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User> {
        const response = await this.coreUsersPartialUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get all user paths
     */
    async coreUsersPathsRetrieveRaw(requestParameters: CoreUsersPathsRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserPath>> {
        const queryParameters: any = {};

        if (requestParameters.search !== undefined) {
            queryParameters['search'] = requestParameters.search;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/paths/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserPathFromJSON(jsonValue));
    }

    /**
     * Get all user paths
     */
    async coreUsersPathsRetrieve(requestParameters: CoreUsersPathsRetrieveRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserPath> {
        const response = await this.coreUsersPathsRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    async coreUsersRecoveryCreateRaw(requestParameters: CoreUsersRecoveryCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Link>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersRecoveryCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/recovery/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LinkFromJSON(jsonValue));
    }

    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    async coreUsersRecoveryCreate(requestParameters: CoreUsersRecoveryCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Link> {
        const response = await this.coreUsersRecoveryCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    async coreUsersRecoveryEmailCreateRaw(requestParameters: CoreUsersRecoveryEmailCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.emailStage === null || requestParameters.emailStage === undefined) {
            throw new runtime.RequiredError('emailStage','Required parameter requestParameters.emailStage was null or undefined when calling coreUsersRecoveryEmailCreate.');
        }

        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersRecoveryEmailCreate.');
        }

        const queryParameters: any = {};

        if (requestParameters.emailStage !== undefined) {
            queryParameters['email_stage'] = requestParameters.emailStage;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/recovery_email/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Create a temporary link that a user can use to recover their accounts
     */
    async coreUsersRecoveryEmailCreate(requestParameters: CoreUsersRecoveryEmailCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreUsersRecoveryEmailCreateRaw(requestParameters, initOverrides);
    }

    /**
     * User Viewset
     */
    async coreUsersRetrieveRaw(requestParameters: CoreUsersRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersRetrieve.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserFromJSON(jsonValue));
    }

    /**
     * User Viewset
     */
    async coreUsersRetrieve(requestParameters: CoreUsersRetrieveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User> {
        const response = await this.coreUsersRetrieveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create a new user account that is marked as a service account
     */
    async coreUsersServiceAccountCreateRaw(requestParameters: CoreUsersServiceAccountCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserServiceAccountResponse>> {
        if (requestParameters.userServiceAccountRequest === null || requestParameters.userServiceAccountRequest === undefined) {
            throw new runtime.RequiredError('userServiceAccountRequest','Required parameter requestParameters.userServiceAccountRequest was null or undefined when calling coreUsersServiceAccountCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/service_account/`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UserServiceAccountRequestToJSON(requestParameters.userServiceAccountRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserServiceAccountResponseFromJSON(jsonValue));
    }

    /**
     * Create a new user account that is marked as a service account
     */
    async coreUsersServiceAccountCreate(requestParameters: CoreUsersServiceAccountCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserServiceAccountResponse> {
        const response = await this.coreUsersServiceAccountCreateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Set password for user
     */
    async coreUsersSetPasswordCreateRaw(requestParameters: CoreUsersSetPasswordCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersSetPasswordCreate.');
        }

        if (requestParameters.userPasswordSetRequest === null || requestParameters.userPasswordSetRequest === undefined) {
            throw new runtime.RequiredError('userPasswordSetRequest','Required parameter requestParameters.userPasswordSetRequest was null or undefined when calling coreUsersSetPasswordCreate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/set_password/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UserPasswordSetRequestToJSON(requestParameters.userPasswordSetRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Set password for user
     */
    async coreUsersSetPasswordCreate(requestParameters: CoreUsersSetPasswordCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.coreUsersSetPasswordCreateRaw(requestParameters, initOverrides);
    }

    /**
     * User Viewset
     */
    async coreUsersUpdateRaw(requestParameters: CoreUsersUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<User>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersUpdate.');
        }

        if (requestParameters.userRequest === null || requestParameters.userRequest === undefined) {
            throw new runtime.RequiredError('userRequest','Required parameter requestParameters.userRequest was null or undefined when calling coreUsersUpdate.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: UserRequestToJSON(requestParameters.userRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserFromJSON(jsonValue));
    }

    /**
     * User Viewset
     */
    async coreUsersUpdate(requestParameters: CoreUsersUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<User> {
        const response = await this.coreUsersUpdateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreUsersUsedByListRaw(requestParameters: CoreUsersUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<UsedBy>>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling coreUsersUsedByList.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("authentik", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/core/users/{id}/used_by/`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(UsedByFromJSON));
    }

    /**
     * Get a list of all objects that use this object
     */
    async coreUsersUsedByList(requestParameters: CoreUsersUsedByListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<UsedBy>> {
        const response = await this.coreUsersUsedByListRaw(requestParameters, initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const CoreTokensListIntentEnum = {
    Api: 'api',
    AppPassword: 'app_password',
    Recovery: 'recovery',
    Verification: 'verification',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type CoreTokensListIntentEnum = typeof CoreTokensListIntentEnum[keyof typeof CoreTokensListIntentEnum];
/**
 * @export
 */
export const CoreUsersListTypeEnum = {
    External: 'external',
    Internal: 'internal',
    InternalServiceAccount: 'internal_service_account',
    ServiceAccount: 'service_account',
    UnknownDefaultOpenApi: '11184809'
} as const;
export type CoreUsersListTypeEnum = typeof CoreUsersListTypeEnum[keyof typeof CoreUsersListTypeEnum];
